/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.logic.map.HexMath;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.TileLayerBorders;
import com.unciv.ui.components.tilegroups.layers.TileLayerCityButton;
import com.unciv.ui.components.tilegroups.layers.TileLayerFeatures;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.tilegroups.layers.TileLayerTerrain;
import com.unciv.ui.components.tilegroups.layers.TileLayerUnitArt;
import com.unciv.ui.components.tilegroups.layers.TileLayerUnitFlag;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001/B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u001a\u0010#\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u000eH\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\"\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\tH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017\u00a8\u00060"}, d2={"Lcom/unciv/ui/components/tilegroups/TileGroupMap;", "T", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "mapHolder", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "tileGroups", "", "worldWrap", "", "tileGroupsToUnwrap", "", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;Ljava/lang/Iterable;ZLjava/util/Set;)V", "bottomX", "", "bottomY", "drawBottomX", "drawTopX", "getMapHolder", "()Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "maxVisibleMapWidth", "shouldAct", "getShouldAct", "()Z", "setShouldAct", "(Z)V", "shouldHit", "getShouldHit", "setShouldHit", "topX", "topY", "getWorldWrap", "act", "", "delta", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getPositionalVector", "Lcom/badlogic/gdx/math/Vector2;", "stageCoords", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nTileGroupMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileGroupMap.kt\ncom/unciv/ui/components/tilegroups/TileGroupMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1054#2:217\n1855#2,2:219\n1#3:218\n*S KotlinDebug\n*F\n+ 1 TileGroupMap.kt\ncom/unciv/ui/components/tilegroups/TileGroupMap\n*L\n115#1:217\n195#1:219,2\n*E\n"})
public final class TileGroupMap<T extends TileGroup>
extends Group {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoomableScrollPane mapHolder;
    private final boolean worldWrap;
    private boolean shouldAct;
    private boolean shouldHit;
    private float topX;
    private float topY;
    private float bottomX;
    private float bottomY;
    private float drawTopX;
    private float drawBottomX;
    private float maxVisibleMapWidth;
    public static final float groupSize = 50.0f;
    public static final float groupSizeDiagonal = 57.735027f;
    public static final float groupHorizontalAdvance = 43.30127f;

    /*
     * WARNING - void declaration
     */
    public TileGroupMap(@NotNull ZoomableScrollPane mapHolder2, @NotNull Iterable<? extends T> tileGroups, boolean worldWrap, @Nullable Set<? extends T> tileGroupsToUnwrap) {
        Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
        Intrinsics.checkNotNullParameter(tileGroups, "tileGroups");
        this.mapHolder = mapHolder2;
        this.worldWrap = worldWrap;
        this.shouldAct = true;
        this.shouldHit = true;
        this.topX = -3.4028235E38f;
        this.topY = -3.4028235E38f;
        this.bottomX = Float.MAX_VALUE;
        this.bottomY = Float.MAX_VALUE;
        for (TileGroup tileGroup : tileGroups) {
            Set<T> set2 = tileGroupsToUnwrap;
            Vector2 positionalVector = (set2 != null ? set2.contains(tileGroup) : false) ? HexMath.INSTANCE.hex2WorldCoords(tileGroup.getTile().getTileMap().getUnWrappedPosition(tileGroup.getTile().getPosition())) : HexMath.INSTANCE.hex2WorldCoords(tileGroup.getTile().getPosition());
            tileGroup.setPosition(positionalVector.x * 0.8f * 50.0f, positionalVector.y * 0.8f * 50.0f);
            this.topX = this.worldWrap ? Math.max(this.topX, tileGroup.getX() + 60.000004f) : Math.max(this.topX, tileGroup.getX() + 50.0f + 4.0f);
            this.topY = Math.max(this.topY, tileGroup.getY() + 50.0f);
            this.bottomX = Math.min(this.bottomX, tileGroup.getX());
            this.bottomY = Math.min(this.bottomY, tileGroup.getY());
        }
        for (TileGroup group : tileGroups) {
            group.moveBy(-this.bottomX, -this.bottomY);
        }
        this.drawTopX = this.topX - this.bottomX;
        this.drawBottomX = this.bottomX - this.bottomX;
        ArrayList<TileLayerTerrain> baseLayers = new ArrayList<TileLayerTerrain>();
        ArrayList featureLayers = new ArrayList();
        ArrayList borderLayers = new ArrayList();
        ArrayList miscLayers = new ArrayList();
        ArrayList pixelUnitLayers = new ArrayList();
        ArrayList circleFogCrosshairLayers = new ArrayList();
        ArrayList unitLayers = new ArrayList();
        ArrayList cityButtonLayers = new ArrayList();
        Iterable<T> iterable = tileGroups;
        boolean $i$f$sortedByDescending = false;
        for (TileGroup tileGroup : CollectionsKt.sortedWith(iterable, new Comparator(){

            public final int compare(T a, T b) {
                TileGroup it = (TileGroup)b;
                boolean bl = false;
                it = (TileGroup)a;
                Comparable comparable = Float.valueOf(it.getTile().getPosition().x + it.getTile().getPosition().y);
                bl = false;
                return ComparisonsKt.compareValues(comparable, (Comparable)Float.valueOf(it.getTile().getPosition().x + it.getTile().getPosition().y));
            }
        })) {
            void $this$_init__u24lambda_u248;
            TileLayer $this$_init__u24lambda_u247;
            TileLayer $this$_init__u24lambda_u246;
            TileLayer $this$_init__u24lambda_u245;
            TileLayer $this$_init__u24lambda_u244;
            TileLayer $this$_init__u24lambda_u243;
            TileLayer $this$_init__u24lambda_u242;
            TileLayer $this$_init__u24lambda_u241;
            TileLayer tileLayer;
            TileLayerTerrain tileLayerTerrain = tileLayer = tileGroup.getLayerTerrain();
            ArrayList<TileLayerTerrain> arrayList = baseLayers;
            boolean bl = false;
            $this$_init__u24lambda_u241.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u241 = tileLayer = tileGroup.getLayerFeatures();
            arrayList = featureLayers;
            boolean bl2 = false;
            $this$_init__u24lambda_u242.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u242 = tileLayer = tileGroup.getLayerBorders();
            arrayList = borderLayers;
            boolean bl3 = false;
            $this$_init__u24lambda_u243.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u243 = tileLayer = tileGroup.getLayerMisc();
            arrayList = miscLayers;
            boolean bl4 = false;
            $this$_init__u24lambda_u244.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u244 = tileLayer = tileGroup.getLayerUnitArt();
            arrayList = pixelUnitLayers;
            boolean bl5 = false;
            $this$_init__u24lambda_u245.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u245 = tileLayer = tileGroup.getLayerOverlay();
            arrayList = circleFogCrosshairLayers;
            boolean bl6 = false;
            $this$_init__u24lambda_u246.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u246 = tileLayer = tileGroup.getLayerUnitFlag();
            arrayList = unitLayers;
            boolean bl7 = false;
            $this$_init__u24lambda_u247.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
            $this$_init__u24lambda_u247 = tileLayer = tileGroup.getLayerCityButton();
            arrayList = cityButtonLayers;
            boolean bl8 = false;
            $this$_init__u24lambda_u248.setPosition(tileGroup.getX(), tileGroup.getY());
            arrayList.add((TileLayerTerrain)tileLayer);
        }
        for (TileLayerTerrain tileLayerTerrain : baseLayers) {
            this.addActor(tileLayerTerrain);
        }
        for (TileLayerFeatures tileLayerFeatures : featureLayers) {
            this.addActor(tileLayerFeatures);
        }
        for (TileLayerBorders tileLayerBorders : borderLayers) {
            this.addActor(tileLayerBorders);
        }
        for (TileLayerMisc tileLayerMisc : miscLayers) {
            this.addActor(tileLayerMisc);
        }
        for (TileLayerUnitArt tileLayerUnitArt : pixelUnitLayers) {
            this.addActor(tileLayerUnitArt);
        }
        for (TileLayerOverlay tileLayerOverlay : circleFogCrosshairLayers) {
            this.addActor(tileLayerOverlay);
        }
        for (TileGroup tileGroup : tileGroups) {
            this.addActor(tileGroup);
        }
        for (TileLayerUnitFlag tileLayerUnitFlag : unitLayers) {
            this.addActor(tileLayerUnitFlag);
        }
        for (TileLayerCityButton tileLayerCityButton : cityButtonLayers) {
            this.addActor(tileLayerCityButton);
        }
        this.setSize(this.topX - this.bottomX, this.topY - this.bottomY);
        this.setCullingArea(new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight()));
        this.maxVisibleMapWidth = this.getWidth() - 75.0f;
    }

    public /* synthetic */ TileGroupMap(ZoomableScrollPane zoomableScrollPane, Iterable iterable, boolean bl, Set set2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            set2 = null;
        }
        this(zoomableScrollPane, iterable, bl, set2);
    }

    @NotNull
    public final ZoomableScrollPane getMapHolder() {
        return this.mapHolder;
    }

    public final boolean getWorldWrap() {
        return this.worldWrap;
    }

    public final boolean getShouldAct() {
        return this.shouldAct;
    }

    public final void setShouldAct(boolean bl) {
        this.shouldAct = bl;
    }

    public final boolean getShouldHit() {
        return this.shouldHit;
    }

    public final void setShouldHit(boolean bl) {
        this.shouldHit = bl;
    }

    @NotNull
    public final Vector2 getPositionalVector(@NotNull Vector2 stageCoords) {
        Intrinsics.checkNotNullParameter(stageCoords, "stageCoords");
        float trueGroupSize = 40.0f;
        Vector2 vector2 = new Vector2(this.bottomX, this.bottomY).add(stageCoords).sub(25.0f, 25.0f).scl(1.0f / trueGroupSize);
        Intrinsics.checkNotNullExpressionValue(vector2, "Vector2(bottomX, bottomY\u2026 .scl(1f / trueGroupSize)");
        return vector2;
    }

    @Override
    public void act(float delta) {
        if (this.shouldAct) {
            super.act(delta);
        }
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        if (this.shouldHit) {
            return super.hit(x, y, touchable);
        }
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.worldWrap) {
            boolean beyondLeft;
            float visibleMapWidth = this.mapHolder.getWidth() > this.maxVisibleMapWidth ? this.maxVisibleMapWidth : this.mapHolder.getWidth();
            float rightSide = this.mapHolder.getScrollX() + visibleMapWidth / 2.0f;
            float leftSide = this.mapHolder.getScrollX() - visibleMapWidth / 2.0f;
            float diffRight = rightSide - this.drawTopX;
            float diffLeft = leftSide - this.drawBottomX;
            boolean beyondRight = diffRight >= 0.0f;
            boolean bl = beyondLeft = diffLeft <= 0.0f;
            if (beyondRight || beyondLeft) {
                float newBottomX = 0.0f;
                newBottomX = Float.MAX_VALUE;
                float newTopX = 0.0f;
                newTopX = -3.4028235E38f;
                SnapshotArray<Actor> snapshotArray = this.getChildren();
                Intrinsics.checkNotNullExpressionValue(snapshotArray, "children");
                Iterable $this$forEach$iv = snapshotArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    if (beyondRight) {
                        if (it.getX() - this.drawBottomX <= diffRight) {
                            it.setX(it.getX() + this.getWidth());
                        }
                    } else if (beyondLeft && it.getX() + 50.0f + 4.0f >= this.drawTopX + diffLeft) {
                        it.setX(it.getX() - this.getWidth());
                    }
                    newBottomX = Math.min(newBottomX, it.getX());
                    newTopX = Math.max(newTopX, it.getX() + 50.0f + 4.0f);
                }
                this.drawBottomX = newBottomX;
                this.drawTopX = newTopX;
            }
        }
        super.draw(batch, parentAlpha);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/components/tilegroups/TileGroupMap$Companion;", "", "()V", "groupHorizontalAdvance", "", "groupSize", "groupSizeDiagonal", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

