/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/tilegroups/YieldGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/HorizontalGroup;", "()V", "currentStats", "Lcom/unciv/models/stats/Stats;", "getCurrentStats", "()Lcom/unciv/models/stats/Stats;", "setCurrentStats", "(Lcom/unciv/models/stats/Stats;)V", "getIcon", "Lcom/unciv/ui/images/IconCircleGroup;", "statName", "", "getStatIconsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "number", "", "setStats", "", "stats", "core"})
@SourceDebugExtension(value={"SMAP\nYieldGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YieldGroup.kt\ncom/unciv/ui/components/tilegroups/YieldGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class YieldGroup
extends HorizontalGroup {
    @NotNull
    private Stats currentStats;

    public YieldGroup() {
        this.setTransform(false);
        this.currentStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
    }

    @NotNull
    public final Stats getCurrentStats() {
        return this.currentStats;
    }

    public final void setCurrentStats(@NotNull Stats stats2) {
        Intrinsics.checkNotNullParameter(stats2, "<set-?>");
        this.currentStats = stats2;
    }

    public final void setStats(@NotNull Stats stats2) {
        Intrinsics.checkNotNullParameter(stats2, "stats");
        if (this.currentStats.equals(stats2)) {
            return;
        }
        this.currentStats = stats2;
        this.clearChildren();
        for (Stats.StatValuePair statValuePair : stats2) {
            Stat stat = statValuePair.component1();
            float amount = statValuePair.component2();
            if (!(amount > 0.0f)) continue;
            this.addActor(this.getStatIconsTable(stat.name(), (int)amount));
        }
        this.pack();
    }

    @NotNull
    public final IconCircleGroup getIcon(@NotNull String statName) {
        IconCircleGroup iconCircleGroup;
        Intrinsics.checkNotNullParameter(statName, "statName");
        IconCircleGroup $this$getIcon_u24lambda_u240 = iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.INSTANCE.getStatIcon(statName), 12.0f, false, null, null, 14, null);
        boolean bl = false;
        $this$getIcon_u24lambda_u240.getCircle().setColor(Color.BLACK);
        $this$getIcon_u24lambda_u240.getCircle().getColor().a = 0.5f;
        return iconCircleGroup;
    }

    private final Table getStatIconsTable(String statName, int number) {
        Table table2 = new Table();
        switch (number) {
            case 1: {
                table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 2: {
                table2.add((Actor)this.getIcon(statName)).row();
                table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 3: {
                table2.add((Actor)this.getIcon(statName)).colspan(2).row();
                table2.add((Actor)this.getIcon(statName));
                table2.add((Actor)this.getIcon(statName));
                break;
            }
            case 4: {
                table2.add((Actor)this.getIcon(statName));
                table2.add((Actor)this.getIcon(statName)).row();
                table2.add((Actor)this.getIcon(statName));
                table2.add((Actor)this.getIcon(statName));
                break;
            }
            default: {
                Group group;
                Group $this$getStatIconsTable_u24lambda_u241 = group = new Group();
                boolean bl = false;
                $this$getStatIconsTable_u24lambda_u241.setSize(22.0f, 22.0f);
                Group group2 = group;
                Group $this$getStatIconsTable_u24lambda_u242 = $this$getStatIconsTable_u24lambda_u241 = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.INSTANCE.getStatIcon(statName), 22.0f, false, null, null, 14, null);
                boolean bl22 = false;
                ((IconCircleGroup)$this$getStatIconsTable_u24lambda_u242).getCircle().setColor(Color.BLACK);
                ((IconCircleGroup)$this$getStatIconsTable_u24lambda_u242).getCircle().getColor().a = 0.5f;
                Group largeImage = $this$getStatIconsTable_u24lambda_u241;
                Scene2dExtensionsKt.addToCenter(group2, largeImage);
                if (number > 5) {
                    String text2 = number < 10 ? String.valueOf(number) : "*";
                    Color bl22 = Color.WHITE;
                    Intrinsics.checkNotNullExpressionValue(bl22, "WHITE");
                    Label label2 = Scene2dExtensionsKt.toLabel$default(text2, bl22, 8, 1, false, 8, null);
                    Actor actor = label2;
                    Color color = Color.BLACK;
                    Intrinsics.checkNotNullExpressionValue(color, "BLACK");
                    IconCircleGroup amountGroup = Scene2dExtensionsKt.surroundWithCircle$default(actor, 10.0f, true, color, null, 8, null);
                    label2.setY(label2.getY() - 0.5f);
                    amountGroup.setX(group2.getWidth() - amountGroup.getWidth() * (float)3 / (float)4);
                    amountGroup.setY(-amountGroup.getHeight() / (float)4);
                    group2.addActor(amountGroup);
                }
                table2.add((Actor)group2);
            }
        }
        table2.pack();
        return table2;
    }
}

