/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.RoadImage;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0006\u0010\u000f\u001a\u00020\rJ\u001a\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0002R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerFeatures;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "roadImages", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lcom/unciv/ui/components/tilegroups/layers/RoadImage;", "Lkotlin/collections/HashMap;", "act", "", "delta", "dim", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "updateRoadImages", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerFeatures.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerFeatures\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class TileLayerFeatures
extends TileLayer {
    @NotNull
    private final HashMap<Tile, RoadImage> roadImages;

    public TileLayerFeatures(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.roadImages = new HashMap();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    private final void updateRoadImages() {
        if (this.getTileGroup().isForMapEditorIcon()) {
            return;
        }
        Tile tile = this.getTileGroup().getTile();
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            RoadStatus roadStatus;
            Tile neighbor = iterator2.next();
            RoadImage roadImage = this.roadImages.get(neighbor);
            if (roadImage == null) {
                RoadImage roadImage2;
                RoadImage it = roadImage2 = new RoadImage();
                boolean bl = false;
                ((Map)this.roadImages).put(neighbor, it);
                roadImage = roadImage2;
            }
            RoadImage roadImage3 = roadImage;
            RoadStatus roadStatus2 = tile.getRoadStatus() == RoadStatus.None || neighbor.getRoadStatus() == RoadStatus.None ? RoadStatus.None : (roadStatus = tile.getRoadStatus() == RoadStatus.Road || neighbor.getRoadStatus() == RoadStatus.Road ? RoadStatus.Road : RoadStatus.Railroad);
            if (roadImage3.getRoadStatus() == roadStatus) continue;
            roadImage3.setRoadStatus(roadStatus);
            if (roadImage3.getImage() != null) {
                Image image2 = roadImage3.getImage();
                Intrinsics.checkNotNull(image2);
                image2.remove();
                roadImage3.setImage(null);
            }
            if (roadStatus == RoadStatus.None) continue;
            Image image3 = ImageGetter.INSTANCE.getImage(this.strings().orFallback((Function1<? super TileSetStrings, String>)new Function1<TileSetStrings, String>(roadStatus){
                final /* synthetic */ RoadStatus $roadStatus;
                {
                    this.$roadStatus = $roadStatus;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull TileSetStrings $this$orFallback) {
                    Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
                    String string = $this$orFallback.getRoadsMap().get(this.$roadStatus);
                    Intrinsics.checkNotNull(string);
                    return string;
                }
            }));
            roadImage3.setImage(image3);
            Vector2 relativeWorldPosition = tile.getTileMap().getNeighborTilePositionAsWorldCoords(tile, neighbor);
            image3.moveBy(25.0f, 25.0f);
            image3.moveBy(-relativeWorldPosition.x * 0.8f * 25.0f, -relativeWorldPosition.y * 0.8f * 25.0f);
            image3.setSize(10.0f, 6.0f);
            image3.setOrigin(0.0f, 3.0f);
            image3.setRotation((float)(57.29577951308232 * Math.atan2(relativeWorldPosition.y, relativeWorldPosition.x)));
            this.addActor(image3);
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.updateRoadImages();
    }

    public final void dim() {
        this.getColor().a = 0.5f;
    }
}

