/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0014J\u001a\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0018\u001a\u00020\u000eJ\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u000eJ\u0010\u0010 \u001a\u00020\u000e2\b\b\u0002\u0010!\u001a\u00020\u0005J\u0006\u0010\"\u001a\u00020\u000eJ\u0006\u0010#\u001a\u00020\u000eJ\u0018\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010!\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerOverlay;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "crosshair", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "fog", "goodCityLocationIndicator", "highlight", "unexplored", "act", "", "delta", "determineVisibility", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "hideCrosshair", "hideGoodCityLocationIndicator", "hideHighlight", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "reset", "showCrosshair", "alpha", "showGoodCityLocationIndicator", "showHighlight", "color", "Lcom/badlogic/gdx/graphics/Color;", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerOverlay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerOverlay.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerOverlay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
public final class TileLayerOverlay
extends TileLayer {
    @NotNull
    private final Image highlight;
    @NotNull
    private final Image crosshair;
    @NotNull
    private final Image goodCityLocationIndicator;
    @NotNull
    private final Image fog;
    @NotNull
    private final Image unexplored;

    public TileLayerOverlay(@NotNull TileGroup tileGroup, float size2) {
        Color color;
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.highlight = TileLayer.setHexagonSize$default(this, ImageGetter.INSTANCE.getImage(this.strings().getHighlight()), null, 1, null);
        this.crosshair = TileLayer.setHexagonSize$default(this, ImageGetter.INSTANCE.getImage(this.strings().getCrosshair()), null, 1, null);
        this.goodCityLocationIndicator = this.setHexagonSize(ImageGetter.INSTANCE.getImage("OtherIcons/Cities"), Float.valueOf(0.25f));
        this.fog = TileLayer.setHexagonSize$default(this, ImageGetter.INSTANCE.getImage(this.strings().getCrosshatchHexagon()), null, 1, null);
        this.unexplored = TileLayer.setHexagonSize$default(this, ImageGetter.INSTANCE.getImage(this.strings().getUnexploredTile()), null, 1, null);
        this.highlight.setVisible(false);
        this.crosshair.setVisible(false);
        this.goodCityLocationIndicator.setVisible(false);
        this.fog.setVisible(false);
        Color color2 = color = Color.WHITE.cpy();
        Image image2 = this.fog;
        boolean bl = false;
        $this$_init__u24lambda_u240.a = 0.2f;
        image2.setColor(color);
        if (ImageGetter.INSTANCE.imageExists(this.strings().getUnexploredTile())) {
            this.addActor(this.unexplored);
        }
        this.addActor(this.highlight);
        this.addActor(this.fog);
        this.addActor(this.crosshair);
        this.addActor(this.goodCityLocationIndicator);
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    public final void showCrosshair(float alpha) {
        this.crosshair.setVisible(true);
        this.crosshair.getColor().a = alpha;
        this.determineVisibility();
    }

    public static /* synthetic */ void showCrosshair$default(TileLayerOverlay tileLayerOverlay, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        tileLayerOverlay.showCrosshair(f);
    }

    public final void hideCrosshair() {
        this.crosshair.setVisible(false);
        this.determineVisibility();
    }

    public final void showHighlight(@NotNull Color color, float alpha) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        this.highlight.setVisible(true);
        Color color3 = color2 = color.cpy();
        Image image2 = this.highlight;
        boolean bl = false;
        $this$showHighlight_u24lambda_u241.a = alpha;
        image2.setColor(color2);
        this.determineVisibility();
    }

    public static /* synthetic */ void showHighlight$default(TileLayerOverlay tileLayerOverlay, Color color, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.3f;
        }
        tileLayerOverlay.showHighlight(color, f);
    }

    public final void showHighlight() {
        this.highlight.setVisible(true);
        this.determineVisibility();
    }

    public final void hideHighlight() {
        this.highlight.setVisible(false);
        this.determineVisibility();
    }

    public final void showGoodCityLocationIndicator() {
        this.goodCityLocationIndicator.setVisible(true);
        this.determineVisibility();
    }

    public final void hideGoodCityLocationIndicator() {
        this.goodCityLocationIndicator.setVisible(false);
        this.determineVisibility();
    }

    public final void reset() {
        this.fog.setVisible(true);
        this.highlight.setVisible(false);
        this.crosshair.setVisible(false);
        this.goodCityLocationIndicator.setVisible(false);
        this.determineVisibility();
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean isViewable = viewingCiv == null || this.isViewable(viewingCiv);
        this.fog.setVisible(!isViewable && !this.getTileGroup().isForceVisible());
        if (viewingCiv == null) {
            return;
        }
        this.unexplored.setVisible(!viewingCiv.hasExplored(this.tile()));
        if (Intrinsics.areEqual(this.tile().getShownImprovement(viewingCiv), "Barbarian encampment") && this.tile().isExplored(viewingCiv)) {
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            TileLayerOverlay.showHighlight$default(this, color, 0.0f, 2, null);
        }
    }

    @Override
    protected void determineVisibility() {
        this.setVisible(this.fog.isVisible() || this.highlight.isVisible() || this.crosshair.isVisible() || this.goodCityLocationIndicator.isVisible());
    }
}

