/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.UnitArtSlot;
import com.unciv.ui.images.ImageGetter;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0014J\u0006\u0010\u000e\u001a\u00020\u000bJ\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u000bJ\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitArt;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "slot1", "Lcom/unciv/ui/components/tilegroups/layers/UnitArtSlot;", "slot2", "act", "", "delta", "determineVisibility", "dim", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "reset", "showMilitaryUnit", "updateSlot", "slot", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isShown", "core"})
public final class TileLayerUnitArt
extends TileLayer {
    @NotNull
    private UnitArtSlot slot1;
    @NotNull
    private UnitArtSlot slot2;

    public TileLayerUnitArt(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.slot1 = new UnitArtSlot();
        this.slot2 = new UnitArtSlot();
        this.addActor(this.slot1);
        this.addActor(this.slot2);
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    private final boolean showMilitaryUnit(Civilization viewingCiv) {
        return this.getTileGroup().isForceVisible() || viewingCiv.getViewableInvisibleUnitsTiles().contains(this.getTileGroup().getTile()) || !this.getTileGroup().getTile().hasEnemyInvisibleUnit(viewingCiv);
    }

    private final void updateSlot(UnitArtSlot slot, MapUnit unit, boolean isShown) {
        String location = "";
        String nationName = "";
        if (unit != null && isShown && UncivGame.Companion.getCurrent().getSettings().getShowPixelUnits()) {
            location = this.strings().getUnitImageLocation(unit);
            nationName = unit.getCiv().getCivName() + '-';
        }
        if (!Intrinsics.areEqual(slot.getImageLocation(), nationName + location)) {
            slot.setImageLocation(nationName + location);
            slot.clear();
            if (!Intrinsics.areEqual(location, "") && ImageGetter.INSTANCE.imageExists(location)) {
                MapUnit mapUnit = unit;
                Intrinsics.checkNotNull(mapUnit);
                Nation nation2 = mapUnit.getCiv().getNation();
                Color[] colorArray = new Color[]{null, nation2.getInnerColor(), nation2.getOuterColor()};
                ArrayList<Image> pixelUnitImages = ImageGetter.INSTANCE.getLayeredImageColored(location, colorArray);
                for (Image pixelUnitImage : pixelUnitImages) {
                    slot.addActor(pixelUnitImage);
                    TileLayer tileLayer = this;
                    Intrinsics.checkNotNullExpressionValue(pixelUnitImage, "pixelUnitImage");
                    TileLayer.setHexagonSize$default(tileLayer, pixelUnitImage, null, 1, null);
                }
            }
        }
    }

    public final void dim() {
        this.getColor().a = 0.5f;
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        MapUnit slot1Unit = this.getTileGroup().getTile().getCivilianUnit();
        MapUnit slot2Unit = this.getTileGroup().getTile().getMilitaryUnit();
        boolean isPixelUnitsEnabled = UncivGame.Companion.getCurrent().getSettings().getShowPixelUnits();
        boolean isViewable = viewingCiv == null || this.isViewable(viewingCiv);
        boolean isVisibleMilitary = viewingCiv == null || this.showMilitaryUnit(viewingCiv);
        boolean isSlot1Shown = isPixelUnitsEnabled && isViewable;
        boolean isSlot2Shown = isPixelUnitsEnabled && isViewable && isVisibleMilitary;
        this.updateSlot(this.slot1, slot1Unit, isSlot1Shown);
        this.updateSlot(this.slot2, slot2Unit, isSlot2Shown);
    }

    @Override
    protected void determineVisibility() {
        this.setVisible(this.slot1.hasChildren() || this.slot2.hasChildren());
    }

    public final void reset() {
        this.slot1.clear();
        this.slot2.clear();
        this.slot1.setImageLocation("");
        this.slot2.setImageLocation("");
    }
}

