/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.widgets.UnitGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0002J\u001a\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u000bH\u0002J.\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0006\u0010\u001f\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "slot1Icon", "Lcom/unciv/ui/components/widgets/UnitGroup;", "slot2Icon", "act", "", "delta", "clearSlots", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "fillSlots", "getAirUnitTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getFlag", "highlightRed", "newUnitIcon", "slot", "", "isViewable", "", "reset", "selectFlag", "setIconPosition", "icon", "showMilitaryUnit", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerUnitFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerUnitFlag.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1747#2,3:160\n*S KotlinDebug\n*F\n+ 1 TileLayerUnitFlag.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerUnitFlag\n*L\n61#1:160,3\n*E\n"})
public final class TileLayerUnitFlag
extends TileLayer {
    @Nullable
    private UnitGroup slot1Icon;
    @Nullable
    private UnitGroup slot2Icon;

    public TileLayerUnitFlag(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.setTouchable(Touchable.disabled);
    }

    @Override
    public void act(float delta) {
        for (Actor child : this.getChildren()) {
            child.act(delta);
        }
    }

    private final void clearSlots() {
        block1: {
            UnitGroup unitGroup = this.slot1Icon;
            if (unitGroup != null) {
                unitGroup.remove();
            }
            UnitGroup unitGroup2 = this.slot2Icon;
            if (unitGroup2 == null) break block1;
            unitGroup2.remove();
        }
    }

    private final boolean showMilitaryUnit(Civilization viewingCiv) {
        return this.getTileGroup().isForceVisible() || viewingCiv.getViewableInvisibleUnitsTiles().contains(this.getTileGroup().getTile()) || !this.getTileGroup().getTile().hasEnemyInvisibleUnit(viewingCiv);
    }

    private final void setIconPosition(int slot, UnitGroup icon) {
        switch (slot) {
            case 0: {
                Scene2dExtensionsKt.center((Actor)icon, this);
                icon.setY(icon.getY() + -20.0f);
                break;
            }
            case 1: {
                Scene2dExtensionsKt.center((Actor)icon, this);
                icon.setY(icon.getY() + 20.0f);
            }
        }
    }

    private final UnitGroup newUnitIcon(int slot, MapUnit unit, boolean isViewable, Civilization viewingCiv) {
        UnitGroup newIcon = null;
        if (unit != null && isViewable) {
            boolean bl;
            block8: {
                newIcon = new UnitGroup(unit, 30.0f);
                this.addActor(newIcon);
                this.setIconPosition(slot, newIcon);
                Iterable $this$any$iv = unit.getTile().getAirUnits();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MapUnit it = (MapUnit)element$iv;
                        boolean bl2 = false;
                        if (!unit.isTransportTypeOf(it)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl && !unit.getTile().isCityCenter()) {
                Table table2 = this.getAirUnitTable(unit);
                newIcon.addActor(table2);
                table2.toBack();
                table2.setY(newIcon.getHeight() / (float)2 - table2.getHeight() / (float)2);
                table2.setX(newIcon.getWidth() - table2.getWidth() * 0.45f);
            }
            if (Intrinsics.areEqual(unit.getCiv(), viewingCiv) && !MapUnit.isIdle$default(unit, false, 1, null) && UncivGame.Companion.getCurrent().getSettings().getUnitIconOpacity() == 1.0f) {
                Group group = newIcon.getActionGroup();
                if ((group != null ? group.getColor() : null) != null) {
                    (group != null ? group.getColor() : null).a = 0.5f;
                }
            }
            if (Intrinsics.areEqual(unit.getCiv(), viewingCiv) && unit.getCurrentMovement() == 0.0f) {
                newIcon.getColor().a = 0.5f * UncivGame.Companion.getCurrent().getSettings().getUnitIconOpacity();
            }
        }
        return newIcon;
    }

    private final Table getAirUnitTable(MapUnit unit) {
        Color iconColor = unit.getCiv().getNation().getOuterColor();
        Color bgColor = unit.getCiv().getNation().getInnerColor();
        Table airUnitTable = new Table();
        airUnitTable.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/AirUnitTable", "", bgColor));
        airUnitTable.pad(0.0f).defaults().pad(0.0f);
        airUnitTable.setSize(28.0f, 12.0f);
        Table table2 = new Table();
        Image aircraftImage = ImageGetter.INSTANCE.getImage("OtherIcons/Aircraft");
        aircraftImage.setColor(iconColor);
        table2.add((Actor)aircraftImage).size(8.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(String.valueOf(unit.getTile().getAirUnits().size()), iconColor, 10, 1, false, 8, null));
        airUnitTable.add((Actor)table2).expand().center().right();
        return airUnitTable;
    }

    public final void selectFlag(@NotNull MapUnit unit) {
        block0: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            UnitGroup unitGroup = this.getFlag(unit);
            if (unitGroup == null) break block0;
            unitGroup.selectUnit();
        }
    }

    @Nullable
    public final UnitGroup getFlag(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        UnitGroup unitGroup = this.slot1Icon;
        if (Intrinsics.areEqual(unitGroup != null ? unitGroup.getUnit() : null, unit)) {
            return this.slot1Icon;
        }
        UnitGroup unitGroup2 = this.slot2Icon;
        if (Intrinsics.areEqual(unitGroup2 != null ? unitGroup2.getUnit() : null, unit)) {
            return this.slot2Icon;
        }
        return null;
    }

    private final void highlightRed() {
        block1: {
            UnitGroup unitGroup = this.slot1Icon;
            if (unitGroup != null) {
                unitGroup.highlightRed();
            }
            UnitGroup unitGroup2 = this.slot2Icon;
            if (unitGroup2 == null) break block1;
            unitGroup2.highlightRed();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void fillSlots(Civilization viewingCiv) {
        v0 = isForceVisible = viewingCiv == null || this.getTileGroup().isForceVisible() != false;
        if (isForceVisible) ** GOTO lbl-1000
        v1 = viewingCiv;
        Intrinsics.checkNotNull(v1);
        if (this.isViewable(v1)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = isViewable = false;
        }
        if (isForceVisible) ** GOTO lbl-1000
        v3 = viewingCiv;
        Intrinsics.checkNotNull(v3);
        if (this.showMilitaryUnit(v3)) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        isVisibleMilitary = v4;
        isSlot1Shown = isViewable;
        isSlot2Shown = isViewable != false && isVisibleMilitary != false;
        this.slot1Icon = this.newUnitIcon(0, this.getTileGroup().getTile().getCivilianUnit(), isSlot1Shown, viewingCiv);
        this.slot2Icon = this.newUnitIcon(1, this.getTileGroup().getTile().getMilitaryUnit(), isSlot2Shown, viewingCiv);
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.clearSlots();
        this.fillSlots(viewingCiv);
        if (viewingCiv != null) {
            boolean shouldBeHighlighted;
            Sequence<MapUnit> unitsInTile = this.tile().getUnits();
            boolean bl = shouldBeHighlighted = SequencesKt.any(unitsInTile) && SequencesKt.first(unitsInTile).getCiv().isAtWarWith(viewingCiv) && this.isViewable(viewingCiv) && this.showMilitaryUnit(viewingCiv);
            if (shouldBeHighlighted) {
                this.highlightRed();
            }
        }
    }

    public final void reset() {
        this.clearSlots();
    }
}

