/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J(\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/unciv/ui/components/widgets/BorderedTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "path", "", "defaultBgShape", "defaultBgBorder", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "bgBorder", "Lcom/badlogic/gdx/scenes/scene2d/utils/Drawable;", "bgBorderColor", "Lcom/badlogic/gdx/graphics/Color;", "getBgBorderColor", "()Lcom/badlogic/gdx/graphics/Color;", "setBgBorderColor", "(Lcom/badlogic/gdx/graphics/Color;)V", "bgColor", "getBgColor", "setBgColor", "bgInner", "borderOnTop", "", "getBorderOnTop", "()Z", "setBorderOnTop", "(Z)V", "borderSize", "", "getBorderSize", "()F", "setBorderSize", "(F)V", "getPath", "()Ljava/lang/String;", "drawBackground", "", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "x", "y", "core"})
public class BorderedTable
extends Table {
    @NotNull
    private final String path;
    @NotNull
    private Color bgColor;
    @NotNull
    private Color bgBorderColor;
    private float borderSize;
    private boolean borderOnTop;
    @NotNull
    private Drawable bgInner;
    @NotNull
    private Drawable bgBorder;

    public BorderedTable(@NotNull String path, @NotNull String defaultBgShape, @NotNull String defaultBgBorder) {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(defaultBgShape, "defaultBgShape");
        Intrinsics.checkNotNullParameter(defaultBgBorder, "defaultBgBorder");
        this.path = path;
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color, "BLACK");
        this.bgColor = color;
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
        this.bgBorderColor = color2;
        this.borderSize = 5.0f;
        this.bgInner = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), this.path, defaultBgShape, null, 4, null);
        this.bgBorder = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), this.path + "Border", defaultBgBorder, null, 4, null);
    }

    public /* synthetic */ BorderedTable(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = BaseScreen.Companion.getSkinStrings().getRectangleWithOutlineShape();
        }
        if ((n & 4) != 0) {
            string3 = BaseScreen.Companion.getSkinStrings().getRectangleWithOutlineShape();
        }
        this(string, string2, string3);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Color getBgColor() {
        return this.bgColor;
    }

    public final void setBgColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.bgColor = color;
    }

    @NotNull
    public final Color getBgBorderColor() {
        return this.bgBorderColor;
    }

    public final void setBgBorderColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "<set-?>");
        this.bgBorderColor = color;
    }

    public final float getBorderSize() {
        return this.borderSize;
    }

    public final void setBorderSize(float f) {
        this.borderSize = f;
    }

    public final boolean getBorderOnTop() {
        return this.borderOnTop;
    }

    public final void setBorderOnTop(boolean bl) {
        this.borderOnTop = bl;
    }

    @Override
    protected void drawBackground(@NotNull Batch batch, float parentAlpha, float x, float y) {
        Intrinsics.checkNotNullParameter(batch, "batch");
        if (this.borderOnTop) {
            batch.setColor(this.bgColor.r * this.getColor().r, this.bgColor.g * this.getColor().g, this.bgColor.b * this.getColor().b, this.bgColor.a * this.getColor().a * parentAlpha);
            this.bgInner.draw(batch, x, y, this.getWidth(), this.getHeight());
            batch.setColor(this.bgBorderColor.r * this.getColor().r, this.bgBorderColor.g * this.getColor().g, this.bgBorderColor.b * this.getColor().b, this.bgBorderColor.a * this.getColor().a * parentAlpha);
            this.bgBorder.draw(batch, x - this.borderSize / (float)2, y - this.borderSize / (float)2, this.getWidth() + this.borderSize, this.getHeight() + this.borderSize);
        } else {
            batch.setColor(this.bgBorderColor.r * this.getColor().r, this.bgBorderColor.g * this.getColor().g, this.bgBorderColor.b * this.getColor().b, this.bgBorderColor.a * this.getColor().a * parentAlpha);
            this.bgBorder.draw(batch, x - this.borderSize / (float)2, y - this.borderSize / (float)2, this.getWidth() + this.borderSize, this.getHeight() + this.borderSize);
            batch.setColor(this.bgColor.r * this.getColor().r, this.bgColor.g * this.getColor().g, this.bgColor.b * this.getColor().b, this.bgColor.a * this.getColor().a * parentAlpha);
            this.bgInner.draw(batch, x, y, this.getWidth(), this.getHeight());
        }
    }
}

