/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002&'B@\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012%\b\u0002\u0010\u0006\u001a\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0002J\b\u0010#\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020\u000bH\u0002J\b\u0010%\u001a\u00020\u000bH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0006\u001a\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/ui/components/widgets/KeyCapturingButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/ImageTextButton;", "default", "Lcom/unciv/ui/components/input/KeyCharAndCode;", "initialStyle", "Lcom/unciv/ui/components/widgets/KeyCapturingButton$KeyCapturingButtonStyle;", "onKeyHit", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "key", "", "(Lcom/unciv/ui/components/input/KeyCharAndCode;Lcom/unciv/ui/components/widgets/KeyCapturingButton$KeyCapturingButtonStyle;Lkotlin/jvm/functions/Function1;)V", "conflictStyle", "Lcom/badlogic/gdx/scenes/scene2d/ui/ImageTextButton$ImageTextButtonStyle;", "value", "current", "getCurrent", "()Lcom/unciv/ui/components/input/KeyCharAndCode;", "setCurrent", "(Lcom/unciv/ui/components/input/KeyCharAndCode;)V", "defaultStyle", "", "markConflict", "getMarkConflict", "()Z", "setMarkConflict", "(Z)V", "normalStyle", "savedFocus", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "handleKey", "code", "", "control", "resetKey", "updateLabel", "updateStyle", "ButtonListener", "KeyCapturingButtonStyle", "core"})
public final class KeyCapturingButton
extends ImageTextButton {
    @NotNull
    private final KeyCharAndCode default;
    @Nullable
    private final Function1<KeyCharAndCode, Unit> onKeyHit;
    @NotNull
    private KeyCharAndCode current;
    private boolean markConflict;
    @Nullable
    private Actor savedFocus;
    @NotNull
    private final ImageTextButton.ImageTextButtonStyle normalStyle;
    @NotNull
    private final ImageTextButton.ImageTextButtonStyle defaultStyle;
    @NotNull
    private final ImageTextButton.ImageTextButtonStyle conflictStyle;

    public KeyCapturingButton(@NotNull KeyCharAndCode keyCharAndCode, @NotNull KeyCapturingButtonStyle initialStyle, @Nullable Function1<? super KeyCharAndCode, Unit> onKeyHit2) {
        Intrinsics.checkNotNullParameter(keyCharAndCode, "default");
        Intrinsics.checkNotNullParameter(initialStyle, "initialStyle");
        super("", initialStyle);
        this.default = keyCharAndCode;
        this.onKeyHit = onKeyHit2;
        this.current = KeyCharAndCode.Companion.getUNKNOWN();
        Cell cell2 = this.getImageCell();
        ImageTextButton.ImageTextButtonStyle imageTextButtonStyle = this.getStyle();
        Intrinsics.checkNotNull(imageTextButtonStyle, "null cannot be cast to non-null type com.unciv.ui.components.widgets.KeyCapturingButton.KeyCapturingButtonStyle");
        cell2.size(((KeyCapturingButtonStyle)imageTextButtonStyle).getImageSize());
        this.getImageCell().align(10);
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, image2, "Hit the desired key now", 18.0f, false, 20, 0, false, null, 116, null);
        this.getLabelCell().expandX();
        ImageTextButton.ImageTextButtonStyle imageTextButtonStyle2 = this.getStyle();
        Intrinsics.checkNotNullExpressionValue(imageTextButtonStyle2, "style");
        this.normalStyle = imageTextButtonStyle2;
        this.defaultStyle = new ImageTextButton.ImageTextButtonStyle(this.normalStyle);
        this.defaultStyle.fontColor = Color.GRAY.cpy();
        this.conflictStyle = new ImageTextButton.ImageTextButtonStyle(this.normalStyle);
        this.conflictStyle.fontColor = Color.RED.cpy();
        this.addListener(new ButtonListener(this));
    }

    public /* synthetic */ KeyCapturingButton(KeyCharAndCode keyCharAndCode, KeyCapturingButtonStyle keyCapturingButtonStyle, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyCharAndCode = KeyCharAndCode.Companion.getUNKNOWN();
        }
        if ((n & 2) != 0) {
            keyCapturingButtonStyle = new KeyCapturingButtonStyle(0.0f, null, null, null, 0.0f, 0.0f, 63, null);
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(keyCharAndCode, keyCapturingButtonStyle, function1);
    }

    @NotNull
    public final KeyCharAndCode getCurrent() {
        return this.current;
    }

    public final void setCurrent(@NotNull KeyCharAndCode value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.current = value;
        this.updateLabel();
    }

    public final boolean getMarkConflict() {
        return this.markConflict;
    }

    public final void setMarkConflict(boolean value) {
        this.markConflict = value;
        this.updateStyle();
    }

    private final void updateLabel() {
        this.getLabel().setText(Intrinsics.areEqual(this.current, KeyCharAndCode.Companion.getBACK()) ? "ESC/Back" : this.current.toString());
        this.updateStyle();
    }

    private final void updateStyle() {
        this.setStyle(this.markConflict ? this.conflictStyle : (Intrinsics.areEqual(this.current, this.default) ? this.defaultStyle : this.normalStyle));
    }

    private final void handleKey(int code, boolean control) {
        block0: {
            this.setCurrent(control ? KeyCharAndCode.Companion.ctrlFromCode(code) : new KeyCharAndCode(code));
            Function1<KeyCharAndCode, Unit> function1 = this.onKeyHit;
            if (function1 == null) break block0;
            function1.invoke(this.current);
        }
    }

    private final void resetKey() {
        block0: {
            this.setCurrent(this.default);
            Function1<KeyCharAndCode, Unit> function1 = this.onKeyHit;
            if (function1 == null) break block0;
            function1.invoke(this.current);
        }
    }

    public KeyCapturingButton() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J4\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J4\u0010\u0011\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/components/widgets/KeyCapturingButton$ButtonListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/ClickListener;", "myButton", "Lcom/unciv/ui/components/widgets/KeyCapturingButton;", "(Lcom/unciv/ui/components/widgets/KeyCapturingButton;)V", "clicked", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "enter", "pointer", "", "fromActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "exit", "toActor", "keyDown", "", "keycode", "mapEscToBack", "core"})
    private static final class ButtonListener
    extends ClickListener {
        @NotNull
        private final KeyCapturingButton myButton;

        public ButtonListener(@NotNull KeyCapturingButton myButton) {
            Intrinsics.checkNotNullParameter(myButton, "myButton");
            this.myButton = myButton;
        }

        @Override
        public void enter(@Nullable InputEvent event, float x, float y, int pointer, @Nullable Actor fromActor) {
            if (this.myButton.getStage() == null) {
                return;
            }
            this.myButton.savedFocus = this.myButton.getStage().getKeyboardFocus();
            this.myButton.getStage().setKeyboardFocus(this.myButton);
        }

        @Override
        public void exit(@Nullable InputEvent event, float x, float y, int pointer, @Nullable Actor toActor) {
            if (this.myButton.getStage() == null) {
                return;
            }
            this.myButton.getStage().setKeyboardFocus(this.myButton.savedFocus);
            this.myButton.savedFocus = null;
        }

        @Override
        public boolean keyDown(@Nullable InputEvent event, int keycode) {
            block4: {
                if (keycode == 0) {
                    return false;
                }
                switch (keycode) {
                    case 129: 
                    case 130: {
                        return false;
                    }
                }
                int n = this.mapEscToBack(keycode);
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                this.myButton.handleKey(n, Scene2dExtensionsKt.isControlKeyPressed(input2));
                InputEvent inputEvent = event;
                if (inputEvent == null) break block4;
                inputEvent.cancel();
            }
            return true;
        }

        private final int mapEscToBack(int keycode) {
            return keycode == 111 ? 4 : keycode;
        }

        @Override
        public void clicked(@Nullable InputEvent event, float x, float y) {
            block3: {
                block2: {
                    if (this.getTapCount() < 2) break block2;
                    InputEvent inputEvent = event;
                    if ((inputEvent != null ? inputEvent.getTarget() : null) instanceof Image) break block3;
                }
                return;
            }
            this.myButton.resetKey();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/components/widgets/KeyCapturingButton$KeyCapturingButtonStyle;", "Lcom/badlogic/gdx/scenes/scene2d/ui/ImageTextButton$ImageTextButtonStyle;", "imageSize", "", "imageName", "", "imageUpTint", "Lcom/badlogic/gdx/graphics/Color;", "imageOverTint", "minWidth", "minHeight", "(FLjava/lang/String;Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;FF)V", "getImageSize", "()F", "core"})
    public static final class KeyCapturingButtonStyle
    extends ImageTextButton.ImageTextButtonStyle {
        private final float imageSize;

        /*
         * WARNING - void declaration
         */
        public KeyCapturingButtonStyle(float imageSize, @NotNull String imageName, @NotNull Color imageUpTint, @NotNull Color imageOverTint, float minWidth, float minHeight) {
            void $this$_init__u24lambda_u240;
            Intrinsics.checkNotNullParameter(imageName, "imageName");
            Intrinsics.checkNotNullParameter(imageUpTint, "imageUpTint");
            Intrinsics.checkNotNullParameter(imageOverTint, "imageOverTint");
            this.imageSize = imageSize;
            this.font = Fonts.INSTANCE.getFont();
            this.fontColor = Color.WHITE;
            TextureRegionDrawable image2 = ImageGetter.INSTANCE.getDrawable(imageName);
            this.imageUp = Intrinsics.areEqual(imageUpTint, Color.CLEAR) ? (Drawable)image2 : image2.tint(imageUpTint);
            this.imageOver = Intrinsics.areEqual(imageOverTint, Color.CLEAR) ? this.imageUp : image2.tint(imageOverTint);
            SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
            KeyCapturingButtonStyle keyCapturingButtonStyle = this;
            boolean bl = false;
            keyCapturingButtonStyle.up = $this$_init__u24lambda_u240.getUiBackground("General/KeyCapturingButton", $this$_init__u24lambda_u240.getRoundedEdgeRectangleSmallShape(), $this$_init__u24lambda_u240.getSkinConfig().getBaseColor());
            this.up.setMinWidth(minWidth);
            this.up.setMinHeight(minHeight);
        }

        public /* synthetic */ KeyCapturingButtonStyle(float f, String string, Color color, Color color2, float f2, float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                f = 24.0f;
            }
            if ((n & 2) != 0) {
                string = "OtherIcons/Keyboard";
            }
            if ((n & 4) != 0) {
                Color color3 = Color.CLEAR;
                Intrinsics.checkNotNullExpressionValue(color3, "CLEAR");
                color = color3;
            }
            if ((n & 8) != 0) {
                Color color4 = Color.LIME;
                Intrinsics.checkNotNullExpressionValue(color4, "LIME");
                color2 = color4;
            }
            if ((n & 0x10) != 0) {
                f2 = 150.0f;
            }
            if ((n & 0x20) != 0) {
                f3 = f;
            }
            this(f, string, color, color2, f2, f3);
        }

        public final float getImageSize() {
            return this.imageSize;
        }

        public KeyCapturingButtonStyle() {
            this(0.0f, null, null, null, 0.0f, 0.0f, 63, null);
        }
    }
}

