/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.badlogic.gdx.utils.Timer;
import com.unciv.models.UncivSound;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0016*\u0001<\u0018\u0000 O2\u00020\u0001:\u0002OPB}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0016\b\u0002\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0016\b\u0002\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010C\u001a\u00020\u0003H\u0002J\b\u0010D\u001a\u00020\u0012H\u0002J\b\u0010E\u001a\u00020\u0012H\u0002J\b\u0010F\u001a\u00020\u0012H\u0002J\b\u0010G\u001a\u00020\u0012H\u0002J\u0016\u0010H\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u001a\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u00032\n\u0010K\u001a\u000202\"\u00020\u0003J\b\u0010L\u001a\u00020\u0012H\u0002J\b\u0010M\u001a\u00020\u0012H\u0002J\b\u0010N\u001a\u00020\u0012H\u0002R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001b\u0010\u0018R \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\u00020\u00038F\u00a2\u0006\f\u0012\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\u00020\u00038F\u00a2\u0006\f\u0012\u0004\b)\u0010\u001d\u001a\u0004\b*\u0010'R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010'\"\u0004\b5\u00106R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010=R\u000e\u0010>\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010'\"\u0004\bA\u00106\u00a8\u0006Q"}, d2={"Lcom/unciv/ui/components/widgets/UncivSlider;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "min", "", "max", "step", "vertical", "", "plusMinus", "initial", "sound", "Lcom/unciv/models/UncivSound;", "tipType", "Lcom/unciv/ui/components/widgets/UncivSlider$TipType;", "getTipText", "Lkotlin/Function1;", "", "onChange", "", "(FFFZZFLcom/unciv/models/UncivSound;Lcom/unciv/ui/components/widgets/UncivSlider$TipType;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "blockListener", "hasFocus", "value", "isDisabled", "()Z", "setDisabled", "(Z)V", "isDragging", "isDragging$annotations", "()V", "killedCaptureListeners", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "", "Lcom/badlogic/gdx/scenes/scene2d/EventListener;", "killedListeners", "maxValue", "getMaxValue$annotations", "getMaxValue", "()F", "minValue", "getMinValue$annotations", "getMinValue", "minusButton", "Lcom/unciv/ui/images/IconCircleGroup;", "plusButton", "slider", "Lcom/badlogic/gdx/scenes/scene2d/ui/Slider;", "snapThreshold", "snapToValues", "", "stepSize", "getStepSize", "setStepSize", "(F)V", "tipContainer", "Lcom/badlogic/gdx/scenes/scene2d/ui/Container;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "tipFormat", "tipHideTask", "com/unciv/ui/components/widgets/UncivSlider$tipHideTask$1", "Lcom/unciv/ui/components/widgets/UncivSlider$tipHideTask$1;", "tipLabel", "newValue", "getValue", "setValue", "addToValue", "delta", "hideTip", "killScrollPanes", "resurrectScrollPanes", "setPlusMinusEnabled", "setRange", "setSnapToValues", "threshold", "values", "showTip", "stepChanged", "valueChanged", "Companion", "TipType", "core"})
@SourceDebugExtension(value={"SMAP\nUncivSlider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivSlider.kt\ncom/unciv/ui/components/widgets/UncivSlider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,341:1\n1#2:342\n1855#3,2:343\n1855#3,2:345\n*S KotlinDebug\n*F\n+ 1 UncivSlider.kt\ncom/unciv/ui/components/widgets/UncivSlider\n*L\n296#1:343,2\n300#1:345,2\n*E\n"})
public final class UncivSlider
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TipType tipType;
    @Nullable
    private final Function1<Float, String> getTipText;
    @Nullable
    private final Function1<Float, Unit> onChange;
    @NotNull
    private final Slider slider;
    @Nullable
    private final IconCircleGroup minusButton;
    @Nullable
    private final IconCircleGroup plusButton;
    @NotNull
    private final Label tipLabel;
    @NotNull
    private final Container<Label> tipContainer;
    @NotNull
    private final tipHideTask.1 tipHideTask;
    @Nullable
    private float[] snapToValues;
    private float snapThreshold;
    @NotNull
    private String tipFormat;
    private boolean hasFocus;
    private boolean blockListener;
    @NotNull
    private final Map<ScrollPane, List<EventListener>> killedListeners;
    @NotNull
    private final Map<ScrollPane, List<EventListener>> killedCaptureListeners;
    public static final int plusMinusFontSize = 18;
    public static final float plusMinusCircleSize = 20.0f;
    public static final float padding = 5.0f;
    public static final float hideDelay = 3.0f;
    public static final float tipAnimationDuration = 0.2f;

    /*
     * WARNING - void declaration
     */
    public UncivSlider(float min, float max, float step, boolean vertical, boolean plusMinus, float initial, final @NotNull UncivSound sound, @NotNull TipType tipType, @Nullable Function1<? super Float, String> getTipText2, @Nullable Function1<? super Float, Unit> onChange) {
        Object $this$_init__u24lambda_u241;
        UncivSlider uncivSlider;
        Cell<Actor> cell2;
        Intrinsics.checkNotNullParameter(sound, "sound");
        Intrinsics.checkNotNullParameter((Object)tipType, "tipType");
        super(BaseScreen.Companion.getSkin());
        this.tipType = tipType;
        this.getTipText = getTipText2;
        this.onChange = onChange;
        this.slider = new Slider(min, max, step, vertical, BaseScreen.Companion.getSkin());
        Color color = Color.LIGHT_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
        this.tipLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        this.tipContainer = new Container<Actor>((Actor)this.tipLabel);
        this.tipHideTask = new Timer.Task(this){
            final /* synthetic */ UncivSlider this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                UncivSlider.access$hideTip(this.this$0);
            }
        };
        this.tipFormat = "%.1f";
        this.tipLabel.setOrigin(1);
        this.tipContainer.setTouchable(Touchable.disabled);
        this.stepChanged();
        if (plusMinus) {
            void $this$_init__u24lambda_u240;
            Color color2 = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
            cell2 = Scene2dExtensionsKt.toLabel$default("-", color2, 18, 0, false, 12, null);
            Label label2 = cell2;
            uncivSlider = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.setAlignment(1);
            uncivSlider.minusButton = Scene2dExtensionsKt.surroundWithCircle$default((Actor)((Object)cell2), 20.0f, false, null, null, 14, null);
            ActivationExtensionsKt.onClick(this.minusButton, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.addToValue(-this.getStepSize());
                }
            });
            cell2 = this.add((Actor)this.minusButton);
            $this$_init__u24lambda_u241 = cell2;
            boolean bl2 = false;
            if (vertical) {
                ((Cell)$this$_init__u24lambda_u241).padBottom(5.0f);
            } else {
                ((Cell)$this$_init__u24lambda_u241).padLeft(5.0f);
            }
            if (vertical) {
                this.row();
            }
        } else {
            this.minusButton = null;
        }
        this.add((Actor)this.slider).pad(5.0f).fillY().growX();
        if (plusMinus) {
            void $this$_init__u24lambda_u242;
            if (vertical) {
                this.row();
            }
            Color color3 = Color.BLACK;
            Intrinsics.checkNotNullExpressionValue(color3, "BLACK");
            cell2 = Scene2dExtensionsKt.toLabel$default("+", color3, 18, 0, false, 12, null);
            $this$_init__u24lambda_u241 = cell2;
            uncivSlider = this;
            boolean bl = false;
            $this$_init__u24lambda_u242.setAlignment(1);
            uncivSlider.plusButton = Scene2dExtensionsKt.surroundWithCircle$default((Actor)((Object)cell2), 20.0f, false, null, null, 14, null);
            ActivationExtensionsKt.onClick(this.plusButton, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.addToValue(this.getStepSize());
                }
            });
            Cell<Actor> $this$_init__u24lambda_u243 = cell2 = this.add((Actor)this.plusButton);
            boolean bl3 = false;
            if (vertical) {
                $this$_init__u24lambda_u243.padTop(5.0f);
            } else {
                $this$_init__u24lambda_u243.padRight(5.0f);
            }
        } else {
            this.plusButton = null;
        }
        this.row();
        this.setValue(initial);
        this.slider.addListener(new ChangeListener(){

            @Override
            public void changed(@Nullable ChangeListener.ChangeEvent event, @Nullable Actor actor) {
                if (blockListener) {
                    return;
                }
                if (slider.isDragging() != hasFocus) {
                    hasFocus = slider.isDragging();
                    if (hasFocus) {
                        this.killScrollPanes();
                    } else {
                        this.resurrectScrollPanes();
                    }
                }
                this.valueChanged();
                Function1 function1 = onChange;
                if (function1 != null) {
                    function1.invoke(Float.valueOf(slider.getValue()));
                }
                SoundPlayer.INSTANCE.play(sound);
            }
        });
        this.killedListeners = new LinkedHashMap();
        this.killedCaptureListeners = new LinkedHashMap();
    }

    public /* synthetic */ UncivSlider(float f, float f2, float f3, boolean bl, boolean bl2, float f4, UncivSound uncivSound, TipType tipType, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x40) != 0) {
            uncivSound = UncivSound.Companion.getSlider();
        }
        if ((n & 0x80) != 0) {
            tipType = TipType.Permanent;
        }
        if ((n & 0x100) != 0) {
            function1 = null;
        }
        if ((n & 0x200) != 0) {
            function12 = null;
        }
        this(f, f2, f3, bl, bl2, f4, uncivSound, tipType, function1, function12);
    }

    public final float getMinValue() {
        return this.slider.getMinValue();
    }

    public static /* synthetic */ void getMinValue$annotations() {
    }

    public final float getMaxValue() {
        return this.slider.getMaxValue();
    }

    public static /* synthetic */ void getMaxValue$annotations() {
    }

    public final float getValue() {
        return this.slider.getValue();
    }

    public final void setValue(float newValue) {
        this.blockListener = true;
        this.slider.setValue(newValue);
        this.blockListener = false;
        this.valueChanged();
    }

    public final float getStepSize() {
        return this.slider.getStepSize();
    }

    public final void setStepSize(float value) {
        this.slider.setStepSize(value);
        this.stepChanged();
    }

    public final boolean isDragging() {
        return this.slider.isDragging();
    }

    public static /* synthetic */ void isDragging$annotations() {
    }

    public final boolean isDisabled() {
        return this.slider.isDisabled();
    }

    public final void setDisabled(boolean value) {
        this.slider.setDisabled(value);
        this.setPlusMinusEnabled();
    }

    public final void setRange(float min, float max) {
        this.slider.setRange(min, max);
        this.setPlusMinusEnabled();
    }

    public final void setSnapToValues(float threshold, float ... values2) {
        Intrinsics.checkNotNullParameter(values2, "values");
        this.snapToValues = values2;
        this.snapThreshold = threshold;
        this.slider.setSnapToValues(threshold, Arrays.copyOf(values2, values2.length));
    }

    private final void addToValue(float delta) {
        block10: {
            boolean bl;
            block9: {
                block8: {
                    boolean bl2 = this.snapToValues != null ? !(this.snapToValues.length == 0) : false;
                    if (!bl2) break block8;
                    Input input2 = Gdx.input;
                    Intrinsics.checkNotNullExpressionValue(input2, "input");
                    if (!Scene2dExtensionsKt.isShiftKeyPressed(input2)) break block9;
                }
                this.setValue(this.getValue() + delta);
                Function1<Float, Unit> function1 = this.onChange;
                if (function1 != null) {
                    function1.invoke(Float.valueOf(this.getValue()));
                }
                return;
            }
            float bestDiff = -1.0f;
            int bestIndex = -1;
            Intrinsics.checkNotNull(this.snapToValues);
            float[] fArray = this.snapToValues;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                float snapValue = fArray[i];
                float diff = Math.abs(this.getValue() - snapValue);
                if (!(diff <= this.snapThreshold) || bestIndex != -1 && !(diff < bestDiff)) continue;
                bestDiff = diff;
                bestIndex = i2;
            }
            if (0 <= (bestIndex += (int)Math.signum(delta))) {
                Intrinsics.checkNotNull(this.snapToValues);
                bl = bestIndex < this.snapToValues.length;
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            Intrinsics.checkNotNull(this.snapToValues);
            this.setValue(this.snapToValues[bestIndex]);
            Function1<Float, Unit> function1 = this.onChange;
            if (function1 == null) break block10;
            function1.invoke(Float.valueOf(this.getValue()));
        }
    }

    private final void valueChanged() {
        if (this.tipType != TipType.None) {
            if (this.getTipText == null) {
                String string = this.tipFormat;
                Object[] objectArray = new Object[]{Float.valueOf(this.slider.getValue())};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(this, *args)");
                this.tipLabel.setText(string2);
            } else {
                Function1<Float, String> function1 = this.getTipText;
                Intrinsics.checkNotNull(function1);
                this.tipLabel.setText(function1.invoke(Float.valueOf(this.slider.getValue())));
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.tipType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.tipHideTask.isScheduled()) {
                    this.showTip();
                }
                this.tipHideTask.cancel();
                Timer.schedule(this.tipHideTask, 3.0f);
                break;
            }
            case 3: {
                this.showTip();
            }
        }
        this.setPlusMinusEnabled();
    }

    private final void setPlusMinusEnabled() {
        block3: {
            IconCircleGroup iconCircleGroup;
            boolean enableMinus = this.slider.getValue() > this.slider.getMinValue() && !this.isDisabled();
            IconCircleGroup iconCircleGroup2 = this.minusButton;
            if (iconCircleGroup2 != null) {
                iconCircleGroup2.setTouchable(enableMinus ? Touchable.enabled : Touchable.disabled);
            }
            IconCircleGroup iconCircleGroup3 = this.minusButton;
            if (iconCircleGroup3 != null) {
                IconCircleGroup iconCircleGroup4;
                IconCircleGroup $this$setPlusMinusEnabled_u24lambda_u244 = iconCircleGroup4 = iconCircleGroup3;
                boolean bl = false;
                $this$setPlusMinusEnabled_u24lambda_u244.getCircle().getColor().a = enableMinus ? 1.0f : 0.5f;
            }
            boolean enablePlus = this.slider.getValue() < this.slider.getMaxValue() && !this.isDisabled();
            IconCircleGroup iconCircleGroup5 = this.plusButton;
            if (iconCircleGroup5 != null) {
                iconCircleGroup5.setTouchable(enablePlus ? Touchable.enabled : Touchable.disabled);
            }
            IconCircleGroup iconCircleGroup6 = this.plusButton;
            if (iconCircleGroup6 == null) break block3;
            IconCircleGroup $this$setPlusMinusEnabled_u24lambda_u245 = iconCircleGroup = iconCircleGroup6;
            boolean bl = false;
            $this$setPlusMinusEnabled_u24lambda_u245.getCircle().getColor().a = enablePlus ? 1.0f : 0.5f;
        }
    }

    private final void stepChanged() {
        String string = this.getStepSize() > 0.99f ? "%.0f" : (this.getStepSize() > 0.099f ? "%.1f" : (this.tipFormat = this.getStepSize() > 0.0099f ? "%.2f" : "%.3f"));
        if (this.tipType != TipType.None && this.getTipText == null) {
            String string2 = this.tipFormat;
            Object[] objectArray = new Object[]{Float.valueOf(this.slider.getValue())};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(this, *args)");
            this.tipLabel.setText(string3);
        }
    }

    private final void killScrollPanes() {
        Group widget = this;
        while (widget.getParent() != null) {
            List list2;
            Group group;
            Map<ScrollPane, List<EventListener>> map2;
            Intrinsics.checkNotNullExpressionValue(widget.getParent(), "widget.parent");
            if (!(widget instanceof ScrollPane)) continue;
            if (((ScrollPane)widget).getListeners().size != 0) {
                map2 = this.killedListeners;
                group = widget;
                DelayedRemovalArray<EventListener> delayedRemovalArray = ((ScrollPane)widget).getListeners();
                Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "widget.listeners");
                list2 = CollectionsKt.toList((Iterable)delayedRemovalArray);
                map2.put((ScrollPane)group, list2);
            }
            if (((ScrollPane)widget).getCaptureListeners().size != 0) {
                map2 = this.killedCaptureListeners;
                group = widget;
                DelayedRemovalArray<EventListener> delayedRemovalArray = ((ScrollPane)widget).getCaptureListeners();
                Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "widget.captureListeners");
                list2 = CollectionsKt.toList((Iterable)delayedRemovalArray);
                map2.put((ScrollPane)group, list2);
            }
            widget.clearListeners();
        }
    }

    private final void resurrectScrollPanes() {
        Group widget = null;
        widget = this;
        while (((Group)widget).getParent() != null) {
            EventListener it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Intrinsics.checkNotNullExpressionValue(((Group)widget).getParent(), "widget.parent");
            if (!(widget instanceof ScrollPane)) continue;
            List<EventListener> list2 = this.killedListeners.get(widget);
            if (list2 != null) {
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (EventListener)element$iv;
                    boolean bl = false;
                    widget.addListener(it);
                }
            }
            this.killedListeners.remove(widget);
            List<EventListener> list3 = this.killedCaptureListeners.get(widget);
            if (list3 != null) {
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (EventListener)element$iv;
                    boolean bl = false;
                    widget.addCaptureListener(it);
                }
            }
            this.killedCaptureListeners.remove(widget);
        }
    }

    private final void showTip() {
        if (this.tipContainer.hasParent()) {
            return;
        }
        this.tipContainer.pack();
        if (this.needsLayout()) {
            this.pack();
        }
        Vector2 pos = this.slider.localToParentCoordinates(new Vector2(this.slider.getWidth() / (float)2, this.slider.getHeight()));
        Container<Label> $this$showTip_u24lambda_u248 = this.tipContainer;
        boolean bl = false;
        $this$showTip_u24lambda_u248.setOrigin(4);
        $this$showTip_u24lambda_u248.setPosition(pos.x, pos.y, 4);
        $this$showTip_u24lambda_u248.setTransform(true);
        $this$showTip_u24lambda_u248.getColor().a = 0.2f;
        $this$showTip_u24lambda_u248.setScale(0.05f);
        this.addActor(this.tipContainer);
        this.tipContainer.addAction(Actions.parallel((Action)Actions.fadeIn(0.2f, Interpolation.fade), (Action)Actions.scaleTo(1.0f, 1.0f, 0.2f, Interpolation.fade)));
    }

    private final void hideTip() {
        this.tipContainer.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.alpha(0.2f, 0.2f, Interpolation.fade), (Action)Actions.scaleTo(0.05f, 0.05f, 0.2f, Interpolation.fade)), (Action)Actions.removeActor()));
    }

    public static final /* synthetic */ void access$hideTip(UncivSlider $this) {
        $this.hideTip();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/components/widgets/UncivSlider$Companion;", "", "()V", "hideDelay", "", "padding", "plusMinusCircleSize", "plusMinusFontSize", "", "tipAnimationDuration", "formatPercent", "", "value", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String formatPercent(float value) {
            return "" + (int)(value * 100.0f + 0.5f) + '%';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/components/widgets/UncivSlider$TipType;", "", "(Ljava/lang/String;I)V", "None", "Auto", "Permanent", "core"})
    public static final class TipType
    extends Enum<TipType> {
        public static final /* enum */ TipType None = new TipType();
        public static final /* enum */ TipType Auto = new TipType();
        public static final /* enum */ TipType Permanent = new TipType();
        private static final /* synthetic */ TipType[] $VALUES;

        public static TipType[] values() {
            return (TipType[])$VALUES.clone();
        }

        public static TipType valueOf(String value) {
            return Enum.valueOf(TipType.class, value);
        }

        static {
            $VALUES = tipTypeArray = new TipType[]{TipType.None, TipType.Auto, TipType.Permanent};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TipType.values().length];
            try {
                nArray[TipType.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipType.Auto.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TipType.Permanent.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

