/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.ActorGestureListener;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.utils.Array;
import com.unciv.UncivGame;
import com.unciv.ui.components.ZoomGestureListener;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b!\b\u0016\u0018\u00002\u00020\u0001:\u0003hijB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010?\u001a\u00020\u001dH\u0014J\u0016\u0010@\u001a\u00020\u001d2\u0006\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u0003J\u001a\u0010C\u001a\u00020\u001d2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020\u0003H\u0016J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\b\u0010I\u001a\u00020JH\u0014J\b\u0010K\u001a\u00020+H\u0002J\u000e\u0010K\u001a\u00020\u001d2\u0006\u0010L\u001a\u00020+J\u0006\u0010M\u001a\u00020\tJ\u0006\u0010N\u001a\u00020\tJ\b\u0010O\u001a\u00020\u001dH\u0002J\b\u0010P\u001a\u00020\u001dH\u0016J\u0010\u0010Q\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0003H\u0016J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u0003H\u0016J \u0010S\u001a\u00020\t2\u0006\u0010T\u001a\u00020\u00032\u0006\u0010U\u001a\u00020\u00032\b\b\u0002\u0010V\u001a\u00020\tJ\u0010\u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020\u0003H\u0014J\u0010\u0010Y\u001a\u00020\u001d2\u0006\u0010Z\u001a\u00020\u0003H\u0014J\u0006\u0010[\u001a\u00020:J\u0012\u0010\\\u001a\u00020\u001d2\b\u0010]\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\u0003H\u0016J\b\u0010`\u001a\u00020\u001dH\u0014J\u0006\u0010a\u001a\u00020\u001dJ\b\u0010b\u001a\u00020\u001dH\u0002J\u0010\u0010c\u001a\u00020\u001d2\u0006\u0010d\u001a\u00020\u0003H\u0016J\u0010\u0010e\u001a\u00020\u001d2\b\b\u0002\u0010f\u001a\u00020\tJ\u0010\u0010g\u001a\u00020\u001d2\b\b\u0002\u0010f\u001a\u00020\tR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0016R\"\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!Ra\u0010%\u001aI\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b()\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(*\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b'\u0012\b\b(\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020\u001d\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\"\u00101\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001f\"\u0004\b3\u0010!R\"\u00104\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001f\"\u0004\b6\u0010!R\u0010\u00107\u001a\u0004\u0018\u000108X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0010R\u0012\u0010=\u001a\u00060>R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "Lcom/badlogic/gdx/scenes/scene2d/ui/ScrollPane;", "extraCullingX", "", "extraCullingY", "minZoom", "maxZoom", "(FFFF)V", "continuousScrollingX", "", "getContinuousScrollingX", "()Z", "setContinuousScrollingX", "(Z)V", "horizontalPadding", "getHorizontalPadding", "()F", "isAutoScrollEnabled", "setAutoScrollEnabled", "mapPanningSpeed", "getMapPanningSpeed", "setMapPanningSpeed", "(F)V", "getMaxZoom", "setMaxZoom", "getMinZoom", "setMinZoom", "onPanStartListener", "Lkotlin/Function0;", "", "getOnPanStartListener", "()Lkotlin/jvm/functions/Function0;", "setOnPanStartListener", "(Lkotlin/jvm/functions/Function0;)V", "onPanStopListener", "getOnPanStopListener", "setOnPanStopListener", "onViewportChangedListener", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "width", "height", "Lcom/badlogic/gdx/math/Rectangle;", "viewport", "getOnViewportChangedListener", "()Lkotlin/jvm/functions/Function3;", "setOnViewportChangedListener", "(Lkotlin/jvm/functions/Function3;)V", "onZoomStartListener", "getOnZoomStartListener", "setOnZoomStartListener", "onZoomStopListener", "getOnZoomStopListener", "setOnZoomStopListener", "scrollingAction", "Lcom/badlogic/gdx/scenes/scene2d/Action;", "scrollingTo", "Lcom/badlogic/gdx/math/Vector2;", "verticalPadding", "getVerticalPadding", "zoomListener", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ZoomListener;", "addScrollListener", "doKeyOrMousePanning", "deltaX", "deltaY", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "getActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getFlickScrollListener", "Lcom/badlogic/gdx/scenes/scene2d/utils/ActorGestureListener;", "getViewport", "rect", "isScrolling", "isZooming", "onViewportChanged", "reloadMaxZoom", "restrictX", "restrictY", "scrollTo", "x", "y", "immediately", "scrollX", "pixelsX", "scrollY", "pixelsY", "scrollingDestination", "setActor", "content", "setScrollX", "pixels", "sizeChanged", "updateCulling", "updatePadding", "zoom", "zoomScale", "zoomIn", "immediate", "zoomOut", "FlickScrollListener", "ScrollToAction", "ZoomListener", "core"})
@SourceDebugExtension(value={"SMAP\nZoomableScrollPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZoomableScrollPane.kt\ncom/unciv/ui/components/widgets/ZoomableScrollPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,417:1\n1747#2,3:418\n1#3:421\n*S KotlinDebug\n*F\n+ 1 ZoomableScrollPane.kt\ncom/unciv/ui/components/widgets/ZoomableScrollPane\n*L\n356#1:418,3\n*E\n"})
public class ZoomableScrollPane
extends ScrollPane {
    private final float extraCullingX;
    private final float extraCullingY;
    private float minZoom;
    private float maxZoom;
    private boolean continuousScrollingX;
    @Nullable
    private Function3<? super Float, ? super Float, ? super Rectangle, Unit> onViewportChangedListener;
    @Nullable
    private Function0<Unit> onPanStopListener;
    @Nullable
    private Function0<Unit> onPanStartListener;
    @Nullable
    private Function0<Unit> onZoomStopListener;
    @Nullable
    private Function0<Unit> onZoomStartListener;
    @NotNull
    private final ZoomListener zoomListener;
    private boolean isAutoScrollEnabled;
    private float mapPanningSpeed;
    @Nullable
    private Vector2 scrollingTo;
    @Nullable
    private Action scrollingAction;

    public ZoomableScrollPane(float extraCullingX, float extraCullingY, float minZoom, float maxZoom) {
        super((Actor)new Group());
        this.extraCullingX = extraCullingX;
        this.extraCullingY = extraCullingY;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.zoomListener = new ZoomListener();
        this.mapPanningSpeed = 6.0f;
        this.addListener(this.zoomListener);
    }

    public /* synthetic */ ZoomableScrollPane(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        if ((n & 4) != 0) {
            f3 = 0.5f;
        }
        if ((n & 8) != 0) {
            f4 = 1.0f / f3;
        }
        this(f, f2, f3, f4);
    }

    public final float getMinZoom() {
        return this.minZoom;
    }

    public final void setMinZoom(float f) {
        this.minZoom = f;
    }

    public final float getMaxZoom() {
        return this.maxZoom;
    }

    public final void setMaxZoom(float f) {
        this.maxZoom = f;
    }

    public final boolean getContinuousScrollingX() {
        return this.continuousScrollingX;
    }

    public final void setContinuousScrollingX(boolean bl) {
        this.continuousScrollingX = bl;
    }

    @Nullable
    public final Function3<Float, Float, Rectangle, Unit> getOnViewportChangedListener() {
        return this.onViewportChangedListener;
    }

    public final void setOnViewportChangedListener(@Nullable Function3<? super Float, ? super Float, ? super Rectangle, Unit> function3) {
        this.onViewportChangedListener = function3;
    }

    @Nullable
    public final Function0<Unit> getOnPanStopListener() {
        return this.onPanStopListener;
    }

    public final void setOnPanStopListener(@Nullable Function0<Unit> function0) {
        this.onPanStopListener = function0;
    }

    @Nullable
    public final Function0<Unit> getOnPanStartListener() {
        return this.onPanStartListener;
    }

    public final void setOnPanStartListener(@Nullable Function0<Unit> function0) {
        this.onPanStartListener = function0;
    }

    @Nullable
    public final Function0<Unit> getOnZoomStopListener() {
        return this.onZoomStopListener;
    }

    public final void setOnZoomStopListener(@Nullable Function0<Unit> function0) {
        this.onZoomStopListener = function0;
    }

    @Nullable
    public final Function0<Unit> getOnZoomStartListener() {
        return this.onZoomStartListener;
    }

    public final void setOnZoomStartListener(@Nullable Function0<Unit> function0) {
        this.onZoomStartListener = function0;
    }

    private final float getHorizontalPadding() {
        return this.getWidth() / (float)2;
    }

    private final float getVerticalPadding() {
        return this.getHeight() / (float)2;
    }

    public final boolean isAutoScrollEnabled() {
        return this.isAutoScrollEnabled;
    }

    public final void setAutoScrollEnabled(boolean bl) {
        this.isAutoScrollEnabled = bl;
    }

    public final float getMapPanningSpeed() {
        return this.mapPanningSpeed;
    }

    public final void setMapPanningSpeed(float f) {
        this.mapPanningSpeed = f;
    }

    public void reloadMaxZoom() {
        this.maxZoom = UncivGame.Companion.getCurrent().getSettings().getMaxWorldZoomOut();
        this.minZoom = 1.0f / this.maxZoom;
        if (this.getScaleX() < this.minZoom) {
            this.zoom(1.0f);
        }
    }

    @Override
    protected void addScrollListener() {
    }

    @Override
    @Nullable
    public Actor getActor() {
        Actor actor = super.getActor();
        Intrinsics.checkNotNull(actor, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.Group");
        Group group = (Group)actor;
        return group.hasChildren() ? (Actor)group.getChildren().get(0) : null;
    }

    @Override
    public void setActor(@Nullable Actor content2) {
        Group group = (Group)super.getActor();
        if (group != null) {
            group.clearChildren();
            group.addActor(content2);
        } else {
            super.setActor(content2);
        }
    }

    @Override
    protected void scrollX(float pixelsX) {
        super.scrollX(pixelsX);
        this.updateCulling();
        this.onViewportChanged();
    }

    @Override
    public void setScrollX(float pixels) {
        float result2 = pixels;
        if (this.continuousScrollingX) {
            if (result2 < 0.0f) {
                result2 += this.getMaxX();
            } else if (result2 > this.getMaxX()) {
                result2 -= this.getMaxX();
            }
        }
        super.setScrollX(result2);
    }

    @Override
    protected void scrollY(float pixelsY) {
        super.scrollY(pixelsY);
        this.updateCulling();
        this.onViewportChanged();
    }

    @Override
    protected void sizeChanged() {
        this.updatePadding();
        super.sizeChanged();
        this.updateCulling();
    }

    private final void updatePadding() {
        Actor actor = this.getActor();
        if (actor == null) {
            return;
        }
        Actor content2 = actor;
        content2.setX(this.getHorizontalPadding());
        content2.setY(this.getVerticalPadding());
        super.getActor().setWidth(content2.getWidth() + this.getHorizontalPadding() * (float)2);
        super.getActor().setHeight(content2.getHeight() + this.getVerticalPadding() * (float)2);
    }

    public final void updateCulling() {
        Actor content2 = this.getActor();
        if (!(content2 instanceof Cullable)) {
            return;
        }
        ((Cullable)((Object)content2)).setCullingArea(ZoomableScrollPane.updateCulling$addInAllDirections(this.getViewport(), this.extraCullingX, this.extraCullingY));
    }

    public void zoom(float zoomScale) {
        float newZoom = RangesKt.coerceIn(zoomScale, this.minZoom, this.maxZoom);
        float oldZoomX = this.getScaleX();
        float oldZoomY = this.getScaleY();
        if (newZoom == oldZoomX) {
            return;
        }
        float newWidth = this.getWidth() * oldZoomX / newZoom;
        float newHeight = this.getHeight() * oldZoomY / newZoom;
        this.setScale(newZoom);
        this.setSize(newWidth, newHeight);
        this.onViewportChanged();
    }

    public final void zoomIn(boolean immediate) {
        if (immediate) {
            this.zoom(this.getScaleX() / 0.8f);
        } else {
            this.zoomListener.zoomIn(0.8f);
        }
    }

    public static /* synthetic */ void zoomIn$default(ZoomableScrollPane zoomableScrollPane, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: zoomIn");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        zoomableScrollPane.zoomIn(bl);
    }

    public final void zoomOut(boolean immediate) {
        if (immediate) {
            this.zoom(this.getScaleX() * 0.8f);
        } else {
            this.zoomListener.zoomOut(0.8f);
        }
    }

    public static /* synthetic */ void zoomOut$default(ZoomableScrollPane zoomableScrollPane, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: zoomOut");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        zoomableScrollPane.zoomOut(bl);
    }

    public final boolean isZooming() {
        return this.zoomListener.isZooming();
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        if (this.isAutoScrollEnabled && !Gdx.input.isTouched()) {
            int deltaY;
            int posX = Gdx.input.getX();
            int posY = Gdx.input.getY();
            int deltaX = posX <= 2 ? 1 : (posX >= this.getStage().getViewport().getScreenWidth() - 2 ? -1 : 0);
            int n = posY <= 6 ? -1 : (deltaY = posY >= this.getStage().getViewport().getScreenHeight() - 6 ? 1 : 0);
            if (deltaX != 0 || deltaY != 0) {
                float relativeSpeed = Gdx.graphics.getDeltaTime() / 0.01f * 0.3f;
                this.doKeyOrMousePanning((float)deltaX * relativeSpeed, (float)deltaY * relativeSpeed);
            }
        }
        super.draw(batch, parentAlpha);
    }

    public float restrictX(float deltaX) {
        return this.getScrollX() - deltaX;
    }

    public float restrictY(float deltaY) {
        return this.getScrollY() + deltaY;
    }

    public final void doKeyOrMousePanning(float deltaX, float deltaY) {
        if (deltaX == 0.0f && deltaY == 0.0f) {
            return;
        }
        float amountToMove = this.mapPanningSpeed / this.getScaleX();
        this.setScrollX(this.restrictX(deltaX * amountToMove));
        this.setScrollY(this.restrictY(deltaY * amountToMove));
        this.updateVisualScroll();
    }

    @Override
    @NotNull
    protected ActorGestureListener getFlickScrollListener() {
        return new FlickScrollListener();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isScrolling() {
        Action it;
        if (this.scrollingAction == null) return false;
        Array<Action> array = this.getActions();
        Intrinsics.checkNotNullExpressionValue(array, "actions");
        Iterable $this$any$iv = array;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Action)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual(it, this.scrollingAction));
        return true;
    }

    @NotNull
    public final Vector2 scrollingDestination() {
        Vector2 vector2;
        if (this.isScrolling()) {
            Vector2 vector22 = this.scrollingTo;
            vector2 = vector22;
            Intrinsics.checkNotNull(vector22);
        } else {
            vector2 = new Vector2(this.getScrollX(), this.getScrollY());
        }
        return vector2;
    }

    public final boolean scrollTo(float x, float y, boolean immediately) {
        if (Intrinsics.areEqual(this.scrollingDestination(), new Vector2(x, y))) {
            return false;
        }
        this.removeAction(this.scrollingAction);
        if (immediately) {
            this.setScrollX(x);
            this.setScrollY(y);
            this.updateVisualScroll();
        } else {
            this.scrollingTo = new Vector2(x, y);
            ScrollToAction action2 = new ScrollToAction(this);
            action2.setInterpolation(Interpolation.sine);
            this.addAction(action2);
            this.scrollingAction = action2;
        }
        return true;
    }

    public static /* synthetic */ boolean scrollTo$default(ZoomableScrollPane zoomableScrollPane, float f, float f2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollTo");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return zoomableScrollPane.scrollTo(f, f2, bl);
    }

    public final void getViewport(@NotNull Rectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        float viewportFromLeft = this.getScrollX();
        float viewportFromBottom = this.getMaxY() - this.getScrollY();
        rect.x = viewportFromLeft - this.getHorizontalPadding();
        rect.y = viewportFromBottom - this.getVerticalPadding();
        rect.width = this.getWidth();
        rect.height = this.getHeight();
    }

    private final Rectangle getViewport() {
        Rectangle rectangle;
        Rectangle it = rectangle = new Rectangle();
        boolean bl = false;
        this.getViewport(it);
        return rectangle;
    }

    private final void onViewportChanged() {
        block0: {
            Function3<? super Float, ? super Float, ? super Rectangle, Unit> function3 = this.onViewportChangedListener;
            if (function3 == null) break block0;
            function3.invoke(Float.valueOf(this.getMaxX()), Float.valueOf(this.getMaxY()), this.getViewport());
        }
    }

    private static final Rectangle updateCulling$addInAllDirections(Rectangle $this$updateCulling_u24addInAllDirections, float xDirectionIncrease, float yDirectionIncrease) {
        $this$updateCulling_u24addInAllDirections.x -= xDirectionIncrease;
        $this$updateCulling_u24addInAllDirections.y -= yDirectionIncrease;
        $this$updateCulling_u24addInAllDirections.width += xDirectionIncrease * (float)2;
        $this$updateCulling_u24addInAllDirections.height += yDirectionIncrease * (float)2;
        return $this$updateCulling_u24addInAllDirections;
    }

    public ZoomableScrollPane() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J2\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/components/widgets/ZoomableScrollPane$FlickScrollListener;", "Lcom/badlogic/gdx/scenes/scene2d/utils/ActorGestureListener;", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;)V", "isPanning", "", "pan", "", "event", "Lcom/badlogic/gdx/scenes/scene2d/InputEvent;", "x", "", "y", "deltaX", "deltaY", "panStop", "pointer", "", "button", "core"})
    public final class FlickScrollListener
    extends ActorGestureListener {
        private boolean isPanning;

        @Override
        public void pan(@NotNull InputEvent event, float x, float y, float deltaX, float deltaY) {
            Intrinsics.checkNotNullParameter(event, "event");
            if (!this.isPanning) {
                this.isPanning = true;
                Function0<Unit> function0 = ZoomableScrollPane.this.getOnPanStartListener();
                if (function0 != null) {
                    function0.invoke();
                }
            }
            ZoomableScrollPane.this.setScrollbarsVisible(true);
            ZoomableScrollPane.this.setScrollX(ZoomableScrollPane.this.restrictX(deltaX));
            ZoomableScrollPane.this.setScrollY(ZoomableScrollPane.this.restrictY(deltaY));
            if (ZoomableScrollPane.this.isScrollX() && !(deltaX == 0.0f) || ZoomableScrollPane.this.isScrollY() && !(deltaY == 0.0f)) {
                ZoomableScrollPane.this.cancelTouchFocus();
            }
        }

        @Override
        public void panStop(@Nullable InputEvent event, float x, float y, int pointer, int button) {
            block1: {
                if (ZoomableScrollPane.this.zoomListener.isZooming()) {
                    ZoomableScrollPane.this.zoomListener.setZooming(false);
                }
                this.isPanning = false;
                Function0<Unit> function0 = ZoomableScrollPane.this.getOnPanStopListener();
                if (function0 == null) break block1;
                function0.invoke();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ScrollToAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/FloatAction;", "zoomableScrollPane", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;)V", "originalScrollX", "", "originalScrollY", "update", "", "percent", "core"})
    public static final class ScrollToAction
    extends FloatAction {
        @NotNull
        private final ZoomableScrollPane zoomableScrollPane;
        private final float originalScrollX;
        private final float originalScrollY;

        public ScrollToAction(@NotNull ZoomableScrollPane zoomableScrollPane) {
            Intrinsics.checkNotNullParameter(zoomableScrollPane, "zoomableScrollPane");
            super(0.0f, 1.0f, 0.4f);
            this.zoomableScrollPane = zoomableScrollPane;
            this.originalScrollX = this.zoomableScrollPane.getScrollX();
            this.originalScrollY = this.zoomableScrollPane.getScrollY();
        }

        @Override
        protected void update(float percent) {
            Vector2 vector2 = this.zoomableScrollPane.scrollingTo;
            Intrinsics.checkNotNull(vector2);
            this.zoomableScrollPane.setScrollX(vector2.x * percent + this.originalScrollX * (1.0f - percent));
            Vector2 vector22 = this.zoomableScrollPane.scrollingTo;
            Intrinsics.checkNotNull(vector22);
            this.zoomableScrollPane.setScrollY(vector22.y * percent + this.originalScrollY * (1.0f - percent));
            this.zoomableScrollPane.updateVisualScroll();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\b\b\u0002\u0010\u001c\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u00020\u00132\b\b\u0002\u0010\u001c\u001a\u00020\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\f\u0018\u00010\u0010R\u00060\u0000R\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ZoomListener;", "Lcom/unciv/ui/components/ZoomGestureListener;", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane;)V", "isZooming", "", "()Z", "setZooming", "(Z)V", "lastInitialDistance", "", "lastScale", "getLastScale", "()F", "setLastScale", "(F)V", "zoomAction", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ZoomListener$ZoomAction;", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "pinch", "", "pinchStop", "scrolled", "amountX", "amountY", "zoom", "initialDistance", "distance", "zoomIn", "zoomMultiplier", "zoomOut", "ZoomAction", "core"})
    public final class ZoomListener
    extends ZoomGestureListener {
        @Nullable
        private ZoomAction zoomAction;
        private float lastInitialDistance;
        private float lastScale = 1.0f;
        private boolean isZooming;

        public final float getLastScale() {
            return this.lastScale;
        }

        public final void setLastScale(float f) {
            this.lastScale = f;
        }

        public final boolean isZooming() {
            return this.isZooming;
        }

        public final void setZooming(boolean bl) {
            this.isZooming = bl;
        }

        public final void zoomOut(float zoomMultiplier) {
            if (ZoomableScrollPane.this.getScaleX() <= ZoomableScrollPane.this.getMinZoom()) {
                if (this.zoomAction != null) {
                    ZoomAction zoomAction = this.zoomAction;
                    Intrinsics.checkNotNull(zoomAction);
                    zoomAction.finish();
                }
                return;
            }
            if (this.zoomAction != null) {
                ZoomAction zoomAction = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction);
                ZoomAction zoomAction2 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction2);
                zoomAction.setStartingZoom(zoomAction2.getCurrentZoom());
                ZoomAction zoomAction3 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction3);
                ZoomAction zoomAction4 = zoomAction3;
                zoomAction4.setFinishingZoom(zoomAction4.getFinishingZoom() * zoomMultiplier);
                ZoomAction zoomAction5 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction5);
                zoomAction5.restart();
            } else {
                ZoomAction zoomAction = this.zoomAction = new ZoomAction();
                Intrinsics.checkNotNull(zoomAction);
                zoomAction.setStartingZoom(ZoomableScrollPane.this.getScaleX());
                ZoomAction zoomAction6 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction6);
                zoomAction6.setFinishingZoom(ZoomableScrollPane.this.getScaleX() * zoomMultiplier);
                ZoomableScrollPane.this.addAction(this.zoomAction);
            }
        }

        public static /* synthetic */ void zoomOut$default(ZoomListener zoomListener, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 0.82f;
            }
            zoomListener.zoomOut(f);
        }

        public final void zoomIn(float zoomMultiplier) {
            if (ZoomableScrollPane.this.getScaleX() >= ZoomableScrollPane.this.getMaxZoom()) {
                if (this.zoomAction != null) {
                    ZoomAction zoomAction = this.zoomAction;
                    Intrinsics.checkNotNull(zoomAction);
                    zoomAction.finish();
                }
                return;
            }
            if (this.zoomAction != null) {
                ZoomAction zoomAction = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction);
                ZoomAction zoomAction2 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction2);
                zoomAction.setStartingZoom(zoomAction2.getCurrentZoom());
                ZoomAction zoomAction3 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction3);
                ZoomAction zoomAction4 = zoomAction3;
                zoomAction4.setFinishingZoom(zoomAction4.getFinishingZoom() / zoomMultiplier);
                ZoomAction zoomAction5 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction5);
                zoomAction5.restart();
            } else {
                ZoomAction zoomAction = this.zoomAction = new ZoomAction();
                Intrinsics.checkNotNull(zoomAction);
                zoomAction.setStartingZoom(ZoomableScrollPane.this.getScaleX());
                ZoomAction zoomAction6 = this.zoomAction;
                Intrinsics.checkNotNull(zoomAction6);
                zoomAction6.setFinishingZoom(ZoomableScrollPane.this.getScaleX() / zoomMultiplier);
                ZoomableScrollPane.this.addAction(this.zoomAction);
            }
        }

        public static /* synthetic */ void zoomIn$default(ZoomListener zoomListener, float f, int n, Object object) {
            if ((n & 1) != 0) {
                f = 0.82f;
            }
            zoomListener.zoomIn(f);
        }

        @Override
        public void pinch() {
            block1: {
                if (this.isZooming) break block1;
                this.isZooming = true;
                Function0<Unit> function0 = ZoomableScrollPane.this.getOnZoomStartListener();
                if (function0 != null) {
                    function0.invoke();
                }
            }
        }

        @Override
        public void pinchStop() {
            block0: {
                this.isZooming = false;
                Function0<Unit> function0 = ZoomableScrollPane.this.getOnZoomStopListener();
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        @Override
        public void zoom(float initialDistance, float distance) {
            if (!(this.lastInitialDistance == initialDistance)) {
                this.lastInitialDistance = initialDistance;
                this.lastScale = ZoomableScrollPane.this.getScaleX();
            }
            float scale = (float)Math.sqrt(distance / initialDistance) * this.lastScale;
            ZoomableScrollPane.this.zoom(scale);
        }

        @Override
        public boolean scrolled(float amountX, float amountY) {
            if (amountX > 0.0f || amountY > 0.0f) {
                ZoomListener.zoomOut$default(this, 0.0f, 1, null);
            } else {
                ZoomListener.zoomIn$default(this, 0.0f, 1, null);
            }
            return true;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0004H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ZoomListener$ZoomAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "(Lcom/unciv/ui/components/widgets/ZoomableScrollPane$ZoomListener;)V", "currentZoom", "", "getCurrentZoom", "()F", "setCurrentZoom", "(F)V", "finishingZoom", "getFinishingZoom", "setFinishingZoom", "startingZoom", "getStartingZoom", "setStartingZoom", "begin", "", "end", "update", "percent", "core"})
        public final class ZoomAction
        extends TemporalAction {
            private float startingZoom = 1.0f;
            private float finishingZoom = 1.0f;
            private float currentZoom = 1.0f;

            public ZoomAction() {
                this.setDuration(0.3f);
                this.setInterpolation(Interpolation.fastSlow);
            }

            public final float getStartingZoom() {
                return this.startingZoom;
            }

            public final void setStartingZoom(float f) {
                this.startingZoom = f;
            }

            public final float getFinishingZoom() {
                return this.finishingZoom;
            }

            public final void setFinishingZoom(float f) {
                this.finishingZoom = f;
            }

            public final float getCurrentZoom() {
                return this.currentZoom;
            }

            public final void setCurrentZoom(float f) {
                this.currentZoom = f;
            }

            @Override
            protected void begin() {
                ZoomListener.this.setZooming(true);
            }

            @Override
            protected void end() {
                ZoomListener.this.zoomAction = null;
                ZoomListener.this.setZooming(false);
            }

            @Override
            protected void update(float percent) {
                this.currentZoom = MathUtils.lerp(this.startingZoom, this.finishingZoom, percent);
                ZoomableScrollPane.this.zoom(this.currentZoom);
            }
        }
    }
}

