/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u00010B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010)\u001a\u00020\u0010H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020+H\u0016J\b\u0010.\u001a\u00020\u0001H\u0002J\u0006\u0010/\u001a\u00020\u0010R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00061"}, d2={"Lcom/unciv/ui/images/Portrait;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "type", "Lcom/unciv/ui/images/Portrait$Type;", "imageName", "", "size", "", "borderSize", "(Lcom/unciv/ui/images/Portrait$Type;Ljava/lang/String;FF)V", "background", "getBackground", "()Lcom/badlogic/gdx/scenes/scene2d/Group;", "getBorderSize", "()F", "image", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getImage", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getImageName", "()Ljava/lang/String;", "isPortrait", "", "()Z", "setPortrait", "(Z)V", "pathIcon", "getPathIcon", "pathIconFallback", "getPathIconFallback", "pathPortrait", "getPathPortrait", "pathPortraitFallback", "getPathPortraitFallback", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "getSize", "getType", "()Lcom/unciv/ui/images/Portrait$Type;", "getDefaultImage", "getDefaultImageTint", "Lcom/badlogic/gdx/graphics/Color;", "getDefaultInnerBackgroundTint", "getDefaultOuterBackgroundTint", "getMainBackground", "getMainImage", "Type", "core"})
@SourceDebugExtension(value={"SMAP\nPortrait.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/Portrait\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,319:1\n1#2:320\n*E\n"})
public class Portrait
extends Group {
    @NotNull
    private final Type type;
    @NotNull
    private final String imageName;
    private final float size;
    private final float borderSize;
    @NotNull
    private final Image image;
    @NotNull
    private final Group background;
    @NotNull
    private final Ruleset ruleset;
    private boolean isPortrait;
    @NotNull
    private final String pathPortrait;
    @NotNull
    private final String pathPortraitFallback;
    @NotNull
    private final String pathIcon;
    @NotNull
    private final String pathIconFallback;

    public Portrait(@NotNull Type type2, @NotNull String imageName, float size2, float borderSize) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(imageName, "imageName");
        this.type = type2;
        this.imageName = imageName;
        this.size = size2;
        this.borderSize = borderSize;
        this.ruleset = ImageGetter.INSTANCE.getRuleset();
        this.pathPortrait = this.type.getDirectory() + "Portraits/" + this.imageName;
        this.pathPortraitFallback = this.type.getDirectory() + "Portraits/Fallback";
        this.pathIcon = this.type.getDirectory() + "Icons/" + this.imageName;
        this.pathIconFallback = this.type.getDirectory() + "Icons/Fallback";
        this.setTransform(false);
        this.image = this.getMainImage();
        this.background = this.getMainBackground();
        this.setSize(this.size + this.borderSize, this.size + this.borderSize);
        Scene2dExtensionsKt.center((Actor)this.background, this);
        Scene2dExtensionsKt.center((Actor)this.image, this);
        this.addActor(this.background);
        this.addActor(this.image);
    }

    public /* synthetic */ Portrait(Type type2, String string, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f2 = 2.0f;
        }
        this(type2, string, f, f2);
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final String getImageName() {
        return this.imageName;
    }

    public final float getSize() {
        return this.size;
    }

    public final float getBorderSize() {
        return this.borderSize;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    @NotNull
    public final Group getBackground() {
        return this.background;
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    public final boolean isPortrait() {
        return this.isPortrait;
    }

    public final void setPortrait(boolean bl) {
        this.isPortrait = bl;
    }

    @NotNull
    public final String getPathPortrait() {
        return this.pathPortrait;
    }

    @NotNull
    public final String getPathPortraitFallback() {
        return this.pathPortraitFallback;
    }

    @NotNull
    public final String getPathIcon() {
        return this.pathIcon;
    }

    @NotNull
    public final String getPathIconFallback() {
        return this.pathIconFallback;
    }

    @NotNull
    public Color getDefaultInnerBackgroundTint() {
        Color color = Color.WHITE.cpy();
        Intrinsics.checkNotNullExpressionValue(color, "WHITE.cpy()");
        return color;
    }

    @NotNull
    public Color getDefaultOuterBackgroundTint() {
        Color color = Color.BLACK.cpy();
        Intrinsics.checkNotNullExpressionValue(color, "BLACK.cpy()");
        return color;
    }

    @NotNull
    public Color getDefaultImageTint() {
        Color color = Color.WHITE.cpy();
        Intrinsics.checkNotNullExpressionValue(color, "WHITE.cpy()");
        return color;
    }

    @NotNull
    public Image getDefaultImage() {
        return ImageGetter.INSTANCE.imageExists(this.pathIcon) ? ImageGetter.INSTANCE.getImage(this.pathIcon) : (ImageGetter.INSTANCE.imageExists(this.pathIconFallback) ? ImageGetter.INSTANCE.getImage(this.pathIconFallback) : ImageGetter.INSTANCE.getCircle());
    }

    @NotNull
    public final Image getMainImage() {
        Image image2;
        if (ImageGetter.INSTANCE.imageExists(this.pathPortrait)) {
            this.isPortrait = true;
            image2 = ImageGetter.INSTANCE.getImage(this.pathPortrait);
        } else if (ImageGetter.INSTANCE.imageExists(this.pathPortraitFallback)) {
            this.isPortrait = true;
            image2 = ImageGetter.INSTANCE.getImage(this.pathPortraitFallback);
        } else {
            Image image3;
            Image $this$getMainImage_u24lambda_u240 = image3 = this.getDefaultImage();
            boolean bl = false;
            $this$getMainImage_u24lambda_u240.setColor(this.getDefaultImageTint());
            image2 = image3;
        }
        return image2;
    }

    private final Group getMainBackground() {
        Group ratioW2;
        if (this.isPortrait && ImageGetter.INSTANCE.imageExists(this.type.getDirectory() + "Portraits/Background")) {
            Image backgroundImage = ImageGetter.INSTANCE.getImage(this.type.getDirectory() + "Portraits/Background");
            float ratioW2 = this.image.getWidth() / backgroundImage.getWidth();
            float ratioH = this.image.getHeight() / backgroundImage.getHeight();
            this.image.setSize((this.size + this.borderSize) * ratioW2, (this.size + this.borderSize) * ratioH);
            return Scene2dExtensionsKt.toGroup(backgroundImage, this.size + this.borderSize);
        }
        this.image.setSize(this.size * 0.75f, this.size * 0.75f);
        Group $this$getMainBackground_u24lambda_u241 = ratioW2 = new Group();
        boolean bl = false;
        $this$getMainBackground_u24lambda_u241.setTransform(false);
        Group bg = ratioW2;
        Image circleInner = ImageGetter.INSTANCE.getCircle();
        Image circleOuter = ImageGetter.INSTANCE.getCircle();
        circleInner.setSize(this.size, this.size);
        circleOuter.setSize(this.size + this.borderSize, this.size + this.borderSize);
        bg.setSize(this.size + this.borderSize, this.size + this.borderSize);
        circleInner.setAlign(1);
        circleOuter.setAlign(1);
        circleInner.setColor(this.getDefaultInnerBackgroundTint());
        circleOuter.setColor(this.getDefaultOuterBackgroundTint());
        Scene2dExtensionsKt.center((Actor)circleOuter, bg);
        Scene2dExtensionsKt.center((Actor)circleInner, bg);
        circleOuter.setOrigin(1);
        circleInner.setOrigin(1);
        bg.addActor(circleOuter);
        bg.addActor(circleInner);
        return bg;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/images/Portrait$Type;", "", "directory", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDirectory", "()Ljava/lang/String;", "Unit", "Building", "Tech", "Resource", "Improvement", "Promotion", "Unique", "Nation", "Religion", "UnitAction", "core"})
    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String directory;
        public static final /* enum */ Type Unit = new Type("Unit");
        public static final /* enum */ Type Building = new Type("Building");
        public static final /* enum */ Type Tech = new Type("Tech");
        public static final /* enum */ Type Resource = new Type("Resource");
        public static final /* enum */ Type Improvement = new Type("Improvement");
        public static final /* enum */ Type Promotion = new Type("UnitPromotion");
        public static final /* enum */ Type Unique = new Type("Unique");
        public static final /* enum */ Type Nation = new Type("Nation");
        public static final /* enum */ Type Religion = new Type("Religion");
        public static final /* enum */ Type UnitAction = new Type("UnitAction");
        private static final /* synthetic */ Type[] $VALUES;

        private Type(String directory) {
            this.directory = directory;
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.Unit, Type.Building, Type.Tech, Type.Resource, Type.Improvement, Type.Promotion, Type.Unique, Type.Nation, Type.Religion, Type.UnitAction};
        }
    }
}

