/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.popups.AnimatedMenuPopup;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\bH&J\n\u0010\n\u001a\u0004\u0018\u00010\bH&J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/popups/ScrollableAnimatedMenuPopup;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "position", "Lcom/badlogic/gdx/math/Vector2;", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/math/Vector2;)V", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "createFixedContent", "createScrollableContent", "createWrapperTable", "maxPopupHeight", "", "maxPopupWidth", "core"})
public abstract class ScrollableAnimatedMenuPopup
extends AnimatedMenuPopup {
    public ScrollableAnimatedMenuPopup(@NotNull Stage stage, @NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(position, "position");
        super(stage, position);
    }

    @Override
    @Nullable
    public final Table createContentTable() {
        Table table2 = this.createScrollableContent();
        if (table2 == null) {
            return null;
        }
        Table top = table2;
        Table table3 = this.createWrapperTable();
        AutoScrollPane scroll = new AutoScrollPane((Actor)top, null, 2, null);
        Cell<Actor> scrollCell = table3.add((Actor)scroll).growX();
        table3.row();
        Table bottom = this.createFixedContent();
        if (bottom != null) {
            table3.add((Actor)bottom);
        }
        float paddedMaxHeight = this.maxPopupHeight();
        float desiredTotalHeight = table3.getPrefHeight();
        float desiredScrollHeight = table3.getRowPrefHeight(0);
        float scrollHeight = desiredTotalHeight <= paddedMaxHeight ? desiredScrollHeight : paddedMaxHeight - (desiredTotalHeight - desiredScrollHeight);
        float paddedMaxWidth = this.maxPopupWidth();
        float desiredTotalWidth = table3.getPrefWidth();
        float desiredContentWidth = table3.getColumnPrefWidth(0);
        float scrollWidth = desiredTotalWidth <= paddedMaxHeight ? desiredContentWidth : paddedMaxWidth - (desiredTotalWidth - desiredContentWidth);
        scrollCell.size(scrollWidth, scrollHeight);
        return table3;
    }

    @NotNull
    public Table createWrapperTable() {
        Table table2 = super.createContentTable();
        Intrinsics.checkNotNull(table2);
        return table2;
    }

    @Nullable
    public abstract Table createScrollableContent();

    @Nullable
    public abstract Table createFixedContent();

    public float maxPopupWidth() {
        return 0.95f * this.getStageToShowOn().getWidth() - 5.0f;
    }

    public float maxPopupHeight() {
        return 0.95f * this.getStageToShowOn().getHeight() - 5.0f;
    }
}

