/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitUpgradeManager;
import com.unciv.models.Counter;
import com.unciv.models.UnitAction;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.objectdescriptions.BaseUnitDescriptions;
import com.unciv.ui.popups.AnimatedMenuPopup;
import com.unciv.ui.popups.ScrollableAnimatedMenuPopup;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsUpgrade;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002J\u001e\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$2\u0006\u0010%\u001a\u00020&H\u0002R!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lcom/unciv/ui/popups/UnitUpgradeMenu;", "Lcom/unciv/ui/popups/ScrollableAnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "positionNextTo", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unitAction", "Lcom/unciv/models/UpgradeUnitAction;", "enable", "", "callbackAfterAnimation", "onButtonClicked", "Lkotlin/Function0;", "", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/unciv/logic/map/mapunit/MapUnit;Lcom/unciv/models/UpgradeUnitAction;ZZLkotlin/jvm/functions/Function0;)V", "allUpgradableUnits", "Lkotlin/sequences/Sequence;", "getAllUpgradableUnits", "()Lkotlin/sequences/Sequence;", "allUpgradableUnits$delegate", "Lkotlin/Lazy;", "unitToUpgradeTo", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getUnitToUpgradeTo", "()Lcom/unciv/models/ruleset/unit/BaseUnit;", "unitToUpgradeTo$delegate", "createFixedContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "createScrollableContent", "doAllUpgrade", "doUpgrade", "getInsufficientResourcesMessage", "", "requiredResources", "Lcom/unciv/models/Counter;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "core"})
@SourceDebugExtension(value={"SMAP\nUnitUpgradeMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitUpgradeMenu.kt\ncom/unciv/ui/popups/UnitUpgradeMenu\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,122:1\n179#2,2:123\n*S KotlinDebug\n*F\n+ 1 UnitUpgradeMenu.kt\ncom/unciv/ui/popups/UnitUpgradeMenu\n*L\n116#1:123,2\n*E\n"})
public final class UnitUpgradeMenu
extends ScrollableAnimatedMenuPopup {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private final UpgradeUnitAction unitAction;
    private final boolean enable;
    private final boolean callbackAfterAnimation;
    @NotNull
    private final Function0<Unit> onButtonClicked;
    @NotNull
    private final Lazy unitToUpgradeTo$delegate;
    @NotNull
    private final Lazy allUpgradableUnits$delegate;

    public UnitUpgradeMenu(@NotNull Stage stage, @NotNull Actor positionNextTo, @NotNull MapUnit unit, @NotNull UpgradeUnitAction unitAction2, boolean enable, boolean callbackAfterAnimation, @NotNull Function0<Unit> onButtonClicked) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(positionNextTo, "positionNextTo");
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(unitAction2, "unitAction");
        Intrinsics.checkNotNullParameter(onButtonClicked, "onButtonClicked");
        super(stage, AnimatedMenuPopup.Companion.getActorTopRight(positionNextTo));
        this.unit = unit;
        this.unitAction = unitAction2;
        this.enable = enable;
        this.callbackAfterAnimation = callbackAfterAnimation;
        this.onButtonClicked = onButtonClicked;
        this.unitToUpgradeTo$delegate = LazyKt.lazy((Function0)new Function0<BaseUnit>(this){
            final /* synthetic */ UnitUpgradeMenu this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BaseUnit invoke() {
                return UnitUpgradeMenu.access$getUnitAction$p(this.this$0).getUnitToUpgradeTo();
            }
        });
        this.allUpgradableUnits$delegate = LazyKt.lazy((Function0)new Function0<Sequence<? extends MapUnit>>(this){
            final /* synthetic */ UnitUpgradeMenu this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Sequence<MapUnit> invoke() {
                return SequencesKt.filter(UnitUpgradeMenu.access$getUnit$p(this.this$0).getCiv().getUnits().getCivUnits(), (Function1)new Function1<MapUnit, Boolean>(this.this$0){
                    final /* synthetic */ UnitUpgradeMenu this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull MapUnit it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(it.getBaseUnit().getName(), UnitUpgradeMenu.access$getUnit$p(this.this$0).getBaseUnit().getName()) && it.getCurrentMovement() > 0.0f && Intrinsics.areEqual(it.getCurrentTile().getOwner(), UnitUpgradeMenu.access$getUnit$p(this.this$0).getCiv()) && !it.isEmbarked() && UnitUpgradeManager.canUpgrade$default(it.getUpgrade(), UnitUpgradeMenu.access$getUnitToUpgradeTo(this.this$0), false, true, 2, null);
                    }
                });
            }
        });
        Function0 action2 = new Function0<Unit>(this){
            final /* synthetic */ UnitUpgradeMenu this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getAnyButtonWasClicked()) {
                    UnitUpgradeMenu.access$getOnButtonClicked$p(this.this$0).invoke();
                }
            }
        };
        if (this.callbackAfterAnimation) {
            this.setAfterCloseCallback(action2);
        } else {
            this.getCloseListeners().add(action2);
        }
    }

    public /* synthetic */ UnitUpgradeMenu(Stage stage, Actor actor, MapUnit mapUnit, UpgradeUnitAction upgradeUnitAction, boolean bl, boolean bl2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(stage, actor, mapUnit, upgradeUnitAction, bl, bl2, function0);
    }

    private final BaseUnit getUnitToUpgradeTo() {
        Lazy lazy = this.unitToUpgradeTo$delegate;
        return (BaseUnit)lazy.getValue();
    }

    private final Sequence<MapUnit> getAllUpgradableUnits() {
        Lazy lazy = this.allUpgradableUnits$delegate;
        return (Sequence)lazy.getValue();
    }

    @Override
    @NotNull
    public Table createScrollableContent() {
        return BaseUnitDescriptions.INSTANCE.getUpgradeInfoTable(this.unitAction.getTitle(), this.unit.getBaseUnit(), this.getUnitToUpgradeTo());
    }

    @Override
    @NotNull
    public Table createFixedContent() {
        Table table2;
        Table $this$createFixedContent_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        TextButton singleButton2 = this.getButton("Upgrade", KeyboardBinding.Upgrade, new Function0<Unit>((Object)this){

            public final void invoke() {
                UnitUpgradeMenu.access$doUpgrade((UnitUpgradeMenu)this.receiver);
            }
        });
        singleButton2.setDisabled(!this.enable);
        $this$createFixedContent_u24lambda_u240.add((Actor)singleButton2).growX().row();
        int allCount = SequencesKt.count(this.getAllUpgradableUnits());
        if (allCount > 1) {
            int allCost = this.unitAction.getGoldCostOfUpgrade() * allCount;
            Counter<String> allResources = this.unitAction.getNewResourceRequirements().times(allCount);
            String upgradeAllText = "Upgrade all [" + allCount + "] [" + this.unit.getName() + "] ([" + allCost + "] gold)";
            TextButton upgradeAllButton2 = this.getButton(upgradeAllText, KeyboardBinding.UpgradeAll, new Function0<Unit>((Object)this){

                public final void invoke() {
                    UnitUpgradeMenu.access$doAllUpgrade((UnitUpgradeMenu)this.receiver);
                }
            });
            boolean insufficientGold = this.unit.getCiv().getGold() < allCost;
            String insufficientResources = this.getInsufficientResourcesMessage(allResources, this.unit.getCiv());
            upgradeAllButton2.setDisabled(insufficientGold || ((CharSequence)insufficientResources).length() > 0);
            $this$createFixedContent_u24lambda_u240.add((Actor)upgradeAllButton2).padTop(7.0f).growX().row();
            if (!(((CharSequence)insufficientResources).length() == 0)) {
                Color color = Color.SCARLET;
                Intrinsics.checkNotNullExpressionValue(color, "SCARLET");
                ColorMarkupLabel label2 = new ColorMarkupLabel(insufficientResources, color, null, 0, 12, null);
                $this$createFixedContent_u24lambda_u240.add((Actor)label2).center();
            }
        }
        return table2;
    }

    private final String getInsufficientResourcesMessage(Counter<String> requiredResources2, Civilization civ) {
        if (requiredResources2.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> available = civ.getCivResourcesByName();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : ((Map)requiredResources2).entrySet()) {
            int difference;
            String name2 = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            Integer n = available.get(name2);
            if (n == null) {
                n = 0;
            }
            if ((difference = amount - ((Number)n).intValue()) <= 0) continue;
            if (((CharSequence)sb).length() == 0) {
                sb.append('\n');
            }
            sb.append(TranslationsKt.tr$default("Need [" + difference + "] more [" + name2 + ']', false, 1, null));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    private final void doUpgrade() {
        SoundPlayer.INSTANCE.play(this.unitAction.getUncivSound());
        Function0<Unit> function0 = this.unitAction.getAction();
        Intrinsics.checkNotNull(function0);
        function0.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final void doAllUpgrade() {
        SoundPlayer.playRepeated$default(SoundPlayer.INSTANCE, this.unitAction.getUncivSound(), 0, 0L, 6, null);
        Iterator<MapUnit> iterator2 = this.getAllUpgradableUnits().iterator();
        while (iterator2.hasNext()) {
            UnitAction otherAction;
            Object object;
            Object v1;
            block2: {
                void $this$firstOrNull$iv;
                MapUnit unit = iterator2.next();
                Sequence<UnitAction> sequence = UnitActionsUpgrade.INSTANCE.getUpgradeActions(unit);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UnitAction it = (UnitAction)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.unciv.models.UpgradeUnitAction");
                    boolean bl2 = Intrinsics.areEqual(((UpgradeUnitAction)it).getUnitToUpgradeTo(), this.getUnitToUpgradeTo()) && it.getAction() != null;
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            if ((object = (otherAction = (UnitAction)v1)) == null || (object = ((UnitAction)object).getAction()) == null) continue;
            object.invoke();
        }
    }

    public static final /* synthetic */ void access$doUpgrade(UnitUpgradeMenu $this) {
        $this.doUpgrade();
    }

    public static final /* synthetic */ void access$doAllUpgrade(UnitUpgradeMenu $this) {
        $this.doAllUpgrade();
    }

    public static final /* synthetic */ UpgradeUnitAction access$getUnitAction$p(UnitUpgradeMenu $this) {
        return $this.unitAction;
    }

    public static final /* synthetic */ MapUnit access$getUnit$p(UnitUpgradeMenu $this) {
        return $this.unit;
    }

    public static final /* synthetic */ BaseUnit access$getUnitToUpgradeTo(UnitUpgradeMenu $this) {
        return $this.getUnitToUpgradeTo();
    }

    public static final /* synthetic */ Function0 access$getOnButtonClicked$p(UnitUpgradeMenu $this) {
        return $this.onButtonClicked;
    }
}

