/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.basescreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.TutorialForRender;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002J\u001c\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/basescreen/TutorialRender;", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;)V", "showDialog", "", "tutorialName", "", "texts", "", "closeAction", "Lkotlin/Function0;", "showTutorial", "tutorial", "Lcom/unciv/ui/screens/basescreen/TutorialForRender;", "core"})
public final class TutorialRender {
    @NotNull
    private final BaseScreen screen;

    public TutorialRender(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        this.screen = screen;
    }

    public final void showTutorial(@NotNull TutorialForRender tutorial, @NotNull Function0<Unit> closeAction) {
        Intrinsics.checkNotNullParameter(tutorial, "tutorial");
        Intrinsics.checkNotNullParameter(closeAction, "closeAction");
        this.showDialog(tutorial.getTutorial().name(), tutorial.getTexts(), closeAction);
    }

    private final void showDialog(String tutorialName, List<String> texts, Function0<Unit> closeAction) {
        if (texts.isEmpty()) {
            closeAction.invoke();
            return;
        }
        Popup tutorialPopup = new Popup(this.screen, null, 0.0f, 6, null);
        tutorialPopup.setName("Tutorial: " + tutorialName);
        FileHandle externalImage = ImageGetter.INSTANCE.findExternalImage(tutorialName);
        if (externalImage != null) {
            tutorialPopup.add((Actor)ImageGetter.INSTANCE.getExternalImage(externalImage)).row();
        }
        Popup.addGoodSizedLabel$default(tutorialPopup, texts.get(0), 0, false, 6, null).row();
        Popup.addCloseButton$default(tutorialPopup, null, KeyCharAndCode.Companion.getSPACE(), null, new Function0<Unit>(tutorialPopup, this, tutorialName, texts, closeAction){
            final /* synthetic */ Popup $tutorialPopup;
            final /* synthetic */ TutorialRender this$0;
            final /* synthetic */ String $tutorialName;
            final /* synthetic */ List<String> $texts;
            final /* synthetic */ Function0<Unit> $closeAction;
            {
                this.$tutorialPopup = $tutorialPopup;
                this.this$0 = $receiver;
                this.$tutorialName = $tutorialName;
                this.$texts = $texts;
                this.$closeAction = $closeAction;
                super(0);
            }

            public final void invoke() {
                this.$tutorialPopup.remove();
                TutorialRender.access$showDialog(this.this$0, this.$tutorialName, this.$texts.subList(1, this.$texts.size()), this.$closeAction);
            }
        }, 5, null);
        Popup.open$default(tutorialPopup, false, 1, null);
    }

    public static final /* synthetic */ void access$showDialog(TutorialRender $this, String tutorialName, List texts, Function0 closeAction) {
        $this.showDialog(tutorialName, texts, closeAction);
    }
}

