/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.CityScreenConstructionMenu;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityConstructionsTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.cityscreen.ConstructionButtonDTO;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0018\u0002\u0018\u00002\u00020\u0001:\u0001gB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J$\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)J\u001a\u0010*\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u0019H\u0002J \u0010+\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010.\u001a\u00020\u001fH\u0002J\u001e\u0010/\u001a\u0004\u0018\u0001002\b\u0010!\u001a\u0004\u0018\u00010&2\b\b\u0002\u0010'\u001a\u00020\u0019H\u0002J\u0018\u00101\u001a\b\u0012\u0004\u0012\u000200022\b\u0010!\u001a\u0004\u0018\u00010&H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002J\u0018\u00106\u001a\u0012\u0012\u0004\u0012\u00020507j\b\u0012\u0004\u0012\u000205`8H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020=H\u0002J \u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020=2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010A\u001a\u00020\u0016J<\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020E2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020=2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0GH\u0002J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020=H\u0002J\u0012\u0010K\u001a\u0002002\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010L\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020=H\u0002J \u0010M\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020=2\u0006\u0010,\u001a\u00020-H\u0002J\u0018\u0010N\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010O\u001a\u00020\u0016J\"\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\r2\b\b\u0002\u0010S\u001a\u00020\rH\u0002J\u0018\u0010T\u001a\u00020\u001f2\u0006\u0010U\u001a\u00020\b2\u0006\u0010R\u001a\u00020\rH\u0002J \u0010V\u001a\u00020\r2\u0006\u0010!\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010W\u001a\u00020\u001bH\u0002J\u0018\u0010X\u001a\u00020\r2\u0006\u0010!\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019H\u0002J\b\u0010Y\u001a\u00020\rH\u0002J&\u0010Z\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020\u00192\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)H\u0002J\b\u0010[\u001a\u00020\u001fH\u0002J\u0010\u0010\\\u001a\u00020\u001f2\b\u0010]\u001a\u0004\u0018\u00010\"J\b\u0010^\u001a\u00020\u001fH\u0002J\u0012\u0010_\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\b\u0010`\u001a\u00020\u001fH\u0002J\u0012\u0010a\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002JF\u0010b\u001a\u00020\u001f*\u00020\b2\u0006\u0010<\u001a\u00020=2\u0016\u0010c\u001a\u0012\u0012\u0004\u0012\u00020\b07j\b\u0012\u0004\u0012\u00020\b`82\u0006\u0010d\u001a\u00020\u00162\u0006\u0010e\u001a\u00020E2\b\b\u0002\u0010f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h\u00b2\u0006\n\u0010i\u001a\u00020jX\u008a\u0084\u0002"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityConstructionsTable;", "", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "availableConstructionsScrollPane", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "availableConstructionsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "buyButtonsTable", "constructionsQueueScrollPane", "constructionsQueueTable", "value", "", "isVisible", "()Z", "setVisible", "(Z)V", "lowerTable", "lowerTableScrollCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "pad", "", "posFromEdge", "preferredBuyStat", "Lcom/unciv/models/stats/Stat;", "selectedQueueEntry", "", "stageHeight", "upperTable", "addActorsToStage", "", "addConstructionToQueue", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "askToBuyConstruction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "tile", "Lcom/unciv/logic/map/tile/Tile;", "buyButtonOnClick", "cannotAddConstructionToQueue", "city", "Lcom/unciv/logic/city/City;", "ensureQueueEntryVisible", "getBuyButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getBuyButtons", "", "getConstructionButton", "constructionButtonDTO", "Lcom/unciv/ui/screens/cityscreen/ConstructionButtonDTO;", "getConstructionButtonDTOs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getConstructionSound", "Lcom/unciv/models/UncivSound;", "getHeader", "title", "", "getLowerPriorityButton", "constructionQueueIndex", "name", "getLowerWidth", "getMovePriorityButton", "arrowDirection", "binding", "Lcom/unciv/ui/components/input/KeyboardBinding;", "movePriority", "Lkotlin/Function1;", "getProgressBar", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "constructionName", "getQueueButton", "getQueueEntry", "getRaisePriorityButton", "getRemoveFromQueueButton", "getUpperWidth", "highlightConstructionButton", "pickConstructionButton", "highlight", "clearOthers", "highlightQueueEntry", "queueEntry", "isConstructionPurchaseAllowed", "constructionBuyCost", "isConstructionPurchaseShown", "isSelectedQueueEntry", "purchaseConstruction", "resizeAvailableConstructionsScrollPane", "update", "selectedConstruction", "updateAvailableConstructions", "updateButtons", "updateConstructionQueue", "updateQueueAndButtons", "addCategory", "list", "prefWidth", "toggleKey", "startsOutOpened", "ConfirmBuyPopup", "core", "unselected", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;"})
@SourceDebugExtension(value={"SMAP\nCityConstructionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityConstructionsTable.kt\ncom/unciv/ui/screens/cityscreen/CityConstructionsTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,885:1\n1864#2,3:886\n766#2:903\n857#2,2:904\n800#2,11:907\n800#2,11:918\n800#2,11:929\n1603#2,9:940\n1855#2:949\n1856#2:951\n1612#2:952\n1821#3,14:889\n1#4:906\n1#4:950\n*S KotlinDebug\n*F\n+ 1 CityConstructionsTable.kt\ncom/unciv/ui/screens/cityscreen/CityConstructionsTable\n*L\n187#1:886,3\n236#1:903\n236#1:904,2\n527#1:907,11\n529#1:918,11\n537#1:929,11\n621#1:940,9\n621#1:949\n621#1:951\n621#1:952\n223#1:889,14\n621#1:950\n*E\n"})
public final class CityConstructionsTable {
    @NotNull
    private final CityScreen cityScreen;
    private int selectedQueueEntry;
    @NotNull
    private Stat preferredBuyStat;
    @NotNull
    private final Table upperTable;
    @NotNull
    private final AutoScrollPane constructionsQueueScrollPane;
    @NotNull
    private final Table constructionsQueueTable;
    @NotNull
    private final Table buyButtonsTable;
    @NotNull
    private final Table lowerTable;
    @NotNull
    private final AutoScrollPane availableConstructionsScrollPane;
    @NotNull
    private final Table availableConstructionsTable;
    @NotNull
    private final Cell<AutoScrollPane> lowerTableScrollCell;
    private final float pad;
    private final float posFromEdge;
    private final float stageHeight;

    public CityConstructionsTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.selectedQueueEntry = -1;
        this.preferredBuyStat = Stat.Gold;
        this.upperTable = new Table(BaseScreen.Companion.getSkin());
        this.constructionsQueueTable = new Table();
        this.buyButtonsTable = new Table();
        this.lowerTable = new Table();
        this.availableConstructionsTable = new Table();
        this.pad = 10.0f;
        this.posFromEdge = 5.0f;
        this.stageHeight = this.cityScreen.getStage().getHeight();
        Actor actor = this.constructionsQueueTable;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.constructionsQueueScrollPane = new AutoScrollPane((Actor)Scene2dExtensionsKt.addBorder$default(actor, 2.0f, color, false, 4, null), null, 2, null);
        this.constructionsQueueScrollPane.setOverscroll(false, false);
        this.constructionsQueueTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/ConstructionsQueueTable", null, Color.BLACK, 2, null));
        this.upperTable.defaults().left().top();
        this.upperTable.add((Actor)this.constructionsQueueScrollPane).maxHeight(this.stageHeight / (float)3 - 10.0f).padBottom(this.pad).row();
        this.upperTable.add((Actor)this.buyButtonsTable).padBottom(this.pad).row();
        Actor actor2 = this.availableConstructionsTable;
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
        this.availableConstructionsScrollPane = new AutoScrollPane((Actor)Scene2dExtensionsKt.addBorder$default(actor2, 2.0f, color2, false, 4, null), null, 2, null);
        this.availableConstructionsScrollPane.setOverscroll(false, false);
        this.availableConstructionsTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/AvailableConstructionsTable", null, Color.BLACK, 2, null));
        Cell<Actor> cell2 = this.lowerTable.add((Actor)this.availableConstructionsScrollPane).bottom();
        Intrinsics.checkNotNullExpressionValue(cell2, "lowerTable.add(available\u2026tionsScrollPane).bottom()");
        this.lowerTableScrollCell = cell2;
        this.lowerTable.row();
    }

    public final boolean isVisible() {
        return this.upperTable.isVisible();
    }

    public final void setVisible(boolean value) {
        this.upperTable.setVisible(value);
        this.lowerTable.setVisible(value);
    }

    public final float getUpperWidth() {
        return Scene2dExtensionsKt.packIfNeeded(this.upperTable).getWidth();
    }

    public final float getLowerWidth() {
        return Math.max(Scene2dExtensionsKt.packIfNeeded(this.lowerTable).getWidth(), this.getUpperWidth());
    }

    public final void addActorsToStage() {
        this.cityScreen.getStage().addActor(this.upperTable);
        this.cityScreen.getStage().addActor(this.lowerTable);
        this.lowerTable.setPosition(this.posFromEdge, this.posFromEdge, 12);
    }

    public final void update(@Nullable IConstruction selectedConstruction) {
        this.updateQueueAndButtons(selectedConstruction);
        this.updateAvailableConstructions();
    }

    private final void updateQueueAndButtons(IConstruction construction2) {
        this.updateButtons(construction2);
        this.updateConstructionQueue();
        this.upperTable.pack();
        this.upperTable.setPosition(this.posFromEdge, this.stageHeight - this.posFromEdge, 10);
        this.lowerTableScrollCell.maxHeight(this.stageHeight - this.upperTable.getHeight() - (float)2 * this.posFromEdge);
    }

    private final void updateButtons(IConstruction construction2) {
        this.buyButtonsTable.clear();
        if (!this.cityScreen.getCanChangeState()) {
            return;
        }
        if (this.cityScreen.getCity$core().isPuppet() && !SequencesKt.any(City.getMatchingUniques$default(this.cityScreen.getCity$core(), UniqueType.MayBuyConstructionsInPuppets, null, false, 6, null))) {
            return;
        }
        this.buyButtonsTable.add((Actor)this.getQueueButton(construction2)).padRight(5.0f);
        if (construction2 != null && !(construction2 instanceof PerpetualConstruction)) {
            for (TextButton button : this.getBuyButtons((INonPerpetualConstruction)construction2)) {
                this.buyButtonsTable.add((Actor)button).padRight(5.0f);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateConstructionQueue() {
        float queueScrollY = this.constructionsQueueScrollPane.getScrollY();
        this.constructionsQueueTable.clear();
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        String currentConstruction = cityConstructions.getCurrentConstructionFromQueue();
        List<String> queue = cityConstructions.getConstructionQueue();
        this.constructionsQueueTable.defaults().pad(0.0f);
        this.constructionsQueueTable.add((Actor)this.getHeader("Current construction")).fillX();
        Scene2dExtensionsKt.addSeparator$default(this.constructionsQueueTable, null, 0, 0.0f, 7, null);
        if (!Intrinsics.areEqual(currentConstruction, "")) {
            this.constructionsQueueTable.add((Actor)this.getQueueEntry(0, currentConstruction)).expandX().fillX().row();
        } else {
            this.constructionsQueueTable.add((Actor)Scene2dExtensionsKt.toLabel("Pick a construction")).pad(2.0f).row();
        }
        Scene2dExtensionsKt.addSeparator$default(this.constructionsQueueTable, null, 0, 0.0f, 7, null);
        if (queue.size() > 1) {
            this.constructionsQueueTable.add((Actor)this.getHeader("Construction queue")).fillX();
            Scene2dExtensionsKt.addSeparator$default(this.constructionsQueueTable, null, 0, 0.0f, 7, null);
            Iterable $this$forEachIndexed$iv = queue;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void constructionName;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl = false;
                if (i == 0) continue;
                this.constructionsQueueTable.add((Actor)this.getQueueEntry(i, (String)constructionName)).expandX().fillX().row();
                if (i == queue.size() - 1) continue;
                Scene2dExtensionsKt.addSeparator$default(this.constructionsQueueTable, null, 0, 0.0f, 7, null);
            }
        }
        this.constructionsQueueScrollPane.layout();
        this.constructionsQueueScrollPane.setScrollY(queueScrollY);
        this.constructionsQueueScrollPane.updateVisualScroll();
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayList<ConstructionButtonDTO> getConstructionButtonDTOs() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String buttonText;
        Object entry;
        ArrayList<ConstructionButtonDTO> constructionButtonDTOList = new ArrayList<ConstructionButtonDTO>();
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        Collection<BaseUnit> collection = city2.getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "city.getRuleset().units.values");
        Sequence sequence = CollectionsKt.asSequence((Iterable)collection);
        Collection<Building> collection2 = city2.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "city.getRuleset().buildings.values");
        Sequence constructionsSequence = SequencesKt.plus(sequence, CollectionsKt.asSequence((Iterable)collection2));
        CityStats.updateTileStats$default(city2.getCityStats(), null, 1, null);
        Iterator<Object> iterator2 = SequencesKt.filter(constructionsSequence, new Function1<?, Boolean>(cityConstructions){
            final /* synthetic */ CityConstructions $cityConstructions;
            {
                this.$cityConstructions = $cityConstructions;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IHasUniques it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ((INonPerpetualConstruction)it).shouldBeDisplayed(this.$cityConstructions);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Object v3;
            void $this$minByOrNull$iv;
            entry = (IHasUniques)iterator2.next();
            boolean useStoredProduction = entry instanceof Building || !cityConstructions.isBeingConstructedOrEnqueued(((INonPerpetualConstruction)entry).getName());
            buttonText = ((Object)StringsKt.trim((CharSequence)cityConstructions.getTurnsToConstructionString$core((IConstruction)entry, useStoredProduction))).toString();
            Counter<String> resourcesRequired = entry instanceof BaseUnit ? ((INonPerpetualConstruction)entry).getResourceRequirementsPerTurn(new StateForConditionals(city2.getCiv(), null, null, null, null, null, null, null, null, false, 1022, null)) : ((INonPerpetualConstruction)entry).getResourceRequirementsPerTurn(new StateForConditionals(city2.getCiv(), city2, null, null, null, null, null, null, null, false, 1020, null));
            Sequence<RejectionReason> sequence2 = SequencesKt.filter(((INonPerpetualConstruction)entry).getRejectionReasons(cityConstructions), getConstructionButtonDTOs.mostImportantRejection.1.INSTANCE);
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    RejectionReason it = (RejectionReason)minElem$iv;
                    boolean bl = false;
                    int minValue$iv = it.getRejectionPrecedence();
                    do {
                        Object e$iv = iterator$iv.next();
                        RejectionReason it2 = (RejectionReason)e$iv;
                        $i$a$-minByOrNull-CityConstructionsTable$getConstructionButtonDTOs$mostImportantRejection$2 = false;
                        int v$iv = it2.getRejectionPrecedence();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            RejectionReason mostImportantRejection2 = v3;
            constructionButtonDTOList.add(new ConstructionButtonDTO((IConstruction)entry, buttonText, (HashMap<String, Integer>)(resourcesRequired.isEmpty() ? null : resourcesRequired), mostImportantRejection2));
        }
        entry = PerpetualConstruction.Companion.getPerpetualConstructionsMap().values();
        boolean $i$f$filter = false;
        buttonText = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PerpetualConstruction it = (PerpetualConstruction)element$iv$iv;
            boolean bl = false;
            if (!it.shouldBeDisplayed(cityConstructions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PerpetualConstruction specialConstruction : (List)destination$iv$iv) {
            constructionButtonDTOList.add(new ConstructionButtonDTO(specialConstruction, TranslationsKt.tr$default("Produce [" + specialConstruction.getName() + ']', false, 1, null) + ' ' + ((Object)StringsKt.trim((CharSequence)PerpetualConstruction.getProductionTooltip$default(specialConstruction, city2, false, 2, null))).toString(), null, null, 12, null));
        }
        return constructionButtonDTOList;
    }

    private final void updateAvailableConstructions() {
        float constructionsScrollY = this.availableConstructionsScrollPane.getScrollY();
        if (!this.availableConstructionsTable.hasChildren()) {
            this.availableConstructionsTable.add((Actor)Scene2dExtensionsKt.toLabel("Loading...")).pad(10.0f);
        }
        Concurrency.run$default(Concurrency.INSTANCE, "Construction info gathering - " + this.cityScreen.getCity$core().getName(), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, constructionsScrollY, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ float $constructionsScrollY;
            {
                this.this$0 = $receiver;
                this.$constructionsScrollY = $constructionsScrollY;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        ArrayList constructionButtonDTOList = CityConstructionsTable.access$getConstructionButtonDTOs(this.this$0);
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, (ArrayList<ConstructionButtonDTO>)constructionButtonDTOList, this.$constructionsScrollY, null){
                            int label;
                            final /* synthetic */ CityConstructionsTable this$0;
                            final /* synthetic */ ArrayList<ConstructionButtonDTO> $constructionButtonDTOList;
                            final /* synthetic */ float $constructionsScrollY;
                            {
                                this.this$0 = $receiver;
                                this.$constructionButtonDTOList = $constructionButtonDTOList;
                                this.$constructionsScrollY = $constructionsScrollY;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(var1_1);
                                        units = new ArrayList<Table>();
                                        buildableWonders = new ArrayList<E>();
                                        buildableNationalWonders = new ArrayList<E>();
                                        buildableBuildings = new ArrayList<E>();
                                        specialConstructions = new ArrayList<Table>();
                                        blacklisted = new ArrayList<Table>();
                                        disabledAutoAssignConstructions = GUI.INSTANCE.getSettings().getDisabledAutoAssignConstructions();
                                        maxButtonWidth = new Ref.FloatRef();
                                        maxButtonWidth.element = CityConstructionsTable.access$getConstructionsQueueTable$p(this.this$0).getWidth();
                                        for (ConstructionButtonDTO dto : this.$constructionButtonDTOList) {
                                            if (!(dto.getConstruction() instanceof Building)) ** GOTO lbl42
                                            v0 = dto.getRejectionReason();
                                            if ((v0 != null ? v0.getType() : null) != RejectionReasonType.RequiresBuildingInThisCity) ** GOTO lbl42
                                            $this$any$iv = this.$constructionButtonDTOList;
                                            $i$f$any = false;
                                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl24
                                            v1 = false;
                                            ** GOTO lbl41
lbl24:
                                            // 2 sources

                                            for (T element$iv : $this$any$iv) {
                                                it = (ConstructionButtonDTO)element$iv;
                                                $i$a$-any-CityConstructionsTable$updateAvailableConstructions$1$1$1 = false;
                                                if (!(it.getConstruction() instanceof Building)) ** GOTO lbl-1000
                                                if (Intrinsics.areEqual(it.getConstruction().getName(), ((Building)dto.getConstruction()).getRequiredBuilding()) || Intrinsics.areEqual(((Building)it.getConstruction()).getReplaces(), ((Building)dto.getConstruction()).getRequiredBuilding())) ** GOTO lbl-1000
                                                v2 = (IHasUniques)it.getConstruction();
                                                v3 = ((Building)dto.getConstruction()).getRequiredBuilding();
                                                Intrinsics.checkNotNull(v3);
                                                if (IHasUniques.DefaultImpls.hasUnique$default(v2, v3, null, 2, null)) lbl-1000:
                                                // 2 sources

                                                {
                                                    v4 = true;
                                                } else lbl-1000:
                                                // 2 sources

                                                {
                                                    v4 = false;
                                                }
                                                if (!v4) continue;
                                                v1 = true;
                                                ** GOTO lbl41
                                            }
                                            v1 = false;
lbl41:
                                            // 3 sources

                                            if (v1) continue;
lbl42:
                                            // 3 sources

                                            Intrinsics.checkNotNullExpressionValue(dto, "dto");
                                            constructionButton = CityConstructionsTable.access$getConstructionButton(this.this$0, dto);
                                            if (disabledAutoAssignConstructions.contains(dto.getConstruction().getName())) {
                                                blacklisted.add(constructionButton);
                                            } else {
                                                $i$f$any = dto.getConstruction();
                                                if ($i$f$any instanceof BaseUnit) {
                                                    units.add(constructionButton);
                                                } else if ($i$f$any instanceof Building) {
                                                    if (((Building)dto.getConstruction()).isWonder()) {
                                                        ((Collection)buildableWonders).add(constructionButton);
                                                    } else if (((Building)dto.getConstruction()).isNationalWonder()) {
                                                        ((Collection)buildableNationalWonders).add(constructionButton);
                                                    } else {
                                                        ((Collection)buildableBuildings).add(constructionButton);
                                                    }
                                                } else if ($i$f$any instanceof PerpetualConstruction) {
                                                    specialConstructions.add(constructionButton);
                                                }
                                            }
                                            maxButtonWidth.element = Math.max(maxButtonWidth.element, Scene2dExtensionsKt.packIfNeeded(constructionButton).getWidth());
                                        }
                                        var10_10 = CityConstructionsTable.access$getAvailableConstructionsTable$p(this.this$0);
                                        var11_11 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u241 = var10_10;
                                        $i$a$-apply-CityConstructionsTable$updateAvailableConstructions$1$1$2 = false;
                                        $this$invokeSuspend_u24lambda_u241.clear();
                                        $this$invokeSuspend_u24lambda_u241.defaults().left().bottom();
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Units", units, maxButtonWidth.element, KeyboardBinding.BuildUnits, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Buildings", buildableBuildings, maxButtonWidth.element, KeyboardBinding.BuildBuildings, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Wonders", buildableWonders, maxButtonWidth.element, KeyboardBinding.BuildWonders, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "National Wonders", buildableNationalWonders, maxButtonWidth.element, KeyboardBinding.BuildNationalWonders, false, 16, null);
                                        CityConstructionsTable.addCategory$default(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Other", specialConstructions, maxButtonWidth.element, KeyboardBinding.BuildOther, false, 16, null);
                                        CityConstructionsTable.access$addCategory(var11_11, (Table)$this$invokeSuspend_u24lambda_u241, "Disabled", blacklisted, maxButtonWidth.element, KeyboardBinding.BuildDisabled, false);
                                        $this$invokeSuspend_u24lambda_u241.pack();
                                        var10_10 = CityConstructionsTable.access$getAvailableConstructionsScrollPane$p(this.this$0);
                                        var11_11 = this.this$0;
                                        var12_13 = this.$constructionsScrollY;
                                        $this$invokeSuspend_u24lambda_u242 = var10_10;
                                        $i$a$-apply-CityConstructionsTable$updateAvailableConstructions$1$1$3 = false;
                                        $this$invokeSuspend_u24lambda_u242.setSize(maxButtonWidth.element, Math.min(CityConstructionsTable.access$getAvailableConstructionsTable$p(var11_11).getPrefHeight(), CityConstructionsTable.access$getLowerTableScrollCell$p(var11_11).getMaxHeight()));
                                        $this$invokeSuspend_u24lambda_u242.layout();
                                        $this$invokeSuspend_u24lambda_u242.setScrollY(var12_13);
                                        $this$invokeSuspend_u24lambda_u242.updateVisualScroll();
                                        CityConstructionsTable.access$getLowerTable$p(this.this$0).pack();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final Table getQueueEntry(int constructionQueueIndex, String constructionName) {
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        Table table2 = new Table();
        table2.align(8).pad(5.0f);
        this.highlightQueueEntry(table2, constructionQueueIndex == this.selectedQueueEntry);
        IConstruction construction2 = cityConstructions.getConstruction$core(constructionName);
        boolean isFirstConstructionOfItsKind = cityConstructions.isFirstConstructionOfItsKind(constructionQueueIndex, constructionName);
        String text2 = TranslationsKt.tr(constructionName, true) + (PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(constructionName) ? "\n\u221e" : cityConstructions.getTurnsToConstructionString$core(construction2, isFirstConstructionOfItsKind));
        Counter<String> constructionResource = construction2 instanceof BaseUnit ? construction2.getResourceRequirementsPerTurn(new StateForConditionals(city2.getCiv(), city2, null, null, null, null, null, null, null, false, 1020, null)) : construction2.getResourceRequirementsPerTurn(new StateForConditionals(city2.getCiv(), null, null, null, null, null, null, null, null, false, 1022, null));
        for (Map.Entry entry : ((Map)constructionResource).entrySet()) {
            TileResource resource2;
            String resourceName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            if (cityConstructions.getCity().getRuleset().getTileResources().get(resourceName) == null) continue;
            text2 = text2 + '\n' + TranslationsKt.tr$default(FormattingExtensionsKt.getConsumesAmountString(resourceName, amount, resource2.isStockpiled()), false, 1, null);
        }
        table2.defaults().pad(2.0f).minWidth(40.0f);
        if (isFirstConstructionOfItsKind) {
            table2.add((Actor)this.getProgressBar(constructionName)).minWidth(5.0f);
        } else {
            table2.add().minWidth(5.0f);
        }
        table2.add((Actor)ImageGetter.INSTANCE.getConstructionPortrait(constructionName, 40.0f)).padRight(10.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel(text2)).expandX().fillX().left();
        if (constructionQueueIndex > 0 && this.cityScreen.canCityBeChanged()) {
            table2.add((Actor)this.getRaisePriorityButton(constructionQueueIndex, constructionName, city2)).right();
        } else {
            table2.add().right();
        }
        if (constructionQueueIndex != CollectionsKt.getLastIndex(cityConstructions.getConstructionQueue()) && this.cityScreen.canCityBeChanged()) {
            table2.add((Actor)this.getLowerPriorityButton(constructionQueueIndex, constructionName, city2)).right();
        } else {
            table2.add().right();
        }
        if (this.cityScreen.canCityBeChanged()) {
            table2.add((Actor)this.getRemoveFromQueueButton(constructionQueueIndex, city2)).right();
        } else {
            table2.add().right();
        }
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, new Function0<Unit>(this, constructionName, constructionQueueIndex){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ String $constructionName;
            final /* synthetic */ int $constructionQueueIndex;
            {
                this.this$0 = $receiver;
                this.$constructionName = $constructionName;
                this.$constructionQueueIndex = $constructionQueueIndex;
                super(0);
            }

            public final void invoke() {
                CityConstructionsTable.access$getQueueEntry$selectQueueEntry(this.this$0, this.$constructionName, this.$constructionQueueIndex, getQueueEntry.1.INSTANCE);
            }
        });
        if (this.cityScreen.canCityBeChanged()) {
            ActivationExtensionsKt.onRightClick$default(table2, null, new Function0<Unit>(this, table2, construction2, constructionName, constructionQueueIndex){
                final /* synthetic */ CityConstructionsTable this$0;
                final /* synthetic */ Table $table;
                final /* synthetic */ IConstruction $construction;
                final /* synthetic */ String $constructionName;
                final /* synthetic */ int $constructionQueueIndex;
                {
                    this.this$0 = $receiver;
                    this.$table = $table;
                    this.$construction = $construction;
                    this.$constructionName = $constructionName;
                    this.$constructionQueueIndex = $constructionQueueIndex;
                    super(0);
                }

                public final void invoke() {
                    CityConstructionsTable.access$getQueueEntry$selectQueueEntry(this.this$0, this.$constructionName, this.$constructionQueueIndex, new Function0<Unit>(this.this$0, this.$table, this.$construction){
                        final /* synthetic */ CityConstructionsTable this$0;
                        final /* synthetic */ Table $table;
                        final /* synthetic */ IConstruction $construction;
                        {
                            this.this$0 = $receiver;
                            this.$table = $table;
                            this.$construction = $construction;
                            super(0);
                        }

                        public final void invoke() {
                            new CityScreenConstructionMenu(CityConstructionsTable.access$getCityScreen$p(this.this$0).getStage(), (Actor)this.$table, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), this.$construction, new Function0<Unit>(this.this$0){
                                final /* synthetic */ CityConstructionsTable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                                    CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                                }
                            });
                        }
                    });
                }
            }, 1, null);
        }
        return table2;
    }

    private final void highlightQueueEntry(Table queueEntry, boolean highlight2) {
        Drawable drawable;
        if (highlight2) {
            SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            drawable = SkinStrings.getUiBackground$default(skinStrings, "CityScreen/CityConstructionTable/QueueEntrySelected", null, Scene2dExtensionsKt.darken(color, 0.5f), 2, null);
        } else {
            drawable = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/QueueEntry", null, Color.BLACK, 2, null);
        }
        queueEntry.setBackground(drawable);
    }

    private final Group getProgressBar(String constructionName) {
        CityConstructions cityConstructions = this.cityScreen.getCity$core().getCityConstructions();
        IConstruction construction2 = cityConstructions.getConstruction$core(constructionName);
        if (construction2 instanceof PerpetualConstruction) {
            return new Table();
        }
        if (cityConstructions.getWorkDone(constructionName) == 0) {
            return new Table();
        }
        float f = cityConstructions.getWorkDone(constructionName);
        Intrinsics.checkNotNull(construction2, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
        float constructionPercentage = f / (float)((INonPerpetualConstruction)construction2).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
        Color color = Color.BROWN;
        Intrinsics.checkNotNullExpressionValue(color, "BROWN");
        Color color2 = Scene2dExtensionsKt.brighten(color, 0.5f);
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color3, "WHITE");
        return ImageGetter.getProgressBarVertical$default(ImageGetter.INSTANCE, 2.0f, 30.0f, constructionPercentage, color2, color3, 0.0f, 32, null);
    }

    private final Table getConstructionButton(ConstructionButtonDTO constructionButtonDTO) {
        Table table2;
        IConstruction construction2 = constructionButtonDTO.getConstruction();
        Table $this$getConstructionButton_u24lambda_u243 = table2 = new Table();
        boolean bl = false;
        $this$getConstructionButton_u24lambda_u243.setTransform(false);
        $this$getConstructionButton_u24lambda_u243.align(8).pad(5.0f);
        $this$getConstructionButton_u24lambda_u243.setTouchable(Touchable.enabled);
        Table pickConstructionButton = table2;
        CityConstructionsTable.highlightConstructionButton$default(this, pickConstructionButton, !this.isSelectedQueueEntry() && Intrinsics.areEqual(this.cityScreen.getSelectedConstruction(), construction2), false, 4, null);
        Group icon = ImageGetter.INSTANCE.getConstructionPortrait(construction2.getName(), 40.0f);
        pickConstructionButton.add((Actor)this.getProgressBar(construction2.getName())).padRight(5.0f);
        pickConstructionButton.add((Actor)icon).padRight(10.0f);
        Table $this$getConstructionButton_u24lambda_u244 = bl = new Table();
        boolean bl2 = false;
        $this$getConstructionButton_u24lambda_u244.setTransform(false);
        Table constructionTable = bl;
        $this$getConstructionButton_u24lambda_u244 = new Table();
        Iterator<Unique> $this$getConstructionButton_u24lambda_u245 = $this$getConstructionButton_u24lambda_u244;
        boolean bl3 = false;
        ((Group)((Object)$this$getConstructionButton_u24lambda_u245)).setTransform(false);
        Table resourceTable = $this$getConstructionButton_u24lambda_u244;
        Color textColor = constructionButtonDTO.getRejectionReason() == null ? Color.WHITE : Color.RED;
        String string = construction2.getName();
        Intrinsics.checkNotNullExpressionValue(textColor, "textColor");
        $this$getConstructionButton_u24lambda_u245 = Scene2dExtensionsKt.toLabel$default(string, textColor, 0, 0, true, 6, null);
        Actor actor = $this$getConstructionButton_u24lambda_u245;
        Table table3 = constructionTable;
        boolean bl32 = false;
        ((Label)actor).setWrap(true);
        table3.add($this$getConstructionButton_u24lambda_u245).width(this.cityScreen.getStage().getWidth() / (float)5).expandX().left().row();
        resourceTable.add((Actor)Scene2dExtensionsKt.toLabel(constructionButtonDTO.getButtonText())).expandX().left();
        if (constructionButtonDTO.getResourcesRequired() != null) {
            for (Map.Entry entry : ((Map)constructionButtonDTO.getResourcesRequired()).entrySet()) {
                String resource2 = (String)entry.getKey();
                int amount = ((Number)entry.getValue()).intValue();
                RejectionReason rejectionReason = constructionButtonDTO.getRejectionReason();
                Color color = (rejectionReason != null ? rejectionReason.getType() : null) == RejectionReasonType.ConsumesResources ? Color.RED : Color.WHITE;
                String string2 = String.valueOf(amount);
                Intrinsics.checkNotNullExpressionValue(color, "color");
                resourceTable.add((Actor)Scene2dExtensionsKt.toLabel$default(string2, color, 0, 0, false, 14, null)).expandX().left().padLeft(5.0f);
                resourceTable.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resource2, 15.0f, 0, 4, null)).padBottom(1.0f);
            }
        }
        $this$getConstructionButton_u24lambda_u245 = constructionButtonDTO.getConstruction().getMatchingUniquesNotConflicting(UniqueType.CostsResources).iterator();
        while ($this$getConstructionButton_u24lambda_u245.hasNext()) {
            Unique unique = $this$getConstructionButton_u24lambda_u245.next();
            RejectionReason rejectionReason = constructionButtonDTO.getRejectionReason();
            Color color = (rejectionReason != null ? rejectionReason.getType() : null) == RejectionReasonType.ConsumesResources ? Color.RED : Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "color");
            resourceTable.add((Actor)new ColorMarkupLabel(unique.getParams().get(0), color, null, 0, 12, null)).expandX().left().padLeft(5.0f);
            resourceTable.add((Actor)ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, unique.getParams().get(1), 15.0f, 0, 4, null)).padBottom(1.0f);
        }
        constructionTable.add((Actor)resourceTable).expandX().left();
        pickConstructionButton.add((Actor)constructionTable).expandX().left();
        if (!this.cannotAddConstructionToQueue(construction2, this.cityScreen.getCity$core(), this.cityScreen.getCity$core().getCityConstructions())) {
            Image image2;
            Image $this$getConstructionButton_u24lambda_u247 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/New");
            boolean bl4 = false;
            $this$getConstructionButton_u24lambda_u247.setColor(Color.BLACK);
            IconCircleGroup addToQueueButton = Scene2dExtensionsKt.surroundWithCircle$default(image2, 40.0f, false, null, null, 14, null);
            ActivationExtensionsKt.onClick(addToQueueButton, UncivSound.Companion.getSilent(), new Function0<Unit>(this, construction2){
                final /* synthetic */ CityConstructionsTable this$0;
                final /* synthetic */ IConstruction $construction;
                {
                    this.this$0 = $receiver;
                    this.$construction = $construction;
                    super(0);
                }

                public final void invoke() {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                }
            });
            pickConstructionButton.add((Actor)addToQueueButton);
        }
        pickConstructionButton.row();
        if (constructionButtonDTO.getRejectionReason() != null) {
            pickConstructionButton.getColor().a = 0.9f;
            icon.getColor().a = 0.5f;
            if (constructionButtonDTO.getRejectionReason().getType() != RejectionReasonType.ConsumesResources) {
                ColorMarkupLabel colorMarkupLabel;
                String string3 = constructionButtonDTO.getRejectionReason().getErrorMessage();
                Color color = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color, "RED");
                ColorMarkupLabel colorMarkupLabel2 = colorMarkupLabel = new ColorMarkupLabel(string3, color, null, 0, 12, null);
                table3 = pickConstructionButton;
                boolean bl5 = false;
                colorMarkupLabel2.setWrap(true);
                table3.add((Actor)colorMarkupLabel).colspan(pickConstructionButton.getColumns()).width(this.cityScreen.getStage().getWidth() / (float)4).fillX().left().padTop(2.0f);
            }
        }
        ActivationExtensionsKt.onClick(pickConstructionButton, new Function0<Unit>(this, construction2, pickConstructionButton){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ IConstruction $construction;
            final /* synthetic */ Table $pickConstructionButton;
            {
                this.this$0 = $receiver;
                this.$construction = $construction;
                this.$pickConstructionButton = $pickConstructionButton;
                super(0);
            }

            public final void invoke() {
                if (Intrinsics.areEqual(CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction(), this.$construction)) {
                    CityConstructionsTable.access$addConstructionToQueue(this.this$0, this.$construction, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core().getCityConstructions());
                } else {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                    CityConstructionsTable.access$highlightConstructionButton(this.this$0, this.$pickConstructionButton, true, true);
                }
                CityConstructionsTable.access$setSelectedQueueEntry$p(this.this$0, -1);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        if (!this.cityScreen.canCityBeChanged()) {
            return pickConstructionButton;
        }
        ActivationExtensionsKt.onRightClick$default(pickConstructionButton, null, new Function0<Unit>(this, construction2, pickConstructionButton){
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ IConstruction $construction;
            final /* synthetic */ Table $pickConstructionButton;
            {
                this.this$0 = $receiver;
                this.$construction = $construction;
                this.$pickConstructionButton = $pickConstructionButton;
                super(0);
            }

            public final void invoke() {
                if (!Intrinsics.areEqual(CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction(), this.$construction)) {
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$construction);
                    CityConstructionsTable.access$highlightConstructionButton(this.this$0, this.$pickConstructionButton, true, true);
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).updateWithoutConstructionAndMap$core();
                }
                new CityScreenConstructionMenu(CityConstructionsTable.access$getCityScreen$p(this.this$0).getStage(), (Actor)this.$pickConstructionButton, CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), this.$construction, new Function0<Unit>(this.this$0){
                    final /* synthetic */ CityConstructionsTable this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                        CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                    }
                });
            }
        }, 1, null);
        return pickConstructionButton;
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightConstructionButton(Table pickConstructionButton, boolean highlight2, boolean clearOthers) {
        Object button2;
        void $this$filterIsInstanceTo$iv$iv;
        Drawable drawable;
        Lazy unselected$delegate = LazyKt.lazy(highlightConstructionButton.unselected.2.INSTANCE);
        if (highlight2) {
            SkinStrings skinStrings = BaseScreen.Companion.getSkinStrings();
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            drawable = SkinStrings.getUiBackground$default(skinStrings, "CityScreen/CityConstructionTable/PickConstructionButtonSelected", null, Scene2dExtensionsKt.darken(color, 0.5f), 2, null);
        } else {
            drawable = CityConstructionsTable.highlightConstructionButton$lambda$9(unselected$delegate);
        }
        pickConstructionButton.setBackground(drawable);
        if (!clearOthers) {
            return;
        }
        SnapshotArray<Actor> snapshotArray = this.availableConstructionsTable.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray, "availableConstructionsTable.children");
        Iterable $this$filterIsInstance$iv = snapshotArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ExpanderTab)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ExpanderTab categoryExpander : (List)destination$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv2;
            if (!categoryExpander.isOpen()) continue;
            SnapshotArray<Actor> snapshotArray2 = categoryExpander.getInnerTable().getChildren();
            Intrinsics.checkNotNullExpressionValue(snapshotArray2, "categoryExpander.innerTable.children");
            Iterable $this$filterIsInstance$iv2 = snapshotArray2;
            boolean $i$f$filterIsInstance2 = false;
            Iterable $i$f$filterIsInstanceTo2 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo3 = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof Table)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            for (Object button2 : (List)destination$iv$iv2) {
                if (Intrinsics.areEqual(button2, pickConstructionButton)) continue;
                ((Table)button2).setBackground(CityConstructionsTable.highlightConstructionButton$lambda$9(unselected$delegate));
            }
        }
        if (!this.isSelectedQueueEntry()) {
            return;
        }
        SnapshotArray<Actor> snapshotArray3 = this.constructionsQueueTable.getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray3, "constructionsQueueTable.children");
        $this$filterIsInstance$iv = snapshotArray3;
        $i$f$filterIsInstance = false;
        button2 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Table)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Table button3 : (List)destination$iv$iv) {
            if (button3.getChildren().size == 1) continue;
            this.highlightQueueEntry(button3, false);
        }
        this.selectedQueueEntry = -1;
    }

    static /* synthetic */ void highlightConstructionButton$default(CityConstructionsTable cityConstructionsTable, Table table2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        cityConstructionsTable.highlightConstructionButton(table2, bl, bl2);
    }

    private final boolean isSelectedQueueEntry() {
        return this.selectedQueueEntry >= 0;
    }

    private final boolean cannotAddConstructionToQueue(IConstruction construction2, City city2, CityConstructions cityConstructions) {
        return cityConstructions.isQueueFull() || !construction2.isBuildable(cityConstructions) || !this.cityScreen.getCanChangeState() || construction2 instanceof PerpetualConstruction && cityConstructions.isBeingConstructedOrEnqueued(construction2.getName()) || city2.isPuppet();
    }

    private final TextButton getQueueButton(IConstruction construction2) {
        City city2 = this.cityScreen.getCity$core();
        CityConstructions cityConstructions = city2.getCityConstructions();
        TextButton button = null;
        if (this.isSelectedQueueEntry()) {
            button = Scene2dExtensionsKt.toTextButton$default("Remove from queue", null, false, 3, null);
            ActivationExtensionsKt.onActivation$default(button, null, KeyboardBinding.AddConstruction, new Function0<Unit>(cityConstructions, this){
                final /* synthetic */ CityConstructions $cityConstructions;
                final /* synthetic */ CityConstructionsTable this$0;
                {
                    this.$cityConstructions = $cityConstructions;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.$cityConstructions.removeFromQueue(CityConstructionsTable.access$getSelectedQueueEntry$p(this.this$0), false);
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).clearSelection();
                    CityConstructionsTable.access$setSelectedQueueEntry$p(this.this$0, -1);
                    City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                    CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                }
            }, 1, null);
            if (city2.isPuppet()) {
                Scene2dExtensionsKt.disable(button);
            }
        } else {
            button = Scene2dExtensionsKt.toTextButton$default("Add to queue", null, false, 3, null);
            if (construction2 == null || this.cannotAddConstructionToQueue(construction2, city2, cityConstructions)) {
                Scene2dExtensionsKt.disable(button);
            } else {
                KeyboardBinding keyboardBinding = KeyboardBinding.AddConstruction;
                UncivSound uncivSound = UncivSound.Companion.getSilent();
                ActivationExtensionsKt.onActivation(button, uncivSound, keyboardBinding, new Function0<Unit>(this, construction2, cityConstructions){
                    final /* synthetic */ CityConstructionsTable this$0;
                    final /* synthetic */ IConstruction $construction;
                    final /* synthetic */ CityConstructions $cityConstructions;
                    {
                        this.this$0 = $receiver;
                        this.$construction = $construction;
                        this.$cityConstructions = $cityConstructions;
                        super(0);
                    }

                    public final void invoke() {
                        CityConstructionsTable.access$addConstructionToQueue(this.this$0, this.$construction, this.$cityConstructions);
                    }
                });
            }
        }
        button.getLabelCell().pad(5.0f);
        return button;
    }

    private final void addConstructionToQueue(IConstruction construction2, CityConstructions cityConstructions) {
        if (this.cannotAddConstructionToQueue(construction2, this.cityScreen.getCity$core(), cityConstructions)) {
            return;
        }
        if (construction2 instanceof Building && ((Building)construction2).hasCreateOneImprovementUnique()) {
            this.cityScreen.startPickTileForCreatesOneImprovement((Building)construction2, Stat.Gold, false);
            return;
        }
        this.cityScreen.stopPickTileForCreatesOneImprovement();
        SoundPlayer.INSTANCE.play(this.getConstructionSound(construction2));
        cityConstructions.addToQueue(construction2.getName());
        if (!construction2.shouldBeDisplayed(cityConstructions)) {
            this.cityScreen.clearSelection();
        }
        City.reassignPopulation$default(this.cityScreen.getCity$core(), false, 1, null);
        this.cityScreen.update$core();
        this.cityScreen.getGame().getSettings().addCompletedTutorialTask("Pick construction");
    }

    private final UncivSound getConstructionSound(IConstruction construction2) {
        IConstruction iConstruction = construction2;
        return iConstruction instanceof Building ? UncivSound.Companion.getConstruction() : (iConstruction instanceof BaseUnit ? UncivSound.Companion.getPromote() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getGold()) ? UncivSound.Companion.getCoin() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getScience()) ? UncivSound.Companion.getPaper() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getCulture()) ? UncivSound.Companion.getPolicy() : (Intrinsics.areEqual(iConstruction, PerpetualConstruction.Companion.getFaith()) ? UncivSound.Companion.getChoir() : UncivSound.Companion.getClick())))));
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextButton> getBuyButtons(INonPerpetualConstruction construction2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = Stat.Companion.getStatsUsableToBuy();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TextButton it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Stat it = (Stat)((Object)element$iv$iv);
            boolean bl2 = false;
            if (this.getBuyButton(construction2, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TextButton getBuyButton(INonPerpetualConstruction construction2, Stat stat) {
        if (!Stat.Companion.getStatsUsableToBuy().contains((Object)stat) || construction2 == null) {
            return null;
        }
        City city2 = this.cityScreen.getCity$core();
        TextButton button = Scene2dExtensionsKt.toTextButton$default("", null, false, 3, null);
        if (!this.isConstructionPurchaseShown(construction2, stat)) {
            if (stat != Stat.Gold || construction2.canBePurchasedWithAnyStat(city2)) {
                return null;
            }
            button.setText(TranslationsKt.tr$default("Buy", false, 1, null));
            Scene2dExtensionsKt.disable(button);
        } else {
            Integer n = construction2.getStatBuyCost(city2, stat);
            Intrinsics.checkNotNull(n);
            int constructionBuyCost = n;
            button.setText(TranslationsKt.tr$default("Buy", false, 1, null) + ' ' + constructionBuyCost + stat.getCharacter());
            ActivationExtensionsKt.onActivation$default(button, null, KeyboardBinding.BuyConstruction, new Function0<Unit>(button, this, construction2, stat){
                final /* synthetic */ TextButton $button;
                final /* synthetic */ CityConstructionsTable this$0;
                final /* synthetic */ INonPerpetualConstruction $construction;
                final /* synthetic */ Stat $stat;
                {
                    this.$button = $button;
                    this.this$0 = $receiver;
                    this.$construction = $construction;
                    this.$stat = $stat;
                    super(0);
                }

                public final void invoke() {
                    Scene2dExtensionsKt.disable(this.$button);
                    CityConstructionsTable.access$buyButtonOnClick(this.this$0, this.$construction, this.$stat);
                }
            }, 1, null);
            Scene2dExtensionsKt.setEnabled(button, this.isConstructionPurchaseAllowed(construction2, stat, constructionBuyCost));
            this.preferredBuyStat = stat;
        }
        button.getLabelCell().pad(5.0f);
        return button;
    }

    static /* synthetic */ TextButton getBuyButton$default(CityConstructionsTable cityConstructionsTable, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        return cityConstructionsTable.getBuyButton(iNonPerpetualConstruction, stat);
    }

    private final void buyButtonOnClick(INonPerpetualConstruction construction2, Stat stat) {
        if (!(construction2 instanceof Building) || !((Building)construction2).hasCreateOneImprovementUnique()) {
            CityConstructionsTable.askToBuyConstruction$default(this, construction2, stat, null, 4, null);
            return;
        }
        if (this.selectedQueueEntry < 0) {
            this.cityScreen.startPickTileForCreatesOneImprovement((Building)construction2, stat, true);
            return;
        }
        TileImprovement tileImprovement = ((Building)construction2).getImprovementToCreate(this.cityScreen.getCity$core().getRuleset(), this.cityScreen.getCity$core().getCiv());
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement2 = tileImprovement;
        Tile tileForImprovement = this.cityScreen.getCity$core().getCityConstructions().getTileForImprovement(improvement2.getName());
        this.askToBuyConstruction(construction2, stat, tileForImprovement);
    }

    static /* synthetic */ void buyButtonOnClick$default(CityConstructionsTable cityConstructionsTable, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = cityConstructionsTable.preferredBuyStat;
        }
        cityConstructionsTable.buyButtonOnClick(iNonPerpetualConstruction, stat);
    }

    public final void askToBuyConstruction(@NotNull INonPerpetualConstruction construction2, @NotNull Stat stat, @Nullable Tile tile) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        Intrinsics.checkNotNullParameter((Object)stat, "stat");
        if (!this.isConstructionPurchaseShown(construction2, stat)) {
            return;
        }
        City city2 = this.cityScreen.getCity$core();
        Integer n = construction2.getStatBuyCost(city2, stat);
        Intrinsics.checkNotNull(n);
        int constructionStatBuyCost = n;
        if (!this.isConstructionPurchaseAllowed(construction2, stat, constructionStatBuyCost)) {
            return;
        }
        PopupKt.closeAllPopups(this.cityScreen);
        new ConfirmBuyPopup(construction2, stat, constructionStatBuyCost, tile);
    }

    public static /* synthetic */ void askToBuyConstruction$default(CityConstructionsTable cityConstructionsTable, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = cityConstructionsTable.preferredBuyStat;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        cityConstructionsTable.askToBuyConstruction(iNonPerpetualConstruction, stat, tile);
    }

    private final boolean isConstructionPurchaseShown(INonPerpetualConstruction construction2, Stat stat) {
        City city2 = this.cityScreen.getCity$core();
        return construction2.canBePurchasedWithStat(city2, stat);
    }

    private final boolean isConstructionPurchaseAllowed(INonPerpetualConstruction construction2, Stat stat, int constructionBuyCost) {
        City city2 = this.cityScreen.getCity$core();
        return city2.isPuppet() && !SequencesKt.any(City.getMatchingUniques$default(city2, UniqueType.MayBuyConstructionsInPuppets, null, false, 6, null)) ? false : (!this.cityScreen.getCanChangeState() ? false : (city2.isInResistance() ? false : (!construction2.isPurchasable(city2.getCityConstructions()) ? false : (construction2 instanceof BaseUnit && !city2.canPlaceNewUnit((BaseUnit)construction2) ? false : (city2.getCiv().getGameInfo().getGameParameters().getGodMode() ? true : (constructionBuyCost == 0 ? true : city2.getStatReserve(stat) >= constructionBuyCost))))));
    }

    private final void purchaseConstruction(INonPerpetualConstruction construction2, Stat stat, Tile tile) {
        block6: {
            IConstruction newConstruction;
            City city2;
            block5: {
                SoundPlayer.INSTANCE.play(stat.getPurchaseSound());
                city2 = this.cityScreen.getCity$core();
                if (!city2.getCityConstructions().purchaseConstruction(construction2, this.selectedQueueEntry, false, stat, tile)) {
                    Popup popup2;
                    Popup $this$purchaseConstruction_u24lambda_u2411 = popup2 = new Popup(this.cityScreen, null, 0.0f, 6, null);
                    boolean bl = false;
                    $this$purchaseConstruction_u24lambda_u2411.add((CharSequence)TranslationsKt.tr$default("No space available to place [" + construction2.getName() + "] near [" + city2.getName() + ']', false, 1, null)).row();
                    Popup.addCloseButton$default($this$purchaseConstruction_u24lambda_u2411, null, null, null, null, 15, null);
                    Popup.open$default($this$purchaseConstruction_u24lambda_u2411, false, 1, null);
                    return;
                }
                if (this.isSelectedQueueEntry()) break block5;
                IConstruction iConstruction = this.cityScreen.getSelectedConstruction();
                if (iConstruction != null ? iConstruction.isBuildable(city2.getCityConstructions()) : false) break block6;
            }
            this.selectedQueueEntry = -1;
            this.cityScreen.clearSelection();
            city2.getCityConstructions().chooseNextConstruction();
            if (((CharSequence)city2.getCityConstructions().getCurrentConstructionFromQueue()).length() > 0 && (newConstruction = city2.getCityConstructions().getCurrentConstruction()) instanceof INonPerpetualConstruction) {
                this.cityScreen.selectConstruction(newConstruction);
            }
        }
        City.reassignPopulation$default(this.cityScreen.getCity$core(), false, 1, null);
        this.cityScreen.update$core();
    }

    static /* synthetic */ void purchaseConstruction$default(CityConstructionsTable cityConstructionsTable, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        cityConstructionsTable.purchaseConstruction(iNonPerpetualConstruction, stat, tile);
    }

    /*
     * WARNING - void declaration
     */
    private final Table getMovePriorityButton(int arrowDirection, KeyboardBinding binding, int constructionQueueIndex, String name2, Function1<? super Integer, Integer> movePriority) {
        void $this$getMovePriorityButton_u24lambda_u2412;
        Image image2;
        Table button = new Table();
        Image image3 = image2 = ImageGetter.INSTANCE.getArrowImage(arrowDirection);
        Table table2 = button;
        boolean bl = false;
        $this$getMovePriorityButton_u24lambda_u2412.setColor(Color.BLACK);
        table2.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(image2, 40.0f, false, null, null, 14, null));
        button.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(button, new Function0<Unit>(button, this, movePriority, constructionQueueIndex, name2){
            final /* synthetic */ Table $button;
            final /* synthetic */ CityConstructionsTable this$0;
            final /* synthetic */ Function1<Integer, Integer> $movePriority;
            final /* synthetic */ int $constructionQueueIndex;
            final /* synthetic */ String $name;
            {
                this.$button = $button;
                this.this$0 = $receiver;
                this.$movePriority = $movePriority;
                this.$constructionQueueIndex = $constructionQueueIndex;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                this.$button.setTouchable(Touchable.disabled);
                CityConstructionsTable.access$setSelectedQueueEntry$p(this.this$0, ((Number)this.$movePriority.invoke(this.$constructionQueueIndex)).intValue());
                CityConstructionsTable.access$getCityScreen$p(this.this$0).selectConstruction(this.$name);
                City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
                CityConstructionsTable.access$updateQueueAndButtons(this.this$0, CityConstructionsTable.access$getCityScreen$p(this.this$0).getSelectedConstruction());
                CityConstructionsTable.access$ensureQueueEntryVisible(this.this$0);
            }
        });
        if (this.selectedQueueEntry == constructionQueueIndex) {
            ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(button), binding, 0, 2, null);
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)button, binding, 0.0f, 2, null);
        }
        return button;
    }

    private final Table getRaisePriorityButton(int constructionQueueIndex, String name2, City city2) {
        return this.getMovePriorityButton(2, KeyboardBinding.RaisePriority, constructionQueueIndex, name2, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((Object)city2.getCityConstructions()){

            @NotNull
            public final Integer invoke(int p0) {
                return ((CityConstructions)this.receiver).raisePriority(p0);
            }
        });
    }

    private final Table getLowerPriorityButton(int constructionQueueIndex, String name2, City city2) {
        return this.getMovePriorityButton(4, KeyboardBinding.LowerPriority, constructionQueueIndex, name2, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>((Object)city2.getCityConstructions()){

            @NotNull
            public final Integer invoke(int p0) {
                return ((CityConstructions)this.receiver).lowerPriority(p0);
            }
        });
    }

    private final Table getRemoveFromQueueButton(int constructionQueueIndex, City city2) {
        Table tab = new Table();
        tab.add((Actor)Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.INSTANCE.getImage("OtherIcons/Stop"), 40.0f, false, null, null, 14, null));
        tab.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(tab, new Function0<Unit>(tab, city2, constructionQueueIndex, this){
            final /* synthetic */ Table $tab;
            final /* synthetic */ City $city;
            final /* synthetic */ int $constructionQueueIndex;
            final /* synthetic */ CityConstructionsTable this$0;
            {
                this.$tab = $tab;
                this.$city = $city;
                this.$constructionQueueIndex = $constructionQueueIndex;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$tab.setTouchable(Touchable.disabled);
                this.$city.getCityConstructions().removeFromQueue(this.$constructionQueueIndex, false);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).clearSelection();
                City.reassignPopulation$default(CityConstructionsTable.access$getCityScreen$p(this.this$0).getCity$core(), false, 1, null);
                CityConstructionsTable.access$getCityScreen$p(this.this$0).update$core();
            }
        });
        return tab;
    }

    private final Table getHeader(String title) {
        Table table2 = new Table().background(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CityConstructionTable/Header", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 2, null));
        Intrinsics.checkNotNullExpressionValue(table2, "Table()\n                \u2026      )\n                )");
        Table table3 = Scene2dExtensionsKt.addCell(table2, (Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).pad(4.0f);
        Intrinsics.checkNotNullExpressionValue(table3, "Table()\n                \u2026\n                .pad(4f)");
        return table3;
    }

    private final void ensureQueueEntryVisible() {
        Object button = this.constructionsQueueTable.getCells().get(this.selectedQueueEntry == 0 ? 2 : 2 * this.selectedQueueEntry + 4).getActor();
        Object buttonOrHeader = this.selectedQueueEntry == 0 ? this.constructionsQueueTable.getCells().get(0).getActor() : button;
        float height = ((Actor)buttonOrHeader).getY() + ((Actor)buttonOrHeader).getHeight() - ((Actor)button).getY() + 4.0f;
        this.constructionsQueueScrollPane.scrollTo(2.0f, ((Actor)button).getY(), ((Actor)button).getWidth(), height);
    }

    private final void resizeAvailableConstructionsScrollPane() {
        this.availableConstructionsScrollPane.setHeight(Math.min(this.availableConstructionsTable.getPrefHeight(), this.lowerTableScrollCell.getMaxHeight()));
        this.lowerTable.pack();
    }

    private final void addCategory(Table $this$addCategory, String title, ArrayList<Table> list2, float prefWidth, KeyboardBinding toggleKey, boolean startsOutOpened) {
        if (list2.isEmpty()) {
            return;
        }
        if ($this$addCategory.getRows() > 0) {
            Scene2dExtensionsKt.addSeparator$default($this$addCategory, null, 0, 0.0f, 7, null);
        }
        ExpanderTab expander2 = new ExpanderTab(title, 0, null, startsOutOpened, 0.0f, 0.0f, prefWidth, "CityConstruction." + title, toggleKey, new Function0<Unit>(this){
            final /* synthetic */ CityConstructionsTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityConstructionsTable.access$resizeAvailableConstructionsScrollPane(this.this$0);
            }
        }, new Function1<Table, Unit>(list2){
            final /* synthetic */ ArrayList<Table> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                for (Table table2 : this.$list) {
                    Scene2dExtensionsKt.addSeparator$default(it, null, 1, 0.0f, 5, null);
                    it.add((Actor)table2).left().row();
                }
            }
        }, 38, null);
        $this$addCategory.add((Actor)expander2).prefWidth(prefWidth).growX().row();
    }

    static /* synthetic */ void addCategory$default(CityConstructionsTable cityConstructionsTable, Table table2, String string, ArrayList arrayList, float f, KeyboardBinding keyboardBinding, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        cityConstructionsTable.addCategory(table2, string, arrayList, f, keyboardBinding, bl);
    }

    private static final void getQueueEntry$selectQueueEntry(CityConstructionsTable this$0, String $constructionName, int $constructionQueueIndex, Function0<Unit> onBeforeUpdate) {
        this$0.cityScreen.selectConstruction($constructionName);
        this$0.selectedQueueEntry = $constructionQueueIndex;
        onBeforeUpdate.invoke();
        this$0.cityScreen.update$core();
        this$0.ensureQueueEntryVisible();
    }

    private static final NinePatchDrawable highlightConstructionButton$lambda$9(Lazy<? extends NinePatchDrawable> $unselected$delegate) {
        Lazy<? extends NinePatchDrawable> lazy = $unselected$delegate;
        return lazy.getValue();
    }

    public static final /* synthetic */ ArrayList access$getConstructionButtonDTOs(CityConstructionsTable $this) {
        return $this.getConstructionButtonDTOs();
    }

    public static final /* synthetic */ Table access$getConstructionsQueueTable$p(CityConstructionsTable $this) {
        return $this.constructionsQueueTable;
    }

    public static final /* synthetic */ Table access$getConstructionButton(CityConstructionsTable $this, ConstructionButtonDTO constructionButtonDTO) {
        return $this.getConstructionButton(constructionButtonDTO);
    }

    public static final /* synthetic */ Table access$getAvailableConstructionsTable$p(CityConstructionsTable $this) {
        return $this.availableConstructionsTable;
    }

    public static final /* synthetic */ AutoScrollPane access$getAvailableConstructionsScrollPane$p(CityConstructionsTable $this) {
        return $this.availableConstructionsScrollPane;
    }

    public static final /* synthetic */ Table access$getLowerTable$p(CityConstructionsTable $this) {
        return $this.lowerTable;
    }

    public static final /* synthetic */ void access$addCategory(CityConstructionsTable $this, Table $receiver, String title, ArrayList list2, float prefWidth, KeyboardBinding toggleKey, boolean startsOutOpened) {
        $this.addCategory($receiver, title, list2, prefWidth, toggleKey, startsOutOpened);
    }

    public static final /* synthetic */ Cell access$getLowerTableScrollCell$p(CityConstructionsTable $this) {
        return $this.lowerTableScrollCell;
    }

    public static final /* synthetic */ void access$getQueueEntry$selectQueueEntry(CityConstructionsTable this$0, String $constructionName, int $constructionQueueIndex, Function0 onBeforeUpdate) {
        CityConstructionsTable.getQueueEntry$selectQueueEntry(this$0, $constructionName, $constructionQueueIndex, onBeforeUpdate);
    }

    public static final /* synthetic */ void access$addConstructionToQueue(CityConstructionsTable $this, IConstruction construction2, CityConstructions cityConstructions) {
        $this.addConstructionToQueue(construction2, cityConstructions);
    }

    public static final /* synthetic */ void access$highlightConstructionButton(CityConstructionsTable $this, Table pickConstructionButton, boolean highlight2, boolean clearOthers) {
        $this.highlightConstructionButton(pickConstructionButton, highlight2, clearOthers);
    }

    public static final /* synthetic */ void access$setSelectedQueueEntry$p(CityConstructionsTable $this, int n) {
        $this.selectedQueueEntry = n;
    }

    public static final /* synthetic */ int access$getSelectedQueueEntry$p(CityConstructionsTable $this) {
        return $this.selectedQueueEntry;
    }

    public static final /* synthetic */ void access$buyButtonOnClick(CityConstructionsTable $this, INonPerpetualConstruction construction2, Stat stat) {
        $this.buyButtonOnClick(construction2, stat);
    }

    public static final /* synthetic */ void access$updateQueueAndButtons(CityConstructionsTable $this, IConstruction construction2) {
        $this.updateQueueAndButtons(construction2);
    }

    public static final /* synthetic */ void access$ensureQueueEntryVisible(CityConstructionsTable $this) {
        $this.ensureQueueEntryVisible();
    }

    public static final /* synthetic */ void access$resizeAvailableConstructionsScrollPane(CityConstructionsTable $this) {
        $this.resizeAvailableConstructionsScrollPane();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityConstructionsTable$ConfirmBuyPopup;", "Lcom/unciv/ui/popups/Popup;", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "Lcom/unciv/models/stats/Stat;", "constructionStatBuyCost", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/ui/screens/cityscreen/CityConstructionsTable;Lcom/unciv/models/ruleset/INonPerpetualConstruction;Lcom/unciv/models/stats/Stat;ILcom/unciv/logic/map/tile/Tile;)V", "core"})
    private final class ConfirmBuyPopup
    extends Popup {
        public ConfirmBuyPopup(final @NotNull INonPerpetualConstruction construction2, final Stat stat, @Nullable int constructionStatBuyCost, final Tile tile) {
            Intrinsics.checkNotNullParameter(construction2, "construction");
            Intrinsics.checkNotNullParameter((Object)stat, "stat");
            super(CityConstructionsTable.this.cityScreen.getStage(), null, 0.0f, 6, null);
            City city2 = CityConstructionsTable.this.cityScreen.getCity$core();
            int balance = city2.getStatReserve(stat);
            Religion majorityReligion = city2.getReligion().getMajorityReligion();
            Religion yourReligion = city2.getCiv().getReligionManager().getReligion();
            boolean isBuyingWithFaithForForeignReligion = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)construction2, UniqueType.ReligiousUnit, null, 2, null) && !Intrinsics.areEqual(majorityReligion, yourReligion);
            Popup.addGoodSizedLabel$default(this, "Currently you have [" + balance + "] [" + stat.name() + "].", 0, false, 6, null).padBottom(10.0f).row();
            if (isBuyingWithFaithForForeignReligion) {
                Popup.addGoodSizedLabel$default(this, "You are buying a religious unit in a city that doesn't follow the religion you founded ([" + ConfirmBuyPopup._init_$getName(yourReligion) + "]). This means that the unit is tied to that foreign religion ([" + ConfirmBuyPopup._init_$getName(majorityReligion) + "]) and will be less useful.", 0, false, 6, null).row();
                Cell $this$_init__u24lambda_u240 = Popup.addGoodSizedLabel$default(this, "Are you really sure you want to purchase this unit?", 24, false, 4, null);
                boolean bl = false;
                ((Label)$this$_init__u24lambda_u240.getActor()).setColor(Color.FIREBRICK);
                $this$_init__u24lambda_u240.padBottom(10.0f);
                $this$_init__u24lambda_u240.row();
            }
            Popup.addGoodSizedLabel$default(this, "Would you like to purchase [" + construction2.getName() + "] for [" + constructionStatBuyCost + "] [" + stat.getCharacter() + "]?", 0, false, 6, null).row();
            this.addCloseButton("Cancel", KeyboardBinding.Cancel, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    CityConstructionsTable.this.cityScreen.update$core();
                }
            });
            TextButton.TextButtonStyle confirmStyle = BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class);
            this.addOKButton("Purchase", KeyboardBinding.Confirm, confirmStyle, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    CityConstructionsTable.this.purchaseConstruction(construction2, stat, tile);
                }
            });
            this.equalizeLastTwoButtonWidths();
            this.open(true);
        }

        private static final String _init_$getName(Religion $this$_init__u24getName) {
            Object object = $this$_init__u24getName;
            if (object == null || (object = ((Religion)object).getReligionDisplayName()) == null) {
                object = "???";
            }
            return object;
        }
    }
}

