/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.managers.CityReligionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eJ\u001e\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001e\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityReligionInfoTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "religionManager", "Lcom/unciv/logic/city/managers/CityReligionManager;", "showMajority", "", "(Lcom/unciv/logic/city/managers/CityReligionManager;Z)V", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "asExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "onChange", "Lkotlin/Function0;", "", "getIconAndLabel", "Lkotlin/Pair;", "", "religion", "Lcom/unciv/models/Religion;", "religionName", "linkedReligionIcon", "Lcom/unciv/ui/images/Portrait;", "iconName", "core"})
public final class CityReligionInfoTable
extends Table {
    @NotNull
    private final CityReligionManager religionManager;
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final GameInfo gameInfo;

    public CityReligionInfoTable(@NotNull CityReligionManager religionManager, boolean showMajority) {
        Intrinsics.checkNotNullParameter(religionManager, "religionManager");
        super(BaseScreen.Companion.getSkin());
        this.religionManager = religionManager;
        this.civInfo = this.religionManager.getCity().getCiv();
        this.gameInfo = this.civInfo.getGameInfo();
        Color gridColor = Color.DARK_GRAY;
        Counter<String> followers = this.religionManager.getNumberOfFollowers();
        Counter<String> futurePressures = this.religionManager.getPressuresFromSurroundingCities();
        if (showMajority) {
            Religion majorityReligion = this.religionManager.getMajorityReligion();
            Pair<String, String> object = this.getIconAndLabel(majorityReligion);
            String iconName = object.component1();
            String label2 = object.component2();
            Religion religion = majorityReligion;
            this.add((Actor)this.linkedReligionIcon(iconName, religion != null ? religion.getName() : null)).pad(5.0f);
            this.add();
            this.add((Actor)Scene2dExtensionsKt.toLabel("Majority Religion: [" + label2 + ']')).colspan(3).center().row();
        }
        if (this.religionManager.getReligionThisIsTheHolyCityOf() != null) {
            Pair<String, String> pair = this.getIconAndLabel(this.religionManager.getReligionThisIsTheHolyCityOf());
            String string = pair.component1();
            String label3 = pair.component2();
            this.add((Actor)this.linkedReligionIcon(string, this.religionManager.getReligionThisIsTheHolyCityOf())).pad(5.0f);
            this.add();
            if (!this.religionManager.isBlockedHolyCity()) {
                this.add((Actor)Scene2dExtensionsKt.toLabel("Holy City of: [" + label3 + ']')).colspan(3).center().row();
            } else {
                this.add((Actor)Scene2dExtensionsKt.toLabel("Former Holy City of: [" + label3 + ']')).colspan(3).center().row();
            }
        }
        if (!followers.isEmpty()) {
            this.add().pad(5.0f);
            Table table2 = this;
            Intrinsics.checkNotNullExpressionValue(gridColor, "gridColor");
            Scene2dExtensionsKt.addSeparatorVertical$default(table2, gridColor, 0.0f, 2, null);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Followers")).pad(5.0f);
            Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Pressure")).pad(5.0f).row();
            Scene2dExtensionsKt.addSeparator$default(this, gridColor, 0, 0.0f, 6, null);
            for (Map.Entry entry : ((Map)followers).entrySet()) {
                String religion = (String)entry.getKey();
                int followerCount = ((Number)entry.getValue()).intValue();
                Religion religion2 = this.gameInfo.getReligions().get(religion);
                Intrinsics.checkNotNull(religion2);
                String iconName = religion2.getIconName();
                this.add((Actor)this.linkedReligionIcon(iconName, religion)).pad(5.0f);
                Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
                this.add((Actor)Scene2dExtensionsKt.toLabel(followerCount)).pad(5.0f);
                Scene2dExtensionsKt.addSeparatorVertical$default(this, gridColor, 0.0f, 2, null);
                if (futurePressures.containsKey(religion)) {
                    this.add((Actor)Scene2dExtensionsKt.toLabel("+ [" + ((Number)futurePressures.get((Object)religion)).intValue() + "] pressure")).pad(5.0f);
                } else {
                    this.add();
                }
                this.row();
            }
        }
    }

    public /* synthetic */ CityReligionInfoTable(CityReligionManager cityReligionManager, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(cityReligionManager, bl);
    }

    private final Pair<String, String> getIconAndLabel(String religionName) {
        return this.getIconAndLabel((Religion)((Map)this.gameInfo.getReligions()).get(religionName));
    }

    private final Pair<String, String> getIconAndLabel(Religion religion) {
        return religion == null ? TuplesKt.to("Religion", "None") : TuplesKt.to(religion.getIconName(), religion.getReligionDisplayName());
    }

    private final Portrait linkedReligionIcon(String iconName, String religion) {
        Portrait icon = ImageGetter.INSTANCE.getReligionPortrait(iconName, 30.0f);
        if (religion == null) {
            return icon;
        }
        if (Intrinsics.areEqual(religion, iconName)) {
            ActivationExtensionsKt.onClick(icon, new Function0<Unit>(religion){
                final /* synthetic */ String $religion;
                {
                    this.$religion = $religion;
                    super(0);
                }

                public final void invoke() {
                    EmpireOverviewScreen newScreen = new EmpireOverviewScreen(GUI.INSTANCE.getViewingPlayer(), EmpireOverviewCategories.Religion, this.$religion);
                    UncivGame.Companion.getCurrent().pushScreen(newScreen);
                }
            });
        } else {
            ActivationExtensionsKt.onClick(icon, new Function0<Unit>(religion){
                final /* synthetic */ String $religion;
                {
                    this.$religion = $religion;
                    super(0);
                }

                public final void invoke() {
                    GUI.INSTANCE.openCivilopedia("Belief/" + this.$religion);
                }
            });
        }
        return icon;
    }

    @NotNull
    public final ExpanderTab asExpander(@Nullable Function0<Unit> onChange) {
        Pair<String, String> pair = this.getIconAndLabel(this.religionManager.getMajorityReligion());
        String icon = pair.component1();
        String label2 = pair.component2();
        String string = "Majority Religion: [" + label2 + ']';
        Portrait portrait = ImageGetter.INSTANCE.getReligionPortrait(icon, 30.0f);
        KeyboardBinding keyboardBinding = KeyboardBinding.ReligionDetail;
        return new ExpanderTab(string, 18, (Actor)portrait, false, 0.0f, 0.0f, 0.0f, "CityStatsTable.Religion", keyboardBinding, onChange, new Function1<Table, Unit>(this){
            final /* synthetic */ CityReligionInfoTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.defaults().center().pad(5.0f);
                it.add((Actor)this.this$0);
            }
        }, 96, null);
    }
}

