/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UnitGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.pickerscreens.CityRenamePopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/cityscreen/CityScreenCityPickerTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "update", "", "core"})
@SourceDebugExtension(value={"SMAP\nCityScreenCityPickerTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityScreenCityPickerTable.kt\ncom/unciv/ui/screens/cityscreen/CityScreenCityPickerTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1#2:95\n*E\n"})
public final class CityScreenCityPickerTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;

    public CityScreenCityPickerTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
    }

    public final void update() {
        Object $this$update_u24lambda_u241;
        Image starImage;
        Object object;
        City city2 = this.cityScreen.getCity$core();
        Civilization civInfo = city2.getCiv();
        this.setBackground(BaseScreen.Companion.getSkinStrings().getUiBackground("CityScreen/CityPickerTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleShape(), civInfo.getNation().getOuterColor()));
        this.clear();
        if (this.cityScreen.getViewableCities().size() > 1) {
            Table prevCityButton = new Table();
            Image image2 = ImageGetter.INSTANCE.getImage("OtherIcons/BackArrow");
            image2.setColor(civInfo.getNation().getInnerColor());
            prevCityButton.add((Actor)image2).size(25.0f).pad(10.0f);
            prevCityButton.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(prevCityButton, new Function0<Unit>(this){
                final /* synthetic */ CityScreenCityPickerTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    CityScreenCityPickerTable.access$getCityScreen$p(this.this$0).page(-1);
                }
            });
            this.add((Actor)prevCityButton).pad(10.0f);
        } else {
            this.add();
        }
        Table cityNameTable = new Table();
        if (city2.isBeingRazed()) {
            Image fireImage = ImageGetter.INSTANCE.getImage("OtherIcons/Fire");
            cityNameTable.add((Actor)fireImage).size(20.0f).padRight(5.0f);
        }
        if (city2.isPuppet()) {
            object = ImageGetter.INSTANCE.getImage("OtherIcons/Puppet");
            Image $this$update_u24lambda_u240 = object;
            boolean bl = false;
            $this$update_u24lambda_u240.setColor(Color.LIGHT_GRAY);
            starImage = object;
            cityNameTable.add((Actor)starImage).size(20.0f).padRight(5.0f);
        }
        if (city2.isInResistance()) {
            Image resistanceImage = ImageGetter.INSTANCE.getImage("StatIcons/Resistance");
            cityNameTable.add((Actor)resistanceImage).size(20.0f).padRight(5.0f);
        }
        if (city2.isCapital()) {
            $this$update_u24lambda_u241 = object = ImageGetter.INSTANCE.getImage("OtherIcons/Star");
            boolean bl = false;
            ((Actor)$this$update_u24lambda_u241).setColor(Color.LIGHT_GRAY);
            starImage = object;
            cityNameTable.add((Actor)starImage).size(20.0f).padRight(5.0f);
        }
        City $this$update_u24lambda_u242 = city2;
        boolean bl = false;
        object = '{' + $this$update_u24lambda_u242.getName() + "} (" + $this$update_u24lambda_u242.getPopulation().getPopulation() + ')';
        $this$update_u24lambda_u241 = civInfo.getNation().getInnerColor();
        Label currentCityLabel = Scene2dExtensionsKt.toLabel$default((String)object, (Color)$this$update_u24lambda_u241, 30, 0, true, 4, null);
        if (this.cityScreen.getCanChangeState()) {
            ActivationExtensionsKt.onClick(currentCityLabel, new Function0<Unit>(this, city2){
                final /* synthetic */ CityScreenCityPickerTable this$0;
                final /* synthetic */ City $city;
                {
                    this.this$0 = $receiver;
                    this.$city = $city;
                    super(0);
                }

                public final void invoke() {
                    new CityRenamePopup(CityScreenCityPickerTable.access$getCityScreen$p(this.this$0), this.$city, new Function0<Unit>(this.this$0, this.$city){
                        final /* synthetic */ CityScreenCityPickerTable this$0;
                        final /* synthetic */ City $city;
                        {
                            this.this$0 = $receiver;
                            this.$city = $city;
                            super(0);
                        }

                        public final void invoke() {
                            CityScreenCityPickerTable.access$getCityScreen$p(this.this$0).getGame().replaceCurrentScreen(new CityScreen(this.$city, null, null, null, 14, null));
                        }
                    });
                }
            });
        }
        cityNameTable.add((Actor)currentCityLabel);
        MapUnit garrison = city2.getGarrison();
        if (garrison != null) {
            cityNameTable.add((Actor)new UnitGroup(garrison, 30.0f)).padLeft(5.0f);
        }
        this.add((Actor)cityNameTable).width(this.getStage().getWidth() / (float)4);
        if (this.cityScreen.getViewableCities().size() > 1) {
            Table nextCityButton = new Table();
            Image image3 = ImageGetter.INSTANCE.getImage("OtherIcons/BackArrow");
            image3.setSize(25.0f, 25.0f);
            image3.setOrigin(1);
            image3.setRotation(180.0f);
            image3.setColor(civInfo.getNation().getInnerColor());
            nextCityButton.add((Actor)image3).size(25.0f).pad(10.0f);
            nextCityButton.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(nextCityButton, new Function0<Unit>(this){
                final /* synthetic */ CityScreenCityPickerTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    CityScreenCityPickerTable.access$getCityScreen$p(this.this$0).page(1);
                }
            });
            this.add((Actor)nextCityButton).pad(10.0f);
        } else {
            this.add();
        }
        this.pack();
    }

    public static final /* synthetic */ CityScreen access$getCityScreen$p(CityScreenCityPickerTable $this) {
        return $this.cityScreen;
    }
}

