/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.civilopediascreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.UncivShowableException;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 d2\u00020\u0001:\u0004defgB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0091\u0001\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u0012\b\b\u0002\u0010\u0011\u001a\u00020\b\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0017J\b\u0010>\u001a\u00020\u0013H\u0002J\u0006\u0010?\u001a\u00020\u0013J\u0010\u0010@\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\bH\u0002J\n\u0010A\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\r2\b\b\u0002\u0010E\u001a\u00020FJ\u0010\u0010G\u001a\u00020H2\u0006\u0010D\u001a\u00020\rH\u0002J \u0010I\u001a\u00020\u00052\u0006\u0010J\u001a\u00020H2\u0006\u0010*\u001a\u00020\b2\u0006\u0010K\u001a\u00020\rH\u0002J\b\u0010L\u001a\u00020\bH\u0016J\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020\b0N2\u0006\u0010O\u001a\u00020PJ#\u0010Q\u001a\u00020R*\b\u0012\u0004\u0012\u00020\b0S2\u0006\u0010O\u001a\u00020PH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ\f\u0010U\u001a\u00020V*\u00020WH\u0002J\f\u0010X\u001a\u00020Y*\u00020WH\u0002J\f\u0010Z\u001a\u00020\u0013*\u00020\bH\u0002J\u001c\u0010[\u001a\u00020\u0013*\u00020\\2\u0006\u0010]\u001a\u00020Y2\u0006\u0010^\u001a\u00020\u0005H\u0002J\u001c\u0010_\u001a\u00020\u0013*\u00020\b2\u0006\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\u0005H\u0002J\u001c\u0010b\u001a\u00020\u0013*\u00020\\2\u0006\u0010]\u001a\u00020Y2\u0006\u0010c\u001a\u00020\u0005H\u0002R\u001b\u0010\u0018\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0015\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001c\u001a\u0004\b#\u0010$R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010 R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001aR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u001b\u0010*\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001c\u001a\u0004\b+\u0010 R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001aR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010 R\u001b\u00101\u001a\u0002028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u001c\u001a\u0004\b3\u00104R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010.R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u001aR\u0011\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010\u001eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010 R\u001b\u0010;\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\u001c\u001a\u0004\b<\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006h"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "indent", "", "(Lcom/unciv/models/ruleset/unique/Unique;I)V", "text", "", "link", "icon", "extraImage", "imageSize", "", "size", "header", "padding", "color", "separator", "", "starred", "centered", "iconCrossed", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;FIIIFLjava/lang/String;ZZZZ)V", "align", "getAlign", "()I", "align$delegate", "Lkotlin/Lazy;", "getCentered", "()Z", "getColor", "()Ljava/lang/String;", "displayColor", "Lcom/badlogic/gdx/graphics/Color;", "getDisplayColor", "()Lcom/badlogic/gdx/graphics/Color;", "displayColor$delegate", "getExtraImage", "getHeader", "getIcon", "getIconCrossed", "iconToDisplay", "getIconToDisplay", "iconToDisplay$delegate", "getImageSize", "()F", "getIndent", "getLink", "linkType", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$LinkType;", "getLinkType", "()Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$LinkType;", "linkType$delegate", "getPadding", "getSeparator", "getSize", "getStarred", "getText", "textToDisplay", "getTextToDisplay", "textToDisplay$delegate", "hasNormalContent", "isEmpty", "isValidInternalLink", "parseColor", "render", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "labelWidth", "iconDisplay", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$IconDisplay;", "renderExtraImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "renderIcon", "table", "iconSize", "toString", "unsupportedReasons", "Lkotlin/sequences/Sequence;", "validator", "Lcom/unciv/models/ruleset/validation/RulesetValidator;", "checkExtraImage", "", "Lkotlin/sequences/SequenceScope;", "(Lkotlin/sequences/SequenceScope;Lcom/unciv/models/ruleset/validation/RulesetValidator;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cropToContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;", "getContentSize", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$IntRectangle;", "hasProtocol", "isColumnEmpty", "Lcom/badlogic/gdx/graphics/Pixmap;", "bounds", "relativeX", "isHex", "start", "length", "isRowEmpty", "relativeY", "Companion", "IconDisplay", "IntRectangle", "LinkType", "core"})
@SourceDebugExtension(value={"SMAP\nFormattedLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattedLine.kt\ncom/unciv/ui/screens/civilopediascreen/FormattedLine\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,468:1\n1064#2,2:469\n1726#3,3:471\n1726#3,3:474\n*S KotlinDebug\n*F\n+ 1 FormattedLine.kt\ncom/unciv/ui/screens/civilopediascreen/FormattedLine\n*L\n252#1:469,2\n419#1:471,3\n426#1:474,3\n*E\n"})
public final class FormattedLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final String link;
    @NotNull
    private final String icon;
    @NotNull
    private final String extraImage;
    private final float imageSize;
    private final int size;
    private final int header;
    private final int indent;
    private final float padding;
    @NotNull
    private final String color;
    private final boolean separator;
    private final boolean starred;
    private final boolean centered;
    private final boolean iconCrossed;
    @NotNull
    private final Lazy linkType$delegate;
    @NotNull
    private final Lazy align$delegate;
    @NotNull
    private final Lazy iconToDisplay$delegate;
    @NotNull
    private final Lazy textToDisplay$delegate;
    @NotNull
    private final Lazy displayColor$delegate;
    @NotNull
    private static final Integer[] headerSizes;
    @NotNull
    private static final Color defaultColor;
    @NotNull
    public static final String linkImage = "OtherIcons/Link";
    @NotNull
    public static final String starImage = "OtherIcons/Star";
    public static final float minIconSize = 30.0f;
    public static final float iconPad = 5.0f;
    public static final float indentPad = 30.0f;
    public static final int indentOneAtNumIcons = 2;
    @Nullable
    private static Ruleset rulesetCachedInNameMap;
    @Nullable
    private static HashMap<String, CivilopediaCategories> allObjectNamesCategoryMap;

    public FormattedLine(@NotNull String text2, @NotNull String link, @NotNull String icon, @NotNull String extraImage, float imageSize, int size2, int header, int indent, float padding, @NotNull String color, boolean separator, boolean starred, boolean centered, boolean iconCrossed) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(link, "link");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(extraImage, "extraImage");
        Intrinsics.checkNotNullParameter(color, "color");
        this.text = text2;
        this.link = link;
        this.icon = icon;
        this.extraImage = extraImage;
        this.imageSize = imageSize;
        this.size = size2;
        this.header = header;
        this.indent = indent;
        this.padding = padding;
        this.color = color;
        this.separator = separator;
        this.starred = starred;
        this.centered = centered;
        this.iconCrossed = iconCrossed;
        this.linkType$delegate = LazyKt.lazy((Function0)new Function0<LinkType>(this){
            final /* synthetic */ FormattedLine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LinkType invoke() {
                return FormattedLine.access$hasProtocol(this.this$0, this.this$0.getLink()) ? LinkType.External : (((CharSequence)this.this$0.getLink()).length() > 0 ? LinkType.Internal : LinkType.None);
            }
        });
        this.align$delegate = LazyKt.lazy((Function0)new Function0<Integer>(this){
            final /* synthetic */ FormattedLine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getCentered() ? 1 : 8;
            }
        });
        this.iconToDisplay$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ FormattedLine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((CharSequence)this.this$0.getIcon()).length() > 0 ? this.this$0.getIcon() : (this.this$0.getLinkType() == LinkType.Internal ? this.this$0.getLink() : "");
            }
        });
        this.textToDisplay$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ FormattedLine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ((CharSequence)this.this$0.getText()).length() == 0 && this.this$0.getLinkType() == LinkType.External ? this.this$0.getLink() : this.this$0.getText();
            }
        });
        this.displayColor$delegate = LazyKt.lazy((Function0)new Function0<Color>(this){
            final /* synthetic */ FormattedLine this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Color invoke() {
                Color color = FormattedLine.access$parseColor(this.this$0);
                if (color == null) {
                    color = FormattedLine.Companion.getDefaultColor();
                }
                return color;
            }
        });
    }

    public /* synthetic */ FormattedLine(String string, String string2, String string3, String string4, float f, int n, int n2, int n3, float f2, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            string = "";
        }
        if ((n4 & 2) != 0) {
            string2 = "";
        }
        if ((n4 & 4) != 0) {
            string3 = "";
        }
        if ((n4 & 8) != 0) {
            string4 = "";
        }
        if ((n4 & 0x10) != 0) {
            f = Float.NaN;
        }
        if ((n4 & 0x20) != 0) {
            n = Integer.MIN_VALUE;
        }
        if ((n4 & 0x40) != 0) {
            n2 = 0;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x100) != 0) {
            f2 = Float.NaN;
        }
        if ((n4 & 0x200) != 0) {
            string5 = "";
        }
        if ((n4 & 0x400) != 0) {
            bl = false;
        }
        if ((n4 & 0x800) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x1000) != 0) {
            bl3 = false;
        }
        if ((n4 & 0x2000) != 0) {
            bl4 = false;
        }
        this(string, string2, string3, string4, f, n, n2, n3, f2, string5, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getLink() {
        return this.link;
    }

    @NotNull
    public final String getIcon() {
        return this.icon;
    }

    @NotNull
    public final String getExtraImage() {
        return this.extraImage;
    }

    public final float getImageSize() {
        return this.imageSize;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getHeader() {
        return this.header;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final float getPadding() {
        return this.padding;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    public final boolean getSeparator() {
        return this.separator;
    }

    public final boolean getStarred() {
        return this.starred;
    }

    public final boolean getCentered() {
        return this.centered;
    }

    public final boolean getIconCrossed() {
        return this.iconCrossed;
    }

    public FormattedLine(@NotNull Unique unique, int indent) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        this(unique.getDisplayText(), FormattedLine.Companion.getUniqueLink(unique), null, null, 0.0f, 0, 0, indent, 0.0f, null, false, false, false, false, 16252, null);
    }

    public /* synthetic */ FormattedLine(Unique unique, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(unique, n);
    }

    @NotNull
    public final LinkType getLinkType() {
        Lazy lazy = this.linkType$delegate;
        return (LinkType)((Object)lazy.getValue());
    }

    public final int getAlign() {
        Lazy lazy = this.align$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    private final String getIconToDisplay() {
        Lazy lazy = this.iconToDisplay$delegate;
        return (String)lazy.getValue();
    }

    private final String getTextToDisplay() {
        Lazy lazy = this.textToDisplay$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final Color getDisplayColor() {
        Lazy lazy = this.displayColor$delegate;
        return (Color)lazy.getValue();
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.text).length() == 0 && ((CharSequence)this.extraImage).length() == 0 && !this.starred && ((CharSequence)this.icon).length() == 0 && ((CharSequence)this.link).length() == 0 && !this.separator;
    }

    @NotNull
    public final Sequence<String> unsupportedReasons(@NotNull RulesetValidator validator) {
        Intrinsics.checkNotNullParameter(validator, "validator");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, validator, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FormattedLine this$0;
            final /* synthetic */ RulesetValidator $validator;
            {
                this.this$0 = $receiver;
                this.$validator = $validator;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (FormattedLine.access$hasNormalContent(this.this$0) && this.this$0.getSeparator()) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield("separator and other options are incompatible", this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (((CharSequence)this.this$0.getLink()).length() > 0 && !FormattedLine.access$isValidInternalLink(this.this$0, this.this$0.getLink()) && !FormattedLine.access$hasProtocol(this.this$0, this.this$0.getLink())) {
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yield("link is invalid - use internal category/name format or a https:// URL", this);
                            if (v1 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl28
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        if (((CharSequence)this.this$0.getIcon()).length() > 0 && !FormattedLine.access$isValidInternalLink(this.this$0, this.this$0.getLink())) {
                            this.L$0 = $this$sequence;
                            this.label = 3;
                            v2 = $this$sequence.yield("icon is invalid - use internal category/name format", this);
                            if (v2 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl39
                    }
                    case 3: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl39:
                        // 2 sources

                        if (this.this$0.getHeader() != 0 && this.this$0.getSize() != -2147483648) {
                            this.L$0 = $this$sequence;
                            this.label = 4;
                            v3 = $this$sequence.yield("use either size or header but not both", this);
                            if (v3 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl50
                    }
                    case 4: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl50:
                        // 2 sources

                        var3_4 = FormattedLine.Companion.getHeaderSizes().length;
                        var4_5 = this.this$0.getHeader();
                        if (!(0 <= var4_5 ? var4_5 < var3_4 : false)) {
                            this.L$0 = $this$sequence;
                            this.label = 5;
                            v4 = $this$sequence.yield("header should be in the range 1.." + (FormattedLine.Companion.getHeaderSizes().length - 1), this);
                            if (v4 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl63
                    }
                    case 5: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl63:
                        // 2 sources

                        if (this.this$0.getSize() != -2147483648) {
                            var3_4 = this.this$0.getSize();
                            if (!(1 <= var3_4 ? var3_4 < 101 : false)) {
                                this.L$0 = $this$sequence;
                                this.label = 6;
                                v5 = $this$sequence.yield("size is out of sensible range", this);
                                if (v5 == var5_2) {
                                    return var5_2;
                                }
                            }
                        }
                        ** GOTO lbl76
                    }
                    case 6: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl76:
                        // 2 sources

                        if (!(0 <= (var3_4 = this.this$0.getIndent()) ? var3_4 < 101 : false)) {
                            this.L$0 = $this$sequence;
                            this.label = 7;
                            v6 = $this$sequence.yield("indent is out of sensible range", this);
                            if (v6 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl87
                    }
                    case 7: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
lbl87:
                        // 2 sources

                        if (((CharSequence)this.this$0.getColor()).length() > 0) {
                            if (FormattedLine.access$parseColor(this.this$0) != null) break;
                            this.L$0 = $this$sequence;
                            this.label = 8;
                            v7 = $this$sequence.yield("unknown color \"" + this.this$0.getColor() + '\"', this);
                            if (v7 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl111
                    }
                    case 8: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
                        ** GOTO lbl111
                    }
                }
                if (((CharSequence)this.this$0.getText()).length() == 0 && ((CharSequence)FormattedLine.access$getTextToDisplay(this.this$0)).length() == 0 && !this.this$0.getStarred() && !this.this$0.getSeparator()) {
                    this.L$0 = $this$sequence;
                    this.label = 9;
                    v8 = $this$sequence.yield("color set but nothing to apply it to", this);
                    if (v8 == var5_2) {
                        return var5_2;
                    }
                }
                ** GOTO lbl111
                {
                    case 9: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
lbl111:
                        // 4 sources

                        if (this.this$0.getIconCrossed() && ((CharSequence)this.this$0.getLink()).length() == 0 && ((CharSequence)this.this$0.getIcon()).length() == 0) {
                            this.L$0 = $this$sequence;
                            this.label = 10;
                            v9 = $this$sequence.yield("iconCrossed set without icon or link", this);
                            if (v9 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl122
                    }
                    case 10: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v9 = $result;
lbl122:
                        // 2 sources

                        if (((CharSequence)this.this$0.getExtraImage()).length() > 0) {
                            this.L$0 = $this$sequence;
                            this.label = 11;
                            v10 = FormattedLine.access$checkExtraImage(this.this$0, $this$sequence, this.$validator, this);
                            if (v10 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl133
                    }
                    case 11: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v10 = $result;
lbl133:
                        // 2 sources

                        if (!Float.isNaN(this.this$0.getImageSize()) && ((CharSequence)this.this$0.getExtraImage()).length() == 0) {
                            this.L$0 = null;
                            this.label = 12;
                            v11 = $this$sequence.yield("imageSize is only valid for an extraImage", this);
                            if (v11 == var5_2) {
                                return var5_2;
                            }
                        }
                        ** GOTO lbl143
                    }
                    case 12: {
                        ResultKt.throwOnFailure($result);
                        v11 = $result;
lbl143:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkExtraImage(SequenceScope<? super String> var1_1, RulesetValidator var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof checkExtraImage.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ FormattedLine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FormattedLine.access$checkExtraImage(this.this$0, null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                if (this.hasNormalContent() || this.separator) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = $this$checkExtraImage;
                    $continuation.L$2 = validator;
                    $continuation.label = 1;
                    v0 = $this$checkExtraImage.yield("extraImage and other options except imageSize are incompatible", $continuation);
                    if (v0 == var6_6) {
                        return var6_6;
                    }
                }
                ** GOTO lbl27
            }
            case 1: {
                validator = (RulesetValidator)$continuation.L$2;
                $this$checkExtraImage = (SequenceScope)$continuation.L$1;
                this = (FormattedLine)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl27:
                // 2 sources

                if (ImageGetter.INSTANCE.imageExists(this.extraImage)) {
                    return Unit.INSTANCE;
                }
                if (ImageGetter.INSTANCE.findExternalImage(this.extraImage) != null) {
                    return Unit.INSTANCE;
                }
                if (validator.uncachedImageExists(this.extraImage)) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v1 = $this$checkExtraImage.yield("extraImage not found as either atlas texture or in ExtraImages folder", $continuation);
                if (v1 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl44
            }
            case 2: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl44:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean hasNormalContent() {
        return ((CharSequence)this.text).length() > 0 || ((CharSequence)this.link).length() > 0 || ((CharSequence)this.icon).length() > 0 || ((CharSequence)this.color).length() > 0 || this.size != Integer.MIN_VALUE || this.header != 0 || this.starred;
    }

    private final boolean isValidInternalLink(String link) {
        CharSequence charSequence = link;
        return new Regex("^[^/]+/[^/]+$").matches(charSequence);
    }

    private final boolean hasProtocol(String $this$hasProtocol) {
        return StringsKt.startsWith$default($this$hasProtocol, "http://", false, 2, null) || StringsKt.startsWith$default($this$hasProtocol, "https://", false, 2, null) || StringsKt.startsWith$default($this$hasProtocol, "mailto:", false, 2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHex(String $this$isHex, int start2, int length) {
        if (length == 0) {
            return false;
        }
        if (start2 + length > $this$isHex.length()) {
            return false;
        }
        String string = $this$isHex.substring(start2, start2 + length);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        CharSequence $this$all$iv = string;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (!Character.isDigit(it)) {
                if (!('a' <= it ? it < 'g' : false)) {
                    if ('A' > it) return false;
                    if (it >= 'G') return false;
                    boolean bl2 = true;
                    if (!bl2) return false;
                }
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final Color parseColor() {
        if (((CharSequence)this.color).length() == 0) {
            return null;
        }
        if (this.color.charAt(0) == '#' && this.isHex(this.color, 1, 3)) {
            if (this.isHex(this.color, 1, 6)) {
                return Color.valueOf(this.color);
            }
            char[] cArray = new char[]{this.color.charAt(1), this.color.charAt(1), this.color.charAt(2), this.color.charAt(2), this.color.charAt(3), this.color.charAt(3)};
            String hex6 = new String(cArray);
            return Color.valueOf(hex6);
        }
        String string = this.color.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
        return Colors.get(string);
    }

    @NotNull
    public final Actor render(float labelWidth, @NotNull IconDisplay iconDisplay) {
        Intrinsics.checkNotNullParameter((Object)iconDisplay, "iconDisplay");
        if (((CharSequence)this.extraImage).length() > 0) {
            return this.renderExtraImage(labelWidth);
        }
        int n = headerSizes.length;
        int n2 = this.header;
        int fontSize = (1 <= n2 ? n2 < n : false) ? headerSizes[this.header] : (this.size == Integer.MIN_VALUE ? 18 : this.size);
        Color labelColor = this.starred ? defaultColor : this.getDisplayColor();
        Table table2 = new Table(BaseScreen.Companion.getSkin());
        int iconCount = 0;
        float iconSize = Math.max(30.0f, (float)fontSize * 1.5f);
        if (this.getLinkType() != LinkType.None && iconDisplay == IconDisplay.All) {
            table2.add((Actor)ImageGetter.INSTANCE.getImage(linkImage)).size(iconSize).padRight(5.0f);
            ++iconCount;
        }
        if (iconDisplay != IconDisplay.None) {
            iconCount += this.renderIcon(table2, this.getIconToDisplay(), iconSize);
        }
        if (this.starred) {
            Image image2 = ImageGetter.INSTANCE.getImage(starImage);
            image2.setColor(this.getDisplayColor());
            table2.add((Actor)image2).size(iconSize).padRight(5.0f);
            ++iconCount;
        }
        if (((CharSequence)this.getTextToDisplay()).length() > 0) {
            float indentWidth;
            float usedWidth = (float)iconCount * (iconSize + 5.0f);
            float f = this.centered ? -usedWidth : (this.indent == 0 && iconCount == 0 ? 0.0f : (this.indent == 0 ? 5.0f : (indentWidth = iconCount == 0 ? (float)this.indent * 30.0f - usedWidth : (float)(this.indent - 1) * 30.0f + 70.0f + 5.0f - usedWidth)));
            Label label2 = StringsKt.contains$default((CharSequence)this.getTextToDisplay(), '\u00ab', false, 2, null) ? (Label)new ColorMarkupLabel(this.getTextToDisplay(), fontSize, null, iconCount != 0, 4, null) : Scene2dExtensionsKt.toLabel$default(this.getTextToDisplay(), labelColor, fontSize, 0, iconCount != 0, 4, null);
            label2.setWrap(!this.centered && labelWidth > 0.0f);
            label2.setAlignment(this.getAlign());
            if (labelWidth == 0.0f) {
                table2.add((Actor)label2).padLeft(RangesKt.coerceAtLeast(indentWidth, 0.0f)).padRight(RangesKt.coerceAtLeast(-indentWidth, 0.0f)).align(this.getAlign());
            } else {
                table2.add((Actor)label2).width(labelWidth - usedWidth - indentWidth).padLeft(indentWidth).align(this.getAlign());
            }
        }
        return table2;
    }

    public static /* synthetic */ Actor render$default(FormattedLine formattedLine, float f, IconDisplay iconDisplay, int n, Object object) {
        if ((n & 2) != 0) {
            iconDisplay = IconDisplay.All;
        }
        return formattedLine.render(f, iconDisplay);
    }

    private final Table renderExtraImage(float labelWidth) {
        Table table2 = new Table(BaseScreen.Companion.getSkin());
        try {
            Image image2 = FormattedLine.renderExtraImage$getExtraImage(this);
            float maxSize = Float.isNaN(this.imageSize) ? labelWidth : this.imageSize;
            Pair<Float, Float> pair = image2.getWidth() > image2.getHeight() ? TuplesKt.to(Float.valueOf(maxSize), Float.valueOf(maxSize * image2.getHeight() / image2.getWidth())) : TuplesKt.to(Float.valueOf(maxSize * image2.getWidth() / image2.getHeight()), Float.valueOf(maxSize));
            float width = ((Number)pair.component1()).floatValue();
            float height = ((Number)pair.component2()).floatValue();
            table2.add((Actor)image2).size(width, height);
        }
        catch (Exception exception2) {
            Log.INSTANCE.error("Exception while rendering civilopedia text", exception2);
        }
        return table2;
    }

    private final int renderIcon(Table table2, String iconToDisplay2, float iconSize) {
        if (((CharSequence)iconToDisplay2).length() == 0) {
            return 0;
        }
        char[] cArray = new char[]{'/'};
        List parts = StringsKt.split$default((CharSequence)iconToDisplay2, cArray, false, 2, 2, null);
        if (parts.size() != 2) {
            return 0;
        }
        CivilopediaCategories civilopediaCategories = CivilopediaCategories.Companion.fromLink((String)parts.get(0));
        if (civilopediaCategories == null) {
            return 0;
        }
        CivilopediaCategories category = civilopediaCategories;
        Function2<String, Float, Actor> function2 = category.getGetImage();
        if (function2 == null || (function2 = function2.invoke((String)parts.get(1), Float.valueOf(iconSize))) == null) {
            return 0;
        }
        Function2<String, Float, Actor> image2 = function2;
        if (this.iconCrossed) {
            table2.add((Actor)ImageGetter.INSTANCE.getCrossedImage((Actor)((Object)image2), iconSize)).size(iconSize).padRight(5.0f);
        } else {
            table2.add(image2).size(iconSize).padRight(5.0f);
        }
        return 1;
    }

    @NotNull
    public String toString() {
        return this.isEmpty() ? "(empty)" : (this.separator ? "(separator)" : (((CharSequence)this.extraImage).length() > 0 ? "(extraImage='" + this.extraImage + "')" : (this.header > 0 ? "(header=" + this.header + ")'" + this.text + '\'' : (this.getLinkType() == LinkType.None ? '\'' + this.text + '\'' : '\'' + this.text + "'->" + this.link))));
    }

    private final Image cropToContent(TextureRegionDrawable $this$cropToContent) {
        IntRectangle rect = this.getContentSize($this$cropToContent);
        TextureRegion newRegion = new TextureRegion($this$cropToContent.getRegion().getTexture(), rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        return new Image(new TextureRegionDrawable(newRegion));
    }

    private final IntRectangle getContentSize(TextureRegionDrawable $this$getContentSize) {
        TextureData textureData = $this$getContentSize.getRegion().getTexture().getTextureData();
        Intrinsics.checkNotNullExpressionValue(textureData, "region.texture.textureData");
        Pixmap pixMap = Scene2dExtensionsKt.getReadonlyPixmap(textureData);
        IntRectangle result2 = new IntRectangle($this$getContentSize.getRegion().getRegionX(), $this$getContentSize.getRegion().getRegionY(), $this$getContentSize.getRegion().getRegionWidth(), $this$getContentSize.getRegion().getRegionHeight());
        IntRectangle original = IntRectangle.copy$default(result2, 0, 0, 0, 0, 15, null);
        while (result2.getHeight() > 0 && this.isRowEmpty(pixMap, result2, result2.getHeight() - 1)) {
            result2.setHeight(result2.getHeight() - 1);
        }
        while (result2.getHeight() > 0 && this.isRowEmpty(pixMap, result2, 0)) {
            result2.setY(result2.getY() + 1);
            result2.setHeight(result2.getHeight() - 1);
        }
        while (result2.getWidth() > 0 && this.isColumnEmpty(pixMap, result2, result2.getWidth() - 1)) {
            result2.setWidth(result2.getWidth() - 1);
        }
        while (result2.getWidth() > 0 && this.isColumnEmpty(pixMap, result2, 0)) {
            result2.setX(result2.getX() + 1);
            result2.setWidth(result2.getWidth() - 1);
        }
        result2.grow(RangesKt.coerceAtLeast(original.getWidth() / 40, 1), RangesKt.coerceAtLeast(original.getHeight() / 40, 1));
        return result2.intersection(original);
    }

    private final boolean isRowEmpty(Pixmap $this$isRowEmpty, IntRectangle bounds, int relativeY) {
        boolean bl;
        block3: {
            int y = bounds.getY() + relativeY;
            Iterable $this$all$iv = RangesKt.until(bounds.getX(), bounds.getX() + bounds.getWidth());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (($this$isRowEmpty.getPixel(it, y) & 0xFF) == 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isColumnEmpty(Pixmap $this$isColumnEmpty, IntRectangle bounds, int relativeX) {
        boolean bl;
        block3: {
            int x = bounds.getX() + relativeX;
            Iterable $this$all$iv = RangesKt.until(bounds.getY(), bounds.getY() + bounds.getHeight());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (($this$isColumnEmpty.getPixel(x, it) & 0xFF) == 0) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Image renderExtraImage$getExtraImage(FormattedLine this$0) {
        if (ImageGetter.INSTANCE.imageExists(this$0.extraImage)) {
            return this$0.centered ? this$0.cropToContent(ImageGetter.INSTANCE.getDrawable(this$0.extraImage)) : ImageGetter.INSTANCE.getImage(this$0.extraImage);
        }
        FileHandle fileHandle = ImageGetter.INSTANCE.findExternalImage(this$0.extraImage);
        if (fileHandle == null) {
            throw new UncivShowableException("Extra image '[" + this$0.extraImage + "]' not found", null, 2, null);
        }
        FileHandle externalImage = fileHandle;
        return ImageGetter.INSTANCE.getExternalImage(externalImage);
    }

    public FormattedLine() {
        this(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null);
    }

    public static final /* synthetic */ boolean access$hasNormalContent(FormattedLine $this) {
        return $this.hasNormalContent();
    }

    public static final /* synthetic */ boolean access$isValidInternalLink(FormattedLine $this, String link) {
        return $this.isValidInternalLink(link);
    }

    public static final /* synthetic */ boolean access$hasProtocol(FormattedLine $this, String $receiver) {
        return $this.hasProtocol($receiver);
    }

    public static final /* synthetic */ Color access$parseColor(FormattedLine $this) {
        return $this.parseColor();
    }

    public static final /* synthetic */ String access$getTextToDisplay(FormattedLine $this) {
        return $this.getTextToDisplay();
    }

    public static final /* synthetic */ Object access$checkExtraImage(FormattedLine $this, SequenceScope $receiver, RulesetValidator validator, Continuation $completion) {
        return $this.checkExtraImage($receiver, validator, $completion);
    }

    static {
        Integer[] integerArray = new Integer[]{18, 36, 32, 27, 24, 21, 15, 12, 9};
        headerSizes = integerArray;
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        defaultColor = color;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J,\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u00072\u0006\u0010 \u001a\u00020\u0019H\u0002R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$Companion;", "", "()V", "allObjectNamesCategoryMap", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "Lkotlin/collections/HashMap;", "defaultColor", "Lcom/badlogic/gdx/graphics/Color;", "getDefaultColor", "()Lcom/badlogic/gdx/graphics/Color;", "headerSizes", "", "", "getHeaderSizes", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "iconPad", "", "indentOneAtNumIcons", "indentPad", "linkImage", "minIconSize", "rulesetCachedInNameMap", "Lcom/unciv/models/ruleset/Ruleset;", "starImage", "getCurrentRuleset", "getUniqueLink", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "initNamesCategoryMap", "ruleSet", "core"})
    @SourceDebugExtension(value={"SMAP\nFormattedLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattedLine.kt\ncom/unciv/ui/screens/civilopediascreen/FormattedLine$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,468:1\n1360#2:469\n1446#2,5:470\n1295#3,2:475\n*S KotlinDebug\n*F\n+ 1 FormattedLine.kt\ncom/unciv/ui/screens/civilopediascreen/FormattedLine$Companion\n*L\n198#1:469\n198#1:470,5\n230#1:475,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Integer[] getHeaderSizes() {
            return headerSizes;
        }

        @NotNull
        public final Color getDefaultColor() {
            return defaultColor;
        }

        /*
         * WARNING - void declaration
         */
        private final String getUniqueLink(Unique unique) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Ruleset ruleSet = this.getCurrentRuleset();
            if (allObjectNamesCategoryMap == null || rulesetCachedInNameMap != ruleSet) {
                allObjectNamesCategoryMap = this.initNamesCategoryMap(ruleSet);
            }
            Iterable iterable = unique.getConditionals();
            Collection collection = unique.getParams();
            boolean $i$f$flatMap = false;
            void var6_7 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Unique it = (Unique)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getParams();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            for (String parameter : CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv))) {
                HashMap hashMap = allObjectNamesCategoryMap;
                Intrinsics.checkNotNull(hashMap);
                CivilopediaCategories civilopediaCategories = (CivilopediaCategories)((Object)hashMap.get(parameter));
                if (civilopediaCategories == null) continue;
                CivilopediaCategories category = civilopediaCategories;
                return category.name() + '/' + parameter;
            }
            return "";
        }

        private final Ruleset getCurrentRuleset() {
            Ruleset ruleset2;
            if (!UncivGame.Companion.isCurrentInitialized()) {
                ruleset2 = new Ruleset();
            } else if (UncivGame.Companion.getCurrent().getGameInfo() == null) {
                Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_Vanilla.getFullName());
                Intrinsics.checkNotNull(object);
                ruleset2 = (Ruleset)object;
            } else {
                GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
                Intrinsics.checkNotNull(gameInfo2);
                ruleset2 = gameInfo2.getRuleset();
            }
            return ruleset2;
        }

        /*
         * WARNING - void declaration
         */
        private final HashMap<String, CivilopediaCategories> initNamesCategoryMap(Ruleset ruleSet) {
            void $this$forEach$iv;
            Sequence allObjectMapsSequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends CivilopediaCategories, ? extends Map>>, Continuation<? super Unit>, Object>(ruleSet, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Ruleset $ruleSet;
                {
                    this.$ruleSet = $ruleSet;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Belief, this.$ruleSet.getBeliefs()), this);
                            if (v0 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Difficulty, this.$ruleSet.getDifficulties()), this);
                            if (v1 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl26
                        }
                        case 2: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl26:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 3;
                            v2 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Promotion, this.$ruleSet.getUnitPromotions()), this);
                            if (v2 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl36
                        }
                        case 3: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl36:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 4;
                            v3 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Policy, this.$ruleSet.getPolicies()), this);
                            if (v3 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl46
                        }
                        case 4: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl46:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 5;
                            v4 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Terrain, this.$ruleSet.getTerrains()), this);
                            if (v4 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl56
                        }
                        case 5: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl56:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 6;
                            v5 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Improvement, this.$ruleSet.getTileImprovements()), this);
                            if (v5 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl66
                        }
                        case 6: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
lbl66:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 7;
                            v6 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Resource, this.$ruleSet.getTileResources()), this);
                            if (v6 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl76
                        }
                        case 7: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v6 = $result;
lbl76:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 8;
                            v7 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Nation, this.$ruleSet.getNations()), this);
                            if (v7 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl86
                        }
                        case 8: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v7 = $result;
lbl86:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 9;
                            v8 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.UnitType, this.$ruleSet.getUnitTypes()), this);
                            if (v8 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl96
                        }
                        case 9: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v8 = $result;
lbl96:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 10;
                            v9 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Unit, this.$ruleSet.getUnits()), this);
                            if (v9 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl106
                        }
                        case 10: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v9 = $result;
lbl106:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.label = 11;
                            v10 = $this$sequence.yield(TuplesKt.to(CivilopediaCategories.Technology, this.$ruleSet.getTechnologies()), this);
                            if (v10 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl116
                        }
                        case 11: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v10 = $result;
lbl116:
                            // 2 sources

                            var3_4 = this.$ruleSet.getBuildings();
                            var13_5 = CivilopediaCategories.Building;
                            var12_6 = $this$sequence;
                            $i$f$filter = false;
                            var5_8 = $this$filter$iv;
                            destination$iv$iv = new LinkedHashMap<K, V>();
                            $i$f$filterTo = false;
                            var8_11 = $this$filterTo$iv$iv.entrySet().iterator();
                            while (var8_11.hasNext()) {
                                it = element$iv$iv = var8_11.next();
                                $i$a$-filter-FormattedLine$Companion$initNamesCategoryMap$allObjectMapsSequence$1$1 = false;
                                if (!(((Building)it.getValue()).isAnyWonder() == false)) continue;
                                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                            }
                            var14_15 = destination$iv$iv;
                            this.L$0 = $this$sequence;
                            this.label = 12;
                            v11 = var12_6.yield(TuplesKt.to(var13_5, var14_15), this);
                            if (v11 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl142
                        }
                        case 12: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v11 = $result;
lbl142:
                            // 2 sources

                            $this$filter$iv = this.$ruleSet.getBuildings();
                            var13_5 = CivilopediaCategories.Wonder;
                            var12_6 = $this$sequence;
                            $i$f$filter = false;
                            $this$filterTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new LinkedHashMap<K, V>();
                            $i$f$filterTo = false;
                            var8_11 = $this$filterTo$iv$iv.entrySet().iterator();
                            while (var8_11.hasNext()) {
                                it = element$iv$iv = var8_11.next();
                                $i$a$-filter-FormattedLine$Companion$initNamesCategoryMap$allObjectMapsSequence$1$2 = false;
                                if (!((Building)it.getValue()).isAnyWonder()) continue;
                                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                            }
                            var14_15 = destination$iv$iv;
                            this.L$0 = null;
                            this.label = 13;
                            v12 = var12_6.yield(TuplesKt.to(var13_5, var14_15), this);
                            if (v12 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl167
                        }
                        case 13: {
                            ResultKt.throwOnFailure($result);
                            v12 = $result;
lbl167:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super Pair<? extends CivilopediaCategories, ? extends Map>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Pair<? extends CivilopediaCategories, ? extends Map>> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
            HashMap<String, CivilopediaCategories> result2 = new HashMap<String, CivilopediaCategories>();
            Sequence sequence = SequencesKt.flatMap(allObjectMapsSequence2, initNamesCategoryMap.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                ((Map)result2).put(it.getSecond(), it.getFirst());
            }
            ((Map)result2).put("Maya Long Count calendar cycle", CivilopediaCategories.Tutorial);
            rulesetCachedInNameMap = ruleSet;
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$IconDisplay;", "", "(Ljava/lang/String;I)V", "All", "NoLink", "None", "core"})
    public static final class IconDisplay
    extends Enum<IconDisplay> {
        public static final /* enum */ IconDisplay All = new IconDisplay();
        public static final /* enum */ IconDisplay NoLink = new IconDisplay();
        public static final /* enum */ IconDisplay None = new IconDisplay();
        private static final /* synthetic */ IconDisplay[] $VALUES;

        public static IconDisplay[] values() {
            return (IconDisplay[])$VALUES.clone();
        }

        public static IconDisplay valueOf(String value) {
            return Enum.valueOf(IconDisplay.class, value);
        }

        static {
            $VALUES = iconDisplayArray = new IconDisplay[]{IconDisplay.All, IconDisplay.NoLink, IconDisplay.None};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$IntRectangle;", "", "x", "", "y", "width", "height", "(IIII)V", "getHeight", "()I", "setHeight", "(I)V", "getWidth", "setWidth", "getX", "setX", "getY", "setY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "grow", "", "h", "v", "hashCode", "intersection", "r", "toString", "", "core"})
    private static final class IntRectangle {
        private int x;
        private int y;
        private int width;
        private int height;

        public IntRectangle(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        public final void grow(int h, int v) {
            this.x -= h;
            this.width += h + h;
            this.y -= v;
            this.height += this.y + this.y;
        }

        @NotNull
        public final IntRectangle intersection(@NotNull IntRectangle r) {
            Intrinsics.checkNotNullParameter(r, "r");
            int tx1 = RangesKt.coerceAtLeast(this.x, r.x);
            int ty1 = RangesKt.coerceAtLeast(this.y, r.y);
            int tx2 = RangesKt.coerceAtMost(this.x + this.width, r.x + r.width);
            int ty2 = RangesKt.coerceAtMost(this.y + this.height, r.y + r.height);
            return new IntRectangle(tx1, ty1, tx2 - tx1, ty2 - ty1);
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.width;
        }

        public final int component4() {
            return this.height;
        }

        @NotNull
        public final IntRectangle copy(int x, int y, int width, int height) {
            return new IntRectangle(x, y, width, height);
        }

        public static /* synthetic */ IntRectangle copy$default(IntRectangle intRectangle, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = intRectangle.x;
            }
            if ((n5 & 2) != 0) {
                n2 = intRectangle.y;
            }
            if ((n5 & 4) != 0) {
                n3 = intRectangle.width;
            }
            if ((n5 & 8) != 0) {
                n4 = intRectangle.height;
            }
            return intRectangle.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "IntRectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.y);
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntRectangle)) {
                return false;
            }
            IntRectangle intRectangle = (IntRectangle)other;
            if (this.x != intRectangle.x) {
                return false;
            }
            if (this.y != intRectangle.y) {
                return false;
            }
            if (this.width != intRectangle.width) {
                return false;
            }
            return this.height == intRectangle.height;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/FormattedLine$LinkType;", "", "(Ljava/lang/String;I)V", "None", "Internal", "External", "core"})
    public static final class LinkType
    extends Enum<LinkType> {
        public static final /* enum */ LinkType None = new LinkType();
        public static final /* enum */ LinkType Internal = new LinkType();
        public static final /* enum */ LinkType External = new LinkType();
        private static final /* synthetic */ LinkType[] $VALUES;

        public static LinkType[] values() {
            return (LinkType[])$VALUES.clone();
        }

        public static LinkType valueOf(String value) {
            return Enum.valueOf(LinkType.class, value);
        }

        static {
            $VALUES = linkTypeArray = new LinkType[]{LinkType.None, LinkType.Internal, LinkType.External};
        }
    }
}

