/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.devconsole;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityExpansionManager;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.ui.screens.devconsole.CliInput;
import com.unciv.ui.screens.devconsole.ConsoleAction;
import com.unciv.ui.screens.devconsole.ConsoleCommand;
import com.unciv.ui.screens.devconsole.ConsoleCommandNode;
import com.unciv.ui.screens.devconsole.ConsoleErrorException;
import com.unciv.ui.screens.devconsole.ConsoleHintException;
import com.unciv.ui.screens.devconsole.ConsoleTileCommands;
import com.unciv.ui.screens.devconsole.ConsoleTileCommands$getTerrainFeature$;
import com.unciv.ui.screens.devconsole.ConsoleTileCommands$subcommands$7$invoke$;
import com.unciv.ui.screens.devconsole.DevConsolePopup;
import com.unciv.ui.screens.devconsole.DevConsoleResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0014H\u0002R0\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTileCommands;", "Lcom/unciv/ui/screens/devconsole/ConsoleCommandNode;", "()V", "subcommands", "Ljava/util/HashMap;", "", "Lcom/unciv/ui/screens/devconsole/ConsoleCommand;", "Lkotlin/collections/HashMap;", "getSubcommands", "()Ljava/util/HashMap;", "getOwnerCity", "Lcom/unciv/logic/city/City;", "console", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "params", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "getTerrainFeature", "Lcom/unciv/models/ruleset/tile/Terrain;", "param", "setBaseTerrain", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "tile", "terrain", "", "terrainName", "setNaturalWonder", "wonder", "ConsoleRiverAction", "core"})
@SourceDebugExtension(value={"SMAP\nConsoleTileCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTileCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleTileCommands\n+ 2 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n179#2:190\n170#2,2:191\n1360#3:193\n1446#3,5:194\n2333#3,14:199\n*S KotlinDebug\n*F\n+ 1 ConsoleTileCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleTileCommands\n*L\n154#1:190\n154#1:191,2\n181#1:193\n181#1:194,5\n186#1:199,14\n*E\n"})
public final class ConsoleTileCommands
implements ConsoleCommandNode {
    @NotNull
    private final HashMap<String, ConsoleCommand> subcommands;

    public ConsoleTileCommands() {
        Pair[] pairArray = new Pair[]{TuplesKt.to("checkfilter", new ConsoleAction("tile checkfilter <tileFilter>", subcommands.1.INSTANCE)), TuplesKt.to("setimprovement", new ConsoleAction("tile setimprovement <improvementName> [civName]", subcommands.2.INSTANCE)), TuplesKt.to("removeimprovement", new ConsoleAction("tile removeimprovement", subcommands.3.INSTANCE)), TuplesKt.to("removeroad", new ConsoleAction("tile removeroad", subcommands.4.INSTANCE)), TuplesKt.to("addfeature", new ConsoleAction("tile addfeature <featureName>", (Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse>)new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(this){
            final /* synthetic */ ConsoleTileCommands this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                block2: {
                    Intrinsics.checkNotNullParameter(console, "console");
                    Intrinsics.checkNotNullParameter(params, "params");
                    Tile selectedTile = console.getSelectedTile$core();
                    Terrain feature = ConsoleTileCommands.access$getTerrainFeature(this.this$0, console, params.get(0));
                    if (Intrinsics.areEqual(feature.getName(), "River")) {
                        RiverGenerator.Companion.continueRiverOn(selectedTile);
                    } else {
                        selectedTile.addTerrainFeature(feature.getName());
                    }
                    City city2 = selectedTile.getCity();
                    if (city2 == null) break block2;
                    City.reassignPopulation$default(city2, false, 1, null);
                }
                return DevConsoleResponse.Companion.getOK();
            }
        })), TuplesKt.to("removefeature", new ConsoleAction("tile removefeature <featureName>", (Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse>)new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(this){
            final /* synthetic */ ConsoleTileCommands this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                block1: {
                    Intrinsics.checkNotNullParameter(console, "console");
                    Intrinsics.checkNotNullParameter(params, "params");
                    Tile selectedTile = console.getSelectedTile$core();
                    Terrain feature = ConsoleTileCommands.access$getTerrainFeature(this.this$0, console, params.get(0));
                    if (Intrinsics.areEqual(feature.getName(), "River")) {
                        throw new ConsoleHintException("Rivers cannot be removed like a terrain feature - use tile removeriver <direction>");
                    }
                    selectedTile.removeTerrainFeature(feature.getName());
                    City city2 = selectedTile.getCity();
                    if (city2 == null) break block1;
                    City.reassignPopulation$default(city2, false, 1, null);
                }
                return DevConsoleResponse.Companion.getOK();
            }
        })), TuplesKt.to("setterrain", new ConsoleAction("tile setterrain <terrainName>", (Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse>)new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(this){
            final /* synthetic */ ConsoleTileCommands this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(console, "console");
                Intrinsics.checkNotNullParameter(params, "params");
                Tile selectedTile = console.getSelectedTile$core();
                CliInput cliInput = params.get(0);
                Collection<Terrain> collection = console.getGameInfo$core().getRuleset().getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(collection, "console.gameInfo.ruleset.terrains.values");
                Iterable options$iv = collection;
                boolean $i$f$find = false;
                T t = this_$iv.findOrNull(options$iv);
                if (t == null) {
                    throw new ConsoleErrorException("" + '\'' + this_$iv + "' is not a valid " + Terrain.class.getSimpleName() + ". Options are: " + CliInput.Companion.access$joinToStringLimited$default(CliInput.Companion, options$iv, null, null, null, 0, subcommands$7$invoke$$inlined$find$1.INSTANCE, 15, null) + '.');
                }
                Intrinsics.checkNotNullExpressionValue(t, "params[0].find(console.g\u2026.ruleset.terrains.values)");
                Terrain terrain2 = (Terrain)t;
                return terrain2.getType() == TerrainType.NaturalWonder ? ConsoleTileCommands.access$setNaturalWonder(this.this$0, selectedTile, terrain2) : ConsoleTileCommands.access$setBaseTerrain(this.this$0, selectedTile, terrain2);
            }
        })), TuplesKt.to("setresource", new ConsoleAction("tile setresource <resourceName>", subcommands.8.INSTANCE)), TuplesKt.to("removeresource", new ConsoleAction("tile removeresource", subcommands.9.INSTANCE)), TuplesKt.to("addriver", new ConsoleRiverAction("tile addriver <direction>", true)), TuplesKt.to("removeriver", new ConsoleRiverAction("tile removeriver <direction>", false)), TuplesKt.to("setowner", new ConsoleAction("tile setowner [civName|cityName]", (Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse>)new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(this){
            final /* synthetic */ ConsoleTileCommands this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                block1: {
                    IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
                    Intrinsics.checkNotNullParameter(console, "console");
                    Intrinsics.checkNotNullParameter(params, "params");
                    Tile selectedTile = console.getSelectedTile$core();
                    City oldOwner = selectedTile.getCity();
                    City newOwner = ConsoleTileCommands.access$getOwnerCity(this.this$0, console, params, selectedTile);
                    IsPartOfGameInfoSerialization isPartOfGameInfoSerialization2 = oldOwner;
                    if (isPartOfGameInfoSerialization2 != null && (isPartOfGameInfoSerialization2 = ((City)isPartOfGameInfoSerialization2).getExpansion()) != null) {
                        ((CityExpansionManager)isPartOfGameInfoSerialization2).relinquishOwnership(selectedTile);
                    }
                    if ((isPartOfGameInfoSerialization = newOwner) == null || (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getExpansion()) == null) break block1;
                    ((CityExpansionManager)isPartOfGameInfoSerialization).takeOwnership(selectedTile);
                }
                return DevConsoleResponse.Companion.getOK();
            }
        })), TuplesKt.to("find", new ConsoleAction("tile find <tileFilter>", subcommands.11.INSTANCE))};
        this.subcommands = MapsKt.hashMapOf(pairArray);
    }

    @Override
    @NotNull
    public HashMap<String, ConsoleCommand> getSubcommands() {
        return this.subcommands;
    }

    private final DevConsoleResponse setBaseTerrain(Tile tile, Terrain terrain2) {
        if (terrain2.getType() != tile.getBaseTerrain().getType()) {
            throw new ConsoleErrorException("Changing terrain type is not allowed");
        }
        this.setBaseTerrain(tile, terrain2.getName());
        return DevConsoleResponse.Companion.getOK();
    }

    private final void setBaseTerrain(Tile tile, String terrainName) {
        block0: {
            tile.setBaseTerrain(terrainName);
            tile.setTerrainTransients();
            City city2 = tile.getCity();
            if (city2 == null) break block0;
            City.reassignPopulation$default(city2, false, 1, null);
        }
    }

    private final DevConsoleResponse setNaturalWonder(Tile tile, Terrain wonder) {
        tile.removeTerrainFeatures();
        tile.setNaturalWonder(wonder.getName());
        String string = wonder.getTurnsInto();
        if (string == null) {
            string = tile.getBaseTerrain();
        }
        this.setBaseTerrain(tile, string);
        for (Civilization civ : tile.getTileMap().getGameInfo().getCivilizations()) {
            if (civ.getNaturalWonders().contains(wonder.getName()) || civ.isDefeated() || civ.isBarbarian() || civ.isSpectator() || !civ.hasExplored(tile)) continue;
            civ.getCache().discoverNaturalWonders();
            civ.updateStatsForNextTurn();
        }
        return DevConsoleResponse.Companion.getOK();
    }

    /*
     * WARNING - void declaration
     */
    private final Terrain getTerrainFeature(DevConsolePopup console, CliInput param) {
        void this_$iv$iv;
        void options$iv;
        void this_$iv;
        CliInput cliInput = param;
        Collection<Terrain> collection = console.getGameInfo$core().getRuleset().getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "console.gameInfo.ruleset.terrains.values");
        Sequence sequence = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), getTerrainFeature.1.INSTANCE);
        boolean $i$f$find = false;
        void var7_6 = this_$iv;
        Iterable options$iv$iv = SequencesKt.asIterable(options$iv);
        boolean $i$f$find2 = false;
        Object t = this_$iv$iv.findOrNull(options$iv$iv);
        if (t == null) {
            throw new ConsoleErrorException("" + '\'' + this_$iv$iv + "' is not a valid " + Terrain.class.getSimpleName() + ". Options are: " + CliInput.Companion.access$joinToStringLimited$default(CliInput.Companion, options$iv$iv, null, null, null, 0, getTerrainFeature$$inlined$find$1.INSTANCE, 15, null) + '.');
        }
        Object t2 = t;
        Intrinsics.checkNotNullExpressionValue(t2, "param.find(\n        cons\u2026pe.TerrainFeature }\n    )");
        return (Terrain)t2;
    }

    /*
     * WARNING - void declaration
     */
    private final City getOwnerCity(DevConsolePopup console, List<CliInput> params, Tile selectedTile) {
        Object v3;
        City namedCity;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        CliInput cliInput = CollectionsKt.getOrNull(params, 0);
        if (cliInput == null) {
            return null;
        }
        CliInput param = cliInput;
        if (param.isEmpty()) {
            return null;
        }
        Iterable iterable = console.getGameInfo$core().getCivilizations();
        CliInput cliInput2 = param;
        boolean $i$f$flatMap = false;
        void var8_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Civilization civ = (Civilization)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = civ.getCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        City city2 = namedCity = (City)cliInput2.findOrNull((List)destination$iv$iv);
        if (city2 != null) {
            return city2;
        }
        Civilization civilization = console.getCivByNameOrNull$core(param);
        if (civilization == null) {
            throw new ConsoleErrorException(param + " is neither a city nor a civilization");
        }
        Civilization namedCiv = civilization;
        Iterable $this$minByOrNull$iv = namedCiv.getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(selectedTile) + (it.isBeingRazed() ? 5 : 0);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-ConsoleTileCommands$getOwnerCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(selectedTile) + (it2.isBeingRazed() ? 5 : 0);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        return v3;
    }

    @Override
    @NotNull
    public DevConsoleResponse handle(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        return ConsoleCommandNode.DefaultImpls.handle(this, console, params);
    }

    @Override
    @Nullable
    public String autocomplete(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
        return ConsoleCommandNode.DefaultImpls.autocomplete(this, console, params);
    }

    public static final /* synthetic */ Terrain access$getTerrainFeature(ConsoleTileCommands $this, DevConsolePopup console, CliInput param) {
        return $this.getTerrainFeature(console, param);
    }

    public static final /* synthetic */ DevConsoleResponse access$setNaturalWonder(ConsoleTileCommands $this, Tile tile, Terrain wonder) {
        return $this.setNaturalWonder(tile, wonder);
    }

    public static final /* synthetic */ DevConsoleResponse access$setBaseTerrain(ConsoleTileCommands $this, Tile tile, Terrain terrain2) {
        return $this.setBaseTerrain(tile, terrain2);
    }

    public static final /* synthetic */ City access$getOwnerCity(ConsoleTileCommands $this, DevConsolePopup console, List params, Tile selectedTile) {
        return $this.getOwnerCity(console, params, selectedTile);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTileCommands$ConsoleRiverAction;", "Lcom/unciv/ui/screens/devconsole/ConsoleAction;", "format", "", "newValue", "", "(Ljava/lang/String;Z)V", "Companion", "core"})
    private static final class ConsoleRiverAction
    extends ConsoleAction {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public ConsoleRiverAction(@NotNull String format, final boolean newValue) {
            Intrinsics.checkNotNullParameter(format, "format");
            super(format, (Function2<? super DevConsolePopup, ? super List<CliInput>, DevConsoleResponse>)new Function2<DevConsolePopup, List<? extends CliInput>, DevConsoleResponse>(){

                @Override
                @NotNull
                public final DevConsoleResponse invoke(@NotNull DevConsolePopup console, @NotNull List<CliInput> params) {
                    Intrinsics.checkNotNullParameter(console, "console");
                    Intrinsics.checkNotNullParameter(params, "params");
                    return Companion.action(console, params, newValue);
                }
            });
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/devconsole/ConsoleTileCommands$ConsoleRiverAction$Companion;", "", "()V", "action", "Lcom/unciv/ui/screens/devconsole/DevConsoleResponse;", "console", "Lcom/unciv/ui/screens/devconsole/DevConsolePopup;", "params", "", "Lcom/unciv/ui/screens/devconsole/CliInput;", "newValue", "", "core"})
        @SourceDebugExtension(value={"SMAP\nConsoleTileCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleTileCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleTileCommands$ConsoleRiverAction$Companion\n+ 2 CliInput.kt\ncom/unciv/ui/screens/devconsole/CliInput\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,189:1\n151#2:190\n147#2:191\n152#2:194\n1282#3,2:192\n*S KotlinDebug\n*F\n+ 1 ConsoleTileCommands.kt\ncom/unciv/ui/screens/devconsole/ConsoleTileCommands$ConsoleRiverAction$Companion\n*L\n166#1:190\n166#1:191\n166#1:194\n166#1:192,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final DevConsoleResponse action(DevConsolePopup console, List<CliInput> params, boolean newValue) {
                Object v0;
                CliInput this_$iv;
                Tile selectedTile;
                block4: {
                    void $this$firstOrNull$iv$iv$iv;
                    selectedTile = console.getSelectedTile$core();
                    this_$iv = params.get(0);
                    boolean $i$f$enumValue = false;
                    CliInput this_$iv$iv = this_$iv;
                    boolean $i$f$enumValueOrNull = false;
                    RiverGenerator.RiverDirections[] riverDirectionsArray = RiverGenerator.RiverDirections.values();
                    boolean $i$f$firstOrNull = false;
                    for (void element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        Enum it$iv$iv = (Enum)element$iv$iv$iv;
                        boolean bl = false;
                        if (!this_$iv$iv.equals(it$iv$iv.name())) continue;
                        v0 = element$iv$iv$iv;
                        break block4;
                    }
                    v0 = null;
                }
                Enum enum_ = v0;
                if (enum_ == null) {
                    throw new ConsoleErrorException("" + '\'' + this_$iv + "' is not a valid " + RiverGenerator.RiverDirections.class.getSimpleName() + ". Options are: " + RiverGenerator.RiverDirections.values() + '.');
                }
                RiverGenerator.RiverDirections direction = (RiverGenerator.RiverDirections)enum_;
                Tile tile = direction.getNeighborTile(selectedTile);
                if (tile == null) {
                    throw new ConsoleErrorException("tile has no neighbor to the " + direction.name());
                }
                Tile otherTile = tile;
                if (!otherTile.isLand()) {
                    throw new ConsoleErrorException("there's no land to the " + direction.name());
                }
                Tile.setConnectedByRiver$default(selectedTile, otherTile, newValue, false, 4, null);
                return DevConsoleResponse.Companion.getOK();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

