/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeType;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.CityStateDiplomacyTable;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006 "}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable;", "", "diplomacyScreen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getCityStateDiplomacyTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "otherCiv", "getCityStateDiplomacyTableHeader", "getDemandTributeTable", "getDiplomaticMarriageButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getGoldGiftTable", "getImprovableResourceTiles", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/map/tile/Tile;", "getImproveTilesButton", "otherCivDiplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "getImprovementGiftTable", "getNegotiatePeaceCityStateButton", "getPledgeToProtectButton", "getQuestTable", "assignedQuest", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "getRevokeProtectionButton", "getWarWithMajorTable", "target", "core"})
@SourceDebugExtension(value={"SMAP\nCityStateDiplomacyTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStateDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,495:1\n1747#2,3:496\n1229#3,2:499\n515#4:501\n500#4,6:502\n1#5:508\n*S KotlinDebug\n*F\n+ 1 CityStateDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/CityStateDiplomacyTable\n*L\n108#1:496,3\n270#1:499,2\n289#1:501\n289#1:502,6\n*E\n"})
public final class CityStateDiplomacyTable {
    @NotNull
    private final DiplomacyScreen diplomacyScreen;
    @NotNull
    private final Civilization viewingCiv;

    public CityStateDiplomacyTable(@NotNull DiplomacyScreen diplomacyScreen) {
        Intrinsics.checkNotNullParameter(diplomacyScreen, "diplomacyScreen");
        this.diplomacyScreen = diplomacyScreen;
        this.viewingCiv = this.diplomacyScreen.getViewingCiv$core();
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getCityStateDiplomacyTable(@NotNull Civilization otherCiv) {
        TextButton diplomaticMarriageButton;
        TextButton improveTileButton;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        TextButton giveGiftButton = Scene2dExtensionsKt.toTextButton$default("Give a Gift", null, false, 3, null);
        ActivationExtensionsKt.onClick(giveGiftButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)CityStateDiplomacyTable.access$getGoldGiftTable(this.this$0, this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)giveGiftButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core() || this.viewingCiv.isAtWarWith(otherCiv)) {
            Scene2dExtensionsKt.disable(giveGiftButton);
        }
        if ((improveTileButton = this.getImproveTilesButton(otherCiv, otherCivDiplomacyManager)) != null) {
            diplomacyTable.add((Actor)improveTileButton).row();
        }
        if (otherCivDiplomacyManager.getDiplomaticStatus() != DiplomaticStatus.Protector) {
            diplomacyTable.add((Actor)this.getPledgeToProtectButton(otherCiv)).row();
        } else {
            diplomacyTable.add((Actor)this.getRevokeProtectionButton(otherCiv)).row();
        }
        TextButton demandTributeButton = Scene2dExtensionsKt.toTextButton$default("Demand Tribute", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandTributeButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)CityStateDiplomacyTable.access$getDemandTributeTable(this.this$0, this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)demandTributeButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core() || this.viewingCiv.isAtWarWith(otherCiv)) {
            Scene2dExtensionsKt.disable(demandTributeButton);
        }
        DiplomacyManager diplomacyManager2 = this.viewingCiv.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager diplomacyManager3 = diplomacyManager2;
        if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this.viewingCiv.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null)) {
            if (this.viewingCiv.isAtWarWith(otherCiv)) {
                diplomacyTable.add((Actor)this.getNegotiatePeaceCityStateButton(otherCiv, diplomacyManager3)).row();
            } else {
                diplomacyTable.add((Actor)this.diplomacyScreen.getDeclareWarButton$core(diplomacyManager3, otherCiv)).row();
            }
        }
        if (Civilization.getCapital$default(otherCiv, false, 1, null) != null) {
            City city2 = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city2);
            if (this.viewingCiv.hasExplored(city2.getCenterTile())) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getGoToOnMapButton$core(otherCiv)).row();
            }
        }
        if ((diplomaticMarriageButton = this.getDiplomaticMarriageButton(otherCiv)) != null) {
            diplomacyTable.add((Actor)diplomaticMarriageButton).row();
        }
        Iterator<IsPartOfGameInfoSerialization> iterator2 = otherCiv.getQuestManager().getAssignedQuestsFor(this.viewingCiv.getCivName()).iterator();
        while (iterator2.hasNext()) {
            AssignedQuest assignedQuest = iterator2.next();
            Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
            diplomacyTable.add((Actor)this.getQuestTable(assignedQuest)).row();
        }
        iterator2 = SequencesKt.filter(otherCiv.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(otherCiv, this){
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ CityStateDiplomacyTable this$0;
            {
                this.$otherCiv = $otherCiv;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$otherCiv.getQuestManager().warWithMajorActive(it) && !Intrinsics.areEqual(this.this$0.getViewingCiv(), it);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization target = (Civilization)iterator2.next();
            Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
            diplomacyTable.add((Actor)this.getWarWithMajorTable(target, otherCiv)).row();
        }
        return diplomacyTable;
    }

    private final Table getCityStateDiplomacyTableHeader(Civilization otherCiv) {
        int turnsToRelationshipChange;
        List<Civilization> protectors;
        boolean bl;
        Table diplomacyTable;
        DiplomacyManager otherCivDiplomacyManager;
        block13: {
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            otherCivDiplomacyManager = diplomacyManager;
            diplomacyTable = new Table();
            diplomacyTable.defaults().pad(2.5f);
            diplomacyTable.add((Actor)new LeaderIntroTable(otherCiv, null, 2, null)).padBottom(15.0f).row();
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("{Type}:  {" + otherCiv.getCityStateType().getName() + '}')).row();
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("{Personality}:  {" + (Object)((Object)otherCiv.getCityStatePersonality()) + '}')).row();
            Iterable $this$any$iv = otherCiv.getDetailedCivResources();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv;
                    boolean bl2 = false;
                    if (!(it.getResource().getResourceType() != ResourceType.Bonus)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            Table resourcesTable = new Table();
            resourcesTable.add((Actor)Scene2dExtensionsKt.toLabel("{Resources}:  ")).padRight(10.0f);
            ResourceSupplyList cityStateResources = otherCiv.getCityStateFunctions().getCityStateResourcesForAlly();
            for (Object supplyList : cityStateResources) {
                if (((ResourceSupplyList.ResourceSupply)supplyList).getResource().getResourceType() == ResourceType.Bonus) continue;
                String name2 = ((ResourceSupplyList.ResourceSupply)supplyList).getResource().getName();
                Table wrapper = new Table();
                Group image2 = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, name2, 30.0f, 0, 4, null);
                wrapper.add((Actor)image2).padRight(5.0f);
                wrapper.add((Actor)Scene2dExtensionsKt.toLabel(((ResourceSupplyList.ResourceSupply)supplyList).getAmount()));
                resourcesTable.add((Actor)wrapper).padRight(20.0f);
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, wrapper, name2, 18.0f, false, 0, 0, false, null, 124, null);
                ActivationExtensionsKt.onClick(wrapper, new Function0<Unit>(this, (ResourceSupplyList.ResourceSupply)supplyList){
                    final /* synthetic */ CityStateDiplomacyTable this$0;
                    final /* synthetic */ ResourceSupplyList.ResourceSupply $supplyList;
                    {
                        this.this$0 = $receiver;
                        this.$supplyList = $supplyList;
                        super(0);
                    }

                    public final void invoke() {
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).openCivilopedia(this.$supplyList.getResource().makeLink());
                    }
                });
            }
            diplomacyTable.add((Actor)resourcesTable).row();
        }
        diplomacyTable.row().padTop(15.0f);
        otherCiv.getCityStateFunctions().updateAllyCivForCityState();
        String ally = otherCiv.getAllyCiv();
        if (ally != null) {
            DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(ally);
            Intrinsics.checkNotNull(diplomacyManager);
            int allyInfluence = (int)diplomacyManager.getInfluence();
            if (!this.viewingCiv.knows(ally) && !Intrinsics.areEqual(ally, this.viewingCiv.getCivName())) {
                ally = "Unknown civilization";
            }
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Ally: [" + ally + "] with [" + allyInfluence + "] Influence")).row();
        }
        if (!((Collection)(protectors = otherCiv.getCityStateFunctions().getProtectorCivs())).isEmpty()) {
            ArrayList<String> newProtectors = new ArrayList<String>();
            for (Civilization protector : protectors) {
                if (!this.viewingCiv.knows(protector) && !Intrinsics.areEqual(protector.getCivName(), this.viewingCiv.getCivName())) {
                    newProtectors.add(TranslationsKt.tr$default("Unknown civilization", false, 1, null));
                    continue;
                }
                newProtectors.add(TranslationsKt.tr$default(protector.getCivName(), false, 1, null));
            }
            String protectorString = "{Protected by}: " + CollectionsKt.joinToString$default(newProtectors, ", ", null, null, 0, null, null, 62, null);
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(protectorString)).row();
        }
        boolean atWar = otherCiv.isAtWarWith(this.viewingCiv);
        String nextLevelString = atWar ? "" : ((int)otherCivDiplomacyManager.getInfluence() < 30 ? "Reach 30 for friendship." : (Intrinsics.areEqual(ally, this.viewingCiv.getCivName()) ? "" : "Reach highest influence above 60 for alliance."));
        diplomacyTable.add((Actor)this.diplomacyScreen.getRelationshipTable$core(otherCivDiplomacyManager)).row();
        if (((CharSequence)nextLevelString).length() > 0) {
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(nextLevelString)).row();
        }
        diplomacyTable.row().padTop(15.0f);
        RelationshipLevel relationLevel = otherCivDiplomacyManager.relationshipIgnoreAfraid();
        if (relationLevel.compareTo((Enum)RelationshipLevel.Friend) >= 0 && (turnsToRelationshipChange = otherCivDiplomacyManager.getTurnsToRelationshipChange()) != 0) {
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Relationship changes in another [" + turnsToRelationshipChange + "] turns")).row();
        }
        CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$addBonusLabel(diplomacyTable, this, otherCiv, "When Friends:", RelationshipLevel.Friend, relationLevel);
        CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$addBonusLabel(diplomacyTable, this, otherCiv, "When Allies:", RelationshipLevel.Ally, relationLevel);
        if (otherCiv.getCityStateUniqueUnit() != null) {
            String unitName = otherCiv.getCityStateUniqueUnit();
            Object v = ((Map)this.viewingCiv.getGameInfo().getRuleset().getUnits()).get(otherCiv.getCityStateUniqueUnit());
            Intrinsics.checkNotNull(v);
            Sequence<String> techNames = ((BaseUnit)v).requiredTechs();
            String techAndTech = SequencesKt.joinToString$default(techNames, " and ", null, null, 0, null, null, 62, null);
            String isOrAre = SequencesKt.count(techNames) == 1 ? "is" : "are";
            diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel$default('[' + otherCiv.getCivName() + "] is able to provide [" + unitName + "] once [" + techAndTech + "] [" + isOrAre + "] researched.", null, 18, 0, false, 13, null)).row();
        }
        return diplomacyTable;
    }

    private final TextButton getRevokeProtectionButton(Civilization otherCiv) {
        TextButton revokeProtectionButton = Scene2dExtensionsKt.toTextButton$default("Revoke Protection", null, false, 3, null);
        ActivationExtensionsKt.onClick(revokeProtectionButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                Popup.open$default(new ConfirmPopup(CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0), "Revoke protection for [" + this.$otherCiv.getCivName() + "]?", "Revoke Protection", false, null, (Function0)new Function0<Unit>(this.$otherCiv, this.this$0){
                    final /* synthetic */ Civilization $otherCiv;
                    final /* synthetic */ CityStateDiplomacyTable this$0;
                    {
                        this.$otherCiv = $otherCiv;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        CityStateFunctions.removeProtectorCiv$default(this.$otherCiv.getCityStateFunctions(), this.this$0.getViewingCiv(), false, 2, null);
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateLeftSideTable$core(this.$otherCiv);
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateRightSide$core(this.$otherCiv);
                    }
                }, 24, null), false, 1, null);
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().otherCivCanWithdrawProtection(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(revokeProtectionButton);
        }
        return revokeProtectionButton;
    }

    private final TextButton getPledgeToProtectButton(Civilization otherCiv) {
        TextButton protectionButton = Scene2dExtensionsKt.toTextButton$default("Pledge to protect", null, false, 3, null);
        ActivationExtensionsKt.onClick(protectionButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                Popup.open$default(new ConfirmPopup(CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0), "Declare Protection of [" + this.$otherCiv.getCivName() + "]?", "Pledge to protect", true, null, (Function0)new Function0<Unit>(this.$otherCiv, this.this$0){
                    final /* synthetic */ Civilization $otherCiv;
                    final /* synthetic */ CityStateDiplomacyTable this$0;
                    {
                        this.$otherCiv = $otherCiv;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        this.$otherCiv.getCityStateFunctions().addProtectorCiv(this.this$0.getViewingCiv());
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateLeftSideTable$core(this.$otherCiv);
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateRightSide$core(this.$otherCiv);
                    }
                }, 16, null), false, 1, null);
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().otherCivCanPledgeProtection(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(protectionButton);
        }
        return protectionButton;
    }

    /*
     * WARNING - void declaration
     */
    private final TextButton getNegotiatePeaceCityStateButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        boolean atWarWithItsAlly;
        TextButton peaceButton;
        block3: {
            boolean bl;
            void $this$any$iv;
            peaceButton = Scene2dExtensionsKt.toTextButton$default("Negotiate Peace", null, false, 3, null);
            ActivationExtensionsKt.onClick(peaceButton, new Function0<Unit>(this, otherCiv){
                final /* synthetic */ CityStateDiplomacyTable this$0;
                final /* synthetic */ Civilization $otherCiv;
                {
                    this.this$0 = $receiver;
                    this.$otherCiv = $otherCiv;
                    super(0);
                }

                public final void invoke() {
                    Popup.open$default(new ConfirmPopup(CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0), "Peace with [" + this.$otherCiv.getCivName() + "]?", "Negotiate Peace", true, null, (Function0)new Function0<Unit>(this.this$0, this.$otherCiv){
                        final /* synthetic */ CityStateDiplomacyTable this$0;
                        final /* synthetic */ Civilization $otherCiv;
                        {
                            this.this$0 = $receiver;
                            this.$otherCiv = $otherCiv;
                            super(0);
                        }

                        public final void invoke() {
                            TradeLogic tradeLogic = new TradeLogic(this.this$0.getViewingCiv(), this.$otherCiv);
                            tradeLogic.getCurrentTrade().getOurOffers().add(new TradeOffer("Peace Treaty", TradeType.Treaty, 0, null, 12, null));
                            tradeLogic.getCurrentTrade().getTheirOffers().add(new TradeOffer("Peace Treaty", TradeType.Treaty, 0, null, 12, null));
                            TradeLogic.acceptTrade$default(tradeLogic, false, 1, null);
                            CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateLeftSideTable$core(this.$otherCiv);
                            CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateRightSide$core(this.$otherCiv);
                        }
                    }, 16, null), false, 1, null);
                }
            });
            String cityStatesAlly = otherCiv.getAllyCiv();
            Sequence<Civilization> sequence = this.viewingCiv.getKnownCivs();
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Civilization it = (Civilization)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual(it.getCivName(), cityStatesAlly) && it.isAtWarWith(this.viewingCiv))) continue;
                bl = true;
                break block3;
            }
            bl = atWarWithItsAlly = false;
        }
        if (this.diplomacyScreen.isNotPlayersTurn$core() || atWarWithItsAlly) {
            Scene2dExtensionsKt.disable(peaceButton);
        }
        if (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclaredWar)) {
            Scene2dExtensionsKt.disable(peaceButton);
            int turnsLeft = otherCivDiplomacyManager.getFlag(DiplomacyFlags.DeclaredWar);
            peaceButton.setText("" + peaceButton.getText() + '\n' + turnsLeft + '\u23f3');
        }
        return peaceButton;
    }

    /*
     * WARNING - void declaration
     */
    private final TextButton getImproveTilesButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        void $this$filterTo$iv$iv;
        if (otherCiv.getCities().isEmpty()) {
            return null;
        }
        Sequence<Tile> improvableResourceTiles = this.getImprovableResourceTiles(otherCiv);
        Map $this$filter$iv = otherCiv.getGameInfo().getRuleset().getTileImprovements();
        boolean $i$f$filter22 = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((TileImprovement)it.getValue()).getTurnsToBuild() != -1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map improvements = destination$iv$iv;
        boolean needsImprovements = false;
        Iterator<Tile> $i$f$filter22 = improvableResourceTiles.iterator();
        while ($i$f$filter22.hasNext()) {
            Tile improvableTile = $i$f$filter22.next();
            for (TileImprovement tileImprovement : improvements.values()) {
                if (!improvableTile.getTileResource().isImprovedBy(tileImprovement.getName()) || !improvableTile.getImprovementFunctions().canBuildImprovement(tileImprovement, otherCiv)) continue;
                needsImprovements = true;
            }
        }
        if (!needsImprovements) {
            return null;
        }
        TextButton improveTileButton = Scene2dExtensionsKt.toTextButton$default("Gift Improvement", null, false, 3, null);
        ActivationExtensionsKt.onClick(improveTileButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)CityStateDiplomacyTable.access$getImprovementGiftTable(this.this$0, this.$otherCiv)));
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core() || otherCivDiplomacyManager.getInfluence() < 60.0f) {
            Scene2dExtensionsKt.disable(improveTileButton);
        }
        return improveTileButton;
    }

    private final TextButton getDiplomaticMarriageButton(Civilization otherCiv) {
        if (!Civilization.hasUnique$default(this.viewingCiv, UniqueType.CityStateCanBeBoughtForGold, null, 2, null)) {
            return null;
        }
        TextButton diplomaticMarriageButton = Scene2dExtensionsKt.toTextButton$default("Diplomatic Marriage ([" + otherCiv.getCityStateFunctions().getDiplomaticMarriageCost() + "] Gold)", null, false, 3, null);
        ActivationExtensionsKt.onClick(diplomaticMarriageButton, new Function0<Unit>(otherCiv, this){
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ CityStateDiplomacyTable this$0;
            {
                this.$otherCiv = $otherCiv;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                List<City> newCities = this.$otherCiv.getCities();
                this.$otherCiv.getCityStateFunctions().diplomaticMarriage(this.this$0.getViewingCiv());
                UncivGame.Companion.getCurrent().popScreen();
                for (City city2 : newCities) {
                    this.this$0.getViewingCiv().getPopupAlerts().add(new PopupAlert(AlertType.DiplomaticMarriage, city2.getId()));
                }
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core() || !otherCiv.getCityStateFunctions().canBeMarriedBy(this.viewingCiv)) {
            Scene2dExtensionsKt.disable(diplomaticMarriageButton);
        }
        return diplomaticMarriageButton;
    }

    private final Table getGoldGiftTable(Civilization otherCiv) {
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        Integer[] integerArray = new Integer[]{250, 500, 1000};
        Iterator<Integer> iterator2 = CollectionsKt.listOf(integerArray).iterator();
        while (iterator2.hasNext()) {
            int giftAmount = ((Number)iterator2.next()).intValue();
            int influenceAmount = otherCiv.getCityStateFunctions().influenceGainedByGift(this.viewingCiv, giftAmount);
            TextButton giftButton = Scene2dExtensionsKt.toTextButton$default("Gift [" + giftAmount + "] gold (+[" + influenceAmount + "] influence)", null, false, 3, null);
            ActivationExtensionsKt.onClick(giftButton, new Function0<Unit>(otherCiv, this, giftAmount){
                final /* synthetic */ Civilization $otherCiv;
                final /* synthetic */ CityStateDiplomacyTable this$0;
                final /* synthetic */ int $giftAmount;
                {
                    this.$otherCiv = $otherCiv;
                    this.this$0 = $receiver;
                    this.$giftAmount = $giftAmount;
                    super(0);
                }

                public final void invoke() {
                    this.$otherCiv.getCityStateFunctions().receiveGoldGift(this.this$0.getViewingCiv(), this.$giftAmount);
                    CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateLeftSideTable$core(this.$otherCiv);
                    CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateRightSide$core(this.$otherCiv);
                }
            });
            diplomacyTable.add((Actor)giftButton).row();
            if (this.viewingCiv.getGold() >= giftAmount && !this.diplomacyScreen.isNotPlayersTurn$core()) continue;
            Scene2dExtensionsKt.disable(giftButton);
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)backButton);
        return diplomacyTable;
    }

    private final Sequence<Tile> getImprovableResourceTiles(Civilization otherCiv) {
        City city2 = Civilization.getCapital$default(otherCiv, false, 1, null);
        Intrinsics.checkNotNull(city2);
        return SequencesKt.filter(city2.getTiles(), (Function1)new Function1<Tile, Boolean>(otherCiv){
            final /* synthetic */ Civilization $otherCiv;
            {
                this.$otherCiv = $otherCiv;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                boolean bl;
                block2: {
                    block3: {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (!it.hasViewableResource(this.$otherCiv) || it.getTileResource().getResourceType() == ResourceType.Bonus) break block2;
                        if (it.getImprovement() == null) break block3;
                        TileResource tileResource = it.getTileResource();
                        String string = it.getImprovement();
                        Intrinsics.checkNotNull(string);
                        if (tileResource.isImprovedBy(string)) break block2;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        });
    }

    private final Table getImprovementGiftTable(Civilization otherCiv) {
        Table improvementGiftTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(improvementGiftTable, null, 0, 0.0f, 7, null);
        Sequence<Tile> improvableResourceTiles = this.getImprovableResourceTiles(otherCiv);
        LinkedHashMap<String, TileImprovement> tileImprovements2 = otherCiv.getGameInfo().getRuleset().getTileImprovements();
        Iterator<Tile> iterator2 = improvableResourceTiles.iterator();
        while (iterator2.hasNext()) {
            Tile improvableTile = iterator2.next();
            for (TileImprovement tileImprovement : tileImprovements2.values()) {
                if (!improvableTile.getTileResource().isImprovedBy(tileImprovement.getName())) continue;
                TileImprovementFunctions tileImprovementFunctions = improvableTile.getImprovementFunctions();
                Intrinsics.checkNotNullExpressionValue(tileImprovement, "tileImprovement");
                if (!tileImprovementFunctions.canBuildImprovement(tileImprovement, otherCiv)) continue;
                TextButton improveTileButton = Scene2dExtensionsKt.toTextButton$default("Build [" + tileImprovement + "] on [" + improvableTile.getTileResource() + "] (200 Gold)", null, false, 3, null);
                ActivationExtensionsKt.onClick(improveTileButton, new Function0<Unit>(this, improvableTile, tileImprovement, otherCiv){
                    final /* synthetic */ CityStateDiplomacyTable this$0;
                    final /* synthetic */ Tile $improvableTile;
                    final /* synthetic */ TileImprovement $tileImprovement;
                    final /* synthetic */ Civilization $otherCiv;
                    {
                        this.this$0 = $receiver;
                        this.$improvableTile = $improvableTile;
                        this.$tileImprovement = $tileImprovement;
                        this.$otherCiv = $otherCiv;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getViewingCiv().addGold(-200);
                        this.$improvableTile.stopWorkingOnImprovement();
                        Tile.setImprovement$default(this.$improvableTile, this.$tileImprovement.getName(), null, null, 6, null);
                        this.$otherCiv.getCache().updateCivResources();
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                        CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
                    }
                });
                if (this.viewingCiv.getGold() < 200) {
                    Scene2dExtensionsKt.disable(improveTileButton);
                }
                improvementGiftTable.add((Actor)improveTileButton).row();
            }
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
            }
        });
        improvementGiftTable.add((Actor)backButton);
        return improvementGiftTable;
    }

    private final Table getDemandTributeTable(Civilization otherCiv) {
        Table diplomacyTable = this.getCityStateDiplomacyTableHeader(otherCiv);
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("Tribute Willingness")).row();
        Table modifierTable = new Table();
        HashMap tributeModifiers = CityStateFunctions.getTributeModifiers$default(otherCiv.getCityStateFunctions(), this.viewingCiv, false, true, 2, null);
        for (Map.Entry item : ((Map)tributeModifiers).entrySet()) {
            Color color = ((Number)item.getValue()).intValue() >= 0 ? Color.GREEN : Color.RED;
            String string = (String)item.getKey();
            Intrinsics.checkNotNullExpressionValue(color, "color");
            modifierTable.add((Actor)Scene2dExtensionsKt.toLabel$default(string, color, 0, 0, false, 14, null));
            modifierTable.add((Actor)Scene2dExtensionsKt.toLabel$default(String.valueOf(((Number)item.getValue()).intValue()), color, 0, 0, false, 14, null)).row();
        }
        modifierTable.add((Actor)Scene2dExtensionsKt.toLabel("Sum:"));
        Collection collection = tributeModifiers.values();
        Intrinsics.checkNotNullExpressionValue(collection, "tributeModifiers.values");
        modifierTable.add((Actor)Scene2dExtensionsKt.toLabel(CollectionsKt.sumOfInt(collection))).row();
        diplomacyTable.add((Actor)modifierTable).row();
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel("At least 0 to take gold, at least 30 and size 4 city for worker")).row();
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        TextButton demandGoldButton = Scene2dExtensionsKt.toTextButton$default("Take [" + otherCiv.getCityStateFunctions().goldGainedByTribute() + "] gold (-15 Influence)", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandGoldButton, new Function0<Unit>(otherCiv, this){
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ CityStateDiplomacyTable this$0;
            {
                this.$otherCiv = $otherCiv;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$otherCiv.getCityStateFunctions().tributeGold(this.this$0.getViewingCiv());
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)demandGoldButton).row();
        if (otherCiv.getCityStateFunctions().getTributeWillingness(this.viewingCiv, false) < 0) {
            Scene2dExtensionsKt.disable(demandGoldButton);
        }
        TextButton demandWorkerButton = Scene2dExtensionsKt.toTextButton$default("Take worker (-50 Influence)", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandWorkerButton, new Function0<Unit>(otherCiv, this){
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ CityStateDiplomacyTable this$0;
            {
                this.$otherCiv = $otherCiv;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$otherCiv.getCityStateFunctions().tributeWorker(this.this$0.getViewingCiv());
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)demandWorkerButton).row();
        if (otherCiv.getCityStateFunctions().getTributeWillingness(this.viewingCiv, true) < 0) {
            Scene2dExtensionsKt.disable(demandWorkerButton);
        }
        TextButton backButton = Scene2dExtensionsKt.toTextButton$default("Back", null, false, 3, null);
        ActivationExtensionsKt.onClick(backButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ CityStateDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                CityStateDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)new ScrollPane((Actor)this.this$0.getCityStateDiplomacyTable(this.$otherCiv)));
            }
        });
        diplomacyTable.add((Actor)backButton);
        return diplomacyTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getQuestTable(AssignedQuest assignedQuest) {
        String leaderString;
        void $this$getQuestTable_u24lambda_u244;
        Label label2;
        Table questTable = new Table();
        questTable.defaults().pad(10.0f);
        Quest quest2 = this.viewingCiv.getGameInfo().getRuleset().getQuests().get(assignedQuest.getQuestName());
        Intrinsics.checkNotNull(quest2);
        Quest quest3 = quest2;
        int remainingTurns = assignedQuest.getRemainingTurns();
        String title = quest3.getInfluence() > 0.0f ? '[' + quest3.getName() + "] (+[" + (int)quest3.getInfluence() + "] influence)" : quest3.getName();
        String description2 = assignedQuest.getDescription();
        questTable.add((Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).row();
        Label label3 = label2 = Scene2dExtensionsKt.toLabel(description2);
        Table table2 = questTable;
        boolean bl = false;
        $this$getQuestTable_u24lambda_u244.setWrap(true);
        $this$getQuestTable_u24lambda_u244.setAlignment(1);
        table2.add((Actor)label2).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        if (quest3.getDuration() > 0) {
            questTable.add((Actor)Scene2dExtensionsKt.toLabel("" + '[' + remainingTurns + "] turns remaining")).row();
        }
        if (quest3.isGlobal() && ((CharSequence)(leaderString = this.viewingCiv.getGameInfo().getCivilization(assignedQuest.getAssigner()).getQuestManager().getScoreStringForGlobalQuest(assignedQuest))).length() > 0) {
            questTable.add((Actor)Scene2dExtensionsKt.toLabel(leaderString)).row();
        }
        ActivationExtensionsKt.onClick(questTable, new Function0<Unit>(assignedQuest){
            final /* synthetic */ AssignedQuest $assignedQuest;
            {
                this.$assignedQuest = $assignedQuest;
                super(0);
            }

            public final void invoke() {
                this.$assignedQuest.onClickAction();
            }
        });
        return questTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getWarWithMajorTable(Civilization target, Civilization otherCiv) {
        void $this$getWarWithMajorTable_u24lambda_u246;
        Label $this$getWarWithMajorTable_u24lambda_u245;
        Label label2;
        Table warTable = new Table();
        warTable.defaults().pad(10.0f);
        String title = "War against [" + target.getCivName() + ']';
        String description2 = "We need you to help us defend against [" + target.getCivName() + "]. Killing [" + otherCiv.getQuestManager().unitsToKill(target) + "] of their military units would slow their offensive.";
        String progress = this.viewingCiv.knows(target) ? "Currently you have killed [" + otherCiv.getQuestManager().unitsKilledSoFar(target, this.viewingCiv) + "] of their military units." : "You need to find them first!";
        warTable.add((Actor)Scene2dExtensionsKt.toLabel$default(title, null, 24, 0, false, 13, null)).row();
        Label label3 = label2 = Scene2dExtensionsKt.toLabel(description2);
        Table table2 = warTable;
        boolean bl = false;
        $this$getWarWithMajorTable_u24lambda_u245.setWrap(true);
        $this$getWarWithMajorTable_u24lambda_u245.setAlignment(1);
        table2.add((Actor)label2).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        $this$getWarWithMajorTable_u24lambda_u245 = label2 = Scene2dExtensionsKt.toLabel(progress);
        table2 = warTable;
        boolean bl2 = false;
        $this$getWarWithMajorTable_u24lambda_u246.setWrap(true);
        $this$getWarWithMajorTable_u24lambda_u246.setAlignment(1);
        table2.add((Actor)label2).width(this.diplomacyScreen.getStage().getWidth() / (float)2).row();
        return warTable;
    }

    private static final String getCityStateDiplomacyTableHeader$getBonusText(CityStateDiplomacyTable this$0, Civilization $otherCiv, String header, RelationshipLevel level) {
        Sequence bonuses2 = SequencesKt.filterNot(CityStateFunctions.getCityStateBonuses$default(this$0.viewingCiv.getCityStateFunctions(), $otherCiv.getCityStateType(), level, null, 4, null), getCityStateDiplomacyTableHeader.getBonusText.bonuses.1.INSTANCE);
        if (SequencesKt.none(bonuses2)) {
            return "";
        }
        String[] stringArray = new String[]{header};
        return SequencesKt.joinToString$default(SequencesKt.plus(SequencesKt.sequenceOf(stringArray), SequencesKt.map(bonuses2, getCityStateDiplomacyTableHeader.getBonusText.1.INSTANCE)), "\n", null, null, 0, null, getCityStateDiplomacyTableHeader.getBonusText.2.INSTANCE, 30, null);
    }

    private static final void getCityStateDiplomacyTableHeader$addBonusLabel(Table diplomacyTable, CityStateDiplomacyTable this$0, Civilization $otherCiv, String header, RelationshipLevel bonusLevel, RelationshipLevel relationLevel) {
        ColorMarkupLabel colorMarkupLabel;
        Color bonusLabelColor = relationLevel == bonusLevel ? Color.GREEN : Color.GRAY;
        String string = CityStateDiplomacyTable.getCityStateDiplomacyTableHeader$getBonusText(this$0, $otherCiv, header, bonusLevel);
        Intrinsics.checkNotNullExpressionValue(bonusLabelColor, "bonusLabelColor");
        ColorMarkupLabel $this$getCityStateDiplomacyTableHeader_u24addBonusLabel_u24lambda_u241 = colorMarkupLabel = new ColorMarkupLabel(string, bonusLabelColor, null, 0, 12, null);
        boolean bl = false;
        $this$getCityStateDiplomacyTableHeader_u24addBonusLabel_u24lambda_u241.setAlignment(1);
        ColorMarkupLabel bonusLabel = colorMarkupLabel;
        diplomacyTable.add((Actor)bonusLabel).row();
    }

    public static final /* synthetic */ DiplomacyScreen access$getDiplomacyScreen$p(CityStateDiplomacyTable $this) {
        return $this.diplomacyScreen;
    }

    public static final /* synthetic */ Table access$getGoldGiftTable(CityStateDiplomacyTable $this, Civilization otherCiv) {
        return $this.getGoldGiftTable(otherCiv);
    }

    public static final /* synthetic */ Table access$getDemandTributeTable(CityStateDiplomacyTable $this, Civilization otherCiv) {
        return $this.getDemandTributeTable(otherCiv);
    }

    public static final /* synthetic */ Table access$getImprovementGiftTable(CityStateDiplomacyTable $this, Civilization otherCiv) {
        return $this.getImprovementGiftTable(otherCiv);
    }
}

