/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/LeaderIntroTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "hello", "", "(Lcom/unciv/logic/civilization/Civilization;Ljava/lang/String;)V", "core"})
public final class LeaderIntroTable
extends Table {
    public LeaderIntroTable(@NotNull Civilization civInfo, @NotNull String hello) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(hello, "hello");
        super(BaseScreen.Companion.getSkin());
        this.defaults().align(1);
        Nation nation2 = civInfo.getNation();
        String leaderPortraitFile = "LeaderIcons/" + nation2.getLeaderName();
        Label leaderLabel = Scene2dExtensionsKt.toLabel$default(civInfo.getLeaderDisplayName(), null, 24, 0, true, 5, null);
        Portrait nationIndicator = ImageGetter.INSTANCE.getNationPortrait(nation2, 24.0f);
        if (((CharSequence)nation2.getLeaderName()).length() > 0 && ImageGetter.INSTANCE.imageExists(leaderPortraitFile)) {
            Table nameTable = new Table();
            nameTable.add((Actor)leaderLabel);
            nameTable.add((Actor)nationIndicator).pad(0.0f, 10.0f, 5.0f, 0.0f).row();
            if (((CharSequence)hello).length() > 0) {
                nameTable.add((Actor)Scene2dExtensionsKt.toLabel(hello)).colspan(2);
            }
            this.add((Actor)ImageGetter.INSTANCE.getImage(leaderPortraitFile)).size(100.0f).padRight(10.0f);
            this.add((Actor)nameTable);
        } else {
            this.add((Actor)nationIndicator).pad(0.0f, 0.0f, 5.0f, 10.0f);
            this.add((Actor)leaderLabel).row();
            if (((CharSequence)hello).length() > 0) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(hello)).colspan(2);
            }
        }
    }

    public /* synthetic */ LeaderIntroTable(Civilization civilization, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(civilization, string);
    }
}

