/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.logic.trade.TradeType;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.OffersListScroll;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ0\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/OffersListScroll;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "persistenceID", "", "onOfferClicked", "Lkotlin/Function1;", "Lcom/unciv/logic/trade/TradeOffer;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "expanderTabs", "Ljava/util/HashMap;", "Lcom/unciv/logic/trade/TradeType;", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "Lkotlin/collections/HashMap;", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "update", "offersToDisplay", "Lcom/unciv/logic/trade/TradeOffersList;", "otherOffers", "untradableOffers", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "ourCiv", "Lcom/unciv/logic/civilization/Civilization;", "theirCiv", "core"})
@SourceDebugExtension(value={"SMAP\nOffersListScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1#2:148\n766#3:149\n857#3,2:150\n766#3:152\n857#3,2:153\n1726#3,3:155\n*S KotlinDebug\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n*L\n77#1:149\n77#1:150,2\n86#1:152\n86#1:153,2\n127#1:155,3\n*E\n"})
public final class OffersListScroll
extends AutoScrollPane {
    @NotNull
    private final String persistenceID;
    @NotNull
    private final Function1<TradeOffer, Unit> onOfferClicked;
    @NotNull
    private final Table table;
    @NotNull
    private final HashMap<TradeType, ExpanderTab> expanderTabs;

    /*
     * WARNING - void declaration
     */
    public OffersListScroll(@NotNull String persistenceID, @NotNull Function1<? super TradeOffer, Unit> onOfferClicked) {
        void $this$table_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(persistenceID, "persistenceID");
        Intrinsics.checkNotNullParameter(onOfferClicked, "onOfferClicked");
        super(null, null, 2, null);
        this.persistenceID = persistenceID;
        this.onOfferClicked = onOfferClicked;
        Table table3 = table2 = new Table(BaseScreen.Companion.getSkin());
        OffersListScroll offersListScroll = this;
        boolean bl = false;
        $this$table_u24lambda_u240.defaults().pad(5.0f);
        offersListScroll.table = table2;
        this.expanderTabs = new HashMap();
        this.setFadeScrollBars(false);
        this.setScrollbarsVisible(true);
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TradeOffersList offersToDisplay, @NotNull TradeOffersList otherOffers, @NotNull ResourceSupplyList untradableOffers, @NotNull Civilization ourCiv, @NotNull Civilization theirCiv) {
        Intrinsics.checkNotNullParameter(offersToDisplay, "offersToDisplay");
        Intrinsics.checkNotNullParameter(otherOffers, "otherOffers");
        Intrinsics.checkNotNullParameter(untradableOffers, "untradableOffers");
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(theirCiv, "theirCiv");
        this.table.clear();
        this.expanderTabs.clear();
        for (TradeType offerType : TradeType.values()) {
            void $this$filterTo$iv$iv;
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[offerType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "";
                    break;
                }
                case 6: {
                    string = "Luxury resources";
                    break;
                }
                case 7: {
                    string = "Strategic resources";
                    break;
                }
                case 8: {
                    string = "Technologies";
                    break;
                }
                case 9: {
                    string = "Declarations of war";
                    break;
                }
                case 10: {
                    string = "Cities";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String labelName = string;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List offersOfType2 = (List)destination$iv$iv;
            if (!(((CharSequence)labelName).length() > 0) || !CollectionsKt.any(offersOfType2)) continue;
            ((Map)this.expanderTabs).put(offerType, new ExpanderTab(labelName, 0, null, false, 0.0f, 0.0f, 0.0f, "Trade." + this.persistenceID + '.' + (Object)((Object)offerType), null, null, update.1.INSTANCE, 894, null));
        }
        for (TradeType offerType : TradeType.values()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Function1[] function1Array = new Function1[]{update.offersOfType.3.INSTANCE, update.offersOfType.4.INSTANCE};
            List<TradeOffer> offersOfType3 = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy(function1Array));
            if (this.expanderTabs.containsKey((Object)offerType)) {
                ExpanderTab expanderTab2 = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab2);
                expanderTab2.getInnerTable().clear();
                ExpanderTab expanderTab3 = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab3);
                this.table.add((Actor)expanderTab3).row();
            }
            for (TradeOffer offer : offersOfType3) {
                int amountPerClick;
                TradeType[] $i$f$filterTo2;
                Group group;
                String tradeLabel = offer.getOfferText(untradableOffers.sumBy(offer.getName()));
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 6: 
                    case 7: {
                        group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, offer.getName(), 30.0f, 0, 4, null);
                        break;
                    }
                    case 9: {
                        GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
                        Intrinsics.checkNotNull(gameInfo2);
                        Nation nation2 = gameInfo2.getRuleset().getNations().get(offer.getName());
                        Intrinsics.checkNotNull(nation2);
                        group = ImageGetter.INSTANCE.getNationPortrait(nation2, 30.0f);
                        break;
                    }
                    default: {
                        group = null;
                    }
                }
                Group tradeIcon = group;
                TradeType[] $this$update_u24lambda_u243 = $i$f$filterTo2 = new IconTextButton(tradeLabel, (Actor)tradeIcon, 0, null, 12, null);
                boolean bl = false;
                if (tradeIcon != null) {
                    $this$update_u24lambda_u243.getIconCell().size(30.0f);
                }
                $this$update_u24lambda_u243.getLabel().setAlignment(1);
                $this$update_u24lambda_u243.getLabelCell().pad(5.0f).grow();
                TradeType[] tradeButton = $i$f$filterTo2;
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 1: {
                        int n = 50;
                        break;
                    }
                    case 3: {
                        int n = Integer.MAX_VALUE;
                        break;
                    }
                    default: {
                        int n = amountPerClick = 1;
                    }
                }
                if (!(!offer.isTradable() || Intrinsics.areEqual(offer.getName(), "Peace Treaty") || Intrinsics.areEqual(offer.getName(), "Research Agreement") && ourCiv.getGold() + theirCiv.getGold() <= ourCiv.getDiplomacyFunctions().getResearchAgreementCost(theirCiv) * 2)) {
                    $this$update_u24lambda_u243 = new TradeType[]{TradeType.Luxury_Resource, TradeType.Strategic_Resource};
                    if (CollectionsKt.listOf($this$update_u24lambda_u243).contains((Object)offerType)) {
                        boolean bl2;
                        block31: {
                            Iterable $this$all$iv = otherOffers;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    TradeOffer it = (TradeOffer)element$iv;
                                    boolean bl3 = false;
                                    if (it.getType() != offer.getType() || !Intrinsics.areEqual(it.getName(), offer.getName())) continue;
                                    bl2 = false;
                                    break block31;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            tradeButton.setColor(Color.GREEN);
                        }
                    }
                    ActivationExtensionsKt.onClick((Actor)tradeButton, new Function0<Unit>(amountPerClick, offer, this){
                        final /* synthetic */ int $amountPerClick;
                        final /* synthetic */ TradeOffer $offer;
                        final /* synthetic */ OffersListScroll this$0;
                        {
                            this.$amountPerClick = $amountPerClick;
                            this.$offer = $offer;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            int amountTransferred = Math.min(this.$amountPerClick, this.$offer.getAmount());
                            OffersListScroll.access$getOnOfferClicked$p(this.this$0).invoke(TradeOffer.copy$default(this.$offer, null, null, amountTransferred, 0, 11, null));
                        }
                    });
                } else {
                    Scene2dExtensionsKt.disable((Button)tradeButton);
                }
                if (this.expanderTabs.containsKey((Object)offerType)) {
                    ExpanderTab expanderTab4 = this.expanderTabs.get((Object)offerType);
                    Intrinsics.checkNotNull(expanderTab4);
                    expanderTab4.getInnerTable().add((Actor)tradeButton).row();
                    continue;
                }
                this.table.add((Actor)tradeButton).row();
            }
        }
        this.setActor(this.table);
    }

    public static /* synthetic */ void update$default(OffersListScroll offersListScroll, TradeOffersList tradeOffersList, TradeOffersList tradeOffersList2, ResourceSupplyList resourceSupplyList, Civilization civilization, Civilization civilization2, int n, Object object) {
        if ((n & 4) != 0) {
            resourceSupplyList = ResourceSupplyList.Companion.getEmptyList();
        }
        offersListScroll.update(tradeOffersList, tradeOffersList2, resourceSupplyList, civilization, civilization2);
    }

    public static final /* synthetic */ Function1 access$getOnOfferClicked$p(OffersListScroll $this) {
        return $this.onOfferClicked;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TradeType.values().length];
            try {
                nArray[TradeType.Gold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Gold_Per_Turn.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Treaty.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Agreement.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Introduction.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Luxury_Resource.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Strategic_Resource.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.Technology.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.WarDeclaration.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeType.City.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

