/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.files.MapSaver;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u0006\u0010\u0019\u001a\u00020\u0005J\u0006\u0010\u001a\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorFilesTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "initWidth", "", "includeMods", "", "onSelect", "Lkotlin/Function1;", "Lcom/badlogic/gdx/files/FileHandle;", "", "onDoubleClick", "Lkotlin/Function0;", "(FZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "selectedIndex", "", "sortedFiles", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorFilesTable$ListEntry;", "Lkotlin/collections/ArrayList;", "markSelection", "button", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "row", "moveSelection", "delta", "noMapsAvailable", "update", "ListEntry", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorFilesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorFilesTable.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorFilesTable\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n6523#2:117\n6442#2:135\n1549#3:118\n1620#3,3:119\n1603#3,9:122\n1855#3:131\n1856#3:133\n1612#3:134\n1549#3:136\n1620#3,3:137\n1603#3,9:140\n1855#3:149\n1856#3:151\n1612#3:152\n1#4:132\n1#4:150\n*S KotlinDebug\n*F\n+ 1 MapEditorFilesTable.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorFilesTable\n*L\n66#1:117\n75#1:135\n67#1:118\n67#1:119,3\n70#1:122,9\n70#1:131\n70#1:133\n70#1:134\n76#1:136\n76#1:137,3\n109#1:140,9\n109#1:149\n109#1:151\n109#1:152\n70#1:132\n109#1:150\n*E\n"})
public final class MapEditorFilesTable
extends Table {
    private final boolean includeMods;
    @NotNull
    private final Function1<FileHandle, Unit> onSelect;
    @NotNull
    private final Function0<Unit> onDoubleClick;
    private int selectedIndex;
    @NotNull
    private ArrayList<ListEntry> sortedFiles;

    public MapEditorFilesTable(float initWidth, boolean includeMods, @NotNull Function1<? super FileHandle, Unit> onSelect, @NotNull Function0<Unit> onDoubleClick) {
        Intrinsics.checkNotNullParameter(onSelect, "onSelect");
        Intrinsics.checkNotNullParameter(onDoubleClick, "onDoubleClick");
        super(BaseScreen.Companion.getSkin());
        this.includeMods = includeMods;
        this.onSelect = onSelect;
        this.onDoubleClick = onDoubleClick;
        this.selectedIndex = -1;
        this.sortedFiles = new ArrayList();
        this.defaults().pad(5.0f).maxWidth(initWidth);
        ActivationExtensionsKt.getKeyShortcuts(this).add(19, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.moveSelection(-1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(20, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.moveSelection(1);
            }
        });
    }

    public /* synthetic */ MapEditorFilesTable(float f, boolean bl, Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(f, bl, function1, function0);
    }

    private final void markSelection(TextButton button, int row) {
        for (Cell cell2 : this.getCells()) {
            if (Intrinsics.areEqual(cell2.getActor(), button) || !(cell2.getActor() instanceof TextButton)) continue;
            ((Actor)cell2.getActor()).setColor(Color.WHITE);
        }
        button.setColor(Color.BLUE);
        this.selectedIndex = row;
        this.onSelect.invoke(this.sortedFiles.get(row).getFile());
    }

    private final void moveSelection(int delta) {
        int n = this.sortedFiles.size();
        int n2 = this.selectedIndex + delta;
        this.selectedIndex = (0 <= n2 ? n2 < n : false) ? this.selectedIndex + delta : (this.selectedIndex + delta < 0 ? this.sortedFiles.size() - 1 : 0);
        Object t = this.getCells().get(this.selectedIndex).getActor();
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.TextButton");
        TextButton button = (TextButton)t;
        Group group = this.getParent();
        ScrollPane scrollPane = group instanceof ScrollPane ? (ScrollPane)group : null;
        if (scrollPane != null) {
            ScrollPane it = scrollPane;
            boolean bl = false;
            it.setScrollY(this.getHeight() - button.getY() - (it.getHeight() - button.getHeight()) / (float)2);
        }
        this.markSelection(button, this.selectedIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterator $this$map$iv;
        this.clear();
        this.sortedFiles.clear();
        Object $this$sortedByDescending$iv = MapSaver.INSTANCE.getMaps();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = ArraysKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle it = (FileHandle)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (FileHandle)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.lastModified());
            }
        });
        ArrayList<ListEntry> arrayList = this.sortedFiles;
        boolean $i$f$map = false;
        void var3_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileHandle fileHandle = (FileHandle)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ListEntry("", (FileHandle)it));
        }
        arrayList.addAll((List)destination$iv$iv);
        if (this.includeMods) {
            Object element$iv$iv;
            Object[] $this$mapNotNullTo$iv$iv;
            Collection<Ruleset> collection2 = RulesetCache.INSTANCE.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "RulesetCache.values");
            Iterable $this$mapNotNull$iv = collection2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator bl = $this$forEach$iv$iv$iv.iterator();
            while (bl.hasNext()) {
                FileHandle it$iv$iv;
                Object element$iv$iv$iv;
                element$iv$iv = element$iv$iv$iv = bl.next();
                boolean bl2 = false;
                Ruleset it = (Ruleset)element$iv$iv;
                boolean bl3 = false;
                if (it.getFolderLocation() == null) continue;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            for (FileHandle modFolder : (List)destination$iv$iv2) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable $this$sortedBy$iv;
                FileHandle mapsFolder = modFolder.child("maps");
                if (!mapsFolder.exists()) continue;
                FileHandle[] fileHandleArray = mapsFolder.list();
                Intrinsics.checkNotNullExpressionValue(fileHandleArray, "mapsFolder.list()");
                $this$mapNotNullTo$iv$iv = fileHandleArray;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        FileHandle it = (FileHandle)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.name());
                        it = (FileHandle)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.name()));
                    }
                });
                arrayList = this.sortedFiles;
                boolean $i$f$map2 = false;
                void $i$f$mapNotNullTo2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    element$iv$iv = (FileHandle)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl5 = false;
                    String string = modFolder.name();
                    Intrinsics.checkNotNullExpressionValue(string, "modFolder.name()");
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    collection.add(new ListEntry(string, (FileHandle)it));
                }
                arrayList.addAll((List)destination$iv$iv3);
            }
        }
        String lastMod = "";
        Iterator<ListEntry> iterator2 = this.sortedFiles.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            ListEntry entry = iterator2.next();
            String mod = entry.component1();
            FileHandle mapFile = entry.component2();
            if (!Intrinsics.areEqual(mod, lastMod)) {
                void $this$update_u24lambda_u246;
                Table $i$f$mapTo2;
                Table bl = $i$f$mapTo2 = new Table();
                arrayList = this;
                boolean bl6 = false;
                Color color = Color.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
                $this$update_u24lambda_u246.add((Actor)ImageGetter.INSTANCE.getDot(color)).minHeight(2.0f).minWidth(15.0f);
                Color color2 = Color.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue(color2, "LIGHT_GRAY");
                Cell<Actor> cell2 = $this$update_u24lambda_u246.add((Actor)Scene2dExtensionsKt.toLabel$default(mod, color2, 0, 0, false, 14, null)).left();
                Intrinsics.checkNotNullExpressionValue(cell2, "add(mod.toLabel(Color.LIGHT_GRAY)).left()");
                Scene2dExtensionsKt.pad(cell2, 0.0f, 2.0f);
                Color color3 = Color.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue(color3, "LIGHT_GRAY");
                $this$update_u24lambda_u246.add((Actor)ImageGetter.INSTANCE.getDot(color3)).minHeight(2.0f).growX().row();
                ((Table)((Object)arrayList)).add((Actor)$i$f$mapTo2).growX().row();
                lastMod = mod;
            }
            TextButton mapButton = new TextButton(mapFile.name(), BaseScreen.Companion.getSkin());
            ActivationExtensionsKt.onClick(mapButton, new Function0<Unit>(this, mapButton, index){
                final /* synthetic */ MapEditorFilesTable this$0;
                final /* synthetic */ TextButton $mapButton;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$mapButton = $mapButton;
                    this.$index = $index;
                    super(0);
                }

                public final void invoke() {
                    MapEditorFilesTable.access$markSelection(this.this$0, this.$mapButton, this.$index);
                }
            });
            ActivationExtensionsKt.onDoubleClick$default(mapButton, null, new Function0<Unit>(this, mapButton, index){
                final /* synthetic */ MapEditorFilesTable this$0;
                final /* synthetic */ TextButton $mapButton;
                final /* synthetic */ int $index;
                {
                    this.this$0 = $receiver;
                    this.$mapButton = $mapButton;
                    this.$index = $index;
                    super(0);
                }

                public final void invoke() {
                    MapEditorFilesTable.access$markSelection(this.this$0, this.$mapButton, this.$index);
                    MapEditorFilesTable.access$getOnDoubleClick$p(this.this$0).invoke();
                }
            }, 1, null);
            this.add((Actor)mapButton).row();
        }
        this.layout();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean noMapsAvailable() {
        void $this$mapNotNullTo$iv$iv;
        if (ArraysKt.any(MapSaver.INSTANCE.getMaps())) {
            return false;
        }
        if (!this.includeMods) {
            return true;
        }
        Collection<Ruleset> collection = RulesetCache.INSTANCE.values();
        Intrinsics.checkNotNullExpressionValue(collection, "RulesetCache.values");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FileHandle it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Ruleset it = (Ruleset)element$iv$iv;
            boolean bl2 = false;
            if (it.getFolderLocation() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        for (FileHandle modFolder : (List)destination$iv$iv) {
            FileHandle mapsFolder = modFolder.child("maps");
            if (!mapsFolder.exists()) continue;
            FileHandle[] fileHandleArray = mapsFolder.list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray, "mapsFolder.list()");
            if (!ArraysKt.any((Object[])fileHandleArray)) continue;
            return false;
        }
        return true;
    }

    public static final /* synthetic */ void access$markSelection(MapEditorFilesTable $this, TextButton button, int row) {
        $this.markSelection(button, row);
    }

    public static final /* synthetic */ Function0 access$getOnDoubleClick$p(MapEditorFilesTable $this) {
        return $this.onDoubleClick;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorFilesTable$ListEntry;", "", "mod", "", "file", "Lcom/badlogic/gdx/files/FileHandle;", "(Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;)V", "getFile", "()Lcom/badlogic/gdx/files/FileHandle;", "getMod", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class ListEntry {
        @NotNull
        private final String mod;
        @NotNull
        private final FileHandle file;

        public ListEntry(@NotNull String mod, @NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(file, "file");
            this.mod = mod;
            this.file = file;
        }

        @NotNull
        public final String getMod() {
            return this.mod;
        }

        @NotNull
        public final FileHandle getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.mod;
        }

        @NotNull
        public final FileHandle component2() {
            return this.file;
        }

        @NotNull
        public final ListEntry copy(@NotNull String mod, @NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(file, "file");
            return new ListEntry(mod, file);
        }

        public static /* synthetic */ ListEntry copy$default(ListEntry listEntry, String string, FileHandle fileHandle, int n, Object object) {
            if ((n & 1) != 0) {
                string = listEntry.mod;
            }
            if ((n & 2) != 0) {
                fileHandle = listEntry.file;
            }
            return listEntry.copy(string, fileHandle);
        }

        @NotNull
        public String toString() {
            return "ListEntry(mod=" + this.mod + ", file=" + this.file + ')';
        }

        public int hashCode() {
            int result2 = this.mod.hashCode();
            result2 = result2 * 31 + this.file.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListEntry)) {
                return false;
            }
            ListEntry listEntry = (ListEntry)other;
            if (!Intrinsics.areEqual(this.mod, listEntry.mod)) {
                return false;
            }
            return Intrinsics.areEqual(this.file, listEntry.file);
        }
    }
}

