/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.UncivGame;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.components.input.KeyboardPanningListener;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.ImageWithCustomSize;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.mapeditorscreen.EditorMapHolder;
import com.unciv.ui.screens.mapeditorscreen.MapEditorMainTabs;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorToolsDrawer;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorOptionsTab;
import com.unciv.ui.screens.worldscreen.ZoomButtonPair;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Dispatcher;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0091\u00012\u00020\u00012\u00020\u0002:\u0002\u0091\u0001B\u0011\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010X\u001a\u00020G2\u0006\u0010Y\u001a\u00020ZH\u0002J.\u0010[\u001a\u00020G2\u0006\u0010\\\u001a\u0002082\u0006\u0010]\u001a\u00020^2\u0016\u0010_\u001a\u0012\u0012\u0004\u0012\u00020^0`j\b\u0012\u0004\u0012\u00020^`aJ0\u0010b\u001a\u00020G2\u0006\u0010c\u001a\u00020^2\u0006\u0010d\u001a\u00020^2\b\b\u0002\u0010e\u001a\u00020\u000b2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020G0gH\u0002J\u0014\u0010h\u001a\u00020G2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020G0gJ\b\u0010i\u001a\u00020GH\u0002J\b\u0010j\u001a\u00020GH\u0002J\r\u0010k\u001a\u00020GH\u0000\u00a2\u0006\u0002\blJ\b\u0010m\u001a\u00020GH\u0016J\b\u0010n\u001a\u000208H\u0016J\u0006\u0010o\u001a\u00020\u0004J)\u0010p\u001a#\u0012\u0015\u0012\u0013\u0018\u00010q\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(r\u0012\u0004\u0012\u00020s0Bj\u0002`tH\u0016J\u0006\u0010u\u001a\u00020+J\u0006\u0010v\u001a\u00020GJ\u0018\u0010w\u001a\u00020G2\u0006\u0010F\u001a\u00020C2\b\b\u0002\u0010x\u001a\u00020yJ$\u0010z\u001a\u00020G2\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\\\u001a\u0004\u0018\u0001082\b\b\u0002\u0010{\u001a\u00020|J\b\u0010}\u001a\u00020\u001bH\u0002J\u0010\u0010~\u001a\u00020G2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010\u007f\u001a\u00020G2\b\u0010*\u001a\u0004\u0018\u000101H\u0002J\t\u0010\u0080\u0001\u001a\u00020\u0001H\u0016J\u001a\u0010\u0081\u0001\u001a\u00020G2\u000f\b\u0002\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020G0gH\u0002J\u0010\u0010\u0083\u0001\u001a\u00020G2\u0007\u0010\u0084\u0001\u001a\u00020\u000bJ\u0012\u0010\u0085\u0001\u001a\u00020G2\u0007\u0010\u0084\u0001\u001a\u00020\u000bH\u0002JR\u0010\u0086\u0001\u001a\u00020G2\u0006\u0010E\u001a\u00020^2\t\b\u0002\u0010\u0087\u0001\u001a\u00020\u000b2-\u0010\u0088\u0001\u001a(\b\u0001\u0012\u0005\u0012\u00030\u008a\u0001\u0012\u000b\u0012\t\u0012\u0004\u0012\u00020G0\u008b\u0001\u0012\u0007\u0012\u0005\u0018\u00010\u008c\u00010\u0089\u0001\u00a2\u0006\u0003\b\u008d\u0001\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u008e\u0001J\u0019\u0010\u008f\u0001\u001a\u00020G2\u0006\u0010F\u001a\u00020C2\b\b\u0002\u0010x\u001a\u00020yJ\u000f\u0010\u0090\u0001\u001a\u00020G2\u0006\u0010F\u001a\u00020CR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\r\"\u0004\b%\u0010\u000fR\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R$\u0010,\u001a\u00020+2\u0006\u0010*\u001a\u00020+@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00102\u001a\u0004\u0018\u0001012\b\u0010*\u001a\u0004\u0018\u000101@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R7\u0010A\u001a\u001f\u0012\u0013\u0012\u00110C\u00a2\u0006\f\bD\u0012\b\bE\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020G\u0018\u00010BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001a\u0010L\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010\u0005R\u001a\u0010P\u001a\u00020QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR\u0010\u0010V\u001a\u0004\u0018\u00010WX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0092\u0001"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "map", "Lcom/unciv/logic/map/TileMap;", "(Lcom/unciv/logic/map/TileMap;)V", "descriptionTextField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "getDescriptionTextField", "()Lcom/unciv/ui/components/widgets/UncivTextField;", "editTabsNeedRefresh", "", "getEditTabsNeedRefresh", "()Z", "setEditTabsNeedRefresh", "(Z)V", "highlightedTileGroups", "", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "imageOverlay", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "isDirty", "setDirty", "jobs", "Lkotlin/collections/ArrayDeque;", "Lkotlinx/coroutines/Job;", "mapHolder", "Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "getMapHolder", "()Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "setMapHolder", "(Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;)V", "modsTabNeedsRefresh", "getModsTabNeedsRefresh", "setModsTabNeedsRefresh", "naturalWondersNeedRefresh", "getNaturalWondersNeedRefresh", "setNaturalWondersNeedRefresh", "newMapParameters", "Lcom/unciv/logic/map/MapParameters;", "getNewMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "value", "", "overlayAlpha", "getOverlayAlpha$core", "()F", "setOverlayAlpha$core", "(F)V", "Lcom/badlogic/gdx/files/FileHandle;", "overlayFile", "getOverlayFile$core", "()Lcom/badlogic/gdx/files/FileHandle;", "setOverlayFile$core", "(Lcom/badlogic/gdx/files/FileHandle;)V", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "tabs", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;", "getTabs", "()Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;", "tileClickHandler", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/ParameterName;", "name", "tile", "", "getTileClickHandler", "()Lkotlin/jvm/functions/Function1;", "setTileClickHandler", "(Lkotlin/jvm/functions/Function1;)V", "tileMap", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "setTileMap", "tileMatchFuzziness", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "getTileMatchFuzziness", "()Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "setTileMatchFuzziness", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;)V", "zoomController", "Lcom/unciv/ui/screens/worldscreen/ZoomButtonPair;", "addOverlayToMapHolder", "newHolderContent", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "applyRuleset", "newRuleset", "newBaseRuleset", "", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "askIfDirty", "question", "confirmText", "isConfirmPositive", "action", "Lkotlin/Function0;", "askIfDirtyForLoad", "cancelJobs", "clearOverlayImages", "closeEditor", "closeEditor$core", "dispose", "getCivilopediaRuleset", "getMapCloneForSave", "getShortcutDispatcherVetoer", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "getToolsWidth", "hideSelection", "highlightTile", "color", "Lcom/badlogic/gdx/graphics/Color;", "loadMap", "selectPage", "", "newMapHolder", "overlayAlphaChanged", "overlayFileChanged", "recreate", "recreateMapHolder", "actionWhileRemoved", "setWorldWrap", "newValue", "setWorldWrapFixOddWidth", "startBackgroundJob", "isDaemon", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function2;)V", "updateAndHighlight", "updateTile", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorScreen.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n800#2,11:380\n1#3:391\n*S KotlinDebug\n*F\n+ 1 MapEditorScreen.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorScreen\n*L\n188#1:380,11\n*E\n"})
public final class MapEditorScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TileMap tileMap;
    private boolean isDirty;
    @NotNull
    private final MapParameters newMapParameters;
    @NotNull
    private Ruleset ruleset;
    private boolean modsTabNeedsRefresh;
    private boolean editTabsNeedRefresh;
    private boolean naturalWondersNeedRefresh;
    @NotNull
    private MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness;
    @NotNull
    private EditorMapHolder mapHolder;
    @NotNull
    private final MapEditorMainTabs tabs;
    @Nullable
    private Function1<? super Tile, Unit> tileClickHandler;
    @Nullable
    private ZoomButtonPair zoomController;
    @NotNull
    private final UncivTextField descriptionTextField;
    @NotNull
    private final List<TileGroup> highlightedTileGroups;
    @NotNull
    private final ArrayDeque<Job> jobs;
    @Nullable
    private Image imageOverlay;
    @Nullable
    private FileHandle overlayFile;
    private float overlayAlpha;

    /*
     * WARNING - void declaration
     */
    public MapEditorScreen(@Nullable TileMap map2) {
        this.newMapParameters = MapEditorScreen.Companion.getDefaultParameters();
        this.tileMatchFuzziness = MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch;
        this.descriptionTextField = new UncivTextField("Enter a description for the users of this map", null, null, 6, null);
        this.highlightedTileGroups = new ArrayList();
        this.jobs = new ArrayDeque(3);
        if (map2 == null) {
            void $this$_init__u24lambda_u240;
            TileMap tileMap;
            Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
            Intrinsics.checkNotNull(object);
            this.ruleset = (Ruleset)object;
            TileMap tileMap2 = tileMap = new TileMap(MapSize.Companion.getTiny().getRadius(), this.ruleset, false);
            MapEditorScreen mapEditorScreen = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.getMapParameters().setMapSize(MapSize.Companion.getTiny());
            mapEditorScreen.tileMap = tileMap;
        } else {
            Ruleset ruleset2 = map2.getRuleset();
            if (ruleset2 == null) {
                ruleset2 = RulesetCache.INSTANCE.getComplexRuleset(map2.getMapParameters());
            }
            this.ruleset = ruleset2;
            this.tileMap = map2;
            this.descriptionTextField.setText(map2.getDescription());
        }
        this.mapHolder = this.newMapHolder();
        this.isDirty = false;
        ActivationExtensionsKt.onChange(this.descriptionTextField, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.setDirty(true);
            }
        });
        this.tabs = new MapEditorMainTabs(this);
        new MapEditorToolsDrawer(this.tabs, this.getStage(), this.mapHolder);
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.ctrl('n'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                MapEditorScreen._init_$selectGeneratePage(this, 0);
            }
        });
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.ctrl('g'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                MapEditorScreen._init_$selectGeneratePage(this, 1);
            }
        });
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.getBACK(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.closeEditor$core();
            }
        });
        this.overlayAlpha = 0.33f;
    }

    public /* synthetic */ MapEditorScreen(TileMap tileMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tileMap = null;
        }
        this(tileMap);
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    public final void setTileMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "<set-?>");
        this.tileMap = tileMap;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @NotNull
    public final MapParameters getNewMapParameters() {
        return this.newMapParameters;
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    public final void setRuleset(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "<set-?>");
        this.ruleset = ruleset2;
    }

    public final boolean getModsTabNeedsRefresh() {
        return this.modsTabNeedsRefresh;
    }

    public final void setModsTabNeedsRefresh(boolean bl) {
        this.modsTabNeedsRefresh = bl;
    }

    public final boolean getEditTabsNeedRefresh() {
        return this.editTabsNeedRefresh;
    }

    public final void setEditTabsNeedRefresh(boolean bl) {
        this.editTabsNeedRefresh = bl;
    }

    public final boolean getNaturalWondersNeedRefresh() {
        return this.naturalWondersNeedRefresh;
    }

    public final void setNaturalWondersNeedRefresh(boolean bl) {
        this.naturalWondersNeedRefresh = bl;
    }

    @NotNull
    public final MapEditorOptionsTab.TileMatchFuzziness getTileMatchFuzziness() {
        return this.tileMatchFuzziness;
    }

    public final void setTileMatchFuzziness(@NotNull MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness) {
        Intrinsics.checkNotNullParameter((Object)tileMatchFuzziness, "<set-?>");
        this.tileMatchFuzziness = tileMatchFuzziness;
    }

    @NotNull
    public final EditorMapHolder getMapHolder() {
        return this.mapHolder;
    }

    public final void setMapHolder(@NotNull EditorMapHolder editorMapHolder) {
        Intrinsics.checkNotNullParameter(editorMapHolder, "<set-?>");
        this.mapHolder = editorMapHolder;
    }

    @NotNull
    public final MapEditorMainTabs getTabs() {
        return this.tabs;
    }

    @Nullable
    public final Function1<Tile, Unit> getTileClickHandler() {
        return this.tileClickHandler;
    }

    public final void setTileClickHandler(@Nullable Function1<? super Tile, Unit> function1) {
        this.tileClickHandler = function1;
    }

    @NotNull
    public final UncivTextField getDescriptionTextField() {
        return this.descriptionTextField;
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.ruleset;
    }

    public final float getToolsWidth() {
        return this.getStage().getWidth() * 0.4f;
    }

    public final void setWorldWrap(boolean newValue) {
        if (newValue == this.tileMap.getMapParameters().getWorldWrap()) {
            return;
        }
        this.setWorldWrapFixOddWidth(newValue);
        if (newValue && this.overlayFile != null) {
            this.setOverlayFile$core(null);
            new ToastPopup("An overlay image is incompatible with world wrap and was deactivated.", this.getStage(), 4000L);
            this.tabs.getOptions().update();
        }
        MapEditorScreen.recreateMapHolder$default(this, null, 1, null);
    }

    private final void setWorldWrapFixOddWidth(boolean newValue) {
        MapParameters $this$setWorldWrapFixOddWidth_u24lambda_u242 = this.tileMap.getMapParameters();
        boolean bl = false;
        if ($this$setWorldWrapFixOddWidth_u24lambda_u242.getWorldWrap() && $this$setWorldWrapFixOddWidth_u24lambda_u242.getMapSize().getWidth() % 2 != 0 && Intrinsics.areEqual($this$setWorldWrapFixOddWidth_u24lambda_u242.getShape(), "Rectangular")) {
            MapSize mapSize = $this$setWorldWrapFixOddWidth_u24lambda_u242.getMapSize();
            int n = mapSize.getWidth();
            mapSize.setWidth(n + -1);
        }
        $this$setWorldWrapFixOddWidth_u24lambda_u242.setWorldWrap(newValue);
    }

    private final void recreateMapHolder(Function0<Unit> actionWhileRemoved) {
        float savedScale = this.mapHolder.getScaleX();
        this.clearOverlayImages();
        this.mapHolder.remove();
        actionWhileRemoved.invoke();
        this.mapHolder = this.newMapHolder();
        this.mapHolder.zoom(savedScale);
    }

    static /* synthetic */ void recreateMapHolder$default(MapEditorScreen mapEditorScreen, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = recreateMapHolder.1.INSTANCE;
        }
        mapEditorScreen.recreateMapHolder(function0);
    }

    /*
     * WARNING - void declaration
     */
    private final EditorMapHolder newMapHolder() {
        void $this$filterIsInstanceTo$iv$iv;
        ImageGetter.INSTANCE.setNewRuleset(this.ruleset);
        BaseScreen.Companion.setSkin();
        this.tileMap.setTransients(this.ruleset, false);
        this.tileMap.setStartingLocationsTransients();
        UncivGame.Companion.getCurrent().getTranslations().setTranslationActiveMods(this.ruleset.getMods());
        EditorMapHolder newHolder2 = new EditorMapHolder(this, this.tileMap, (Function1<? super Tile, Unit>)new Function1<Tile, Unit>(this){
            final /* synthetic */ MapEditorScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Tile it) {
                block0: {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Function1<Tile, Unit> function1 = this.this$0.getTileClickHandler();
                    if (function1 == null) break block0;
                    function1.invoke(it);
                }
            }
        });
        DelayedRemovalArray<EventListener> delayedRemovalArray = this.getStage().getRoot().getListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "stage.root.listeners");
        Iterable $this$filterIsInstance$iv = delayedRemovalArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardPanningListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (KeyboardPanningListener oldPanningListener : (List)destination$iv$iv) {
            this.getStage().removeListener(oldPanningListener);
        }
        newHolder2.setMapPanningSpeed(UncivGame.Companion.getCurrent().getSettings().getMapPanningSpeed());
        this.getStage().addListener(new KeyboardPanningListener(newHolder2, false));
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            newHolder2.setAutoScrollEnabled(UncivGame.Companion.getCurrent().getSettings().getMapAutoScroll());
        }
        Actor actor = newHolder2.getActor();
        Intrinsics.checkNotNull(actor, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.Group");
        this.addOverlayToMapHolder((Group)actor);
        this.getStage().getRoot().addActorAt(0, newHolder2);
        this.getStage().setScrollFocus(newHolder2);
        this.isDirty = true;
        this.modsTabNeedsRefresh = true;
        this.editTabsNeedRefresh = true;
        this.naturalWondersNeedRefresh = true;
        if (UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons()) {
            ZoomButtonPair zoomButtonPair = this.zoomController = new ZoomButtonPair(newHolder2);
            Intrinsics.checkNotNull(zoomButtonPair);
            zoomButtonPair.setPosition(10.0f, 10.0f);
            this.getStage().addActor(this.zoomController);
        }
        return newHolder2;
    }

    @Override
    @NotNull
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return KeyShortcutDispatcherVeto.INSTANCE.createTileGroupMapDispatcherVetoer();
    }

    public final void loadMap(@NotNull TileMap map2, @Nullable Ruleset newRuleset, int selectPage) {
        Intrinsics.checkNotNullParameter(map2, "map");
        this.clearOverlayImages();
        this.mapHolder.remove();
        this.tileMap = map2;
        this.descriptionTextField.setText(map2.getDescription());
        Ruleset ruleset2 = newRuleset;
        if (ruleset2 == null) {
            ruleset2 = RulesetCache.INSTANCE.getComplexRuleset(map2.getMapParameters());
        }
        this.ruleset = ruleset2;
        this.mapHolder = this.newMapHolder();
        this.isDirty = false;
        Gdx.input.setInputProcessor(this.getStage());
        TabbedPager.selectPage$default((TabbedPager)this.tabs, selectPage, false, 2, null);
    }

    public static /* synthetic */ void loadMap$default(MapEditorScreen mapEditorScreen, TileMap tileMap, Ruleset ruleset2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            ruleset2 = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        mapEditorScreen.loadMap(tileMap, ruleset2, n);
    }

    @NotNull
    public final TileMap getMapCloneForSave() {
        TileMap tileMap;
        TileMap $this$getMapCloneForSave_u24lambda_u243 = tileMap = this.tileMap.clone();
        boolean bl = false;
        TileMap.setTransients$default($this$getMapCloneForSave_u24lambda_u243, null, false, 1, null);
        return tileMap;
    }

    public final void applyRuleset(@NotNull Ruleset newRuleset, @NotNull String newBaseRuleset, @NotNull LinkedHashSet<String> mods) {
        Intrinsics.checkNotNullParameter(newRuleset, "newRuleset");
        Intrinsics.checkNotNullParameter(newBaseRuleset, "newBaseRuleset");
        Intrinsics.checkNotNullParameter(mods, "mods");
        this.recreateMapHolder(new Function0<Unit>(this, newBaseRuleset, mods, newRuleset){
            final /* synthetic */ MapEditorScreen this$0;
            final /* synthetic */ String $newBaseRuleset;
            final /* synthetic */ LinkedHashSet<String> $mods;
            final /* synthetic */ Ruleset $newRuleset;
            {
                this.this$0 = $receiver;
                this.$newBaseRuleset = $newBaseRuleset;
                this.$mods = $mods;
                this.$newRuleset = $newRuleset;
                super(0);
            }

            public final void invoke() {
                this.this$0.getTileMap().getMapParameters().setBaseRuleset(this.$newBaseRuleset);
                this.this$0.getTileMap().getMapParameters().setMods(this.$mods);
                this.this$0.getTileMap().setRuleset(this.$newRuleset);
                this.this$0.setRuleset(this.$newRuleset);
            }
        });
        this.modsTabNeedsRefresh = false;
    }

    public final void closeEditor$core() {
        MapEditorScreen.askIfDirty$default(this, "Do you want to leave without saving the recent changes?", "Leave", false, new Function0<Unit>(this){
            final /* synthetic */ MapEditorScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MapEditorScreen.access$cancelJobs(this.this$0);
                this.this$0.getGame().popScreen();
            }
        }, 4, null);
    }

    private final void askIfDirty(String question, String confirmText, boolean isConfirmPositive, Function0<Unit> action2) {
        if (!this.isDirty) {
            action2.invoke();
            return;
        }
        Popup.open$default(new ConfirmPopup(this, question, confirmText, isConfirmPositive, null, action2, 16, null), false, 1, null);
    }

    static /* synthetic */ void askIfDirty$default(MapEditorScreen mapEditorScreen, String string, String string2, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        mapEditorScreen.askIfDirty(string, string2, bl, function0);
    }

    public final void askIfDirtyForLoad(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        MapEditorScreen.askIfDirty$default(this, "Do you want to load another map without saving the recent changes?", "Load map", false, action2, 4, null);
    }

    public final void hideSelection() {
        for (TileGroup group : this.highlightedTileGroups) {
            group.getLayerOverlay().hideHighlight();
        }
        this.highlightedTileGroups.clear();
    }

    public final void highlightTile(@NotNull Tile tile, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(color, "color");
        TileGroup tileGroup = this.mapHolder.getTileGroups().get(tile);
        if (tileGroup == null) {
            return;
        }
        TileGroup group = tileGroup;
        TileLayerOverlay.showHighlight$default(group.getLayerOverlay(), color, 0.0f, 2, null);
        this.highlightedTileGroups.add(group);
    }

    public static /* synthetic */ void highlightTile$default(MapEditorScreen mapEditorScreen, Tile tile, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        mapEditorScreen.highlightTile(tile, color);
    }

    public final void updateTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        TileGroup tileGroup = this.mapHolder.getTileGroups().get(tile);
        Intrinsics.checkNotNull(tileGroup);
        TileGroup.update$default(tileGroup, null, null, 3, null);
    }

    public final void updateAndHighlight(@NotNull Tile tile, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(color, "color");
        this.updateTile(tile);
        this.highlightTile(tile, color);
    }

    public static /* synthetic */ void updateAndHighlight$default(MapEditorScreen mapEditorScreen, Tile tile, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        mapEditorScreen.updateAndHighlight(tile, color);
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        this.cancelJobs();
        return new MapEditorScreen(this.tileMap);
    }

    @Override
    public void dispose() {
        this.cancelJobs();
        super.dispose();
    }

    public final void startBackgroundJob(@NotNull String name2, boolean isDaemon, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(block2, "block");
        CoroutineScope scope2 = CoroutineScopeKt.CoroutineScope(isDaemon ? Dispatcher.INSTANCE.getDAEMON() : Dispatcher.INSTANCE.getNON_DAEMON());
        Job newJob = Concurrency.INSTANCE.run(name2, scope2, block2);
        this.jobs.add(newJob);
        newJob.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(this, newJob){
            final /* synthetic */ MapEditorScreen this$0;
            final /* synthetic */ Job $newJob;
            {
                this.this$0 = $receiver;
                this.$newJob = $newJob;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                MapEditorScreen.access$getJobs$p(this.this$0).remove(this.$newJob);
            }
        });
    }

    public static /* synthetic */ void startBackgroundJob$default(MapEditorScreen mapEditorScreen, String string, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        mapEditorScreen.startBackgroundJob(string, bl, function2);
    }

    private final void cancelJobs() {
        for (Job job2 : this.jobs) {
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
        this.jobs.clear();
    }

    @Nullable
    public final FileHandle getOverlayFile$core() {
        return this.overlayFile;
    }

    public final void setOverlayFile$core(@Nullable FileHandle value) {
        this.overlayFile = value;
        this.overlayFileChanged(value);
    }

    public final float getOverlayAlpha$core() {
        return this.overlayAlpha;
    }

    public final void setOverlayAlpha$core(float value) {
        this.overlayAlpha = value;
        this.overlayAlphaChanged(value);
    }

    private final void clearOverlayImages() {
        block1: {
            Image image2 = this.imageOverlay;
            if (image2 == null) {
                return;
            }
            Image oldImage = image2;
            this.imageOverlay = null;
            oldImage.remove();
            Drawable drawable = oldImage.getDrawable();
            Object object = drawable instanceof TextureRegionDrawable ? (TextureRegionDrawable)drawable : null;
            if (object == null || (object = ((TextureRegionDrawable)object).getRegion()) == null || (object = ((TextureRegion)object).getTexture()) == null) break block1;
            ((Texture)object).dispose();
        }
    }

    private final void overlayFileChanged(FileHandle value) {
        this.clearOverlayImages();
        if (value == null) {
            return;
        }
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            this.setWorldWrapFixOddWidth(false);
            new ToastPopup("World wrap is incompatible with an overlay and was deactivated.", this.getStage(), 4000L);
            this.tabs.getOptions().update();
        }
        MapEditorScreen.recreateMapHolder$default(this, null, 1, null);
    }

    private final void overlayAlphaChanged(float value) {
        Image image2 = this.imageOverlay;
        if ((image2 != null ? image2.getColor() : null) != null) {
            (image2 != null ? image2.getColor() : null).a = value;
        }
    }

    private final void addOverlayToMapHolder(Group newHolderContent) {
        block3: {
            Image image2;
            this.clearOverlayImages();
            if (this.overlayFile == null) {
                return;
            }
            try {
                Texture texture = new Texture(this.overlayFile);
                texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                this.imageOverlay = new ImageWithCustomSize(new TextureRegion(texture));
            }
            catch (Throwable ex) {
                Log.INSTANCE.error("Invalid overlay image", ex);
                this.setOverlayFile$core(null);
                new ToastPopup("Invalid overlay image", this.getStage(), 3000L);
                this.tabs.getOptions().update();
                return;
            }
            Image image3 = this.imageOverlay;
            if (image3 == null) break block3;
            Image $this$addOverlayToMapHolder_u24lambda_u244 = image2 = image3;
            boolean bl = false;
            $this$addOverlayToMapHolder_u24lambda_u244.setTouchable(Touchable.disabled);
            $this$addOverlayToMapHolder_u24lambda_u244.setFillParent(true);
            $this$addOverlayToMapHolder_u24lambda_u244.getColor().a = this.overlayAlpha;
            newHolderContent.addActor($this$addOverlayToMapHolder_u24lambda_u244);
        }
    }

    private static final void _init_$selectGeneratePage(MapEditorScreen this$0, int index) {
        MapEditorMainTabs $this$selectGeneratePage_u24lambda_u241 = this$0.tabs;
        boolean bl = false;
        TabbedPager.selectPage$default((TabbedPager)$this$selectGeneratePage_u24lambda_u241, 1, false, 2, null);
        TabbedPager.selectPage$default((TabbedPager)$this$selectGeneratePage_u24lambda_u241.getGenerate(), index, false, 2, null);
    }

    public MapEditorScreen() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$cancelJobs(MapEditorScreen $this) {
        $this.cancelJobs();
    }

    public static final /* synthetic */ ArrayDeque access$getJobs$p(MapEditorScreen $this) {
        return $this.jobs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen$Companion;", "", "()V", "getDefaultParameters", "Lcom/unciv/logic/map/MapParameters;", "saveDefaultParameters", "", "parameters", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final MapParameters getDefaultParameters() {
            MapParameters mapParameters;
            GameSetupInfo gameSetupInfo = UncivGame.Companion.getCurrent().getSettings().getLastGameSetup();
            if (gameSetupInfo == null) {
                return new MapParameters();
            }
            GameSetupInfo lastSetup = gameSetupInfo;
            MapParameters $this$getDefaultParameters_u24lambda_u240 = mapParameters = lastSetup.getMapParameters().clone();
            boolean bl = false;
            $this$getDefaultParameters_u24lambda_u240.reseed();
            $this$getDefaultParameters_u24lambda_u240.getMods().removeAll(CollectionsKt.toSet((Iterable)RulesetCache.INSTANCE.getSortedBaseRulesets()));
            return mapParameters;
        }

        public final void saveDefaultParameters(@NotNull MapParameters parameters2) {
            Intrinsics.checkNotNullParameter(parameters2, "parameters");
            GameSettings settings = UncivGame.Companion.getCurrent().getSettings();
            Object object = settings.getLastGameSetup();
            if (object == null || (object = ((GameSetupInfo)object).getGameParameters()) == null) {
                object = new GameParameters();
            }
            Object gameParameters = object;
            settings.setLastGameSetup(new GameSetupInfo((GameParameters)gameParameters, parameters2));
            settings.save();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

