/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditRiversTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001 B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u001b*\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "iconSize", "", "showOnTerrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "activated", "", "index", "", "caption", "", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "getRemoveRiverIcon", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "getRiverIcon", "edge", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab$RiverEdge;", "getTileGroupWithRivers", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "isDisabled", "", "makeTileGroup", "Lcom/unciv/logic/map/tile/Tile;", "RiverEdge", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorEditSubTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,499:1\n614#2:500\n*S KotlinDebug\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab\n*L\n356#1:500\n*E\n"})
public final class MapEditorEditRiversTab
extends Table
implements IMapEditorEditSubTabs,
TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;
    private final float iconSize;
    @NotNull
    private final Terrain showOnTerrain;

    public MapEditorEditRiversTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset2) {
        Table table2;
        Table $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(editTab, "editTab");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        super(BaseScreen.Companion.getSkin());
        this.editTab = editTab;
        this.ruleset = ruleset2;
        this.iconSize = 50.0f;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleset.terrains.values");
        Sequence sequence = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), showOnTerrain.1.INSTANCE);
        boolean $i$f$sortedByDescending = false;
        Terrain terrain2 = (Terrain)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Terrain it = (Terrain)b;
                boolean bl = false;
                Comparable comparable = Float.valueOf(it.getProduction() * (float)2 + it.getFood());
                it = (Terrain)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)Float.valueOf(it.getProduction() * (float)2 + it.getFood()));
            }
        }));
        if (terrain2 == null && (terrain2 = this.ruleset.getTerrains().get("Plains")) == null) {
            Collection<Terrain> collection2 = this.ruleset.getTerrains().values();
            Intrinsics.checkNotNullExpressionValue(collection2, "ruleset.terrains.values");
            terrain2 = (Terrain)CollectionsKt.first((Iterable)collection2);
        }
        Terrain terrain3 = terrain2;
        Intrinsics.checkNotNullExpressionValue(terrain3, "ruleset.terrains.values.\u2026t.terrains.values.first()");
        this.showOnTerrain = terrain3;
        String pediaLink = "Terrain/River";
        this.top();
        this.defaults().pad(10.0f).left();
        Table $this$_init__u24lambda_u241 = $this$sortedByDescending$iv = new Table();
        boolean bl = false;
        $this$_init__u24lambda_u241.add((Actor)this.getRemoveRiverIcon()).padRight(10.0f);
        $this$_init__u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel$default("Remove rivers", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u241, new Function0<Unit>(this, pediaLink){
            final /* synthetic */ MapEditorEditRiversTab this$0;
            final /* synthetic */ String $pediaLink;
            {
                this.this$0 = $receiver;
                this.$pediaLink = $pediaLink;
                super(0);
            }

            public final void invoke() {
                MapEditorEditRiversTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.River, "Remove rivers", MapEditorEditRiversTab.access$getRemoveRiverIcon(this.this$0), this.$pediaLink, (Function1<? super Tile, Unit>)removeLine.1.1.INSTANCE);
            }
        });
        Table removeLine2 = $this$sortedByDescending$iv;
        this.add((Actor)removeLine2).row();
        Table $this$_init__u24lambda_u242 = $this$_init__u24lambda_u241 = new Table();
        boolean bl2 = false;
        $this$_init__u24lambda_u242.add((Actor)this.getRiverIcon(RiverEdge.Left)).padRight(10.0f);
        $this$_init__u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom left river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u242, new Function0<Unit>(this, pediaLink){
            final /* synthetic */ MapEditorEditRiversTab this$0;
            final /* synthetic */ String $pediaLink;
            {
                this.this$0 = $receiver;
                this.$pediaLink = $pediaLink;
                super(0);
            }

            public final void invoke() {
                MapEditorEditRiversTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom left river", MapEditorEditRiversTab.access$getTileGroupWithRivers(this.this$0, RiverEdge.Left), this.$pediaLink, (Function1<? super Tile, Unit>)leftRiverLine.1.1.INSTANCE);
            }
        });
        Table leftRiverLine2 = $this$_init__u24lambda_u241;
        this.add((Actor)leftRiverLine2).row();
        Table $this$_init__u24lambda_u243 = $this$_init__u24lambda_u242 = new Table();
        boolean bl3 = false;
        $this$_init__u24lambda_u243.add((Actor)this.getRiverIcon(RiverEdge.Bottom)).padRight(10.0f);
        $this$_init__u24lambda_u243.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u243, new Function0<Unit>(this, pediaLink){
            final /* synthetic */ MapEditorEditRiversTab this$0;
            final /* synthetic */ String $pediaLink;
            {
                this.this$0 = $receiver;
                this.$pediaLink = $pediaLink;
                super(0);
            }

            public final void invoke() {
                MapEditorEditRiversTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom river", MapEditorEditRiversTab.access$getTileGroupWithRivers(this.this$0, RiverEdge.Bottom), this.$pediaLink, (Function1<? super Tile, Unit>)bottomRiverLine.1.1.INSTANCE);
            }
        });
        Table bottomRiverLine2 = $this$_init__u24lambda_u242;
        this.add((Actor)bottomRiverLine2).row();
        Table $this$_init__u24lambda_u244 = $this$_init__u24lambda_u243 = new Table();
        boolean bl4 = false;
        $this$_init__u24lambda_u244.add((Actor)this.getRiverIcon(RiverEdge.Right)).padRight(10.0f);
        $this$_init__u24lambda_u244.add((Actor)Scene2dExtensionsKt.toLabel$default("Bottom right river", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u244, new Function0<Unit>(this, pediaLink){
            final /* synthetic */ MapEditorEditRiversTab this$0;
            final /* synthetic */ String $pediaLink;
            {
                this.this$0 = $receiver;
                this.$pediaLink = $pediaLink;
                super(0);
            }

            public final void invoke() {
                MapEditorEditRiversTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Bottom right river", MapEditorEditRiversTab.access$getTileGroupWithRivers(this.this$0, RiverEdge.Right), this.$pediaLink, (Function1<? super Tile, Unit>)rightRiverLine.1.1.INSTANCE);
            }
        });
        Table rightRiverLine2 = $this$_init__u24lambda_u243;
        this.add((Actor)rightRiverLine2).row();
        Table $this$_init__u24lambda_u245 = table2 = new Table();
        boolean bl5 = false;
        $this$_init__u24lambda_u245.add((Actor)this.getRiverIcon(RiverEdge.All)).padRight(10.0f);
        $this$_init__u24lambda_u245.add((Actor)Scene2dExtensionsKt.toLabel$default("Spawn river from/to", null, 32, 0, false, 13, null));
        ActivationExtensionsKt.onClick($this$_init__u24lambda_u245, new Function0<Unit>(this, pediaLink){
            final /* synthetic */ MapEditorEditRiversTab this$0;
            final /* synthetic */ String $pediaLink;
            {
                this.this$0 = $receiver;
                this.$pediaLink = $pediaLink;
                super(0);
            }

            public final void invoke() {
                MapEditorEditRiversTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.RiverFromTo, "Spawn river from/to", MapEditorEditRiversTab.access$getTileGroupWithRivers(this.this$0, RiverEdge.All), this.$pediaLink, (Function1<? super Tile, Unit>)spawnRiverLine.1.1.INSTANCE);
            }
        });
        Table spawnRiverLine2 = table2;
        this.add((Actor)spawnRiverLine2).row();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.editTab.setBrushSize$core(1);
    }

    private final TileGroup makeTileGroup(Tile $this$makeTileGroup) {
        TileGroup tileGroup;
        $this$makeTileGroup.setRuleset(this.ruleset);
        $this$makeTileGroup.setTerrainTransients();
        TileGroup $this$makeTileGroup_u24lambda_u246 = tileGroup = new TileGroup($this$makeTileGroup, new TileSetStrings(null, null, 0, 7, null), this.iconSize * 36.0f / 54.0f);
        boolean bl = false;
        $this$makeTileGroup_u24lambda_u246.setForceVisible(true);
        $this$makeTileGroup_u24lambda_u246.setForMapEditorIcon(true);
        TileGroup.update$default($this$makeTileGroup_u24lambda_u246, null, null, 3, null);
        return tileGroup;
    }

    /*
     * WARNING - void declaration
     */
    private final TileGroup getTileGroupWithRivers(RiverEdge edge) {
        void $this$getTileGroupWithRivers_u24lambda_u247;
        Tile tile;
        Tile tile2 = tile = new Tile();
        MapEditorEditRiversTab mapEditorEditRiversTab = this;
        boolean bl = false;
        $this$getTileGroupWithRivers_u24lambda_u247.setBaseTerrain(this.showOnTerrain.getName());
        switch (WhenMappings.$EnumSwitchMapping$0[edge.ordinal()]) {
            case 1: {
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomLeftRiver(true);
                break;
            }
            case 2: {
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomRiver(true);
                break;
            }
            case 3: {
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomRightRiver(true);
                break;
            }
            case 4: {
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomLeftRiver(true);
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomRightRiver(true);
                $this$getTileGroupWithRivers_u24lambda_u247.setHasBottomRiver(true);
            }
        }
        return mapEditorEditRiversTab.makeTileGroup(tile);
    }

    private final Group getRemoveRiverIcon() {
        return ImageGetter.INSTANCE.getCrossedImage(this.getTileGroupWithRivers(RiverEdge.All), this.iconSize);
    }

    private final Group getRiverIcon(RiverEdge edge) {
        Group group;
        Group $this$getRiverIcon_u24lambda_u248 = group = new Group();
        boolean bl = false;
        $this$getRiverIcon_u24lambda_u248.setTransform(false);
        $this$getRiverIcon_u24lambda_u248.setSize(this.iconSize, this.iconSize);
        TileGroup tileGroup = this.getTileGroupWithRivers(edge);
        Scene2dExtensionsKt.center((Actor)tileGroup, $this$getRiverIcon_u24lambda_u248);
        $this$getRiverIcon_u24lambda_u248.addActor(tileGroup);
        return group;
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.DefaultImpls.deactivated(this, index, caption, pager);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ MapEditorEditTab access$getEditTab$p(MapEditorEditRiversTab $this) {
        return $this.editTab;
    }

    public static final /* synthetic */ Group access$getRemoveRiverIcon(MapEditorEditRiversTab $this) {
        return $this.getRemoveRiverIcon();
    }

    public static final /* synthetic */ TileGroup access$getTileGroupWithRivers(MapEditorEditRiversTab $this, RiverEdge edge) {
        return $this.getTileGroupWithRivers(edge);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditRiversTab$RiverEdge;", "", "(Ljava/lang/String;I)V", "Left", "Bottom", "Right", "All", "core"})
    private static final class RiverEdge
    extends Enum<RiverEdge> {
        public static final /* enum */ RiverEdge Left = new RiverEdge();
        public static final /* enum */ RiverEdge Bottom = new RiverEdge();
        public static final /* enum */ RiverEdge Right = new RiverEdge();
        public static final /* enum */ RiverEdge All = new RiverEdge();
        private static final /* synthetic */ RiverEdge[] $VALUES;

        public static RiverEdge[] values() {
            return (RiverEdge[])$VALUES.clone();
        }

        public static RiverEdge valueOf(String value) {
            return Enum.valueOf(RiverEdge.class, value);
        }

        static {
            $VALUES = riverEdgeArray = new RiverEdge[]{RiverEdge.Left, RiverEdge.Bottom, RiverEdge.Right, RiverEdge.All};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RiverEdge.values().length];
            try {
                nArray[RiverEdge.Left.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.Bottom.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.Right.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiverEdge.All.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

