/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.newgamescreen.ModCheckboxTable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\"B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorModsTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;)V", "applyButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "baseRulesetSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "mods", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "modsTable", "Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "modsTableCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "revertButton", "activated", "", "index", "", "caption", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "applyControls", "enableApplyButton", "fitMapToRuleset", "newRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "getIncompatibilities", "", "revertControls", "AskFitMapToRulesetPopup", "core"})
public final class MapEditorModsTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final LinkedHashSet<String> mods;
    @NotNull
    private ModCheckboxTable modsTable;
    @NotNull
    private final Cell<ModCheckboxTable> modsTableCell;
    @NotNull
    private final TextButton applyButton;
    @NotNull
    private final TextButton revertButton;
    @NotNull
    private final TranslatedSelectBox baseRulesetSelectBox;

    /*
     * WARNING - void declaration
     */
    public MapEditorModsTab(@NotNull MapEditorScreen editorScreen) {
        void $this$_init__u24lambda_u241;
        Table $this$_init__u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.mods = this.editorScreen.getNewMapParameters().getMods();
        this.applyButton = Scene2dExtensionsKt.toTextButton$default("Change map ruleset", null, false, 3, null);
        this.revertButton = Scene2dExtensionsKt.toTextButton$default("Revert to map ruleset", null, false, 3, null);
        String rulesetName = this.editorScreen.getNewMapParameters().getBaseRuleset();
        this.modsTable = new ModCheckboxTable(new LinkedHashSet<String>(), rulesetName, this.editorScreen, false, 1.INSTANCE);
        List<String> baseRulesets = RulesetCache.INSTANCE.getSortedBaseRulesets();
        this.baseRulesetSelectBox = new TranslatedSelectBox((Collection<String>)baseRulesets, rulesetName, BaseScreen.Companion.getSkin());
        ActivationExtensionsKt.onChange(this.baseRulesetSelectBox, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                String newBaseRuleset = ((TranslatedSelectBox.TranslatedString)baseRulesetSelectBox.getSelected()).getValue();
                editorScreen.getNewMapParameters().setBaseRuleset(newBaseRuleset);
                modsTable.setBaseRuleset(newBaseRuleset);
                modsTable.disableAllCheckboxes();
                this.enableApplyButton();
            }
        });
        this.top();
        this.pad(5.0f);
        Table table3 = table2 = new Table();
        MapEditorModsTab mapEditorModsTab = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel("{Base Ruleset}:"));
        $this$_init__u24lambda_u240.add((Actor)this.baseRulesetSelectBox).fillX();
        mapEditorModsTab.add((Actor)table2).fillX().padBottom(10.0f).row();
        $this$_init__u24lambda_u240 = table2 = new Table();
        mapEditorModsTab = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.add((Actor)this.applyButton).padRight(10.0f);
        $this$_init__u24lambda_u241.add((Actor)this.revertButton);
        mapEditorModsTab.add((Actor)table2).fillX().pad(10.0f).row();
        Cell<Actor> cell2 = this.add((Actor)this.modsTable);
        Intrinsics.checkNotNullExpressionValue(cell2, "add(modsTable)");
        this.modsTableCell = cell2;
        this.row();
        ActivationExtensionsKt.onClick(this.applyButton, new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((MapEditorModsTab)this.receiver).applyControls();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, this.applyButton, "Change the map to use the ruleset selected on this page", 21.0f, false, 4, 0, false, null, 116, null);
        ActivationExtensionsKt.onClick(this.revertButton, new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((MapEditorModsTab)this.receiver).revertControls();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, this.revertButton, "Reset the controls to reflect the current map ruleset", 21.0f, false, 4, 0, false, null, 116, null);
    }

    private final void enableApplyButton() {
        MapParameters currentParameters = this.editorScreen.getTileMap().getMapParameters();
        boolean enabled = !Intrinsics.areEqual(currentParameters.getMods(), this.mods) || !Intrinsics.areEqual(currentParameters.getBaseRuleset(), ((TranslatedSelectBox.TranslatedString)this.baseRulesetSelectBox.getSelected()).getValue());
        Scene2dExtensionsKt.setEnabled(this.applyButton, enabled);
        Scene2dExtensionsKt.setEnabled(this.revertButton, enabled);
    }

    private final void revertControls() {
        MapParameters currentParameters = this.editorScreen.getTileMap().getMapParameters();
        this.baseRulesetSelectBox.setSelected(currentParameters.getBaseRuleset());
        this.mods.clear();
        this.mods.addAll((Collection<String>)currentParameters.getMods());
        this.modsTable = new ModCheckboxTable(this.mods, currentParameters.getBaseRuleset(), this.editorScreen, false, (Function1<? super String, Unit>)new Function1<String, Unit>(this){
            final /* synthetic */ MapEditorModsTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MapEditorModsTab.access$enableApplyButton(this.this$0);
            }
        });
        this.modsTableCell.setActor((Actor)this.modsTable);
        this.enableApplyButton();
    }

    private final void applyControls() {
        Ruleset newRuleset = RulesetCache.INSTANCE.getComplexRuleset(this.mods, this.editorScreen.getNewMapParameters().getBaseRuleset());
        List<String> incompatibilities = this.getIncompatibilities(newRuleset);
        if (incompatibilities.isEmpty()) {
            this.editorScreen.applyRuleset(newRuleset, this.editorScreen.getNewMapParameters().getBaseRuleset(), this.mods);
            this.enableApplyButton();
        } else {
            new AskFitMapToRulesetPopup((BaseScreen)this.editorScreen, incompatibilities, new Function0<Unit>(this, newRuleset){
                final /* synthetic */ MapEditorModsTab this$0;
                final /* synthetic */ Ruleset $newRuleset;
                {
                    this.this$0 = $receiver;
                    this.$newRuleset = $newRuleset;
                    super(0);
                }

                public final void invoke() {
                    MapEditorModsTab.access$fitMapToRuleset(this.this$0, this.$newRuleset);
                    MapEditorModsTab.access$getEditorScreen$p(this.this$0).applyRuleset(this.$newRuleset, MapEditorModsTab.access$getEditorScreen$p(this.this$0).getNewMapParameters().getBaseRuleset(), MapEditorModsTab.access$getMods$p(this.this$0));
                    MapEditorModsTab.access$enableApplyButton(this.this$0);
                }
            });
        }
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.enableApplyButton();
        if (!this.editorScreen.getModsTabNeedsRefresh()) {
            return;
        }
        this.editorScreen.setModsTabNeedsRefresh(false);
        this.revertControls();
    }

    private final List<String> getIncompatibilities(Ruleset newRuleset) {
        HashSet incompatibilities = new HashSet();
        for (Tile tile : this.editorScreen.getTileMap().getValues()) {
            CollectionsKt.addAll((Collection)incompatibilities, (Iterable)tile.getRulesetIncompatibility(newRuleset));
        }
        incompatibilities.remove("");
        return CollectionsKt.sorted(incompatibilities);
    }

    private final void fitMapToRuleset(Ruleset newRuleset) {
        for (Tile tile : this.editorScreen.getTileMap().getValues()) {
            TileNormalizer.INSTANCE.normalizeToRuleset(tile, newRuleset);
        }
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        TabbedPager.IPageExtensions.DefaultImpls.deactivated(this, index, caption, pager);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ void access$fitMapToRuleset(MapEditorModsTab $this, Ruleset newRuleset) {
        $this.fitMapToRuleset(newRuleset);
    }

    public static final /* synthetic */ LinkedHashSet access$getMods$p(MapEditorModsTab $this) {
        return $this.mods;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorModsTab$AskFitMapToRulesetPopup;", "Lcom/unciv/ui/popups/Popup;", "editorScreen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "incompatibilities", "", "", "onOK", "Lkotlin/Function0;", "", "(Lcom/unciv/ui/screens/basescreen/BaseScreen;Ljava/util/List;Lkotlin/jvm/functions/Function0;)V", "core"})
    private static final class AskFitMapToRulesetPopup
    extends Popup {
        public AskFitMapToRulesetPopup(@NotNull BaseScreen editorScreen, @NotNull List<String> incompatibilities, final @NotNull Function0<Unit> onOK) {
            Table table2;
            Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
            Intrinsics.checkNotNullParameter(incompatibilities, "incompatibilities");
            Intrinsics.checkNotNullParameter(onOK, "onOK");
            super(editorScreen, null, 0.0f, 6, null);
            Table $this$_init__u24lambda_u240 = table2 = new Table();
            boolean bl = false;
            for (String inc : incompatibilities) {
                $this$_init__u24lambda_u240.add((Actor)Scene2dExtensionsKt.toLabel(inc)).row();
            }
            Table incompatibilityTable = table2;
            this.add((Actor)new ScrollPane((Actor)incompatibilityTable)).colspan(2).maxHeight(this.getStageToShowOn().getHeight() * 0.8f).row();
            Popup.addGoodSizedLabel$default(this, "Change map to fit selected ruleset?", 24, false, 4, null).colspan(2).row();
            Popup.addButton$default((Popup)this, "Yes", 'y', null, (Function0)new Function0<Unit>(){

                @Override
                public final void invoke() {
                    onOK.invoke();
                    this.close();
                }
            }, 4, null);
            Popup.addButton$default((Popup)this, "No", 'n', null, (Function0)new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.close();
                }
            }, 4, null);
            this.equalizeLastTwoButtonWidths();
            this.open(true);
        }
    }
}

