/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.files.FileChooser;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorWesnothImporter;
import com.unciv.utils.Log;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J \u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002J\u0006\u0010$\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;)V", "copyMapButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "copySeedButton", "overlayAlphaSlider", "Lcom/unciv/ui/components/widgets/UncivSlider;", "overlayFileButton", "pasteMapButton", "seedLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "seedToCopy", "", "tileMatchFuzziness", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "tileMatchGroup", "Lcom/badlogic/gdx/scenes/scene2d/ui/ButtonGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "worldWrapCheckBox", "activated", "", "index", "", "caption", "pager", "Lcom/unciv/ui/components/widgets/TabbedPager;", "canChangeWorldWrap", "", "copyHandler", "deactivated", "pasteHandler", "showOverlayFileName", "update", "TileMatchFuzziness", "core"})
public final class MapEditorOptionsTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final Label seedLabel;
    @NotNull
    private final TextButton copySeedButton;
    @NotNull
    private final ButtonGroup<CheckBox> tileMatchGroup;
    @NotNull
    private final TextButton copyMapButton;
    @NotNull
    private final TextButton pasteMapButton;
    @NotNull
    private final CheckBox worldWrapCheckBox;
    @NotNull
    private final TextButton overlayFileButton;
    @NotNull
    private final UncivSlider overlayAlphaSlider;
    @NotNull
    private String seedToCopy;
    @NotNull
    private TileMatchFuzziness tileMatchFuzziness;

    /*
     * WARNING - void declaration
     */
    public MapEditorOptionsTab(@NotNull MapEditorScreen editorScreen) {
        void $this$_init__u24lambda_u241;
        Object $this$_init__u24lambda_u240;
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        Color color = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color, "GOLD");
        this.seedLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        this.copySeedButton = Scene2dExtensionsKt.toTextButton$default("Copy to clipboard", null, false, 3, null);
        this.tileMatchGroup = new ButtonGroup();
        this.copyMapButton = Scene2dExtensionsKt.toTextButton$default("Copy to clipboard", null, false, 3, null);
        this.pasteMapButton = Scene2dExtensionsKt.toTextButton$default("Load copied data", null, false, 3, null);
        this.overlayFileButton = new TextButton(null, BaseScreen.Companion.getSkin());
        this.seedToCopy = "";
        this.tileMatchFuzziness = TileMatchFuzziness.CompleteMatch;
        this.top();
        this.defaults().pad(10.0f);
        Color color2 = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color2, "GOLD");
        this.add((Actor)Scene2dExtensionsKt.toLabel$default("Tile Matching Criteria", color2, 0, 0, false, 14, null)).row();
        Object object = TileMatchFuzziness.values();
        int n = ((TileMatchFuzziness[])object).length;
        for (int i = 0; i < n; ++i) {
            TileMatchFuzziness option = object[i];
            CheckBox check2 = Scene2dExtensionsKt.toCheckBox(option.getLabel(), option == this.tileMatchFuzziness, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(this, option){
                final /* synthetic */ MapEditorOptionsTab this$0;
                final /* synthetic */ TileMatchFuzziness $option;
                {
                    this.this$0 = $receiver;
                    this.$option = $option;
                    super(1);
                }

                public final void invoke(boolean it) {
                    MapEditorOptionsTab.access$setTileMatchFuzziness$p(this.this$0, this.$option);
                }
            });
            this.add((Actor)check2).row();
            this.tileMatchGroup.add((CheckBox)((Button)check2));
        }
        Table table2 = this;
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table2, color3, 0, 0.0f, 6, null);
        this.add((Actor)this.seedLabel).row();
        this.add((Actor)this.copySeedButton).row();
        ActivationExtensionsKt.onClick(this.copySeedButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                Gdx.app.getClipboard().setContents(seedToCopy);
            }
        });
        Table table3 = this;
        Color color4 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table3, color4, 0, 0.0f, 6, null);
        Color color5 = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color5, "GOLD");
        this.add((Actor)Scene2dExtensionsKt.toLabel$default("Map copy and paste", color5, 0, 0, false, 14, null)).row();
        ActivationExtensionsKt.onActivation(this.copyMapButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.copyHandler();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.copyMapButton).add(KeyCharAndCode.Companion.ctrl('c'));
        ActivationExtensionsKt.onActivation(this.pasteMapButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.pasteHandler();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.pasteMapButton).add(KeyCharAndCode.Companion.ctrl('v'));
        Object object2 = object = new Table();
        MapEditorOptionsTab mapEditorOptionsTab = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.add((Actor)this.copyMapButton).padRight(15.0f);
        $this$_init__u24lambda_u240.add((Actor)this.pasteMapButton);
        mapEditorOptionsTab.add((Actor)object).row();
        this.add(ActivationExtensionsKt.onActivation(Scene2dExtensionsKt.toTextButton$default("Import a Wesnoth map", null, false, 3, null), new Function0<Unit>(){

            @Override
            public final void invoke() {
                new MapEditorWesnothImporter(editorScreen).onImportButtonClicked();
            }
        }));
        Table table4 = this;
        Color color6 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color6, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table4, color6, 0, 0.0f, 6, null);
        this.worldWrapCheckBox = Scene2dExtensionsKt.toCheckBox("Current map: World Wrap", this.editorScreen.getTileMap().getMapParameters().getWorldWrap(), (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            @Override
            public final void invoke(boolean it) {
                editorScreen.setWorldWrap(it);
            }
        });
        this.add((Actor)this.worldWrapCheckBox).growX().row();
        Table table5 = this;
        Color color7 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color7, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table5, color7, 0, 0.0f, 6, null);
        Color color8 = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color8, "GOLD");
        this.add((Actor)Scene2dExtensionsKt.toLabel$default("Overlay image", color8, 0, 0, false, 14, null)).row();
        this.overlayFileButton.setStyle(new TextButton.TextButtonStyle(this.overlayFileButton.getStyle()));
        this.showOverlayFileName();
        ActivationExtensionsKt.onClick(this.overlayFileButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                FileChooser fileChooser;
                Stage stage = this.getStage();
                Intrinsics.checkNotNullExpressionValue(stage, "stage");
                FileChooser $this$invoke_u24lambda_u240 = fileChooser = FileChooser.Companion.createLoadDialog(stage, "Choose an image", editorScreen.getOverlayFile$core(), (Function2<? super Boolean, ? super FileHandle, Unit>)new Function2<Boolean, FileHandle, Unit>(){

                    @Override
                    public final void invoke(boolean success, @NotNull FileHandle file) {
                        Intrinsics.checkNotNullParameter(file, "file");
                        if (!success) {
                            return;
                        }
                        editorScreen.setOverlayFile$core(file);
                        this.showOverlayFileName();
                    }
                });
                boolean bl = false;
                String[] stringArray = new String[]{"png", "jpg", "jpeg"};
                $this$invoke_u24lambda_u240.setFilter(FileChooser.Companion.createExtensionFilter(stringArray));
                Popup.open$default(fileChooser, false, 1, null);
            }
        });
        this.add((Actor)this.overlayFileButton).fillX().row();
        this.overlayAlphaSlider = new UncivSlider(0.0f, 1.0f, 0.05f, false, false, this.editorScreen.getOverlayAlpha$core(), null, null, null, new Function1<Float, Unit>(){

            @Override
            public final void invoke(float it) {
                editorScreen.setOverlayAlpha$core(it);
            }
        }, 472, null);
        $this$_init__u24lambda_u240 = object = new Table();
        mapEditorOptionsTab = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel$default("Overlay opacity:", null, 0, 8, false, 11, null)).left();
        $this$_init__u24lambda_u241.add((Actor)this.overlayAlphaSlider).right();
        mapEditorOptionsTab.add((Actor)object).row();
    }

    private final void copyHandler() {
        Gdx.app.getClipboard().setContents(MapSaver.INSTANCE.mapToSavedString(this.editorScreen.getMapCloneForSave()));
    }

    private final void pasteHandler() {
        try {
            String string = Gdx.app.getClipboard().getContents();
            Intrinsics.checkNotNullExpressionValue(string, "app.clipboard.contents");
            String clipboardContentsString = ((Object)StringsKt.trim((CharSequence)string)).toString();
            TileMap loadedMap = MapSaver.INSTANCE.mapFromSavedString(clipboardContentsString);
            MapEditorScreen.loadMap$default(this.editorScreen, loadedMap, null, 0, 6, null);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Could not load map", ex);
            new ToastPopup("Could not load map!", this.editorScreen, 0L, 4, null);
        }
    }

    private final void showOverlayFileName() {
        TextButton $this$showOverlayFileName_u24lambda_u242 = this.overlayFileButton;
        boolean bl = false;
        if (this.editorScreen.getOverlayFile$core() == null) {
            $this$showOverlayFileName_u24lambda_u242.setText(TranslationsKt.tr$default("Click to choose a file", false, 1, null));
            $this$showOverlayFileName_u24lambda_u242.getStyle().fontColor.a = 0.5f;
        } else {
            FileHandle fileHandle = this.editorScreen.getOverlayFile$core();
            Intrinsics.checkNotNull(fileHandle);
            $this$showOverlayFileName_u24lambda_u242.setText(fileHandle.path());
            $this$showOverlayFileName_u24lambda_u242.getStyle().fontColor.a = 1.0f;
        }
    }

    private final boolean canChangeWorldWrap() {
        MapParameters params = this.editorScreen.getTileMap().getMapParameters();
        if (!Intrinsics.areEqual(params.getShape(), "Rectangular")) {
            return false;
        }
        if (params.getMapSize().getRadius() < MapSize.Companion.getTiny().getRadius()) {
            return false;
        }
        if (params.getMapSize().getWidth() % 2 == 0) {
            return true;
        }
        return params.getWorldWrap();
    }

    public final void update() {
        Scene2dExtensionsKt.setEnabled(this.pasteMapButton, Gdx.app.getClipboard().hasContents());
        this.worldWrapCheckBox.setChecked(this.editorScreen.getTileMap().getMapParameters().getWorldWrap());
        this.worldWrapCheckBox.setDisabled(!this.canChangeWorldWrap());
        this.showOverlayFileName();
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.seedToCopy = String.valueOf(this.editorScreen.getTileMap().getMapParameters().getSeed());
        this.seedLabel.setText(TranslationsKt.tr$default("Current map RNG seed: [" + this.seedToCopy + ']', false, 1, null));
        this.update();
        this.overlayAlphaSlider.setValue(this.editorScreen.getOverlayAlpha$core());
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        this.editorScreen.setTileMatchFuzziness(this.tileMatchFuzziness);
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ void access$setTileMatchFuzziness$p(MapEditorOptionsTab $this, TileMatchFuzziness tileMatchFuzziness) {
        $this.tileMatchFuzziness = tileMatchFuzziness;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "", "label", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "CompleteMatch", "NoImprovement", "BaseAndFeatures", "BaseTerrain", "LandOrWater", "core"})
    public static final class TileMatchFuzziness
    extends Enum<TileMatchFuzziness> {
        @NotNull
        private final String label;
        public static final /* enum */ TileMatchFuzziness CompleteMatch = new TileMatchFuzziness("Complete match");
        public static final /* enum */ TileMatchFuzziness NoImprovement = new TileMatchFuzziness("Except improvements");
        public static final /* enum */ TileMatchFuzziness BaseAndFeatures = new TileMatchFuzziness("Base and terrain features");
        public static final /* enum */ TileMatchFuzziness BaseTerrain = new TileMatchFuzziness("Base terrain only");
        public static final /* enum */ TileMatchFuzziness LandOrWater = new TileMatchFuzziness("Land or water only");
        private static final /* synthetic */ TileMatchFuzziness[] $VALUES;

        private TileMatchFuzziness(String label2) {
            this.label = label2;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static TileMatchFuzziness[] values() {
            return (TileMatchFuzziness[])$VALUES.clone();
        }

        public static TileMatchFuzziness valueOf(String value) {
            return Enum.valueOf(TileMatchFuzziness.class, value);
        }

        static {
            $VALUES = tileMatchFuzzinessArray = new TileMatchFuzziness[]{TileMatchFuzziness.CompleteMatch, TileMatchFuzziness.NoImprovement, TileMatchFuzziness.BaseAndFeatures, TileMatchFuzziness.BaseTerrain, TileMatchFuzziness.LandOrWater};
        }
    }
}

