/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.modmanager;

import com.unciv.logic.github.GithubAPI;
import com.unciv.models.metadata.ModCategories;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.modmanager.ModManagementOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nB?\b\u0002\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\fJ\u0013\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&J\u0006\u0010(\u001a\u00020\"J\u0006\u0010)\u001a\u00020\"J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\f0+R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006,"}, d2={"Lcom/unciv/ui/screens/modmanager/ModUIData;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "isVisual", "", "(Lcom/unciv/models/ruleset/Ruleset;Z)V", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "isUpdated", "(Lcom/unciv/logic/github/GithubAPI$Repo;Z)V", "name", "", "description", "hasUpdate", "(Ljava/lang/String;Ljava/lang/String;Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/logic/github/GithubAPI$Repo;ZZ)V", "getDescription", "()Ljava/lang/String;", "getHasUpdate", "()Z", "setHasUpdate", "(Z)V", "isInstalled", "setVisual", "getName", "getRepo", "()Lcom/unciv/logic/github/GithubAPI$Repo;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "author", "buttonText", "equals", "other", "hashCode", "", "lastUpdated", "matchesCategory", "filter", "Lcom/unciv/ui/screens/modmanager/ModManagementOptions$Filter;", "matchesFilter", "stargazers", "stateSortWeight", "topics", "", "core"})
public final class ModUIData {
    @NotNull
    private final String name;
    @NotNull
    private final String description;
    @Nullable
    private final Ruleset ruleset;
    @Nullable
    private final GithubAPI.Repo repo;
    private boolean isVisual;
    private boolean hasUpdate;

    private ModUIData(String name2, String description2, Ruleset ruleset2, GithubAPI.Repo repo, boolean isVisual, boolean hasUpdate) {
        this.name = name2;
        this.description = description2;
        this.ruleset = ruleset2;
        this.repo = repo;
        this.isVisual = isVisual;
        this.hasUpdate = hasUpdate;
    }

    /* synthetic */ ModUIData(String string, String string2, Ruleset ruleset2, GithubAPI.Repo repo, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(string, string2, ruleset2, repo, bl, bl2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    @Nullable
    public final GithubAPI.Repo getRepo() {
        return this.repo;
    }

    public final boolean isVisual() {
        return this.isVisual;
    }

    public final void setVisual(boolean bl) {
        this.isVisual = bl;
    }

    public final boolean getHasUpdate() {
        return this.hasUpdate;
    }

    public final void setHasUpdate(boolean bl) {
        this.hasUpdate = bl;
    }

    /*
     * WARNING - void declaration
     */
    public ModUIData(@NotNull Ruleset ruleset2, boolean isVisual) {
        void it;
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        String string = ruleset2.getSummary();
        String string2 = ruleset2.getName();
        ModUIData modUIData = this;
        boolean bl = false;
        String string3 = TranslationsKt.tr$default("Installed", false, 1, null) + (((CharSequence)it).length() == 0 ? "" : ": " + (String)it);
        modUIData(string2, string3, ruleset2, null, isVisual, false, 32, null);
    }

    public ModUIData(@NotNull GithubAPI.Repo repo, boolean isUpdated) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        String string = repo.getName();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = repo.getDescription();
        if (string2 == null) {
            string2 = TranslationsKt.tr$default("-{No description provided}-", false, 1, null);
        }
        this(string, stringBuilder.append(string2).append('\n').append(TranslationsKt.tr$default("" + '[' + repo.getStargazers_count() + "]\u272f", false, 1, null)).toString(), null, repo, false, isUpdated, 16, null);
    }

    public final boolean isInstalled() {
        return this.ruleset != null;
    }

    @NotNull
    public final String lastUpdated() {
        Object object = this.ruleset;
        if (object == null || (object = ((Ruleset)object).getModOptions()) == null || (object = ((ModOptions)object).getLastUpdated()) == null) {
            GithubAPI.Repo repo = this.repo;
            object = repo != null ? repo.getPushed_at() : "";
        }
        return object;
    }

    public final int stargazers() {
        GithubAPI.Repo repo = this.repo;
        return repo != null ? repo.getStargazers_count() : 0;
    }

    @NotNull
    public final String author() {
        Object object = this.ruleset;
        if (object == null || (object = ((Ruleset)object).getModOptions()) == null || (object = ((ModOptions)object).getAuthor()) == null) {
            Object object2 = this.repo;
            object = object2 != null && (object2 = ((GithubAPI.Repo)object2).getOwner()) != null ? ((GithubAPI.RepoOwner)object2).getLogin() : "";
        }
        return object;
    }

    @NotNull
    public final List<String> topics() {
        Object object = this.ruleset;
        if (object == null || (object = ((Ruleset)object).getModOptions()) == null || (object = ((ModOptions)object).getTopics()) == null) {
            GithubAPI.Repo repo = this.repo;
            object = repo != null ? repo.getTopics() : CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final String buttonText() {
        return this.ruleset != null ? this.ruleset.getName() : (this.repo != null ? this.repo.getName() + (this.hasUpdate ? " - {Updated}" : "") : "");
    }

    public final boolean matchesFilter(@NotNull ModManagementOptions.Filter filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return !this.matchesCategory(filter2) ? false : (((CharSequence)filter2.getText()).length() == 0 ? true : (StringsKt.contains((CharSequence)this.name, filter2.getText(), true) ? true : StringsKt.contains((CharSequence)this.author(), filter2.getText(), true)));
    }

    private final boolean matchesCategory(ModManagementOptions.Filter filter2) {
        if (Intrinsics.areEqual(filter2.getTopic(), ModCategories.Companion.default().getTopic())) {
            return true;
        }
        Object object = this.repo;
        if (object == null || (object = ((GithubAPI.Repo)object).getTopics()) == null) {
            Object object2 = this.ruleset;
            List<String> list2 = object2 != null && (object2 = ((Ruleset)object2).getModOptions()) != null ? ((ModOptions)object2).getTopics() : null;
            object = list2;
            Intrinsics.checkNotNull(list2);
        }
        Object modTopics = object;
        return modTopics.contains(filter2.getTopic());
    }

    public final int stateSortWeight() {
        return this.hasUpdate && this.isVisual ? 3 : (this.hasUpdate ? 2 : (this.isVisual ? 1 : 0));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModUIData)) {
            return false;
        }
        return ((ModUIData)other).isInstalled() == this.isInstalled() && Intrinsics.areEqual(((ModUIData)other).name, this.name);
    }

    public int hashCode() {
        return this.name.hashCode() * (this.isInstalled() ? 31 : 19);
    }
}

