/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.IdChecker;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.multiplayerscreens.EditFriendScreenKt;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/EditFriendScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "selectedFriend", "Lcom/unciv/logic/multiplayer/FriendList$Friend;", "(Lcom/unciv/logic/multiplayer/FriendList$Friend;)V", "core"})
@SourceDebugExtension(value={"SMAP\nEditFriendScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditFriendScreen.kt\ncom/unciv/ui/screens/multiplayerscreens/EditFriendScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class EditFriendScreen
extends PickerScreen {
    public EditFriendScreen(final @NotNull FriendList.Friend selectedFriend) {
        Actor actor;
        Intrinsics.checkNotNullParameter(selectedFriend, "selectedFriend");
        super(false, 1, null);
        final UncivTextField friendNameTextField = new UncivTextField("Please input a name for your friend!", selectedFriend.getName(), null, 4, null);
        TextButton pastePlayerIDButton = Scene2dExtensionsKt.toTextButton$default("Player ID from clipboard", null, false, 3, null);
        final UncivTextField playerIDTextField = new UncivTextField("Please input a player ID for your friend!", selectedFriend.getPlayerID(), null, 4, null);
        TextButton deleteFriendButton = Scene2dExtensionsKt.toTextButton$default("Delete", null, false, 3, null);
        final FriendList friendlist = new FriendList();
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Friend name")).row();
        this.getTopTable().add((Actor)friendNameTextField).pad(10.0f).padBottom(30.0f).width(this.getStage().getWidth() / (float)2).row();
        ActivationExtensionsKt.onClick(pastePlayerIDButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                playerIDTextField.setText(Gdx.app.getClipboard().getContents());
            }
        });
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Player ID")).row();
        Table gameIDTable = new Table();
        gameIDTable.add((Actor)playerIDTextField).pad(10.0f).width((float)2 * this.getStage().getWidth() / (float)3 - pastePlayerIDButton.getWidth());
        gameIDTable.add((Actor)pastePlayerIDButton);
        this.getTopTable().add((Actor)gameIDTable).padBottom(30.0f).row();
        Actor $this$_init__u24lambda_u240 = actor = ActivationExtensionsKt.onClick(deleteFriendButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                ConfirmPopup askPopup2 = new ConfirmPopup(this, "Are you sure you want to delete this friend?", "Delete", false, null, (Function0)new Function0<Unit>(friendlist, selectedFriend){
                    final /* synthetic */ FriendList $friendlist;
                    final /* synthetic */ FriendList.Friend $selectedFriend;
                    {
                        this.$friendlist = $friendlist;
                        this.$selectedFriend = $selectedFriend;
                        super(0);
                    }

                    public final void invoke() {
                        this.$friendlist.delete(this.$selectedFriend);
                        EditFriendScreenKt.goBack();
                    }
                }, 24, null);
                Popup.open$default(askPopup2, false, 1, null);
            }
        });
        boolean bl = false;
        $this$_init__u24lambda_u240.setColor(Color.RED);
        this.getTopTable().add((Actor)deleteFriendButton);
        this.getCloseButton().setText(TranslationsKt.tr$default("Back", false, 1, null));
        ActivationExtensionsKt.onClick(this.getCloseButton(), 4.INSTANCE);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Save", false, 1, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        ActivationExtensionsKt.onClick(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (Intrinsics.areEqual(selectedFriend.getName(), friendNameTextField.getText()) && Intrinsics.areEqual(selectedFriend.getPlayerID(), playerIDTextField.getText())) {
                    EditFriendScreenKt.goBack();
                }
                String string = friendNameTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string, "friendNameTextField.text");
                if (friendlist.isFriendNameInFriendList(string) == FriendList.ErrorType.ALREADYINLIST) {
                    String string2 = playerIDTextField.getText();
                    Intrinsics.checkNotNullExpressionValue(string2, "playerIDTextField.text");
                    if (friendlist.isFriendIDInFriendList(string2) == FriendList.ErrorType.ALREADYINLIST) {
                        new ToastPopup("Player name already used!", this, 0L, 4, null);
                        return;
                    }
                }
                String string3 = playerIDTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string3, "playerIDTextField.text");
                if (friendlist.isFriendIDInFriendList(string3) == FriendList.ErrorType.ALREADYINLIST) {
                    String string4 = friendNameTextField.getText();
                    Intrinsics.checkNotNullExpressionValue(string4, "friendNameTextField.text");
                    if (friendlist.isFriendNameInFriendList(string4) == FriendList.ErrorType.ALREADYINLIST) {
                        new ToastPopup("Player ID already used!", this, 0L, 4, null);
                        return;
                    }
                }
                try {
                    String string5 = playerIDTextField.getText();
                    Intrinsics.checkNotNullExpressionValue(string5, "playerIDTextField.text");
                    UUID.fromString(IdChecker.INSTANCE.checkAndReturnPlayerUuid(string5));
                }
                catch (Exception _) {
                    new ToastPopup("Player ID is incorrect", this, 0L, 4, null);
                    return;
                }
                String string6 = friendNameTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string6, "friendNameTextField.text");
                String string7 = playerIDTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string7, "playerIDTextField.text");
                friendlist.edit(selectedFriend, string6, string7);
                EditFriendScreenKt.goBack();
            }
        });
    }
}

