/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.multiplayer.HasMultiplayerGameName;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateEnded;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateFailed;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateStarted;
import com.unciv.logic.multiplayer.MultiplayerGameUpdateSucceeded;
import com.unciv.logic.multiplayer.MultiplayerGameUpdated;
import com.unciv.logic.multiplayer.OnlineMultiplayerKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0011\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u0004H\u0002J\u0013\u0010/\u001a\u0002002\b\u0010,\u001a\u0004\u0018\u000101H\u0096\u0002J\b\u00102\u001a\u00020+H\u0016J\u0006\u00103\u001a\u000200J\u0010\u00104\u001a\u00020\f2\u0006\u00105\u001a\u000200H\u0002J\b\u00106\u001a\u00020\fH\u0002R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0011R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0011\u00a8\u00067"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/GameDisplay;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "", "multiplayerGameName", "", "preview", "Lcom/unciv/logic/GameInfoPreview;", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSelected", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lcom/unciv/logic/GameInfoPreview;Ljava/lang/Exception;Lkotlin/jvm/functions/Function1;)V", "errorIndicator", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getErrorIndicator", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "getEvents", "()Lcom/unciv/logic/event/EventBus$EventReceiver;", "gameButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getGameButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "<set-?>", "gameName", "getGameName", "()Ljava/lang/String;", "getPreview", "()Lcom/unciv/logic/GameInfoPreview;", "setPreview", "(Lcom/unciv/logic/GameInfoPreview;)V", "refreshIndicator", "getRefreshIndicator", "statusIndicators", "Lcom/badlogic/gdx/scenes/scene2d/ui/HorizontalGroup;", "getStatusIndicators", "()Lcom/badlogic/gdx/scenes/scene2d/ui/HorizontalGroup;", "turnIndicator", "getTurnIndicator", "compareTo", "", "other", "createIndicator", "imagePath", "equals", "", "", "hashCode", "isPlayersTurn", "updateErrorIndicator", "hasError", "updateTurnIndicator", "core"})
final class GameDisplay
extends Table
implements Comparable<GameDisplay> {
    @Nullable
    private GameInfoPreview preview;
    @NotNull
    private final Function1<String, Unit> onSelected;
    @NotNull
    private String gameName;
    @NotNull
    private final TextButton gameButton;
    @NotNull
    private final Actor turnIndicator;
    @NotNull
    private final Actor errorIndicator;
    @NotNull
    private final Actor refreshIndicator;
    @NotNull
    private final HorizontalGroup statusIndicators;
    @NotNull
    private final EventBus.EventReceiver events;

    public GameDisplay(@NotNull String multiplayerGameName, @Nullable GameInfoPreview preview, @Nullable Exception error2, @NotNull Function1<? super String, Unit> onSelected) {
        Intrinsics.checkNotNullParameter(multiplayerGameName, "multiplayerGameName");
        Intrinsics.checkNotNullParameter(onSelected, "onSelected");
        this.preview = preview;
        this.onSelected = onSelected;
        this.gameName = multiplayerGameName;
        this.gameButton = new TextButton(this.gameName, BaseScreen.Companion.getSkin());
        this.turnIndicator = this.createIndicator("OtherIcons/ExclamationMark");
        this.errorIndicator = this.createIndicator("StatIcons/Malcontent");
        this.refreshIndicator = this.createIndicator("EmojiIcons/Turn");
        this.statusIndicators = new HorizontalGroup();
        this.events = new EventBus.EventReceiver();
        this.padBottom(5.0f);
        this.updateTurnIndicator();
        this.updateErrorIndicator(error2 != null);
        this.add((Actor)this.statusIndicators);
        this.add((Actor)this.gameButton);
        ActivationExtensionsKt.onClick(this, new Function0<Unit>(){

            @Override
            public final void invoke() {
                onSelected.invoke(this.getGameName());
            }
        });
        Function1 isOurGame2 = new Function1<HasMultiplayerGameName, Boolean>(this){
            final /* synthetic */ GameDisplay this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HasMultiplayerGameName it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getName(), this.this$0.getGameName());
            }
        };
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateStarted.class), isOurGame2, (Function1)new Function1<MultiplayerGameUpdateStarted, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateStarted it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.getStatusIndicators().addActor(this.getRefreshIndicator());
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateEnded.class), isOurGame2, (Function1)new Function1<MultiplayerGameUpdateEnded, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateEnded it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.getRefreshIndicator().remove();
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdated.class), isOurGame2, (Function1)new Function1<MultiplayerGameUpdated, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdated it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.setPreview(it.getPreview());
                this.updateTurnIndicator();
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateSucceeded.class), isOurGame2, (Function1)new Function1<MultiplayerGameUpdateSucceeded, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateSucceeded it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.updateErrorIndicator(false);
            }
        });
        this.events.receive(Reflection.getOrCreateKotlinClass(MultiplayerGameUpdateFailed.class), isOurGame2, (Function1)new Function1<MultiplayerGameUpdateFailed, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameUpdateFailed it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.updateErrorIndicator(true);
            }
        });
    }

    @Nullable
    public final GameInfoPreview getPreview() {
        return this.preview;
    }

    public final void setPreview(@Nullable GameInfoPreview gameInfoPreview) {
        this.preview = gameInfoPreview;
    }

    @NotNull
    public final String getGameName() {
        return this.gameName;
    }

    @NotNull
    public final TextButton getGameButton() {
        return this.gameButton;
    }

    @NotNull
    public final Actor getTurnIndicator() {
        return this.turnIndicator;
    }

    @NotNull
    public final Actor getErrorIndicator() {
        return this.errorIndicator;
    }

    @NotNull
    public final Actor getRefreshIndicator() {
        return this.refreshIndicator;
    }

    @NotNull
    public final HorizontalGroup getStatusIndicators() {
        return this.statusIndicators;
    }

    @NotNull
    public final EventBus.EventReceiver getEvents() {
        return this.events;
    }

    private final void updateTurnIndicator() {
        if (this.isPlayersTurn()) {
            this.statusIndicators.addActor(this.turnIndicator);
        } else {
            this.turnIndicator.remove();
        }
    }

    private final void updateErrorIndicator(boolean hasError) {
        if (hasError) {
            this.statusIndicators.addActor(this.errorIndicator);
        } else {
            this.errorIndicator.remove();
        }
    }

    private final Actor createIndicator(String imagePath) {
        Image image2 = ImageGetter.INSTANCE.getImage(imagePath);
        Scene2dExtensionsKt.setSize(image2, 50.0f);
        Container<Actor> container = new Container<Actor>((Actor)image2);
        container.padRight(5.0f);
        return container;
    }

    public final boolean isPlayersTurn() {
        GameInfoPreview gameInfoPreview = this.preview;
        return gameInfoPreview != null ? OnlineMultiplayerKt.isUsersTurn(gameInfoPreview) : false;
    }

    @Override
    public int compareTo(@NotNull GameDisplay other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.isPlayersTurn() != other.isPlayersTurn() ? Boolean.compare(other.isPlayersTurn(), this.isPlayersTurn()) : this.gameName.compareTo(other.gameName);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof GameDisplay && Intrinsics.areEqual(this.gameName, ((GameDisplay)other).gameName);
    }

    public int hashCode() {
        return this.gameName.hashCode();
    }
}

