/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.unciv.UncivGame;
import com.unciv.logic.event.EventBus;
import com.unciv.logic.multiplayer.MultiplayerGameNameChanged;
import com.unciv.logic.multiplayer.OnlineMultiplayerGame;
import com.unciv.ui.screens.multiplayerscreens.GameDisplay;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/GameList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/VerticalGroup;", "onSelected", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "events", "Lcom/unciv/logic/event/EventBus$EventReceiver;", "gameDisplays", "", "Lcom/unciv/ui/screens/multiplayerscreens/GameDisplay;", "getOnSelected", "()Lkotlin/jvm/functions/Function1;", "update", "core"})
public final class GameList
extends VerticalGroup {
    @NotNull
    private final Function1<String, Unit> onSelected;
    @NotNull
    private final Map<String, GameDisplay> gameDisplays;
    @NotNull
    private final EventBus.EventReceiver events;

    public GameList(@NotNull Function1<? super String, Unit> onSelected) {
        Intrinsics.checkNotNullParameter(onSelected, "onSelected");
        this.onSelected = onSelected;
        this.gameDisplays = new LinkedHashMap();
        this.events = new EventBus.EventReceiver();
        this.padTop(10.0f);
        this.padBottom(10.0f);
        EventBus.EventReceiver.receive$default(this.events, Reflection.getOrCreateKotlinClass(MultiplayerGameNameChanged.class), null, new Function1<MultiplayerGameNameChanged, Unit>(){

            @Override
            public final void invoke(@NotNull MultiplayerGameNameChanged it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.update();
            }
        }, 2, null);
        this.update();
    }

    @NotNull
    public final Function1<String, Unit> getOnSelected() {
        return this.onSelected;
    }

    public final void update() {
        this.clearChildren();
        this.gameDisplays.clear();
        for (OnlineMultiplayerGame game : UncivGame.Companion.getCurrent().getOnlineMultiplayer().getGames()) {
            String string = game.getName();
            Intrinsics.checkNotNullExpressionValue(string, "game.name");
            GameDisplay gameDisplay = new GameDisplay(string, game.getPreview(), game.getError(), this.onSelected);
            Map<String, GameDisplay> map2 = this.gameDisplays;
            String string2 = game.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "game.name");
            map2.put(string2, gameDisplay);
            this.addActor(gameDisplay);
        }
        this.getChildren().sort();
    }
}

