/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.multiplayer.OnlineMultiplayer;
import com.unciv.logic.multiplayer.OnlineMultiplayerGame;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerHelpers;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/MultiplayerHelpers;", "", "()V", "buildDescriptionText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "multiplayerGame", "Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;", "loadMultiplayerGame", "", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "selectedGame", "showDropboxWarning", "core"})
public final class MultiplayerHelpers {
    @NotNull
    public static final MultiplayerHelpers INSTANCE = new MultiplayerHelpers();

    private MultiplayerHelpers() {
    }

    public final void loadMultiplayerGame(@NotNull BaseScreen screen, @NotNull OnlineMultiplayerGame selectedGame) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(selectedGame, "selectedGame");
        Popup loadingGamePopup = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(loadingGamePopup, "Loading latest game state...", 0, false, 6, null);
        Popup.open$default(loadingGamePopup, false, 1, null);
        Concurrency.run$default(Concurrency.INSTANCE, "JoinMultiplayerGame", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedGame, loadingGamePopup, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ OnlineMultiplayerGame $selectedGame;
            final /* synthetic */ Popup $loadingGamePopup;
            {
                this.$selectedGame = $selectedGame;
                this.$loadingGamePopup = $loadingGamePopup;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        this.L$0 = $this$run;
                        this.label = 1;
                        Object object3 = UncivGame.Companion.getCurrent().getOnlineMultiplayer().loadGame(this.$selectedGame, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            String message2 = (String)LoadGameScreen.Companion.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, 2, null).component1();
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingGamePopup, message2, null){
                                int label;
                                final /* synthetic */ Popup $loadingGamePopup;
                                final /* synthetic */ String $message;
                                {
                                    this.$loadingGamePopup = $loadingGamePopup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$loadingGamePopup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @NotNull
    public final StringBuilder buildDescriptionText(@NotNull OnlineMultiplayerGame multiplayerGame) {
        GameInfoPreview preview;
        CharSequence message2;
        Intrinsics.checkNotNullParameter(multiplayerGame, "multiplayerGame");
        StringBuilder descriptionText = new StringBuilder();
        Exception ex = multiplayerGame.getError();
        if (ex != null) {
            message2 = LoadGameScreen.Companion.getLoadExceptionMessage(ex, "Error while refreshing:").component1();
            StringBuilder stringBuilder = descriptionText.append((String)message2);
            Intrinsics.checkNotNullExpressionValue(stringBuilder, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder.append('\n'), "append('\\n')");
        }
        Instant lastUpdate = multiplayerGame.getLastUpdate();
        message2 = descriptionText;
        StringBuilder stringBuilder = new StringBuilder().append("Last refresh: [");
        Duration duration = Duration.between(lastUpdate, Instant.now());
        Intrinsics.checkNotNullExpressionValue(duration, "between(lastUpdate, Instant.now())");
        StringBuilder stringBuilder2 = ((StringBuilder)message2).append(TranslationsKt.tr$default(stringBuilder.append(FormattingExtensionsKt.formatShort(duration)).append("] ago").toString(), false, 1, null));
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        GameInfoPreview gameInfoPreview = preview = multiplayerGame.getPreview();
        if ((gameInfoPreview != null ? gameInfoPreview.getCurrentPlayer() : null) != null) {
            Instant currentTurnStartTime = Instant.ofEpochMilli(preview.getCurrentTurnStartTime());
            StringBuilder stringBuilder3 = descriptionText;
            StringBuilder stringBuilder4 = new StringBuilder().append("Current Turn: [").append(preview.getCurrentPlayer()).append("] since [");
            Duration duration2 = Duration.between(currentTurnStartTime, Instant.now());
            Intrinsics.checkNotNullExpressionValue(duration2, "between(currentTurnStartTime, Instant.now())");
            StringBuilder stringBuilder5 = stringBuilder3.append(TranslationsKt.tr$default(stringBuilder4.append(FormattingExtensionsKt.formatShort(duration2)).append("] ago").toString(), false, 1, null));
            Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
        }
        return descriptionText;
    }

    public final void showDropboxWarning(@NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(screen, "screen");
        if (!OnlineMultiplayer.Companion.usesDropbox() || UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getHideDropboxWarning()) {
            return;
        }
        Popup dropboxWarning = new Popup(screen, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(dropboxWarning, "You're currently using the default multiplayer server, which is based on a free Dropbox account. Because a lot of people use this, it is uncertain if you'll actually be able to access it consistently. Consider using a custom server instead.", 0, false, 6, null).colspan(2).row();
        Popup.addButton$default(dropboxWarning, "Open Documentation", null, null, (Function0)showDropboxWarning.1.INSTANCE, 6, null).colspan(2).row();
        CheckBox checkBox2 = Scene2dExtensionsKt.toCheckBox$default("Don't show again", false, null, 3, null);
        dropboxWarning.add((Actor)checkBox2);
        Popup.addCloseButton$default(dropboxWarning, null, null, null, new Function0<Unit>(checkBox2){
            final /* synthetic */ CheckBox $checkBox;
            {
                this.$checkBox = $checkBox;
                super(0);
            }

            public final void invoke() {
                UncivGame.Companion.getCurrent().getSettings().getMultiplayer().setHideDropboxWarning(this.$checkBox.isChecked());
            }
        }, 7, null);
        Popup.open$default(dropboxWarning, false, 1, null);
    }
}

