/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.multiplayer.OnlineMultiplayer;
import com.unciv.logic.multiplayer.OnlineMultiplayerGame;
import com.unciv.logic.multiplayer.storage.MultiplayerAuthException;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.AuthPopup;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.AddMultiplayerGameScreen;
import com.unciv.ui.screens.multiplayerscreens.GameList;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerHelpers;
import com.unciv.ui.screens.multiplayerscreens.ViewFriendsListScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.savescreens.LoadGameScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\u0006\u0010\u0019\u001a\u00020\u0004J\u0006\u0010\u001a\u001a\u00020\u0004J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0006\u0010\u001c\u001a\u00020\u0004J\u0006\u0010\u001d\u001a\u00020\u0004J\u0006\u0010\u001e\u001a\u00020\u0004J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0015H\u0002J\u000e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020#J\b\u0010(\u001a\u00020!H\u0002J\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/MultiplayerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "()V", "addGameButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "copyGameIdButton", "copyUserIdButton", "deleteButton", "friendsListButton", "gameList", "Lcom/unciv/ui/screens/multiplayerscreens/GameList;", "getGameList", "()Lcom/unciv/ui/screens/multiplayerscreens/GameList;", "gameSpecificButtons", "", "refreshButton", "renameButton", "resignButton", "rightSideTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "selectedGame", "Lcom/unciv/logic/multiplayer/OnlineMultiplayerGame;", "createAddGameButton", "createCopyGameIdButton", "createCopyUserIdButton", "createDeleteButton", "createFriendsListButton", "createMainContent", "createRefreshButton", "createRenameButton", "createResignButton", "createRightSideTable", "onGameDeleted", "", "gameName", "", "resign", "multiplayerGame", "selectGame", "name", "setupHelpButton", "setupRightSideButton", "unselectGame", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerScreen.kt\ncom/unciv/ui/screens/multiplayerscreens/MultiplayerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,314:1\n1#2:315\n*E\n"})
public final class MultiplayerScreen
extends PickerScreen {
    @Nullable
    private OnlineMultiplayerGame selectedGame;
    @NotNull
    private final TextButton copyGameIdButton = this.createCopyGameIdButton();
    @NotNull
    private final TextButton resignButton = this.createResignButton();
    @NotNull
    private final TextButton deleteButton = this.createDeleteButton();
    @NotNull
    private final TextButton renameButton = this.createRenameButton();
    @NotNull
    private final List<TextButton> gameSpecificButtons;
    @NotNull
    private final TextButton addGameButton;
    @NotNull
    private final TextButton copyUserIdButton;
    @NotNull
    private final TextButton friendsListButton;
    @NotNull
    private final TextButton refreshButton;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final GameList gameList;

    public MultiplayerScreen() {
        super(false, 1, null);
        TextButton[] textButtonArray = new TextButton[]{this.copyGameIdButton, this.resignButton, this.deleteButton, this.renameButton};
        this.gameSpecificButtons = CollectionsKt.listOf(textButtonArray);
        this.addGameButton = this.createAddGameButton();
        this.copyUserIdButton = this.createCopyUserIdButton();
        this.friendsListButton = this.createFriendsListButton();
        this.refreshButton = this.createRefreshButton();
        this.rightSideTable = this.createRightSideTable();
        this.gameList = new GameList((Function1<? super String, Unit>)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((MultiplayerScreen)this.receiver).selectGame(p0);
            }
        });
        this.setDefaultCloseAction();
        this.getScrollPane().setScrollingDisabled(false, true);
        this.getTopTable().add((Actor)this.createMainContent()).row();
        this.setupHelpButton();
        this.setupRightSideButton();
        OnlineMultiplayer.requestUpdate$default(this.getGame().getOnlineMultiplayer(), false, null, 3, null);
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "MultiplayerScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getTopTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "MultiplayerScreen/TopTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
    }

    @NotNull
    public final GameList getGameList() {
        return this.gameList;
    }

    public final void onGameDeleted(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        OnlineMultiplayerGame onlineMultiplayerGame = this.selectedGame;
        if (Intrinsics.areEqual(onlineMultiplayerGame != null ? onlineMultiplayerGame.getName() : null, gameName)) {
            this.unselectGame();
        }
        this.gameList.update();
    }

    private final void setupRightSideButton() {
        this.getRightSideButton().setText(TranslationsKt.tr$default("Join game", false, 1, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BaseScreen baseScreen = this.this$0;
                OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                Intrinsics.checkNotNull(onlineMultiplayerGame);
                MultiplayerHelpers.INSTANCE.loadMultiplayerGame(baseScreen, onlineMultiplayerGame);
            }
        });
    }

    private final Table createRightSideTable() {
        Table table2;
        Table table3;
        Table table4 = new Table();
        table4.defaults().uniformX();
        table4.defaults().fillX();
        table4.defaults().pad(10.0f);
        Table $this$createRightSideTable_u24lambda_u240 = table3 = new Table();
        boolean bl = false;
        $this$createRightSideTable_u24lambda_u240.defaults().pad(10.0f);
        Table gameSpecificActions = table3;
        gameSpecificActions.add((Actor)this.copyGameIdButton).row();
        gameSpecificActions.add((Actor)this.renameButton).row();
        gameSpecificActions.add((Actor)this.resignButton).row();
        gameSpecificActions.add((Actor)this.deleteButton).row();
        table4.add((Actor)gameSpecificActions);
        Table $this$createRightSideTable_u24lambda_u241 = table2 = new Table();
        boolean bl2 = false;
        $this$createRightSideTable_u24lambda_u241.defaults().pad(10.0f);
        Table generalActions = table2;
        generalActions.add((Actor)this.copyUserIdButton).row();
        generalActions.add((Actor)this.addGameButton).row();
        generalActions.add((Actor)this.friendsListButton).row();
        generalActions.add((Actor)this.refreshButton).row();
        table4.add((Actor)generalActions);
        return table4;
    }

    @NotNull
    public final TextButton createRefreshButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Refresh list", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                OnlineMultiplayer.requestUpdate$default(this.this$0.getGame().getOnlineMultiplayer(), false, null, 3, null);
            }
        });
        return btn;
    }

    @NotNull
    public final TextButton createAddGameButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Add multiplayer game", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().pushScreen(new AddMultiplayerGameScreen(this.this$0));
            }
        });
        return btn;
    }

    @NotNull
    public final TextButton createResignButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createResignButton_u24lambda_u242 = textButton = Scene2dExtensionsKt.toTextButton$default("Resign", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createResignButton_u24lambda_u242);
        TextButton resignButton = textButton;
        ActivationExtensionsKt.onClick(resignButton, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConfirmPopup askPopup2 = new ConfirmPopup(this.this$0, "Are you sure you want to resign?", "Resign", false, null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ MultiplayerScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                        Intrinsics.checkNotNull(onlineMultiplayerGame);
                        MultiplayerScreen.access$resign(this.this$0, onlineMultiplayerGame);
                    }
                }, 24, null);
                Popup.open$default(askPopup2, false, 1, null);
            }
        });
        return resignButton;
    }

    private final void resign(OnlineMultiplayerGame multiplayerGame) {
        Popup popup2 = new Popup(this, null, 0.0f, 6, null);
        Popup.addGoodSizedLabel$default(popup2, "Working...", 0, false, 6, null).row();
        Popup.open$default(popup2, false, 1, null);
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("Resign", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, multiplayerGame, popup2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MultiplayerScreen this$0;
            final /* synthetic */ OnlineMultiplayerGame $multiplayerGame;
            final /* synthetic */ Popup $popup;
            {
                this.this$0 = $receiver;
                this.$multiplayerGame = $multiplayerGame;
                this.$popup = $popup;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        this.L$0 = $this$runOnNonDaemonThreadPool;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().resign(this.$multiplayerGame, this);
                        ** if (v0 != var5_2) goto lbl13
lbl12:
                        // 1 sources

                        return var5_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl20:
                            // 2 sources

                            ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>((resignSuccess = ((Boolean)v0).booleanValue()) != false, this.$popup, this.this$0, null){
                                int label;
                                final /* synthetic */ boolean $resignSuccess;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ MultiplayerScreen this$0;
                                {
                                    this.$resignSuccess = $resignSuccess;
                                    this.$popup = $popup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            if (this.$resignSuccess) {
                                                this.$popup.close();
                                                this.this$0.getGame().popScreen();
                                            } else {
                                                this.$popup.reuseWith("You can only resign if it's your turn", true);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception ex) {
                            message = (String)LoadGameScreen.Companion.getLoadExceptionMessage$default(LoadGameScreen.Companion, ex, null, 2, null).component1();
                            if (ex instanceof MultiplayerAuthException) {
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$multiplayerGame, null){
                                    int label;
                                    final /* synthetic */ MultiplayerScreen this$0;
                                    final /* synthetic */ OnlineMultiplayerGame $multiplayerGame;
                                    {
                                        this.this$0 = $receiver;
                                        this.$multiplayerGame = $multiplayerGame;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                new AuthPopup(this.this$0, (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(this.this$0, this.$multiplayerGame){
                                                    final /* synthetic */ MultiplayerScreen this$0;
                                                    final /* synthetic */ OnlineMultiplayerGame $multiplayerGame;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$multiplayerGame = $multiplayerGame;
                                                        super(1);
                                                    }

                                                    public final void invoke(boolean success) {
                                                        if (success) {
                                                            MultiplayerScreen.access$resign(this.this$0, this.$multiplayerGame);
                                                        }
                                                    }
                                                }).open(true);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                                return Unit.INSTANCE;
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$popup, message, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ String $message;
                                {
                                    this.$popup = $popup;
                                    this.$message = $message;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$popup.reuseWith(this.$message, true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final TextButton createDeleteButton() {
        TextButton textButton;
        TextButton.TextButtonStyle negativeButtonStyle = BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class);
        TextButton $this$createDeleteButton_u24lambda_u243 = textButton = Scene2dExtensionsKt.toTextButton$default("Delete save", negativeButtonStyle, false, 2, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createDeleteButton_u24lambda_u243);
        TextButton deleteButton = textButton;
        ActivationExtensionsKt.onClick(deleteButton, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ConfirmPopup askPopup2 = new ConfirmPopup(this.this$0, "Are you sure you want to delete this save?", "Delete save", false, null, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ MultiplayerScreen this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            OnlineMultiplayer onlineMultiplayer = this.this$0.getGame().getOnlineMultiplayer();
                            OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                            Intrinsics.checkNotNull(onlineMultiplayerGame);
                            onlineMultiplayer.deleteGame(onlineMultiplayerGame);
                            OnlineMultiplayerGame onlineMultiplayerGame2 = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                            Intrinsics.checkNotNull(onlineMultiplayerGame2);
                            String string = onlineMultiplayerGame2.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "selectedGame!!.name");
                            this.this$0.onGameDeleted(string);
                        }
                        catch (Exception ex) {
                            Log.INSTANCE.error("Could not delete game!", ex);
                            new ToastPopup("Could not delete game!", this.this$0, 0L, 4, null);
                        }
                    }
                }, 24, null);
                Popup.open$default(askPopup2, false, 1, null);
            }
        });
        return deleteButton;
    }

    @NotNull
    public final TextButton createRenameButton() {
        TextButton textButton;
        TextButton $this$createRenameButton_u24lambda_u244 = textButton = Scene2dExtensionsKt.toTextButton$default("Rename", null, false, 3, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createRenameButton_u24lambda_u244);
        TextButton btn = textButton;
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Popup popup2 = new Popup(this.this$0, null, 0.0f, 6, null);
                MultiplayerScreen multiplayerScreen = this.this$0;
                Popup $this$invoke_u24lambda_u240 = popup2;
                boolean bl = false;
                OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(multiplayerScreen);
                Intrinsics.checkNotNull(onlineMultiplayerGame);
                String string = onlineMultiplayerGame.getName();
                Intrinsics.checkNotNullExpressionValue(string, "selectedGame!!.name");
                UncivTextField textField = new UncivTextField("Game name", string, null, 4, null);
                $this$invoke_u24lambda_u240.add((Actor)textField).width($this$invoke_u24lambda_u240.getStageToShowOn().getWidth() / (float)2).row();
                TextButton saveButton = Scene2dExtensionsKt.toTextButton$default("Save", null, false, 3, null);
                Function0 saveNewNameFunction2 = new Function0<Unit>(textField, multiplayerScreen, $this$invoke_u24lambda_u240){
                    final /* synthetic */ UncivTextField $textField;
                    final /* synthetic */ MultiplayerScreen this$0;
                    final /* synthetic */ Popup $this_apply;
                    {
                        this.$textField = $textField;
                        this.this$0 = $receiver;
                        this.$this_apply = $receiver2;
                        super(0);
                    }

                    public final void invoke() {
                        String string = this.$textField.getText();
                        Intrinsics.checkNotNullExpressionValue(string, "textField.text");
                        String newName = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        OnlineMultiplayer onlineMultiplayer = this.this$0.getGame().getOnlineMultiplayer();
                        OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                        Intrinsics.checkNotNull(onlineMultiplayerGame);
                        onlineMultiplayer.changeGameName(onlineMultiplayerGame, newName, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(this.$this_apply){
                            final /* synthetic */ Popup $this_apply;
                            {
                                this.$this_apply = $receiver;
                                super(1);
                            }

                            public final void invoke(@Nullable Exception it) {
                                if (it != null) {
                                    this.$this_apply.reuseWith("Could not save game!", true);
                                }
                            }
                        });
                        this.this$0.getGameList().update();
                        this.this$0.selectGame(newName);
                        this.$this_apply.close();
                    }
                };
                ActivationExtensionsKt.onActivation(saveButton, saveNewNameFunction2);
                ActivationExtensionsKt.getKeyShortcuts(saveButton).add(KeyCharAndCode.Companion.getRETURN());
                textField.setCursorPosition(textField.getText().length());
                multiplayerScreen.getStage().setKeyboardFocus(textField);
                $this$invoke_u24lambda_u240.add((Actor)saveButton);
                Popup.open$default($this$invoke_u24lambda_u240, false, 1, null);
            }
        });
        return btn;
    }

    @NotNull
    public final TextButton createCopyGameIdButton() {
        TextButton textButton;
        TextButton $this$createCopyGameIdButton_u24lambda_u245 = textButton = Scene2dExtensionsKt.toTextButton$default("Copy game ID", null, false, 3, null);
        boolean bl = false;
        Scene2dExtensionsKt.disable($this$createCopyGameIdButton_u24lambda_u245);
        TextButton btn = textButton;
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GameInfoPreview gameInfo2;
                OnlineMultiplayerGame onlineMultiplayerGame = MultiplayerScreen.access$getSelectedGame$p(this.this$0);
                GameInfoPreview gameInfoPreview = gameInfo2 = onlineMultiplayerGame != null ? onlineMultiplayerGame.getPreview() : null;
                if (gameInfo2 != null) {
                    Gdx.app.getClipboard().setContents(gameInfo2.getGameId());
                    new ToastPopup("Game ID copied to clipboard!", this.this$0, 0L, 4, null);
                }
            }
        });
        return btn;
    }

    @NotNull
    public final TextButton createFriendsListButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Friends list", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().pushScreen(new ViewFriendsListScreen());
            }
        });
        return btn;
    }

    private final TextButton createCopyUserIdButton() {
        TextButton btn = Scene2dExtensionsKt.toTextButton$default("Copy user ID", null, false, 3, null);
        ActivationExtensionsKt.onClick(btn, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Gdx.app.getClipboard().setContents(this.this$0.getGame().getSettings().getMultiplayer().getUserId());
                new ToastPopup("UserID copied to clipboard", this.this$0, 0L, 4, null);
            }
        });
        return btn;
    }

    /*
     * WARNING - void declaration
     */
    private final Table createMainContent() {
        void $this$createMainContent_u24lambda_u246;
        AutoScrollPane autoScrollPane;
        Table mainTable = new Table();
        AutoScrollPane autoScrollPane2 = autoScrollPane = new AutoScrollPane((Actor)this.gameList, null, 2, null);
        Table table2 = mainTable;
        boolean bl = false;
        $this$createMainContent_u24lambda_u246.setScrollingDisabled(true, false);
        table2.add((Actor)autoScrollPane).center();
        mainTable.add((Actor)this.rightSideTable);
        return mainTable;
    }

    private final void setupHelpButton() {
        Table tab = new Table();
        TextButton helpButton = Scene2dExtensionsKt.toTextButton$default("Help", null, false, 3, null);
        ActivationExtensionsKt.onClick(helpButton, new Function0<Unit>(this){
            final /* synthetic */ MultiplayerScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Popup helpPopup = new Popup(this.this$0, null, 0.0f, 6, null);
                Popup.addGoodSizedLabel$default(helpPopup, "To create a multiplayer game, check the 'multiplayer' toggle in the New Game screen, and for each human player insert that player's user ID.", 0, false, 6, null).row();
                Popup.addGoodSizedLabel$default(helpPopup, "You can assign your own user ID there easily, and other players can copy their user IDs here and send them to you for you to include them in the game.", 0, false, 6, null).row();
                helpPopup.row();
                Popup.addGoodSizedLabel$default(helpPopup, "Once you've created your game, the Game ID gets automatically copied to your clipboard so you can send it to the other players.", 0, false, 6, null).row();
                Popup.addGoodSizedLabel$default(helpPopup, "Players can enter your game by copying the game ID to the clipboard, and clicking on the 'Add multiplayer game' button", 0, false, 6, null).row();
                helpPopup.row();
                Popup.addGoodSizedLabel$default(helpPopup, "The symbol of your nation will appear next to the game when it's your turn", 0, false, 6, null).row();
                Popup.addCloseButton$default(helpPopup, null, null, null, null, 15, null);
                Popup.open$default(helpPopup, false, 1, null);
            }
        });
        tab.add((Actor)helpButton);
        tab.setX(this.getStage().getWidth() - helpButton.getWidth());
        tab.setY(this.getStage().getHeight() - helpButton.getHeight());
        this.getStage().addActor(tab);
    }

    private final void unselectGame() {
        this.selectedGame = null;
        Scene2dExtensionsKt.disable(this.getRightSideButton());
        for (TextButton button : this.gameSpecificButtons) {
            Scene2dExtensionsKt.disable(button);
        }
        this.getDescriptionLabel().setText("");
    }

    public final void selectGame(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        OnlineMultiplayerGame multiplayerGame = this.getGame().getOnlineMultiplayer().getGameByName(name2);
        if (multiplayerGame == null) {
            this.unselectGame();
            return;
        }
        this.selectedGame = multiplayerGame;
        for (TextButton button : this.gameSpecificButtons) {
            Scene2dExtensionsKt.enable(button);
        }
        if (multiplayerGame.getPreview() != null) {
            Scene2dExtensionsKt.enable(this.copyGameIdButton);
        } else {
            Scene2dExtensionsKt.disable(this.copyGameIdButton);
        }
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        this.getDescriptionLabel().setText(MultiplayerHelpers.INSTANCE.buildDescriptionText(multiplayerGame));
    }

    public static final /* synthetic */ OnlineMultiplayerGame access$getSelectedGame$p(MultiplayerScreen $this) {
        return $this.selectedGame;
    }

    public static final /* synthetic */ void access$resign(MultiplayerScreen $this, OnlineMultiplayerGame multiplayerGame) {
        $this.resign(multiplayerGame);
    }
}

