/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.models.metadata.Player;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.FriendPickerList;
import com.unciv.ui.screens.newgamescreen.PlayerPickerTable;
import com.unciv.ui.screens.pickerscreens.PickerPane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/newgamescreen/FriendSelectionPopup;", "Lcom/unciv/ui/popups/Popup;", "playerPicker", "Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;", "player", "Lcom/unciv/models/metadata/Player;", "screen", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "(Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;Lcom/unciv/models/metadata/Player;Lcom/unciv/ui/screens/basescreen/BaseScreen;)V", "pickerPane", "Lcom/unciv/ui/screens/pickerscreens/PickerPane;", "selectedFriendId", "", "friendSelected", "", "friendName", "core"})
public final class FriendSelectionPopup
extends Popup {
    @NotNull
    private final PlayerPickerTable playerPicker;
    @NotNull
    private final PickerPane pickerPane;
    @Nullable
    private String selectedFriendId;

    public FriendSelectionPopup(@NotNull PlayerPickerTable playerPicker, final @NotNull Player player, @NotNull BaseScreen screen) {
        Intrinsics.checkNotNullParameter(playerPicker, "playerPicker");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(screen, "screen");
        super(screen, null, 0.0f, 6, null);
        this.playerPicker = playerPicker;
        this.pickerPane = new PickerPane(false, 1, null);
        Cell<Actor> pickerCell = this.add().width(700.0f).fillX().expandX().minHeight(screen.getStage().getHeight() * 0.5f).maxHeight(screen.getStage().getHeight() * 0.8f);
        FriendPickerList friendList2 = new FriendPickerList(this.playerPicker, (Function1<? super String, Unit>)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                FriendSelectionPopup.access$friendSelected((FriendSelectionPopup)this.receiver, p0);
            }
        });
        this.pickerPane.getTopTable().add((Actor)friendList2);
        this.pickerPane.getRightSideButton().setText(TranslationsKt.tr$default("Select friend", false, 1, null));
        ActivationExtensionsKt.onActivation(this.pickerPane.getCloseButton(), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((FriendSelectionPopup)this.receiver).close();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.pickerPane.getCloseButton()).add(KeyCharAndCode.Companion.getBACK());
        pickerCell.setActor((Actor)this.pickerPane);
        ActivationExtensionsKt.onClick(this.pickerPane.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.close();
                String friendId = selectedFriendId;
                if (friendId != null) {
                    player.setPlayerId(String.valueOf(selectedFriendId));
                    this.close();
                    PlayerPickerTable.update$default(playerPicker, null, 1, null);
                }
            }
        });
        this.setClickBehindToClose(true);
    }

    private final void friendSelected(String friendName) {
        FriendList friendsList = new FriendList();
        FriendList.Friend friend = friendsList.getFriendByName(friendName);
        if (friend != null) {
            this.selectedFriendId = friend.getPlayerID();
        }
        this.pickerPane.setRightSideButtonEnabled(true);
        this.pickerPane.getRightSideButton().setText(TranslationsKt.tr$default("Select [" + friendName + ']', false, 1, null));
    }

    public static final /* synthetic */ void access$friendSelected(FriendSelectionPopup $this, String friendName) {
        $this.friendSelected(friendName);
    }
}

