/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.WrappableLabel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/newgamescreen/FriendTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "friend", "Lcom/unciv/logic/multiplayer/FriendList$Friend;", "width", "", "minHeight", "(Lcom/unciv/logic/multiplayer/FriendList$Friend;FF)V", "getFriend", "()Lcom/unciv/logic/multiplayer/FriendList$Friend;", "innerTable", "getInnerTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "core"})
public final class FriendTable
extends Table {
    @NotNull
    private final FriendList.Friend friend;
    @NotNull
    private final Table innerTable;

    public FriendTable(@NotNull FriendList.Friend friend, float width, float minHeight) {
        Intrinsics.checkNotNullParameter(friend, "friend");
        this.friend = friend;
        this.innerTable = new Table();
        Color innerColor = Color.WHITE;
        float totalPadding = 30.0f;
        float internalWidth = width - totalPadding;
        Table titleTable = new Table();
        String titleText = this.friend.getName();
        float friendDisplayNameMaxWidth = internalWidth - 70.0f;
        Intrinsics.checkNotNullExpressionValue(innerColor, "innerColor");
        WrappableLabel friendDisplayLabel = new WrappableLabel(titleText, friendDisplayNameMaxWidth, innerColor, 24, false, 16, null);
        if (friendDisplayLabel.getPrefWidth() > friendDisplayNameMaxWidth - 2.0f) {
            friendDisplayLabel.setWrap(true);
            titleTable.add((Actor)friendDisplayLabel).width(friendDisplayNameMaxWidth);
        } else {
            Cell<Actor> cell2 = titleTable.add((Actor)friendDisplayLabel).align(1);
            Intrinsics.checkNotNullExpressionValue(cell2, "titleTable.add(friendDis\u2026abel).align(Align.center)");
            Scene2dExtensionsKt.pad(cell2, 10.0f, 0.0f);
        }
        this.innerTable.add((Actor)titleTable).growX().fillY().row();
        this.add((Actor)this.innerTable).width(width).minHeight(minHeight - totalPadding);
        this.setTouchable(Touchable.enabled);
    }

    @NotNull
    public final FriendList.Friend getFriend() {
        return this.friend;
    }

    @NotNull
    public final Table getInnerTable() {
        return this.innerTable;
    }
}

