/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/newgamescreen/NationTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "width", "", "minHeight", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/nation/Nation;FFLcom/unciv/models/ruleset/Ruleset;)V", "innerTable", "getInnerTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getNation", "()Lcom/unciv/models/ruleset/nation/Nation;", "core"})
@SourceDebugExtension(value={"SMAP\nNationTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NationTable.kt\ncom/unciv/ui/screens/newgamescreen/NationTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n766#2:105\n857#2,2:106\n*S KotlinDebug\n*F\n+ 1 NationTable.kt\ncom/unciv/ui/screens/newgamescreen/NationTable\n*L\n57#1:105\n57#1:106,2\n*E\n"})
public final class NationTable
extends Table {
    @NotNull
    private final Nation nation;
    @NotNull
    private final Table innerTable;

    /*
     * WARNING - void declaration
     */
    public NationTable(@NotNull Nation nation2, float width, float minHeight, @Nullable Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(nation2, "nation");
        super(BaseScreen.Companion.getSkin());
        this.nation = nation2;
        this.innerTable = new Table();
        Color innerColor = this.nation.getInnerColor();
        Color outerColor = this.nation.getOuterColor();
        Color textBackgroundColor = new Color(2114303);
        float borderWidth = 5.0f;
        float totalPadding = 10.0f + (float)4 * borderWidth;
        float internalWidth = width - totalPadding;
        Table titleTable = new Table();
        titleTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/NationTable/Title", null, outerColor, 2, null));
        Portrait nationIndicator = ImageGetter.INSTANCE.getNationPortrait(this.nation, 50.0f);
        titleTable.add((Actor)nationIndicator).pad(10.0f).padLeft(0.0f);
        String titleText = ruleset2 == null || Intrinsics.areEqual(this.nation.getName(), "Random") || Intrinsics.areEqual(this.nation.getName(), "Spectator") ? this.nation.getName() : this.nation.getLeaderDisplayName();
        float leaderDisplayNameMaxWidth = internalWidth - 70.0f;
        WrappableLabel leaderDisplayLabel = new WrappableLabel(titleText, leaderDisplayNameMaxWidth, innerColor, 24, true);
        if (leaderDisplayLabel.getPrefWidth() > leaderDisplayNameMaxWidth - 2.0f) {
            leaderDisplayLabel.setWrap(true);
            titleTable.add((Actor)leaderDisplayLabel).width(leaderDisplayNameMaxWidth);
        } else {
            Cell<Actor> cell2 = titleTable.add((Actor)leaderDisplayLabel).align(1);
            Intrinsics.checkNotNullExpressionValue(cell2, "titleTable.add(leaderDis\u2026abel).align(Align.center)");
            Scene2dExtensionsKt.pad(cell2, 10.0f, 0.0f);
        }
        this.innerTable.add((Actor)titleTable).growX().fillY().row();
        if (ruleset2 != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            titleTable.padBottom(borderWidth);
            this.innerTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/NationTable/RightInnerTable", null, textBackgroundColor, 2, null));
            Iterable iterable = this.nation.getCivilopediaTextLines(ruleset2);
            boolean $i$f$filter = false;
            void var19_18 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FormattedLine it = (FormattedLine)element$iv$iv;
                boolean bl = false;
                if (!(it.getHeader() != 3)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List lines2 = (List)destination$iv$iv;
            this.innerTable.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, lines2, internalWidth, 0.0f, FormattedLine.IconDisplay.NoLink, null, 20, null)).pad(10.0f);
            Table borderTable = new Table();
            borderTable.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/NationTable/BorderTable", null, outerColor, 2, null));
            borderTable.add((Actor)this.innerTable).pad(borderWidth).grow();
            this.add((Actor)borderTable).pad(borderWidth).width(width).minHeight(minHeight - totalPadding);
        } else {
            this.add((Actor)this.innerTable).width(width).minHeight(minHeight - totalPadding);
        }
        this.setTouchable(Touchable.enabled);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/NationTable/Background", null, innerColor, 2, null));
    }

    public /* synthetic */ NationTable(Nation nation2, float f, float f2, Ruleset ruleset2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ruleset2 = null;
        }
        this(nation2, f, f2, ruleset2);
    }

    @NotNull
    public final Nation getNation() {
        return this.nation;
    }

    @NotNull
    public final Table getInnerTable() {
        return this.innerTable;
    }
}

