/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameStarter;
import com.unciv.logic.IdChecker;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.multiplayer.OnlineMultiplayer;
import com.unciv.logic.multiplayer.storage.FileStorageRateLimitReached;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.newgamescreen.AcceptModErrorsPopup;
import com.unciv.ui.screens.newgamescreen.GameOptionsTable;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.MapOptionsTable;
import com.unciv.ui.screens.newgamescreen.MapParametersTable;
import com.unciv.ui.screens.newgamescreen.PlayerPickerTable;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\r\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0006\u0010\u001e\u001a\u00020\u001cJ\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0011\u0010\"\u001a\u00020\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017J\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001cR\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/newgamescreen/NewGameScreen;", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "defaultGameSetupInfo", "Lcom/unciv/models/metadata/GameSetupInfo;", "(Lcom/unciv/models/metadata/GameSetupInfo;)V", "gameSetupInfo", "getGameSetupInfo", "()Lcom/unciv/models/metadata/GameSetupInfo;", "mapOptionsTable", "Lcom/unciv/ui/screens/newgamescreen/MapOptionsTable;", "newGameOptionsTable", "Lcom/unciv/ui/screens/newgamescreen/GameOptionsTable;", "playerPickerTable", "Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;", "getPlayerPickerTable$core", "()Lcom/unciv/ui/screens/newgamescreen/PlayerPickerTable;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "checkConnectionToMultiplayerServer", "", "getColumnWidth", "", "getColumnWidth$core", "initLandscape", "", "initPortrait", "lockTables", "onStartGameClicked", "recreate", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "startNewGame", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tryUpdateRuleset", "updateUI", "unlockTables", "updateTables", "core"})
@SourceDebugExtension(value={"SMAP\nNewGameScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewGameScreen.kt\ncom/unciv/ui/screens/newgamescreen/NewGameScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n766#2:415\n857#2,2:416\n2624#2,3:418\n2624#2,3:421\n1#3:424\n*S KotlinDebug\n*F\n+ 1 NewGameScreen.kt\ncom/unciv/ui/screens/newgamescreen/NewGameScreen\n*L\n125#1:415\n125#1:416,2\n138#1:418,3\n148#1:421,3\n*E\n"})
public final class NewGameScreen
extends PickerScreen
implements IPreviousScreen,
RecreateOnResize {
    @NotNull
    private final GameSetupInfo gameSetupInfo;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final GameOptionsTable newGameOptionsTable;
    @NotNull
    private final PlayerPickerTable playerPickerTable;
    @NotNull
    private final MapOptionsTable mapOptionsTable;

    public NewGameScreen(@Nullable GameSetupInfo defaultGameSetupInfo) {
        super(false, 1, null);
        GameSetupInfo gameSetupInfo = defaultGameSetupInfo;
        if (gameSetupInfo == null) {
            gameSetupInfo = GameSetupInfo.Companion.fromSettings$default(GameSetupInfo.Companion, null, 1, null);
        }
        this.gameSetupInfo = gameSetupInfo;
        this.ruleset = new Ruleset();
        boolean isPortrait = this.isNarrowerThan4to3();
        this.tryUpdateRuleset(false);
        CollectionsKt.removeAll((List)this.getGameSetupInfo().getGameParameters().getVictoryTypes(), (Function1)new Function1<String, Boolean>(){

            @Override
            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !this.getRuleset().getVictories().keySet().contains(it);
            }
        });
        if (this.getGameSetupInfo().getGameParameters().getVictoryTypes().isEmpty()) {
            this.getGameSetupInfo().getGameParameters().getVictoryTypes().addAll((Collection<String>)this.getRuleset().getVictories().keySet());
        }
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        this.playerPickerTable = new PlayerPickerTable(this, this.getGameSetupInfo().getGameParameters(), isPortrait ? this.getStage().getWidth() - 20.0f : 0.0f);
        this.newGameOptionsTable = new GameOptionsTable(this, isPortrait, (Function1<? super String, Unit>)new Function1<String, Unit>(){

            @Override
            public final void invoke(@NotNull String desiredCiv) {
                Intrinsics.checkNotNullParameter(desiredCiv, "desiredCiv");
                this.getPlayerPickerTable$core().update(desiredCiv);
            }
        }, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getPlayerPickerTable$core().updateRandomNumberLabel();
            }
        });
        this.mapOptionsTable = new MapOptionsTable(this);
        ActivationExtensionsKt.onActivation(this.getCloseButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                mapOptionsTable.cancelBackgroundJobs$core();
                this.getGame().popScreen();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getCloseButton()).add(KeyCharAndCode.Companion.getBACK());
        if (isPortrait) {
            this.initPortrait();
        } else {
            this.initLandscape();
        }
        this.getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getTopTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/TopTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        if (UncivGame.Companion.getCurrent().getSettings().getLastGameSetup() != null) {
            this.getRightSideGroup().addActorAt(0, new VerticalGroup().padBottom(5.0f));
            TextButton resetToDefaultsButton = Scene2dExtensionsKt.toTextButton$default("Reset to defaults", null, false, 3, null);
            this.getRightSideGroup().addActorAt(0, resetToDefaultsButton);
            ActivationExtensionsKt.onClick(resetToDefaultsButton, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    new ConfirmPopup(this, "Are you sure you want to reset all game options to defaults?", "Reset to defaults", false, null, (Function0)new Function0<Unit>(){

                        @Override
                        public final void invoke() {
                            this.getGame().replaceCurrentScreen(new NewGameScreen(new GameSetupInfo(null, null, 3, null)));
                        }
                    }, 24, null).open(true);
                }
            });
        }
        this.getRightSideButton().setText(TranslationsKt.tr$default("Start game!", false, 1, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), new Function0<Unit>((Object)this){

            @Override
            public final void invoke() {
                ((NewGameScreen)this.receiver).onStartGameClicked();
            }
        });
    }

    public /* synthetic */ NewGameScreen(GameSetupInfo gameSetupInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gameSetupInfo = null;
        }
        this(gameSetupInfo);
    }

    @Override
    @NotNull
    public GameSetupInfo getGameSetupInfo() {
        return this.gameSetupInfo;
    }

    @Override
    @NotNull
    public Ruleset getRuleset() {
        return this.ruleset;
    }

    @NotNull
    public final PlayerPickerTable getPlayerPickerTable$core() {
        return this.playerPickerTable;
    }

    /*
     * WARNING - void declaration
     */
    private final void onStartGameClicked() {
        boolean bl;
        block25: {
            Object it;
            Iterable $this$none$iv;
            this.mapOptionsTable.cancelBackgroundJobs$core();
            if (this.getGameSetupInfo().getGameParameters().isOnlineMultiplayer()) {
                void $this$filterTo$iv$iv;
                if (!this.checkConnectionToMultiplayerServer()) {
                    Popup noInternetConnectionPopup = new Popup(this, null, 0.0f, 6, null);
                    String label2 = OnlineMultiplayer.Companion.usesCustomServer() ? "Couldn't connect to Multiplayer Server!" : "Couldn't connect to Dropbox!";
                    Popup.addGoodSizedLabel$default(noInternetConnectionPopup, TranslationsKt.tr$default(label2, false, 1, null), 0, false, 6, null).row();
                    Popup.addCloseButton$default(noInternetConnectionPopup, null, null, null, null, 15, null);
                    Popup.open$default(noInternetConnectionPopup, false, 1, null);
                    return;
                }
                Iterable $this$filter$iv = this.getGameSetupInfo().getGameParameters().getPlayers();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Player it2 = (Player)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it2.getPlayerType() == PlayerType.Human)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (Player player : (List)destination$iv$iv) {
                    try {
                        UUID.fromString(IdChecker.INSTANCE.checkAndReturnPlayerUuid(player.getPlayerId()));
                    }
                    catch (Exception _) {
                        Popup invalidPlayerIdPopup = new Popup(this, null, 0.0f, 6, null);
                        Popup.addGoodSizedLabel$default(invalidPlayerIdPopup, TranslationsKt.tr$default("Invalid player ID!", false, 1, null), 0, false, 6, null).row();
                        Popup.addCloseButton$default(invalidPlayerIdPopup, null, null, null, null, 15, null);
                        Popup.open$default(invalidPlayerIdPopup, false, 1, null);
                        return;
                    }
                }
                if (!this.getGameSetupInfo().getGameParameters().getAnyoneCanSpectate()) {
                    boolean bl3;
                    block24: {
                        $this$none$iv = this.getGameSetupInfo().getGameParameters().getPlayers();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl3 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (Player)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual(((Player)it).getPlayerId(), UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getUserId())) continue;
                                bl3 = false;
                                break block24;
                            }
                            bl3 = true;
                        }
                    }
                    if (bl3) {
                        Popup notAllowedToSpectate = new Popup(this, null, 0.0f, 6, null);
                        Popup.addGoodSizedLabel$default(notAllowedToSpectate, TranslationsKt.tr$default("You are not allowed to spectate!", false, 1, null), 0, false, 6, null).row();
                        Popup.addCloseButton$default(notAllowedToSpectate, null, null, null, null, 15, null);
                        Popup.open$default(notAllowedToSpectate, false, 1, null);
                        return;
                    }
                }
            }
            $this$none$iv = this.getGameSetupInfo().getGameParameters().getPlayers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it = (Player)element$iv;
                    boolean bl5 = false;
                    boolean bl6 = !(((Player)it).getPlayerType() != PlayerType.Human || Intrinsics.areEqual(((Player)it).getChosenCiv(), "Spectator") && this.getGameSetupInfo().getGameParameters().isOnlineMultiplayer());
                    if (!bl6) continue;
                    bl = false;
                    break block25;
                }
                bl = true;
            }
        }
        if (bl) {
            Popup noHumanPlayersPopup = new Popup(this, null, 0.0f, 6, null);
            Popup.addGoodSizedLabel$default(noHumanPlayersPopup, TranslationsKt.tr$default("No human players selected!", false, 1, null), 0, false, 6, null).row();
            Popup.addCloseButton$default(noHumanPlayersPopup, null, null, null, null, 15, null);
            Popup.open$default(noHumanPlayersPopup, false, 1, null);
            return;
        }
        if (this.getGameSetupInfo().getGameParameters().getVictoryTypes().isEmpty()) {
            Popup noVictoryTypesPopup = new Popup(this, null, 0.0f, 6, null);
            Popup.addGoodSizedLabel$default(noVictoryTypesPopup, TranslationsKt.tr$default("No victory conditions were selected!", false, 1, null), 0, false, 6, null).row();
            Popup.addCloseButton$default(noVictoryTypesPopup, null, null, null, null, 15, null);
            Popup.open$default(noVictoryTypesPopup, false, 1, null);
            return;
        }
        String modCheckResult = this.newGameOptionsTable.getModCheckboxes$core().getSavedModcheckResult();
        this.newGameOptionsTable.getModCheckboxes$core().setSavedModcheckResult(null);
        if (modCheckResult != null) {
            new AcceptModErrorsPopup(this, modCheckResult, new Function0<Unit>(this){
                final /* synthetic */ NewGameScreen this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    NewGameScreen.access$getNewGameOptionsTable$p(this.this$0).resetRuleset();
                }
            }, new Function0<Unit>(this, modCheckResult){
                final /* synthetic */ NewGameScreen this$0;
                final /* synthetic */ String $modCheckResult;
                {
                    this.this$0 = $receiver;
                    this.$modCheckResult = $modCheckResult;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getGameSetupInfo().getGameParameters().setAcceptedModCheckErrors(this.$modCheckResult);
                    NewGameScreen.access$onStartGameClicked(this.this$0);
                }
            });
            return;
        }
        Gdx.input.setInputProcessor(null);
        if (Intrinsics.areEqual(((TranslatedSelectBox.TranslatedString)this.mapOptionsTable.getMapTypeSelectBox$core().getSelected()).getValue(), "Custom")) {
            TileMap _;
            try {
                FileHandle fileHandle = this.getGameSetupInfo().getMapFile();
                Intrinsics.checkNotNull(fileHandle);
                _ = MapSaver.INSTANCE.loadMap(fileHandle);
            }
            catch (Throwable ex) {
                Log.INSTANCE.error("Could not load map", ex);
                Gdx.input.setInputProcessor(this.getStage());
                new ToastPopup("Could not load map!", this, 0L, 4, null);
                return;
            }
            TileMap map2 = _;
            HashSet<String> rulesetIncompatibilities = map2.getRulesetIncompatibility(this.getRuleset());
            if (!((Collection)rulesetIncompatibilities).isEmpty()) {
                Popup incompatibleMap = new Popup(this, null, 0.0f, 6, null);
                Popup.addGoodSizedLabel$default(incompatibleMap, TranslationsKt.tr$default("Map is incompatible with the chosen ruleset!", false, 1, null), 0, false, 6, null).row();
                for (String incompatibility : rulesetIncompatibilities) {
                    Intrinsics.checkNotNullExpressionValue(incompatibility, "incompatibility");
                    Popup.addGoodSizedLabel$default(incompatibleMap, incompatibility, 0, false, 6, null).row();
                }
                Popup.addCloseButton$default(incompatibleMap, null, null, null, null, 15, null);
                Popup.open$default(incompatibleMap, false, 1, null);
                Gdx.input.setInputProcessor(this.getStage());
                return;
            }
        } else {
            MapSize mapSize = this.getGameSetupInfo().getMapParameters().getMapSize();
            String message2 = mapSize.fixUndesiredSizes(this.getGameSetupInfo().getMapParameters().getWorldWrap());
            if (message2 != null) {
                BaseScreen baseScreen = UncivGame.Companion.getCurrent().getScreen();
                Intrinsics.checkNotNull(baseScreen);
                new ToastPopup(message2, baseScreen, 4000L);
                MapParametersTable $this$onStartGameClicked_u24lambda_u243 = this.mapOptionsTable.getGeneratedMapOptionsTable$core();
                boolean bl7 = false;
                $this$onStartGameClicked_u24lambda_u243.getCustomMapSizeRadius().setText(String.valueOf(mapSize.getRadius()));
                $this$onStartGameClicked_u24lambda_u243.getCustomMapWidth().setText(String.valueOf(mapSize.getWidth()));
                $this$onStartGameClicked_u24lambda_u243.getCustomMapHeight().setText(String.valueOf(mapSize.getHeight()));
                Gdx.input.setInputProcessor(this.getStage());
                return;
            }
        }
        Scene2dExtensionsKt.disable(this.getRightSideButton());
        this.getRightSideButton().setText(TranslationsKt.tr$default("Working...", false, 1, null));
        BaseScreen.Companion.setSkin();
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("NewGame", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NewGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = NewGameScreen.access$startNewGame(this.this$0, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final float getColumnWidth$core() {
        return (float)Math.floor(this.getStage().getWidth() / (float)(this.isNarrowerThan4to3() ? 1 : 3));
    }

    /*
     * WARNING - void declaration
     */
    private final void initLandscape() {
        void $this$initLandscape_u24lambda_u245;
        AutoScrollPane $this$initLandscape_u24lambda_u244;
        AutoScrollPane autoScrollPane;
        this.getScrollPane().setScrollingDisabled(true, true);
        Cell<Actor> cell2 = this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel$default("Game Options", null, 24, 0, false, 13, null));
        Intrinsics.checkNotNullExpressionValue(cell2, "topTable.add(\"Game Optio\u2026nstants.headingFontSize))");
        Scene2dExtensionsKt.pad(cell2, 20.0f, 0.0f);
        Table table2 = this.getTopTable();
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color, "BLACK");
        Scene2dExtensionsKt.addSeparatorVertical(table2, color, 1.0f);
        Cell<Actor> cell3 = this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel$default("Map Options", null, 24, 0, false, 13, null));
        Intrinsics.checkNotNullExpressionValue(cell3, "topTable.add(\"Map Option\u2026nstants.headingFontSize))");
        Scene2dExtensionsKt.pad(cell3, 20.0f, 0.0f);
        Table table3 = this.getTopTable();
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        Scene2dExtensionsKt.addSeparatorVertical(table3, color2, 1.0f);
        Cell<Actor> cell4 = this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel$default("Civilizations", null, 24, 0, false, 13, null));
        Intrinsics.checkNotNullExpressionValue(cell4, "topTable.add(\"Civilizati\u2026nstants.headingFontSize))");
        Scene2dExtensionsKt.pad(cell4, 20.0f, 0.0f);
        Table table4 = this.getTopTable();
        Color color3 = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color3, "CLEAR");
        Scene2dExtensionsKt.addSeparator$default(table4, color3, 0, 1.0f, 2, null);
        AutoScrollPane autoScrollPane2 = autoScrollPane = new AutoScrollPane((Actor)this.newGameOptionsTable, null, 2, null);
        Table table5 = this.getTopTable();
        boolean bl = false;
        $this$initLandscape_u24lambda_u244.setOverscroll(false, false);
        table5.add((Actor)autoScrollPane).width(this.getStage().getWidth() / (float)3).top();
        Table table6 = this.getTopTable();
        Color color4 = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color4, "CLEAR");
        Scene2dExtensionsKt.addSeparatorVertical(table6, color4, 1.0f);
        $this$initLandscape_u24lambda_u244 = autoScrollPane = new AutoScrollPane((Actor)this.mapOptionsTable, null, 2, null);
        table5 = this.getTopTable();
        boolean bl2 = false;
        $this$initLandscape_u24lambda_u245.setOverscroll(false, false);
        table5.add((Actor)autoScrollPane).width(this.getStage().getWidth() / (float)3).top();
        Table table7 = this.getTopTable();
        Color color5 = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color5, "CLEAR");
        Scene2dExtensionsKt.addSeparatorVertical(table7, color5, 1.0f);
        this.getTopTable().add((Actor)this.playerPickerTable).width(this.getStage().getWidth() / (float)3).top();
    }

    private final void initPortrait() {
        this.getScrollPane().setScrollingDisabled(false, false);
        this.getTopTable().add((Actor)new ExpanderTab("Game Options", 0, null, false, 0.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>(this){
            final /* synthetic */ NewGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)NewGameScreen.access$getNewGameOptionsTable$p(this.this$0)).row();
            }
        }, 1022, null)).expandX().fillX().row();
        Table table2 = this.getTopTable();
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 1.0f, 2, null);
        this.getTopTable().add((Actor)this.newGameOptionsTable.getModCheckboxes$core()).expandX().fillX().row();
        Table table3 = this.getTopTable();
        Color color2 = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "DARK_GRAY");
        Scene2dExtensionsKt.addSeparator$default(table3, color2, 0, 1.0f, 2, null);
        this.getTopTable().add((Actor)new ExpanderTab("Map Options", 0, null, false, 0.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>(this){
            final /* synthetic */ NewGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)NewGameScreen.access$getMapOptionsTable$p(this.this$0)).row();
            }
        }, 1022, null)).expandX().fillX().row();
        Table table4 = this.getTopTable();
        Color color3 = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "DARK_GRAY");
        Scene2dExtensionsKt.addSeparator$default(table4, color3, 0, 1.0f, 2, null);
        Group group = this.playerPickerTable.getPlayerListTable().getParent();
        Intrinsics.checkNotNull(group, "null cannot be cast to non-null type com.unciv.ui.components.widgets.AutoScrollPane");
        ((AutoScrollPane)group).setScrollingDisabled(true, true);
        this.getTopTable().add((Actor)new ExpanderTab("Civilizations", 0, null, false, 0.0f, 0.0f, 0.0f, null, null, null, new Function1<Table, Unit>(this){
            final /* synthetic */ NewGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)this.this$0.getPlayerPickerTable$core()).row();
            }
        }, 1022, null)).expandX().fillX().row();
    }

    private final boolean checkConnectionToMultiplayerServer() {
        boolean bl;
        try {
            String multiplayerServer = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer();
            URL u = new URL(OnlineMultiplayer.Companion.usesDropbox() ? "https://content.dropboxapi.com" : multiplayerServer);
            URLConnection con = u.openConnection();
            con.setConnectTimeout(3000);
            con.connect();
            bl = true;
        }
        catch (Throwable _) {
            bl = false;
        }
        return bl;
    }

    private final Object startNewGame(Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NewGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        popup = new Popup(this.this$0, null, 0.0f, 6, null);
                        ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(popup, null){
                            int label;
                            final /* synthetic */ Popup $popup;
                            {
                                this.$popup = $popup;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        Popup.addGoodSizedLabel$default(this.$popup, "Working...", 0, false, 6, null).row();
                                        Popup.open$default(this.$popup, false, 1, null);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        try {
                            newGame = GameStarter.INSTANCE.startNewGame(this.this$0.getGameSetupInfo());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(popup, this.this$0, exception, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ NewGameScreen this$0;
                                final /* synthetic */ Exception $exception;
                                {
                                    this.$popup = $popup;
                                    this.this$0 = $receiver;
                                    this.$exception = $exception;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            Popup popup2 = this.$popup;
                                            Exception exception2 = this.$exception;
                                            Popup $this$invokeSuspend_u24lambda_u240 = popup2;
                                            boolean bl = false;
                                            Popup.reuseWith$default($this$invokeSuspend_u24lambda_u240, "It looks like we can't make a map with the parameters you requested!", false, 2, null);
                                            $this$invokeSuspend_u24lambda_u240.row();
                                            Popup.addGoodSizedLabel$default($this$invokeSuspend_u24lambda_u240, "Maybe you put too many players into too small a map?", 0, false, 6, null).row();
                                            Popup.addButton$default($this$invokeSuspend_u24lambda_u240, "Copy to clipboard", null, null, (Function0)new Function0<Unit>(exception2){
                                                final /* synthetic */ Exception $exception;
                                                {
                                                    this.$exception = $exception;
                                                    super(0);
                                                }

                                                public final void invoke() {
                                                    Gdx.app.getClipboard().setContents(ExceptionsKt.stackTraceToString(this.$exception));
                                                }
                                            }, 6, null);
                                            Popup.addCloseButton$default($this$invokeSuspend_u24lambda_u240, null, null, null, null, 15, null);
                                            Gdx.input.setInputProcessor(this.this$0.getStage());
                                            Scene2dExtensionsKt.enable(this.this$0.getRightSideButton());
                                            this.this$0.getRightSideButton().setText(TranslationsKt.tr$default("Start game!", false, 1, null));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                        if (!this.this$0.getGameSetupInfo().getGameParameters().isOnlineMultiplayer()) ** GOTO lbl52
                        newGame.setUpToDate(true);
                        this.L$0 = $this$coroutineScope;
                        this.L$1 = popup;
                        this.L$2 = newGame;
                        this.label = 1;
                        v0 = this.this$0.getGame().getOnlineMultiplayer().createGame(newGame, this);
                        ** if (v0 != var6_2) goto lbl29
lbl28:
                        // 1 sources

                        return var6_2;
lbl29:
                        // 1 sources

                        ** GOTO lbl38
                    }
                    case 1: {
                        newGame = (GameInfo)this.L$2;
                        popup = (Popup)this.L$1;
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        try {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl38:
                            // 2 sources

                            Autosaves.requestAutoSave$default(this.this$0.getGame().getFiles().getAutosaves(), newGame, false, 2, null);
                        }
                        catch (FileStorageRateLimitReached ex) {
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(popup, ex, this.this$0, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ FileStorageRateLimitReached $ex;
                                final /* synthetic */ NewGameScreen this$0;
                                {
                                    this.$popup = $popup;
                                    this.$ex = $ex;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$popup.reuseWith("Server limit reached! Please wait for [" + this.$ex.getLimitRemainingSeconds() + "] seconds", true);
                                            Scene2dExtensionsKt.enable(this.this$0.getRightSideButton());
                                            this.this$0.getRightSideButton().setText(TranslationsKt.tr$default("Start game!", false, 1, null));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            Gdx.input.setInputProcessor(this.this$0.getStage());
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            Log.INSTANCE.error("Error while creating game", ex);
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(popup, this.this$0, null){
                                int label;
                                final /* synthetic */ Popup $popup;
                                final /* synthetic */ NewGameScreen this$0;
                                {
                                    this.$popup = $popup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$popup.reuseWith("Could not upload game!", true);
                                            Scene2dExtensionsKt.enable(this.this$0.getRightSideButton());
                                            this.this$0.getRightSideButton().setText(TranslationsKt.tr$default("Start game!", false, 1, null));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            Gdx.input.setInputProcessor(this.this$0.getStage());
                            return Unit.INSTANCE;
                        }
lbl52:
                        // 2 sources

                        this.L$0 = $this$coroutineScope;
                        this.L$1 = newGame;
                        this.L$2 = null;
                        this.label = 2;
                        v1 = UncivGame.loadGame$default(this.this$0.getGame(), newGame, null, false, this, 6, null);
                        if (v1 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl65
                    }
                    case 2: {
                        newGame = (GameInfo)this.L$1;
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl65:
                        // 2 sources

                        worldScreen = (WorldScreen)v1;
                        if (newGame.getGameParameters().isOnlineMultiplayer()) {
                            ConcurrencyKt.launchOnGLThread$default($this$coroutineScope, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newGame, worldScreen, null){
                                int label;
                                final /* synthetic */ GameInfo $newGame;
                                final /* synthetic */ WorldScreen $worldScreen;
                                {
                                    this.$newGame = $newGame;
                                    this.$worldScreen = $worldScreen;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            Gdx.app.getClipboard().setContents(this.$newGame.getGameId());
                                            new ToastPopup(TranslationsKt.tr$default("Game ID copied to clipboard!", false, 1, null), this.$worldScreen, 2500L);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean tryUpdateRuleset(boolean updateUI) {
        Ruleset ruleset2;
        Ref.BooleanRef success = new Ref.BooleanRef();
        success.element = true;
        try {
            ruleset2 = RulesetCache.INSTANCE.getComplexRuleset(this.getGameSetupInfo().getGameParameters());
        }
        catch (UncivShowableException ex) {
            ruleset2 = NewGameScreen.tryUpdateRuleset$handleFailure(success, this, "\u00abYELLOW\u00bb{Your previous options needed to be reset to defaults.}\u00ab\u00bb\n\n" + ex.getLocalizedMessage());
        }
        catch (Throwable ex) {
            Log.INSTANCE.debug("updateRuleset failed", ex);
            ruleset2 = NewGameScreen.tryUpdateRuleset$handleFailure(success, this, "\u00abRED\u00bb{Your previous options needed to be reset to defaults.}\u00ab\u00bb");
        }
        Ruleset newRuleset = ruleset2;
        this.getRuleset().clear();
        this.getRuleset().add(newRuleset);
        ImageGetter.INSTANCE.setNewRuleset(this.getRuleset());
        this.getGame().getMusicController().setModList((HashSet<String>)this.getGameSetupInfo().getGameParameters().getModsAndBaseRuleset());
        if (updateUI) {
            this.newGameOptionsTable.updateRuleset(this.getRuleset());
        }
        return success.element;
    }

    public final void lockTables() {
        this.playerPickerTable.setLocked(true);
        this.newGameOptionsTable.setLocked$core(true);
    }

    public final void unlockTables() {
        this.playerPickerTable.setLocked(false);
        this.newGameOptionsTable.setLocked$core(false);
    }

    public final void updateTables() {
        this.playerPickerTable.setGameParameters(this.getGameSetupInfo().getGameParameters());
        PlayerPickerTable.update$default(this.playerPickerTable, null, 1, null);
        this.newGameOptionsTable.changeGameParameters(this.getGameSetupInfo().getGameParameters());
        this.newGameOptionsTable.update();
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new NewGameScreen(this.getGameSetupInfo());
    }

    private static final Ruleset tryUpdateRuleset$handleFailure(Ref.BooleanRef success, NewGameScreen this$0, String message2) {
        success.element = false;
        new ToastPopup(message2, this$0, 5000L);
        this$0.getGameSetupInfo().getGameParameters().getMods().clear();
        this$0.getGameSetupInfo().getGameParameters().setBaseRuleset(BaseRuleset.Civ_V_GnK.getFullName());
        Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
        Intrinsics.checkNotNull(object);
        return (Ruleset)object;
    }

    public NewGameScreen() {
        this(null, 1, null);
    }

    public static final /* synthetic */ GameOptionsTable access$getNewGameOptionsTable$p(NewGameScreen $this) {
        return $this.newGameOptionsTable;
    }

    public static final /* synthetic */ Object access$startNewGame(NewGameScreen $this, Continuation $completion) {
        return $this.startNewGame($completion);
    }
}

