/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.NationTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 .2\u00020\u0001:\u0001.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010#\u001a\u00020\bJ8\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100'2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070)H\u0002J\u0014\u0010*\u001a\u00020+*\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0002R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup;", "Lcom/unciv/ui/popups/Popup;", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "onExit", "Lkotlin/Function0;", "", "(Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;Lcom/unciv/models/metadata/GameParameters;Lkotlin/jvm/functions/Function0;)V", "allNationTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/newgamescreen/NationTable;", "Lkotlin/collections/ArrayList;", "availableNations", "", "", "availableNationsListScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "availableNationsListTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civBlocksWidth", "", "isPortrait", "", "partHeight", "selectedNations", "selectedNationsListScroll", "selectedNationsListTable", "addNationToPool", "nation", "Lcom/unciv/models/ruleset/nation/Nation;", "removeNationFromPool", "returnSelected", "switchAllNations", "update", "updateNationListTable", "table", "nations", "", "actionFactory", "Lkotlin/Function1;", "toImageButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "overColor", "Lcom/badlogic/gdx/graphics/Color;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nGameOptionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,631:1\n766#2:632\n857#2,2:633\n1549#2:635\n1620#2,3:636\n1549#2:639\n1620#2,3:640\n1#3:643\n*S KotlinDebug\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup\n*L\n536#1:632\n536#1:633,2\n539#1:635\n539#1:636,3\n541#1:639\n541#1:640,3\n*E\n"})
final class RandomNationPickerPopup
extends Popup {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final GameParameters gameParameters;
    @NotNull
    private final Function0<Unit> onExit;
    private final boolean isPortrait;
    private final float civBlocksWidth;
    private final float partHeight;
    @NotNull
    private final Table availableNationsListTable;
    @NotNull
    private final AutoScrollPane availableNationsListScroll;
    @NotNull
    private final Table selectedNationsListTable;
    @NotNull
    private final AutoScrollPane selectedNationsListScroll;
    @NotNull
    private final ArrayList<NationTable> allNationTables;
    @NotNull
    private Set<String> availableNations;
    @NotNull
    private Set<String> selectedNations;
    public static final float buttonsCircleSize = 70.0f;
    public static final float buttonsIconSize = 50.0f;
    public static final float buttonsOffsetFromEdge = 5.0f;
    @NotNull
    private static final Color buttonsBackColor;

    /*
     * WARNING - void declaration
     */
    public RandomNationPickerPopup(@NotNull IPreviousScreen previousScreen, @NotNull GameParameters gameParameters, @NotNull Function0<Unit> onExit) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Nation it;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Intrinsics.checkNotNullParameter(previousScreen, "previousScreen");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        Intrinsics.checkNotNullParameter(onExit, "onExit");
        super((BaseScreen)((Object)previousScreen), null, 0.0f, 6, null);
        this.gameParameters = gameParameters;
        this.onExit = onExit;
        this.isPortrait = ((BaseScreen)((Object)previousScreen)).isPortrait();
        this.civBlocksWidth = this.getStageToShowOn().getWidth() / (float)3 - 5.0f;
        this.partHeight = this.getStageToShowOn().getHeight() * (this.isPortrait ? 0.45f : 0.8f);
        this.availableNationsListTable = new Table();
        this.availableNationsListScroll = new AutoScrollPane((Actor)this.availableNationsListTable, null, 2, null);
        this.selectedNationsListTable = new Table();
        this.selectedNationsListScroll = new AutoScrollPane((Actor)this.selectedNationsListTable, null, 2, null);
        Collection<Nation> collection = previousScreen.getRuleset().getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "previousScreen.ruleset.nations.values");
        Iterable iterable = collection;
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Nation)element$iv$iv;
            boolean bl = false;
            if (!it.isMajorCiv()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        List sortedNations = CollectionsKt.sortedWith((List)destination$iv$iv, new Comparator((Comparator)$this$filter$iv){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                Nation nation2 = (Nation)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                Nation it = (Nation)b;
                String string = TranslationsKt.tr(it.getName(), true);
                bl = false;
                String string2 = TranslationsKt.tr(it.getName(), true);
                return comparator.compare(string, string2);
            }
        });
        $this$filter$iv = sortedNations;
        RandomNationPickerPopup randomNationPickerPopup = this;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Nation)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection2.add(new NationTable(it, this.civBlocksWidth, 0.0f, null, 8, null));
        }
        Collection collection3 = (List)destination$iv$iv;
        randomNationPickerPopup.allNationTables = new ArrayList(collection3);
        $this$map$iv = sortedNations;
        randomNationPickerPopup = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Nation)item$iv$iv;
            Collection collection4 = destination$iv$iv;
            boolean bl = false;
            collection4.add(it.getName());
        }
        randomNationPickerPopup.availableNations = CollectionsKt.toMutableSet((List)destination$iv$iv);
        Set set2 = CollectionsKt.intersect((Iterable)this.gameParameters.getRandomNationsPool(), (Iterable)this.availableNations);
        Intrinsics.checkNotNull(set2, "null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.String>");
        this.selectedNations = TypeIntrinsics.asMutableSet(set2);
        this.availableNations.removeAll((Collection)this.selectedNations);
        this.availableNationsListScroll.setOverscroll(false, false);
        this.add((CharSequence)TranslationsKt.tr$default("Banned nations", false, 1, null));
        if (this.isPortrait) {
            this.row();
            this.add((Actor)this.availableNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight).row();
            Popup.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.add((CharSequence)TranslationsKt.tr$default("Available nations", false, 1, null)).row();
        } else {
            this.add((CharSequence)TranslationsKt.tr$default("Available nations", false, 1, null)).row();
            this.add((Actor)this.availableNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        }
        this.selectedNationsListScroll.setOverscroll(false, false);
        this.add((Actor)this.selectedNationsListScroll).size(this.civBlocksWidth + 10.0f, this.partHeight);
        this.update();
        this.pack();
        Color color = Color.FIREBRICK;
        Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
        Group closeButton2 = Scene2dExtensionsKt.getCloseButton(70.0f, 50.0f, buttonsBackColor, color, new Function0<Unit>(this){
            final /* synthetic */ RandomNationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.close();
            }
        });
        closeButton2.setPosition(5.0f, 5.0f, 12);
        this.getInnerTable().addActor(closeButton2);
        this.setClickBehindToClose(true);
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        Group okButton = this.toImageButton("OtherIcons/Checkmark", color2);
        ActivationExtensionsKt.onClick(okButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.returnSelected();
            }
        });
        okButton.setPosition(this.getInnerTable().getWidth() - 5.0f, 5.0f, 20);
        this.getInnerTable().addActor(okButton);
        Color color3 = Color.YELLOW;
        Intrinsics.checkNotNullExpressionValue(color3, "YELLOW");
        Group switchButton = this.toImageButton("OtherIcons/NationSwap", color3);
        ActivationExtensionsKt.onClick(switchButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.switchAllNations();
            }
        });
        switchButton.setPosition(this.getInnerTable().getWidth() / (float)2, 40.0f, 1);
        this.getInnerTable().addActor(switchButton);
        this.selectedNationsListTable.setTouchable(Touchable.enabled);
    }

    public final void update() {
        this.updateNationListTable(this.availableNationsListTable, this.availableNations, (Function1<? super Nation, ? extends Function0<Unit>>)new Function1<Nation, Function0<? extends Unit>>(this){
            final /* synthetic */ RandomNationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Function0<Unit> invoke(@NotNull Nation nation2) {
                Intrinsics.checkNotNullParameter(nation2, "nation");
                return new Function0<Unit>(this.this$0, nation2){
                    final /* synthetic */ RandomNationPickerPopup this$0;
                    final /* synthetic */ Nation $nation;
                    {
                        this.this$0 = $receiver;
                        this.$nation = $nation;
                        super(0);
                    }

                    public final void invoke() {
                        RandomNationPickerPopup.access$addNationToPool(this.this$0, this.$nation);
                    }
                };
            }
        });
        this.updateNationListTable(this.selectedNationsListTable, this.selectedNations, (Function1<? super Nation, ? extends Function0<Unit>>)new Function1<Nation, Function0<? extends Unit>>(this){
            final /* synthetic */ RandomNationPickerPopup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Function0<Unit> invoke(@NotNull Nation nation2) {
                Intrinsics.checkNotNullParameter(nation2, "nation");
                return new Function0<Unit>(this.this$0, nation2){
                    final /* synthetic */ RandomNationPickerPopup this$0;
                    final /* synthetic */ Nation $nation;
                    {
                        this.this$0 = $receiver;
                        this.$nation = $nation;
                        super(0);
                    }

                    public final void invoke() {
                        RandomNationPickerPopup.access$removeNationFromPool(this.this$0, this.$nation);
                    }
                };
            }
        });
    }

    private final void updateNationListTable(Table table2, Set<String> nations2, Function1<? super Nation, ? extends Function0<Unit>> actionFactory) {
        for (Actor child : table2.getChildren()) {
            child.getListeners().clear();
        }
        table2.clear();
        for (NationTable nationTable : this.allNationTables) {
            if (!nations2.contains(nationTable.getNation().getName())) continue;
            Intrinsics.checkNotNullExpressionValue(nationTable, "nationTable");
            ActivationExtensionsKt.onClick(nationTable, actionFactory.invoke(nationTable.getNation()));
            table2.add((Actor)nationTable).row();
        }
    }

    private final Group toImageButton(String $this$toImageButton, Color overColor) {
        return Scene2dExtensionsKt.toImageButton($this$toImageButton, 50.0f, 70.0f, buttonsBackColor, overColor);
    }

    private final void addNationToPool(Nation nation2) {
        this.availableNations.remove(nation2.getName());
        this.selectedNations.add(nation2.getName());
        this.update();
    }

    private final void removeNationFromPool(Nation nation2) {
        this.availableNations.add(nation2.getName());
        this.selectedNations.remove(nation2.getName());
        this.update();
    }

    private final void returnSelected() {
        this.close();
        this.gameParameters.setRandomNationsPool(new ArrayList<String>((Collection)this.selectedNations));
        this.onExit.invoke();
    }

    private final void switchAllNations() {
        Set<String> tempNations = this.availableNations;
        this.availableNations = this.selectedNations;
        this.selectedNations = tempNations;
        this.update();
    }

    public static final /* synthetic */ void access$addNationToPool(RandomNationPickerPopup $this, Nation nation2) {
        $this.addNationToPool(nation2);
    }

    public static final /* synthetic */ void access$removeNationFromPool(RandomNationPickerPopup $this, Nation nation2) {
        $this.removeNationFromPool(nation2);
    }

    static {
        Color color;
        Companion = new Companion(null);
        Color $this$buttonsBackColor_u24lambda_u244 = color = Color.BLACK.cpy();
        boolean bl = false;
        $this$buttonsBackColor_u24lambda_u244.a = 0.67f;
        Color color2 = color;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK.cpy().apply { a = 0.67f }");
        buttonsBackColor = color2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/newgamescreen/RandomNationPickerPopup$Companion;", "", "()V", "buttonsBackColor", "Lcom/badlogic/gdx/graphics/Color;", "getButtonsBackColor", "()Lcom/badlogic/gdx/graphics/Color;", "buttonsCircleSize", "", "buttonsIconSize", "buttonsOffsetFromEdge", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getButtonsBackColor() {
            return buttonsBackColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

