/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.ISortableGridContentProvider;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.SortableGrid;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTabColumn;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTabHelpers;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000f\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/\u00a8\u00060"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "", "Lcom/unciv/ui/components/ISortableGridContentProvider;", "Lcom/unciv/logic/city/City;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "(Ljava/lang/String;I)V", "align", "", "getAlign", "()I", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "equalizeHeight", "", "getEqualizeHeight", "()Z", "expandX", "getExpandX", "fillX", "getFillX", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "stat", "Lcom/unciv/models/stats/Stat;", "getEntryValue", "item", "getHeaderActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "iconSize", "", "CityColumn", "Status", "ConstructionIcon", "Construction", "Population", "Food", "Gold", "Science", "Production", "Culture", "Happiness", "Faith", "WLTK", "Garrison", "core"})
public class CityOverviewTabColumn
extends Enum<CityOverviewTabColumn>
implements ISortableGridContentProvider<City, EmpireOverviewScreen> {
    @Nullable
    private final Stat stat = Stat.Companion.safeValueOf(this.name());
    private final int align;
    private final boolean fillX;
    private final boolean expandX;
    private final boolean equalizeHeight;
    public static final /* enum */ CityOverviewTabColumn CityColumn = new CityColumn("CityColumn", 0);
    public static final /* enum */ CityOverviewTabColumn Status = new Status("Status", 1);
    public static final /* enum */ CityOverviewTabColumn ConstructionIcon = new ConstructionIcon("ConstructionIcon", 2);
    public static final /* enum */ CityOverviewTabColumn Construction = new Construction("Construction", 3);
    public static final /* enum */ CityOverviewTabColumn Population = new Population("Population", 4);
    public static final /* enum */ CityOverviewTabColumn Food = new Food("Food", 5);
    public static final /* enum */ CityOverviewTabColumn Gold = new CityOverviewTabColumn();
    public static final /* enum */ CityOverviewTabColumn Science = new CityOverviewTabColumn();
    public static final /* enum */ CityOverviewTabColumn Production = new Production("Production", 8);
    public static final /* enum */ CityOverviewTabColumn Culture = new CityOverviewTabColumn();
    public static final /* enum */ CityOverviewTabColumn Happiness = new Happiness("Happiness", 10);
    public static final /* enum */ CityOverviewTabColumn Faith = new Faith("Faith", 11);
    public static final /* enum */ CityOverviewTabColumn WLTK = new WLTK("WLTK", 12);
    public static final /* enum */ CityOverviewTabColumn Garrison = new Garrison("Garrison", 13);
    private static final /* synthetic */ CityOverviewTabColumn[] $VALUES;

    private CityOverviewTabColumn() {
        this.align = 1;
    }

    @Override
    @NotNull
    public String getHeaderTip() {
        return this.name();
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    @Override
    public boolean getFillX() {
        return this.fillX;
    }

    @Override
    public boolean getExpandX() {
        return this.expandX;
    }

    @Override
    public boolean getEqualizeHeight() {
        return this.equalizeHeight;
    }

    @Override
    @NotNull
    public SortableGrid.SortDirection getDefaultSort() {
        return SortableGrid.SortDirection.Descending;
    }

    @Override
    @Nullable
    public Actor getHeaderActor(float iconSize) {
        return ImageGetter.INSTANCE.getStatIcon(this.name());
    }

    @Override
    public int getEntryValue(@NotNull City item) {
        Intrinsics.checkNotNullParameter(item, "item");
        Stats stats2 = item.getCityStats().getCurrentCityStats();
        Stat stat = this.stat;
        Intrinsics.checkNotNull((Object)stat);
        return MathKt.roundToInt(stats2.get(stat));
    }

    @Override
    public boolean getHeaderTipHideIcons() {
        return ISortableGridContentProvider.DefaultImpls.getHeaderTipHideIcons(this);
    }

    @Override
    public boolean isVisible(@NotNull GameInfo gameInfo2) {
        return ISortableGridContentProvider.DefaultImpls.isVisible(this, gameInfo2);
    }

    @Override
    @NotNull
    public Comparator<City> getComparator() {
        return ISortableGridContentProvider.DefaultImpls.getComparator(this);
    }

    @Override
    @Nullable
    public Actor getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
        return ISortableGridContentProvider.DefaultImpls.getEntryActor(this, item, iconSize, actionContext);
    }

    @Override
    @Nullable
    public Actor getTotalsActor(@NotNull Iterable<City> items2) {
        return ISortableGridContentProvider.DefaultImpls.getTotalsActor(this, items2);
    }

    public static CityOverviewTabColumn[] values() {
        return (CityOverviewTabColumn[])$VALUES.clone();
    }

    public static CityOverviewTabColumn valueOf(String value) {
        return Enum.valueOf(CityOverviewTabColumn.class, value);
    }

    public /* synthetic */ CityOverviewTabColumn(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        $VALUES = cityOverviewTabColumnArray = new CityOverviewTabColumn[]{CityOverviewTabColumn.CityColumn, CityOverviewTabColumn.Status, CityOverviewTabColumn.ConstructionIcon, CityOverviewTabColumn.Construction, CityOverviewTabColumn.Population, CityOverviewTabColumn.Food, CityOverviewTabColumn.Gold, CityOverviewTabColumn.Science, CityOverviewTabColumn.Production, CityOverviewTabColumn.Culture, CityOverviewTabColumn.Happiness, CityOverviewTabColumn.Faith, CityOverviewTabColumn.WLTK, CityOverviewTabColumn.Garrison};
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$CityColumn;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "align", "", "getAlign", "()I", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "fillX", "", "getFillX", "()Z", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "getComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/city/City;", "Lkotlin/Comparator;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "item", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "getHeaderActor", "Lcom/unciv/ui/images/IconCircleGroup;", "getTotalsActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "items", "", "core"})
    static final class CityColumn
    extends CityOverviewTabColumn {
        @NotNull
        private final String headerTip;
        private final int align;
        private final boolean fillX;

        /*
         * WARNING - void declaration
         */
        CityColumn() {
            void var1_1;
            this.headerTip = "Name";
            this.align = 8;
            this.fillX = true;
        }

        @Override
        @NotNull
        public String getHeaderTip() {
            return this.headerTip;
        }

        @Override
        public int getAlign() {
            return this.align;
        }

        @Override
        public boolean getFillX() {
            return this.fillX;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Ascending;
        }

        @Override
        @NotNull
        public Comparator<City> getComparator() {
            Comparator comparator = ISortableGridContentProvider.Companion.getCollator();
            return new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    City city2 = (City)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    City it = (City)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    return comparator.compare(string, string2);
                }
            };
        }

        @Override
        @NotNull
        public IconCircleGroup getHeaderActor(float iconSize) {
            return Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getUnitIcon$default(ImageGetter.INSTANCE, "Settler", null, 2, null), iconSize, false, null, null, 14, null);
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return 0;
        }

        @Override
        @NotNull
        public Actor getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            return ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default(item.getName(), null, true, 1, null), new Function0<Unit>(actionContext, item){
                final /* synthetic */ EmpireOverviewScreen $actionContext;
                final /* synthetic */ City $item;
                {
                    this.$actionContext = $actionContext;
                    this.$item = $item;
                    super(0);
                }

                public final void invoke() {
                    this.$actionContext.getGame().pushScreen(new CityScreen(this.$item, null, null, null, 14, null));
                }
            });
        }

        @Override
        @NotNull
        public Label getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return Scene2dExtensionsKt.toLabel("Total");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Construction;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "align", "", "getAlign", "()I", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "equalizeHeight", "", "getEqualizeHeight", "()Z", "expandX", "getExpandX", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "getComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/city/City;", "Lkotlin/Comparator;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "item", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "getHeaderActor", "Lcom/unciv/ui/images/IconCircleGroup;", "getTotalsActor", "", "items", "", "core"})
    static final class Construction
    extends CityOverviewTabColumn {
        private final int align;
        private final boolean expandX;
        private final boolean equalizeHeight;
        @NotNull
        private final String headerTip;

        /*
         * WARNING - void declaration
         */
        Construction() {
            void var1_1;
            this.align = 8;
            this.equalizeHeight = true;
            this.headerTip = "Current construction";
        }

        @Override
        public int getAlign() {
            return this.align;
        }

        @Override
        public boolean getExpandX() {
            return this.expandX;
        }

        @Override
        public boolean getEqualizeHeight() {
            return this.equalizeHeight;
        }

        @Override
        @NotNull
        public String getHeaderTip() {
            return this.headerTip;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Ascending;
        }

        @Override
        @NotNull
        public Comparator<City> getComparator() {
            Comparator comparator = ISortableGridContentProvider.Companion.getCollator();
            return new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    City city2 = (City)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    City it = (City)b;
                    String string = TranslationsKt.tr(it.getCityConstructions().getCurrentConstructionFromQueue(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getCityConstructions().getCurrentConstructionFromQueue(), true);
                    return comparator.compare(string, string2);
                }
            };
        }

        @Override
        @NotNull
        public IconCircleGroup getHeaderActor(float iconSize) {
            return ISortableGridContentProvider.Companion.getCircledIcon$default(ISortableGridContentProvider.Companion, "OtherIcons/Settings", iconSize, null, 4, null);
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return 0;
        }

        @Override
        @NotNull
        public Label getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            return Scene2dExtensionsKt.toLabel(item.getCityConstructions().getCityProductionTextForCityButton());
        }

        @Nullable
        public Void getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$ConstructionIcon;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "item", "Lcom/unciv/logic/city/City;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "", "getHeaderActor", "", "getTotalsActor", "items", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCityOverviewTabColumn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityOverviewTabColumn.kt\ncom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$ConstructionIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
    static final class ConstructionIcon
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        ConstructionIcon() {
            void var1_1;
        }

        @Nullable
        public Void getHeaderActor(float iconSize) {
            return null;
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            CityConstructions $this$getEntryValue_u24lambda_u240 = item.getCityConstructions();
            boolean bl = false;
            return CityConstructions.turnsToConstruction$default($this$getEntryValue_u24lambda_u240, $this$getEntryValue_u24lambda_u240.getCurrentConstructionFromQueue(), false, 2, null);
        }

        @Override
        @Nullable
        public Actor getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            String construction2 = item.getCityConstructions().getCurrentConstructionFromQueue();
            if (((CharSequence)construction2).length() == 0) {
                return null;
            }
            return ImageGetter.INSTANCE.getConstructionPortrait(construction2, iconSize * 0.8f);
        }

        @Nullable
        public Void getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Faith;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "isVisible", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "core"})
    static final class Faith
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Faith() {
            void var1_1;
        }

        @Override
        public boolean isVisible(@NotNull GameInfo gameInfo2) {
            Intrinsics.checkNotNullParameter(gameInfo2, "gameInfo");
            return gameInfo2.isReligionEnabled();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Food;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "getTotalsActor", "", "items", "", "Lcom/unciv/logic/city/City;", "core"})
    static final class Food
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Food() {
            void var1_1;
        }

        @Nullable
        public Void getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Garrison;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "getComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/city/City;", "Lkotlin/Comparator;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "item", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "", "getHeaderActor", "Lcom/unciv/ui/images/IconCircleGroup;", "core"})
    static final class Garrison
    extends CityOverviewTabColumn {
        @NotNull
        private final String headerTip;

        /*
         * WARNING - void declaration
         */
        Garrison() {
            void var1_1;
            this.headerTip = "Garrisoned by unit";
        }

        @Override
        @NotNull
        public String getHeaderTip() {
            return this.headerTip;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Ascending;
        }

        @Override
        @NotNull
        public Comparator<City> getComparator() {
            Comparator comparator = ISortableGridContentProvider.Companion.getCollator();
            return new Comparator(comparator){
                final /* synthetic */ Comparator $comparator;
                {
                    this.$comparator = $comparator;
                }

                public final int compare(T a, T b) {
                    City it;
                    City city2 = (City)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Object object = it.getGarrison();
                    if (object == null || (object = ((MapUnit)object).getName()) == null || (object = TranslationsKt.tr((String)object, true)) == null) {
                        object = "";
                    }
                    it = (City)b;
                    Object object2 = object;
                    bl = false;
                    Object object3 = it.getGarrison();
                    if (object3 == null || (object3 = ((MapUnit)object3).getName()) == null || (object3 = TranslationsKt.tr((String)object3, true)) == null) {
                        object3 = "";
                    }
                    Object object4 = object3;
                    return comparator.compare(object2, object4);
                }
            };
        }

        @Override
        @NotNull
        public IconCircleGroup getHeaderActor(float iconSize) {
            return ISortableGridContentProvider.Companion.getCircledIcon$default(ISortableGridContentProvider.Companion, "OtherIcons/Shield", iconSize, null, 4, null);
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getGarrison() != null ? 1 : 0;
        }

        @Override
        @Nullable
        public Actor getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            MapUnit mapUnit = item.getGarrison();
            if (mapUnit == null) {
                return null;
            }
            MapUnit unit = mapUnit;
            String unitName = unit.displayName();
            Group unitIcon = ImageGetter.INSTANCE.getConstructionPortrait(unit.getBaseUnit().getIconName(), iconSize * 0.7f);
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, unitIcon, unitName, 18.0f, false, 0, 10, false, null, 108, null);
            ActivationExtensionsKt.onClick(unitIcon, new Function0<Unit>(actionContext, unit){
                final /* synthetic */ EmpireOverviewScreen $actionContext;
                final /* synthetic */ MapUnit $unit;
                {
                    this.$actionContext = $actionContext;
                    this.$unit = $unit;
                    super(0);
                }

                public final void invoke() {
                    this.$actionContext.select(EmpireOverviewCategories.Units, UnitOverviewTabHelpers.getUnitIdentifier$core$default(UnitOverviewTabColumn.Companion, this.$unit, null, 2, null));
                }
            });
            return unitIcon;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Happiness;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "getEntryValue", "", "item", "Lcom/unciv/logic/city/City;", "core"})
    static final class Happiness
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Happiness() {
            void var1_1;
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            Collection<Float> collection = item.getCityStats().getHappinessList().values();
            Intrinsics.checkNotNullExpressionValue(collection, "item.cityStats.happinessList.values");
            return MathKt.roundToInt(CollectionsKt.sumOfFloat((Iterable<Float>)collection));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Population;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "getEntryValue", "", "item", "Lcom/unciv/logic/city/City;", "core"})
    static final class Population
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Population() {
            void var1_1;
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.getPopulation().getPopulation();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Production;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "getTotalsActor", "", "items", "", "Lcom/unciv/logic/city/City;", "core"})
    static final class Production
    extends CityOverviewTabColumn {
        /*
         * WARNING - void declaration
         */
        Production() {
            void var1_1;
        }

        @Nullable
        public Void getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$Status;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "item", "Lcom/unciv/logic/city/City;", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "", "getHeaderActor", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getTotalsActor", "", "items", "", "core"})
    static final class Status
    extends CityOverviewTabColumn {
        @NotNull
        private final String headerTip;

        /*
         * WARNING - void declaration
         */
        Status() {
            void var1_1;
            this.headerTip = "Status\n(puppet, resistance or being razed)";
        }

        @Override
        @NotNull
        public String getHeaderTip() {
            return this.headerTip;
        }

        @Override
        @NotNull
        public Image getHeaderActor(float iconSize) {
            return ImageGetter.INSTANCE.getImage("OtherIcons/CityStatus");
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.isBeingRazed() ? 3 : (item.isInResistance() ? 2 : (item.isPuppet() ? 1 : 0));
        }

        @Override
        @Nullable
        public Actor getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            String string;
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            if (item.isBeingRazed()) {
                string = "OtherIcons/Fire";
            } else if (item.isInResistance()) {
                string = "StatIcons/Resistance";
            } else if (item.isPuppet()) {
                string = "OtherIcons/Puppet";
            } else {
                return null;
            }
            String iconPath = string;
            Actor actor = ImageGetter.INSTANCE.getImage(iconPath);
            Color color = Color.CLEAR;
            Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
            return Scene2dExtensionsKt.surroundWithCircle$default(actor, iconSize * 0.7f, false, color, null, 10, null);
        }

        @Nullable
        public Void getTotalsActor(@NotNull Iterable<City> items2) {
            Intrinsics.checkNotNullParameter(items2, "items");
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn$WLTK;", "Lcom/unciv/ui/screens/overviewscreen/CityOverviewTabColumn;", "defaultSort", "Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "getDefaultSort", "()Lcom/unciv/ui/components/widgets/SortableGrid$SortDirection;", "headerTip", "", "getHeaderTip", "()Ljava/lang/String;", "getComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/city/City;", "Lkotlin/Comparator;", "getEntryActor", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "item", "iconSize", "", "actionContext", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "getEntryValue", "", "getHeaderActor", "Lcom/unciv/ui/images/IconCircleGroup;", "core"})
    static final class WLTK
    extends CityOverviewTabColumn {
        @NotNull
        private final String headerTip;

        /*
         * WARNING - void declaration
         */
        WLTK() {
            void var1_1;
            this.headerTip = "We Love The King Day";
        }

        @Override
        @NotNull
        public String getHeaderTip() {
            return this.headerTip;
        }

        @Override
        @NotNull
        public SortableGrid.SortDirection getDefaultSort() {
            return SortableGrid.SortDirection.Ascending;
        }

        @Override
        @NotNull
        public Comparator<City> getComparator() {
            Comparator<City> comparator = super.getComparator();
            return new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        City it = (City)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)TranslationsKt.tr(it.getDemandedResource(), true));
                        it = (City)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)TranslationsKt.tr(it.getDemandedResource(), true)));
                    }
                    return n;
                }
            };
        }

        @Override
        @NotNull
        public IconCircleGroup getHeaderActor(float iconSize) {
            Color color = Color.TAN;
            Intrinsics.checkNotNullExpressionValue(color, "TAN");
            return ISortableGridContentProvider.Companion.getCircledIcon("OtherIcons/WLTK 2", iconSize, color);
        }

        @Override
        public int getEntryValue(@NotNull City item) {
            Intrinsics.checkNotNullParameter(item, "item");
            return item.isWeLoveTheKingDayActive() ? 1 : 0;
        }

        @Override
        @Nullable
        public Group getEntryActor(@NotNull City item, float iconSize, @NotNull EmpireOverviewScreen actionContext) {
            Group group;
            Intrinsics.checkNotNullParameter(item, "item");
            Intrinsics.checkNotNullParameter(actionContext, "actionContext");
            if (item.isWeLoveTheKingDayActive()) {
                IconCircleGroup iconCircleGroup;
                Actor actor = ImageGetter.INSTANCE.getImage("OtherIcons/WLTK 1");
                Color color = Color.CLEAR;
                Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
                IconCircleGroup $this$getEntryActor_u24lambda_u241 = iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(actor, iconSize, false, color, null, 10, null);
                boolean bl = false;
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, $this$getEntryActor_u24lambda_u241, "" + '[' + item.getFlag(CityFlags.WeLoveTheKing) + "] turns", 18.0f, false, 0, 10, false, null, 108, null);
                group = iconCircleGroup;
            } else if (((CharSequence)item.getDemandedResource()).length() > 0) {
                Group group2;
                Group $this$getEntryActor_u24lambda_u242 = group2 = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, item.getDemandedResource(), iconSize * 0.7f, 0, 4, null);
                boolean bl = false;
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, $this$getEntryActor_u24lambda_u242, "Demanding [" + item.getDemandedResource() + ']', 18.0f, false, 0, 10, false, null, 108, null);
                ActivationExtensionsKt.onClick($this$getEntryActor_u24lambda_u242, new Function0<Unit>(actionContext, item){
                    final /* synthetic */ EmpireOverviewScreen $actionContext;
                    final /* synthetic */ City $item;
                    {
                        this.$actionContext = $actionContext;
                        this.$item = $item;
                        super(0);
                    }

                    public final void invoke() {
                        this.$actionContext.showOneTimeNotification$core(GameInfo.getExploredResourcesNotification$default(this.$item.getCiv().getGameInfo(), this.$item.getCiv(), this.$item.getDemandedResource(), 0, null, 12, null));
                    }
                });
                group = group2;
            } else {
                group = null;
            }
            return group;
        }
    }
}

