/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.EspionageManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.models.Spy;
import com.unciv.models.SpyAction;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.SmallButtonStyle;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003123B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0016H\u0002J\u0016\u0010'\u001a\u00020\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0002J\u0018\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0016H\u0002J\u0010\u0010,\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0016H\u0002J\b\u0010-\u001a\u00020#H\u0002J\b\u0010.\u001a\u00020#H\u0002J\b\u0010/\u001a\u00020#H\u0002J\b\u00100\u001a\u00020#H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u001b\u001a*\u0012\b\u0012\u00060\u001cR\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u0015j\u0014\u0012\b\u0012\u00060\u001cR\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u001d`\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00064"}, d2={"Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "cityScrollPane", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "citySelectionTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "collator", "Ljava/text/Collator;", "manager", "Lcom/unciv/logic/civilization/managers/EspionageManager;", "getManager", "()Lcom/unciv/logic/civilization/managers/EspionageManager;", "middlePanes", "moveSpyButtons", "Ljava/util/HashMap;", "Lcom/unciv/models/Spy;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "Lkotlin/collections/HashMap;", "selectedSpy", "selectedSpyButton", "spyActionButtons", "Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$SpyCityActionButton;", "Lcom/unciv/logic/city/City;", "spyScrollPane", "spySelectionTable", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "addCityToSelectionTable", "", "city", "getSpyIcon", "spy", "getSpyIcons", "spies", "", "onSpyClicked", "moveSpyButton", "onSpyRightClicked", "resetSelection", "update", "updateCityList", "updateSpyList", "CoupButton", "MoveToCityButton", "SpyCityActionButton", "core"})
public final class EspionageOverviewScreen
extends PickerScreen {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final Collator collator;
    @NotNull
    private final Table spySelectionTable;
    @NotNull
    private final AutoScrollPane spyScrollPane;
    @NotNull
    private final Table citySelectionTable;
    @NotNull
    private final AutoScrollPane cityScrollPane;
    @NotNull
    private final Table middlePanes;
    @Nullable
    private TextButton selectedSpyButton;
    @Nullable
    private Spy selectedSpy;
    @NotNull
    private HashMap<SpyCityActionButton, City> spyActionButtons;
    @NotNull
    private HashMap<Spy, TextButton> moveSpyButtons;

    public EspionageOverviewScreen(@NotNull Civilization civInfo, @NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(true);
        this.civInfo = civInfo;
        this.worldScreen = worldScreen;
        this.collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        this.spySelectionTable = new Table(BaseScreen.Companion.getSkin());
        this.spyScrollPane = new AutoScrollPane((Actor)this.spySelectionTable, null, 2, null);
        this.citySelectionTable = new Table(BaseScreen.Companion.getSkin());
        this.cityScrollPane = new AutoScrollPane((Actor)this.citySelectionTable, null, 2, null);
        this.middlePanes = new Table(BaseScreen.Companion.getSkin());
        this.spyActionButtons = new HashMap();
        this.moveSpyButtons = new HashMap();
        this.spySelectionTable.defaults().pad(10.0f);
        this.citySelectionTable.defaults().pad(5.0f);
        this.middlePanes.add((Actor)this.spyScrollPane);
        Scene2dExtensionsKt.addSeparatorVertical$default(this.middlePanes, null, 0.0f, 3, null);
        this.middlePanes.add((Actor)this.cityScrollPane);
        this.getTopTable().add((Actor)this.middlePanes);
        this.update();
        this.getCloseButton().setVisible(true);
        ActivationExtensionsKt.onActivation(this.getCloseButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                CivInfoTransientCache.updateViewableTiles$default(this.getCivInfo().getCache(), null, 1, null);
                this.getGame().popScreen();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getCloseButton()).add(KeyCharAndCode.Companion.getBACK());
        this.getRightSideButton().setVisible(false);
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    private final EspionageManager getManager() {
        return this.civInfo.getEspionageManager();
    }

    private final void update() {
        this.updateSpyList();
        this.updateCityList();
    }

    private final void updateSpyList() {
        this.spySelectionTable.clear();
        this.moveSpyButtons.clear();
        this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Spy"));
        this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Rank"));
        this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Location"));
        this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Action")).row();
        for (Spy spy : this.getManager().getSpyList()) {
            this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel(spy.getName()));
            this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel(spy.getRank()));
            this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel(spy.getLocationName()));
            String actionString = spy.getAction().getShowTurns() ? '[' + spy.getAction().getDisplayString() + "] " + spy.getTurnsRemainingForAction() + '\u23f3' : spy.getAction().getDisplayString();
            this.spySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel(actionString));
            TextButton moveSpyButton = Scene2dExtensionsKt.toTextButton$default("Move", null, false, 3, null);
            ActivationExtensionsKt.onClick(moveSpyButton, new Function0<Unit>(this, moveSpyButton, spy){
                final /* synthetic */ EspionageOverviewScreen this$0;
                final /* synthetic */ TextButton $moveSpyButton;
                final /* synthetic */ Spy $spy;
                {
                    this.this$0 = $receiver;
                    this.$moveSpyButton = $moveSpyButton;
                    this.$spy = $spy;
                    super(0);
                }

                public final void invoke() {
                    Spy spy = this.$spy;
                    Intrinsics.checkNotNullExpressionValue(spy, "spy");
                    EspionageOverviewScreen.access$onSpyClicked(this.this$0, this.$moveSpyButton, spy);
                }
            });
            ActivationExtensionsKt.onRightClick$default(moveSpyButton, null, new Function0<Unit>(this, spy){
                final /* synthetic */ EspionageOverviewScreen this$0;
                final /* synthetic */ Spy $spy;
                {
                    this.this$0 = $receiver;
                    this.$spy = $spy;
                    super(0);
                }

                public final void invoke() {
                    Spy spy = this.$spy;
                    Intrinsics.checkNotNullExpressionValue(spy, "spy");
                    EspionageOverviewScreen.access$onSpyRightClicked(this.this$0, spy);
                }
            }, 1, null);
            if (!this.worldScreen.getCanChangeState() || !spy.isAlive() || this.civInfo.isDefeated()) {
                Scene2dExtensionsKt.disable(moveSpyButton);
            }
            this.spySelectionTable.add((Actor)moveSpyButton).pad(5.0f, 10.0f, 5.0f, 20.0f).row();
            Map map2 = this.moveSpyButtons;
            Intrinsics.checkNotNullExpressionValue(spy, "spy");
            map2.put(spy, moveSpyButton);
        }
    }

    private final void updateCityList() {
        this.citySelectionTable.clear();
        this.spyActionButtons.clear();
        this.citySelectionTable.add();
        this.citySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("City")).padTop(10.0f);
        this.citySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Spy present")).padTop(10.0f).row();
        this.citySelectionTable.add();
        this.citySelectionTable.add((Actor)Scene2dExtensionsKt.toLabel("Spy Hideout"));
        this.citySelectionTable.add((Actor)this.getSpyIcons((Iterable<Spy>)this.getManager().getIdleSpies()));
        MoveToCityButton moveSpyHereButton = new MoveToCityButton(null);
        this.citySelectionTable.add((Actor)moveSpyHereButton).row();
        Object object = new Comparator(this){
            final /* synthetic */ EspionageOverviewScreen this$0;
            {
                this.this$0 = espionageOverviewScreen;
            }

            public final int compare(T a, T b) {
                City it = (City)a;
                boolean bl = false;
                boolean bl2 = !Intrinsics.areEqual(it.getCiv(), this.this$0.getCivInfo());
                it = (City)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it.getCiv(), this.this$0.getCivInfo()));
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.getCiv().isCityState());
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getCiv().isCityState());
                }
                return n;
            }
        };
        Comparator comparator = this.collator;
        object = new Comparator((Comparator)object, comparator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    City city2 = (City)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    City it = (City)b;
                    String string = TranslationsKt.tr(it.getCiv().getCivName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getCiv().getCivName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        };
        comparator = this.collator;
        Sequence<City> sortedCities2 = SequencesKt.sortedWith(SequencesKt.filter(this.civInfo.getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(this){
            final /* synthetic */ EspionageOverviewScreen this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull City it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.getCivInfo().hasExplored(it.getCenterTile());
            }
        }), new Comparator((Comparator)object, comparator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    City city2 = (City)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    City it = (City)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        });
        object = sortedCities2.iterator();
        while (object.hasNext()) {
            City city2 = (City)object.next();
            this.addCityToSelectionTable(city2);
        }
    }

    private final void addCityToSelectionTable(City city2) {
        this.citySelectionTable.add((Actor)ImageGetter.INSTANCE.getNationPortrait(city2.getCiv().getNation(), 30.0f)).padLeft(20.0f);
        Label label2 = Scene2dExtensionsKt.toLabel$default(city2.getName(), null, 0, 0, true, 7, null);
        ActivationExtensionsKt.onClick(label2, new Function0<Unit>(this, city2){
            final /* synthetic */ EspionageOverviewScreen this$0;
            final /* synthetic */ City $city;
            {
                this.this$0 = $receiver;
                this.$city = $city;
                super(0);
            }

            public final void invoke() {
                this.this$0.getWorldScreen().getGame().popScreen();
                WorldMapHolder.setCenterPosition$default(this.this$0.getWorldScreen().getMapHolder(), this.$city.getLocation(), false, false, null, 14, null);
            }
        });
        this.citySelectionTable.add((Actor)label2).fill();
        this.citySelectionTable.add((Actor)this.getSpyIcons((Iterable<Spy>)this.getManager().getSpiesInCity(city2)));
        Spy spy = this.civInfo.getEspionageManager().getSpyAssignedToCity(city2);
        if (city2.getCiv().isCityState() && spy != null && spy.canDoCoup()) {
            CoupButton coupButton = new CoupButton(city2, spy.getAction() == SpyAction.Coup);
            this.citySelectionTable.add((Actor)coupButton);
        } else {
            MoveToCityButton moveSpyHereButton = new MoveToCityButton(city2);
            this.citySelectionTable.add((Actor)moveSpyHereButton);
        }
        this.citySelectionTable.row();
    }

    /*
     * WARNING - void declaration
     */
    private final Table getSpyIcon(Spy spy) {
        void $this$getSpyIcon_u24lambda_u246_u24lambda_u244;
        Image image2;
        Table table2;
        Table $this$getSpyIcon_u24lambda_u246 = table2 = new Table();
        boolean bl = false;
        Image image3 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/Spy_White");
        Table table3 = $this$getSpyIcon_u24lambda_u246;
        boolean bl2 = false;
        $this$getSpyIcon_u24lambda_u246_u24lambda_u244.setColor(Color.WHITE);
        table3.add((Actor)image2).size(30.0f);
        if (spy.getRank() >= 10) {
            Image star = ImageGetter.INSTANCE.getImage("OtherIcons/Star");
            star.setColor(EspionageOverviewScreen.getSpyIcon$lambda$6$getColor(spy.getRank() / 10));
            $this$getSpyIcon_u24lambda_u246.add((Actor)star).size(20.0f).pad(3.0f);
        }
        Color color = EspionageOverviewScreen.getSpyIcon$lambda$6$getColor(spy.getRank());
        Table starTable = new Table();
        int n = spy.getRank() % 10;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl3 = false;
            Image star = ImageGetter.INSTANCE.getImage("OtherIcons/Star");
            star.setColor(color);
            starTable.add((Actor)star).size(8.0f).pad(1.0f);
            if (it % 3 != 2) continue;
            starTable.row();
        }
        $this$getSpyIcon_u24lambda_u246.add((Actor)starTable).center().padLeft(-4.0f);
        if (this.worldScreen.getCanChangeState() && spy.isAlive() && !this.civInfo.isDefeated()) {
            ActivationExtensionsKt.onClick($this$getSpyIcon_u24lambda_u246, new Function0<Unit>(this, spy){
                final /* synthetic */ EspionageOverviewScreen this$0;
                final /* synthetic */ Spy $spy;
                {
                    this.this$0 = $receiver;
                    this.$spy = $spy;
                    super(0);
                }

                public final void invoke() {
                    V v = EspionageOverviewScreen.access$getMoveSpyButtons$p(this.this$0).get(this.$spy);
                    Intrinsics.checkNotNull(v);
                    EspionageOverviewScreen.access$onSpyClicked(this.this$0, (TextButton)v, this.$spy);
                }
            });
            ActivationExtensionsKt.onRightClick$default($this$getSpyIcon_u24lambda_u246, null, new Function0<Unit>(this, spy){
                final /* synthetic */ EspionageOverviewScreen this$0;
                final /* synthetic */ Spy $spy;
                {
                    this.this$0 = $receiver;
                    this.$spy = $spy;
                    super(0);
                }

                public final void invoke() {
                    EspionageOverviewScreen.access$onSpyRightClicked(this.this$0, this.$spy);
                }
            }, 1, null);
        }
        return table2;
    }

    private final Table getSpyIcons(Iterable<Spy> spies) {
        Table table2;
        Table $this$getSpyIcons_u24lambda_u247 = table2 = new Table();
        boolean bl = false;
        $this$getSpyIcons_u24lambda_u247.defaults().space(0.0f, 2.0f, 0.0f, 2.0f);
        for (Spy spy : spies) {
            $this$getSpyIcons_u24lambda_u247.add((Actor)this.getSpyIcon(spy));
        }
        return table2;
    }

    private final void onSpyClicked(TextButton moveSpyButton, Spy spy) {
        if (Intrinsics.areEqual(this.selectedSpyButton, moveSpyButton)) {
            this.resetSelection();
            return;
        }
        this.resetSelection();
        this.selectedSpyButton = moveSpyButton;
        this.selectedSpy = spy;
        TextButton textButton = this.selectedSpyButton;
        Intrinsics.checkNotNull(textButton);
        textButton.getLabel().setText(TranslationsKt.tr$default("Cancel", false, 1, null));
        for (Map.Entry entry : ((Map)this.spyActionButtons).entrySet()) {
            SpyCityActionButton button = (SpyCityActionButton)entry.getKey();
            City city2 = (City)entry.getValue();
            if (Intrinsics.areEqual(city2, spy.getCityOrNull())) {
                button.setVisible(true);
                button.setDirection(16);
                continue;
            }
            button.setVisible(city2 == null || !city2.getEspionage().hasSpyOf(this.civInfo));
            button.setDirection(8);
        }
    }

    private final void onSpyRightClicked(Spy spy) {
        this.worldScreen.getBottomUnitTable$core().selectSpy(spy);
        this.worldScreen.getGame().popScreen();
        this.worldScreen.setShouldUpdate(true);
    }

    private final void resetSelection() {
        this.selectedSpy = null;
        Actor actor = this.selectedSpyButton;
        if (actor != null && (actor = ((TextButton)actor).getLabel()) != null) {
            ((Label)actor).setText(TranslationsKt.tr$default("Move", false, 1, null));
        }
        this.selectedSpyButton = null;
        Iterator iterator2 = ((Map)this.spyActionButtons).entrySet().iterator();
        while (iterator2.hasNext()) {
            SpyCityActionButton button = (SpyCityActionButton)iterator2.next().getKey();
            button.setVisible(false);
        }
    }

    private static final Color getSpyIcon$lambda$6$getColor(int rank) {
        Color color;
        switch (rank) {
            case 1: {
                Color color2 = Color.BROWN;
                color = color2;
                Intrinsics.checkNotNullExpressionValue(color2, "BROWN");
                break;
            }
            case 2: {
                Color color3 = Color.LIGHT_GRAY;
                color = color3;
                Intrinsics.checkNotNullExpressionValue(color3, "LIGHT_GRAY");
                break;
            }
            default: {
                Color color4 = Color.GOLD;
                color = color4;
                Intrinsics.checkNotNullExpressionValue(color4, "GOLD");
            }
        }
        return color;
    }

    public static final /* synthetic */ void access$onSpyClicked(EspionageOverviewScreen $this, TextButton moveSpyButton, Spy spy) {
        $this.onSpyClicked(moveSpyButton, spy);
    }

    public static final /* synthetic */ void access$onSpyRightClicked(EspionageOverviewScreen $this, Spy spy) {
        $this.onSpyRightClicked(spy);
    }

    public static final /* synthetic */ HashMap access$getMoveSpyButtons$p(EspionageOverviewScreen $this) {
        return $this.moveSpyButtons;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$CoupButton;", "Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$SpyCityActionButton;", "Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;", "city", "Lcom/unciv/logic/city/City;", "isCurrentAction", "", "(Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;Lcom/unciv/logic/city/City;Z)V", "fist", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getFist", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "core"})
    private final class CoupButton
    extends SpyCityActionButton {
        @NotNull
        private final Image fist;

        public CoupButton(final City city2, final boolean isCurrentAction) {
            Intrinsics.checkNotNullParameter(city2, "city");
            this.fist = ImageGetter.INSTANCE.getStatIcon("Resistance");
            Scene2dExtensionsKt.setSize(this.fist, 24.0f);
            this.add((Actor)this.fist).size(24.0f);
            this.fist.setOrigin(1);
            if (isCurrentAction) {
                this.fist.setColor(Color.WHITE);
            } else {
                this.fist.setColor(Color.DARK_GRAY);
            }
            ActivationExtensionsKt.onClick(this, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    Spy spy = EspionageOverviewScreen.this.selectedSpy;
                    Intrinsics.checkNotNull(spy);
                    final Spy spy2 = spy;
                    if (!isCurrentAction) {
                        BaseScreen baseScreen = EspionageOverviewScreen.this;
                        StringBuilder stringBuilder = new StringBuilder().append("Do you want to stage a coup in [").append(city2.getCiv().getCivName()).append("] with a [");
                        Spy spy3 = EspionageOverviewScreen.this.selectedSpy;
                        Intrinsics.checkNotNull(spy3);
                        Popup.open$default(new ConfirmPopup(baseScreen, stringBuilder.append((int)(spy3.getCoupChanceOfSuccess(false) * 100.0f)).append("]% chance of success?").toString(), "Stage Coup", false, null, (Function0)new Function0<Unit>(){

                            @Override
                            public final void invoke() {
                                spy2.setAction(SpyAction.Coup, 1);
                                this.getFist().setColor(Color.DARK_GRAY);
                                EspionageOverviewScreen.this.update();
                            }
                        }, 24, null), false, 1, null);
                    } else {
                        spy2.setAction(SpyAction.CounterIntelligence, 10);
                        this.getFist().setColor(Color.WHITE);
                        EspionageOverviewScreen.this.update();
                    }
                }
            });
            ((Map)EspionageOverviewScreen.this.spyActionButtons).put(this, city2);
            this.setVisible(false);
        }

        @NotNull
        public final Image getFist() {
            return this.fist;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$MoveToCityButton;", "Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$SpyCityActionButton;", "Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;Lcom/unciv/logic/city/City;)V", "arrow", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getArrow", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "setDirection", "", "align", "", "core"})
    private final class MoveToCityButton
    extends SpyCityActionButton {
        @NotNull
        private final Image arrow;

        public MoveToCityButton(final City city2) {
            this.arrow = ImageGetter.INSTANCE.getArrowImage(8);
            Scene2dExtensionsKt.setSize(this.arrow, 24.0f);
            this.add((Actor)this.arrow).size(24.0f);
            this.arrow.setOrigin(1);
            this.arrow.setColor(Color.WHITE);
            ActivationExtensionsKt.onClick(this, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    Spy spy = EspionageOverviewScreen.this.selectedSpy;
                    Intrinsics.checkNotNull(spy);
                    spy.moveTo(city2);
                    EspionageOverviewScreen.this.resetSelection();
                    EspionageOverviewScreen.this.update();
                }
            });
            ((Map)EspionageOverviewScreen.this.spyActionButtons).put(this, city2);
            this.setVisible(false);
        }

        @NotNull
        public final Image getArrow() {
            return this.arrow;
        }

        @Override
        public void setDirection(int align2) {
            this.arrow.setRotation(align2 == 16 ? 0.0f : 180.0f);
            this.setDisabled(align2 == 16);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen$SpyCityActionButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "(Lcom/unciv/ui/screens/overviewscreen/EspionageOverviewScreen;)V", "setDirection", "", "align", "", "core"})
    private abstract class SpyCityActionButton
    extends Button {
        public SpyCityActionButton() {
            super(new SmallButtonStyle());
        }

        public void setDirection(int align2) {
        }
    }
}

