/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.HexMath;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.nation.NationKt;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ClickableCircle;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.components.widgets.ShadowedLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.AnimatedMenuPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import com.unciv.ui.screens.overviewscreen.GlobalPoliticsOverviewTable;
import com.unciv.ui.screens.overviewscreen.WonderInfo;
import com.unciv.ui.screens.worldscreen.WorldMapHolder;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003123B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020\u001cH\u0002J\b\u0010+\u001a\u00020\u001cH\u0002J*\u0010,\u001a\u00020\u001c*\u00020\n2\u0006\u0010(\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00152\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0002J\u0014\u0010/\u001a\u00020\u001c*\u00020\n2\u0006\u0010(\u001a\u00020)H\u0002J\f\u00100\u001a\u00020\u0013*\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "civTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "defeatedCivs", "Lkotlin/sequences/Sequence;", "fixedContent", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "portraitMode", "", "relevantCivsCount", "", "showDiplomacyGroup", "undefeatedCivs", "createGlobalPoliticsHeader", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "createGlobalPoliticsTable", "", "getCivInfoTable", "civ", "getCivMiniTable", "civInfo", "getCivName", "otherciv", "getFixedContent", "getPoliciesTable", "getPoliticsOfCivTable", "getWondersOfCivTable", "updateCivTable", "columns", "", "updateDiagram", "updatePoliticsTable", "addCivsCategory", "aliveOrDefeated", "civs", "addTitleInfo", "hideCityStateCount", "DiagramLegendPopup", "DiplomacyGroup", "DiplomacyTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nGlobalPoliticsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,554:1\n1774#2,4:555\n1774#2,4:559\n1229#3,2:563\n1250#3,3:565\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable\n*L\n166#1:555,4\n288#1:559,4\n299#1:563,2\n335#1:565,3\n*E\n"})
public final class GlobalPoliticsOverviewTable
extends EmpireOverviewTab {
    @NotNull
    private final DiplomacyTabPersistableData persistableData;
    @NotNull
    private final Table fixedContent;
    @NotNull
    private final Table civTable;
    @NotNull
    private Sequence<Civilization> undefeatedCivs;
    @NotNull
    private Sequence<Civilization> defeatedCivs;
    @NotNull
    private String relevantCivsCount;
    private boolean showDiplomacyGroup;
    private boolean portraitMode;

    /*
     * WARNING - void declaration
     */
    public GlobalPoliticsOverviewTable(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        void $this$civTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        DiplomacyTabPersistableData diplomacyTabPersistableData = persistedData instanceof DiplomacyTabPersistableData ? (DiplomacyTabPersistableData)persistedData : null;
        if (diplomacyTabPersistableData == null) {
            diplomacyTabPersistableData = new DiplomacyTabPersistableData(false, false, 3, null);
        }
        this.persistableData = diplomacyTabPersistableData;
        this.fixedContent = new Table();
        Table table3 = table2 = new Table();
        GlobalPoliticsOverviewTable globalPoliticsOverviewTable = this;
        boolean bl = false;
        $this$civTable_u24lambda_u240.defaults().pad(5.0f);
        $this$civTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/DiplomacyOverviewTab/CivTable", null, Color.BLACK, 2, null));
        globalPoliticsOverviewTable.civTable = table2;
        this.undefeatedCivs = SequencesKt.sequenceOf(new Civilization[0]);
        this.defeatedCivs = SequencesKt.sequenceOf(new Civilization[0]);
        this.relevantCivsCount = "?";
        this.top();
        if (this.getPersistableData().getShowDiagram()) {
            this.updateDiagram();
        } else {
            this.updatePoliticsTable();
        }
    }

    public /* synthetic */ GlobalPoliticsOverviewTable(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public DiplomacyTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.fixedContent;
    }

    private final void updatePoliticsTable() {
        this.getPersistableData().setShowDiagram(false);
        this.createGlobalPoliticsHeader();
        this.createGlobalPoliticsTable();
        Table[] tableArray = new Table[]{this.fixedContent, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Cell<Image> createGlobalPoliticsHeader() {
        void $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241;
        Table table2;
        Table $this$createGlobalPoliticsHeader_u24lambda_u242 = this.fixedContent;
        boolean bl = false;
        Actor diagramButton2 = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show diagram", null, false, 3, null), new Function0<Unit>((Object)this){

            public final void invoke() {
                GlobalPoliticsOverviewTable.access$updateDiagram((GlobalPoliticsOverviewTable)this.receiver);
            }
        });
        $this$createGlobalPoliticsHeader_u24lambda_u242.clear();
        $this$createGlobalPoliticsHeader_u24lambda_u242.add();
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Civilization Info"));
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color2, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Social policies"));
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color3, 0.0f, 2, null);
        $this$createGlobalPoliticsHeader_u24lambda_u242.add((Actor)Scene2dExtensionsKt.toLabel("Wonders"));
        Color color4 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$createGlobalPoliticsHeader_u24lambda_u242, color4, 0.0f, 2, null);
        Table table3 = table2 = new Table();
        Table table4 = $this$createGlobalPoliticsHeader_u24lambda_u242;
        boolean bl2 = false;
        $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel("Relations")).padTop(10.0f).row();
        $this$createGlobalPoliticsHeader_u24lambda_u242_u24lambda_u241.add(diagramButton2).pad(10.0f);
        table4.add((Actor)table2);
        Color color5 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color5, "GRAY");
        return Scene2dExtensionsKt.addSeparator$default($this$createGlobalPoliticsHeader_u24lambda_u242, color5, 0, 0.0f, 6, null);
    }

    private final void createGlobalPoliticsTable() {
        this.clear();
        Civilization[] civilizationArray = new Civilization[]{this.getViewingPlayer()};
        Iterator<Civilization> iterator2 = SequencesKt.plus(SequencesKt.sequenceOf(civilizationArray), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), false, false, 2, null)).iterator();
        while (iterator2.hasNext()) {
            Civilization civ = iterator2.next();
            if (this.getCells().size > 0) {
                Table table2 = this;
                Color color = Color.GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "GRAY");
                Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 0.0f, 6, null);
            }
            this.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 100.0f)).pad(20.0f);
            Table table3 = this;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table3, color, 0.0f, 2, null);
            this.add((Actor)this.getCivInfoTable(civ)).pad(20.0f);
            Table table4 = this;
            Color color2 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table4, color2, 0.0f, 2, null);
            this.add((Actor)this.getPoliciesTable(civ)).pad(20.0f);
            Table table5 = this;
            Color color3 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table5, color3, 0.0f, 2, null);
            this.add((Actor)this.getWondersOfCivTable(civ)).pad(20.0f);
            Table table6 = this;
            Color color4 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table6, color4, 0.0f, 2, null);
            this.add((Actor)this.getPoliticsOfCivTable(civ)).pad(20.0f);
        }
    }

    private final Table getCivInfoTable(Civilization civ) {
        Table civInfoTable = new Table(this.getSkin());
        String leaderName = civ.getNation().getLeaderName();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(leaderName, null, 30, 0, false, 13, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel$default(civ.getCivName(), null, 0, 0, true, 7, null)).row();
        civInfoTable.add((Actor)Scene2dExtensionsKt.toLabel(civ.getTech().getEra().getName())).row();
        return civInfoTable;
    }

    /*
     * WARNING - void declaration
     */
    private final Table getPoliciesTable(Civilization civ) {
        Table policiesTable = new Table(this.getSkin());
        for (PolicyBranch branch : civ.getPolicies().getBranches()) {
            int n;
            void $this$count$iv;
            if (!civ.getPolicies().isAdopted(branch.getName())) continue;
            Iterable iterable = branch.getPolicies();
            int n2 = 1;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Policy it = (Policy)element$iv;
                    boolean bl = false;
                    boolean bl2 = it.getPolicyBranchType() != Policy.PolicyBranchType.BranchComplete && civ.getPolicies().isAdopted(it.getName());
                    if (!bl2 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            int count2 = n2 + n3;
            policiesTable.add((Actor)Scene2dExtensionsKt.toLabel('[' + branch.getName() + "]: " + count2)).row();
        }
        return policiesTable;
    }

    private final Table getWondersOfCivTable(Civilization civ) {
        Table wonderTable = new Table(this.getSkin());
        WonderInfo wonderInfo = new WonderInfo();
        for (WonderInfo.WonderInfo wonder : wonderInfo.collectInfo(this.getViewingPlayer())) {
            Civilization civilization = wonder.getCiv();
            if (!Intrinsics.areEqual(civilization != null ? civilization.getCivName() : null, civ.getCivName())) continue;
            Label wonderName = Scene2dExtensionsKt.toLabel(wonder.getName());
            if (wonder.getLocation() != null) {
                ActivationExtensionsKt.onClick(wonderName, new Function0<Unit>(wonder){
                    final /* synthetic */ WonderInfo.WonderInfo $wonder;
                    {
                        this.$wonder = $wonder;
                        super(0);
                    }

                    public final void invoke() {
                        WorldScreen worldScreen = UncivGame.Companion.getCurrent().resetToWorldScreen();
                        WorldMapHolder.setCenterPosition$default(worldScreen.getMapHolder(), this.$wonder.getLocation().getPosition(), false, false, null, 14, null);
                    }
                });
            }
            wonderTable.add((Actor)wonderName).left().row();
        }
        return wonderTable;
    }

    private final String getCivName(Civilization otherciv) {
        if (this.getViewingPlayer().knows(otherciv) || Intrinsics.areEqual(otherciv.getCivName(), this.getViewingPlayer().getCivName())) {
            return otherciv.getCivName();
        }
        return "an unknown civilization";
    }

    private final Table getPoliticsOfCivTable(Civilization civ) {
        Label turnsLeftText;
        Civilization otherCiv;
        Table politicsTable = new Table(this.getSkin());
        if (!this.getViewingPlayer().knows(civ) && !Intrinsics.areEqual(civ.getCivName(), this.getViewingPlayer().getCivName())) {
            return politicsTable;
        }
        if (civ.isDefeated()) {
            politicsTable.add((Actor)Scene2dExtensionsKt.toLabel("{Defeated} \u2620"));
            return politicsTable;
        }
        Iterator<Civilization> iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            if (!civ.isAtWarWith(otherCiv)) continue;
            String string = "At war with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel warText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)warText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            ColorMarkupLabel friendText;
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact) : false;
            if (bl) {
                String string = "Defensive pact with [" + this.getCivName(otherCiv) + ']';
                Color color = Color.CYAN;
                Intrinsics.checkNotNullExpressionValue(color, "CYAN");
                friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
                DiplomacyManager diplomacyManager2 = civ.getDiplomacy().get(otherCiv.getCivName());
                turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager2 != null ? Integer.valueOf(diplomacyManager2.getFlag(DiplomacyFlags.DefensivePact)) : null) + " \u23f3)");
                politicsTable.add((Actor)friendText);
                politicsTable.add((Actor)turnsLeftText).row();
                continue;
            }
            DiplomacyManager diplomacyManager3 = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl2 = diplomacyManager3 != null ? diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship) : false;
            if (!bl2) continue;
            String string = "Friends with [" + this.getCivName(otherCiv) + ']';
            Color color = Color.GREEN;
            Intrinsics.checkNotNullExpressionValue(color, "GREEN");
            friendText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager4 = civ.getDiplomacy().get(otherCiv.getCivName());
            turnsLeftText = Scene2dExtensionsKt.toLabel(" (" + (diplomacyManager4 != null ? Integer.valueOf(diplomacyManager4.getFlag(DiplomacyFlags.DeclarationOfFriendship)) : null) + " \u23f3)");
            politicsTable.add((Actor)friendText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        iterator2 = civ.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            otherCiv = iterator2.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacy().get(otherCiv.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.hasFlag(DiplomacyFlags.Denunciation) : false;
            if (!bl) continue;
            String string = "Denounced [" + this.getCivName(otherCiv) + ']';
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            ColorMarkupLabel denouncedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            DiplomacyManager diplomacyManager5 = civ.getDiplomacy().get(otherCiv.getCivName());
            turnsLeftText = Scene2dExtensionsKt.toLabel("" + '(' + (diplomacyManager5 != null ? Integer.valueOf(diplomacyManager5.getFlag(DiplomacyFlags.Denunciation)) : null) + " \u23f3)");
            politicsTable.add((Actor)denouncedText);
            politicsTable.add((Actor)turnsLeftText).row();
        }
        politicsTable.row();
        for (Civilization cityState : this.getGameInfo().getAliveCityStates()) {
            DiplomacyManager diplomacyManager = cityState.getDiplomacy().get(civ.getCivName());
            boolean bl = diplomacyManager != null ? diplomacyManager.isRelationshipLevelEQ(RelationshipLevel.Ally) : false;
            if (!bl) continue;
            String string = "Allied with [" + this.getCivName(cityState) + ']';
            Color color = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color, "CYAN");
            ColorMarkupLabel alliedText = new ColorMarkupLabel(string, color, null, 0, 12, null);
            politicsTable.add((Actor)alliedText).row();
        }
        return politicsTable;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDiagram() {
        Table table2;
        int n;
        int n2;
        WidgetGroup floatingTable;
        WidgetGroup civTableScroll;
        TextButton toggleCityStatesButton2;
        block11: {
            void $this$any$iv;
            Object $this$count$iv;
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable;
            String string;
            this.getPersistableData().setShowDiagram(true);
            Actor politicsButton2 = ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Show global politics", null, false, 3, null), new Function0<Unit>((Object)this){

                public final void invoke() {
                    GlobalPoliticsOverviewTable.access$updatePoliticsTable((GlobalPoliticsOverviewTable)this.receiver);
                }
            });
            TextButton textButton = Scene2dExtensionsKt.toTextButton$default("City-States", null, false, 3, null);
            WidgetGroup $this$updateDiagram_u24lambda_u244 = textButton;
            boolean bl = false;
            ActivationExtensionsKt.onClick($this$updateDiagram_u24lambda_u244, new Function0<Unit>(this){
                final /* synthetic */ GlobalPoliticsOverviewTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getPersistableData().setIncludeCityStates(!this.this$0.getPersistableData().getIncludeCityStates());
                    GlobalPoliticsOverviewTable.access$updateDiagram(this.this$0);
                }
            });
            toggleCityStatesButton2 = textButton;
            WidgetGroup $this$updateDiagram_u24lambda_u245 = $this$updateDiagram_u24lambda_u244 = new AutoScrollPane((Actor)this.civTable, null, 2, null);
            boolean bl2 = false;
            ((ScrollPane)$this$updateDiagram_u24lambda_u245).setOverscroll(false, false);
            civTableScroll = $this$updateDiagram_u24lambda_u244;
            $this$updateDiagram_u24lambda_u245 = new Table();
            Object $this$updateDiagram_u24lambda_u246 = $this$updateDiagram_u24lambda_u245;
            boolean bl3 = false;
            ((Table)$this$updateDiagram_u24lambda_u246).add((Actor)toggleCityStatesButton2).pad(10.0f).row();
            ((Table)$this$updateDiagram_u24lambda_u246).add(politicsButton2).row();
            Actor actor = civTableScroll;
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            ((Table)$this$updateDiagram_u24lambda_u246).add((Actor)Scene2dExtensionsKt.addBorder$default(actor, 2.0f, color, false, 4, null)).pad(10.0f);
            floatingTable = $this$updateDiagram_u24lambda_u245;
            boolean hideCivsCount = this.getViewingPlayer().hideCivCount() || this.getPersistableData().getIncludeCityStates() && this.hideCityStateCount(this.getViewingPlayer());
            GlobalPoliticsOverviewTable globalPoliticsOverviewTable2 = this;
            if (hideCivsCount) {
                string = "?";
            } else {
                int n3;
                $this$updateDiagram_u24lambda_u246 = this.getGameInfo().getCivilizations();
                globalPoliticsOverviewTable = globalPoliticsOverviewTable2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object t : $this$count$iv) {
                        Civilization it = (Civilization)t;
                        boolean bl4 = false;
                        if (!(!it.isSpectator() && !it.isBarbarian() && (this.getPersistableData().getIncludeCityStates() || !it.isCityState())) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                n2 = n3;
                globalPoliticsOverviewTable2 = globalPoliticsOverviewTable;
                string = String.valueOf(n2);
            }
            globalPoliticsOverviewTable2.relevantCivsCount = string;
            $this$count$iv = new Civilization[]{this.getViewingPlayer()};
            this.undefeatedCivs = SequencesKt.plus(SequencesKt.sequenceOf($this$count$iv), DiplomacyFunctions.getKnownCivsSorted$default(this.getViewingPlayer().getDiplomacyFunctions(), this.getPersistableData().getIncludeCityStates(), false, 2, null));
            this.defeatedCivs = SequencesKt.filter(this.getViewingPlayer().getDiplomacyFunctions().getKnownCivsSorted(this.getPersistableData().getIncludeCityStates(), true), updateDiagram.2.INSTANCE);
            this.clear();
            this.fixedContent.clear();
            $this$count$iv = this.undefeatedCivs;
            globalPoliticsOverviewTable = this;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Civilization civilization = (Civilization)element$iv;
                boolean bl5 = false;
                if (!(!Intrinsics.areEqual(civilization, this.getViewingPlayer()))) continue;
                n = 1;
                break block11;
            }
            n = 0;
        }
        n2 = n;
        globalPoliticsOverviewTable.showDiplomacyGroup = n2;
        this.updateCivTable(2);
        this.portraitMode = !this.showDiplomacyGroup || this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth() / (float)2 || this.getOverviewScreen().isPortrait();
        Table table3 = table2 = this.portraitMode ? (Table)this : this.fixedContent;
        if (this.showDiplomacyGroup) {
            float diplomacySize = RangesKt.coerceAtMost(this.getOverviewScreen().getStage().getWidth() - (this.portraitMode ? 0.0f : this.civTable.getMinWidth()), this.getOverviewScreen().getCenterAreaHeight$core());
            DiplomacyGroup diplomacyGroup = new DiplomacyGroup(this.undefeatedCivs, diplomacySize);
            table2.add((Actor)diplomacyGroup).top();
        }
        if (this.portraitMode) {
            int columns;
            if (this.showDiplomacyGroup) {
                table2.row();
            }
            if ((columns = 2 * MathKt.roundToInt(this.getOverviewScreen().getStage().getWidth() / this.civTable.getMinWidth())) > 2) {
                this.updateCivTable(columns);
                if (this.civTable.getMinWidth() > this.getOverviewScreen().getStage().getWidth()) {
                    this.updateCivTable(columns - 2);
                }
            }
        }
        table2.add((Actor)floatingTable);
        toggleCityStatesButton2.setStyle(this.getPersistableData().getIncludeCityStates() ? BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class) : BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class));
        ((AutoScrollPane)civTableScroll).setScrollingDisabled(this.portraitMode, this.portraitMode);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hideCityStateCount(Civilization $this$hideCityStateCount) {
        void $this$count$iv;
        if (!$this$hideCityStateCount.getGameInfo().getGameParameters().getRandomNumberOfCityStates()) {
            return false;
        }
        Sequence<Civilization> sequence = $this$hideCityStateCount.getKnownCivs();
        int n = 1;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            if (!it.isCityState() || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int n2 = count$iv;
        int knownCivs = n + n2;
        if (knownCivs >= $this$hideCityStateCount.getGameInfo().getGameParameters().getMaxNumberOfCityStates()) {
            return false;
        }
        return !Civilization.hasUnique$default($this$hideCityStateCount, UniqueType.OneTimeRevealEntireMap, null, 2, null);
    }

    private final Table updateCivTable(int columns) {
        Table table2;
        Table $this$updateCivTable_u24lambda_u2410 = table2 = this.civTable;
        boolean bl = false;
        $this$updateCivTable_u24lambda_u2410.clear();
        this.addTitleInfo($this$updateCivTable_u24lambda_u2410, columns);
        this.addCivsCategory($this$updateCivTable_u24lambda_u2410, columns, "alive", SequencesKt.filter(this.undefeatedCivs, (Function1)new Function1<Civilization, Boolean>(this){
            final /* synthetic */ GlobalPoliticsOverviewTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.this$0.getViewingPlayer());
            }
        }));
        this.addCivsCategory($this$updateCivTable_u24lambda_u2410, columns, "defeated", this.defeatedCivs);
        $this$updateCivTable_u24lambda_u2410.layout();
        return table2;
    }

    private final Table getCivMiniTable(Civilization civInfo) {
        Table table2 = new Table();
        table2.add((Actor)ImageGetter.INSTANCE.getNationPortrait(civInfo.getNation(), 25.0f)).pad(5.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(civInfo.getCivName(), null, 0, 0, true, 7, null)).left().padRight(10.0f);
        table2.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick(table2, new Function0<Unit>(civInfo, this){
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ GlobalPoliticsOverviewTable this$0;
            {
                this.$civInfo = $civInfo;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$civInfo.isDefeated() || this.this$0.getViewingPlayer().isSpectator() || Intrinsics.areEqual(this.$civInfo, this.this$0.getViewingPlayer())) {
                    return;
                }
                UncivGame.Companion.getCurrent().pushScreen(new DiplomacyScreen(this.this$0.getViewingPlayer(), this.$civInfo, null, false, 12, null));
            }
        });
        return table2;
    }

    private final void addTitleInfo(Table $this$addTitleInfo, int columns) {
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel('[' + this.relevantCivsCount + "] Civilizations in the game")).colspan(columns).row();
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Our Civilization:")).colspan(columns).left().padLeft(10.0f).padTop(10.0f).row();
        $this$addTitleInfo.add((Actor)this.getCivMiniTable(this.getViewingPlayer())).left();
        String scoreText = this.getViewingPlayer().isDefeated() ? "\u2620" : String.valueOf((int)this.getViewingPlayer().calculateTotalScore());
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel(scoreText)).left().row();
        Integer n = this.getViewingPlayer().getTurnsTillNextDiplomaticVote();
        if (n == null) {
            return;
        }
        int turnsTillNextDiplomaticVote = n;
        $this$addTitleInfo.add((Actor)Scene2dExtensionsKt.toLabel("Turns until the next\ndiplomacy victory vote: [" + turnsTillNextDiplomaticVote + ']')).colspan(columns).row();
    }

    private final void addCivsCategory(Table $this$addCivsCategory, int columns, String aliveOrDefeated, Sequence<Civilization> civs) {
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        int count2 = SequencesKt.count(civs);
        $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel("Known and " + aliveOrDefeated + " ([" + count2 + "])")).pad(5.0f).colspan(columns).row();
        if (count2 == 0) {
            return;
        }
        Scene2dExtensionsKt.addSeparator$default($this$addCivsCategory, null, 0, 0.0f, 7, null);
        Ref.IntRef currentColumn = new Ref.IntRef();
        Ref.BooleanRef lastCivWasMajor = new Ref.BooleanRef();
        Iterator<Civilization> iterator2 = civs.iterator();
        while (iterator2.hasNext()) {
            Civilization civ = iterator2.next();
            if (lastCivWasMajor.element && civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, columns);
            }
            $this$addCivsCategory.add((Actor)this.getCivMiniTable(civ)).left();
            if (civ.isCityState()) {
                GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 1);
                continue;
            }
            $this$addCivsCategory.add((Actor)Scene2dExtensionsKt.toLabel((int)civ.calculateTotalScore())).left();
            GlobalPoliticsOverviewTable.addCivsCategory$advanceCols(currentColumn, columns, $this$addCivsCategory, lastCivWasMajor, 2);
        }
    }

    private static final void addCivsCategory$advanceCols(Ref.IntRef currentColumn, int $columns, Table $this_addCivsCategory, Ref.BooleanRef lastCivWasMajor, int delta) {
        currentColumn.element += delta;
        if (currentColumn.element >= $columns) {
            $this_addCivsCategory.row();
            currentColumn.element = 0;
        }
        lastCivWasMajor.element = delta == 2;
    }

    public static final /* synthetic */ void access$updatePoliticsTable(GlobalPoliticsOverviewTable $this) {
        $this.updatePoliticsTable();
    }

    public static final /* synthetic */ void access$updateDiagram(GlobalPoliticsOverviewTable $this) {
        $this.updateDiagram();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\n*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiagramLegendPopup;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "diagram", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;)V", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "addLegendRow", "", "text", "", "color", "Lcom/badlogic/gdx/graphics/Color;", "Companion", "core"})
    private static final class DiagramLegendPopup
    extends AnimatedMenuPopup {
        @NotNull
        public static final Companion Companion = new Companion(null);
        public static final float lineWidth = 3.0f;
        public static final float lowContrastWidth = 4.0f;
        public static final float lineLength = 120.0f;

        public DiagramLegendPopup(@NotNull Stage stage, @NotNull Actor diagram) {
            Intrinsics.checkNotNullParameter(stage, "stage");
            Intrinsics.checkNotNullParameter(diagram, "diagram");
            super(stage, DiagramLegendPopup.Companion.getCenterInStageCoordinates(diagram));
            this.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation(this, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.close();
                }
            });
        }

        @Override
        @NotNull
        public Table createContentTable() {
            Table legend = new Table();
            legend.setBackground(ImageGetter.INSTANCE.getDrawable("OtherIcons/Politics-diagram-bg"));
            legend.add((Actor)new ShadowedLabel("Diagram line colors", 24, null, null, false, 0.0f, 60, null)).colspan(2).row();
            Color color = Color.RED;
            Intrinsics.checkNotNullExpressionValue(color, "RED");
            this.addLegendRow(legend, "War", color);
            Object object = RelationshipLevel.values();
            int n = ((RelationshipLevel[])object).length;
            for (int i = 0; i < n; ++i) {
                RelationshipLevel level = object[i];
                Color lineColor = level == RelationshipLevel.Ally ? Color.CYAN : level.getColor();
                String string = level.name();
                Intrinsics.checkNotNullExpressionValue(lineColor, "lineColor");
                this.addLegendRow(legend, string, lineColor);
            }
            Color color2 = Color.CYAN;
            Intrinsics.checkNotNullExpressionValue(color2, "CYAN");
            this.addLegendRow(legend, "Defensive Pact", color2);
            Table table2 = super.createContentTable();
            Intrinsics.checkNotNull(table2);
            Object $this$createContentTable_u24lambda_u240 = object = table2;
            boolean bl = false;
            ((Table)$this$createContentTable_u24lambda_u240).add((Actor)legend).grow();
            return object;
        }

        public final void addLegendRow(@NotNull Table $this$addLegendRow, @NotNull String text2, @NotNull Color color) {
            Intrinsics.checkNotNullParameter($this$addLegendRow, "<this>");
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(color, "color");
            Color color2 = Color.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue(color2, "DARK_GRAY");
            float contrast = (float)NationKt.getContrastRatio(color2, color);
            float width = 3.0f + 1.0f / RangesKt.coerceAtLeast(contrast, 1.0f);
            Image line = ImageGetter.INSTANCE.getLine(0.0f, width / (float)2, 120.0f, width / (float)2, width);
            line.setColor(color);
            $this$addLegendRow.add((Actor)line).size(120.0f, width).padTop(5.0f);
            $this$addLegendRow.add((Actor)new ShadowedLabel(text2, 0, null, null, false, 0.0f, 62, null)).padLeft(5.0f).padTop(10.0f).row();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiagramLegendPopup$Companion;", "", "()V", "lineLength", "", "lineWidth", "lowContrastWidth", "getCenterInStageCoordinates", "Lcom/badlogic/gdx/math/Vector2;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "core"})
        public static final class Companion {
            private Companion() {
            }

            private final Vector2 getCenterInStageCoordinates(Actor $this$getCenterInStageCoordinates) {
                Vector2 vector2 = $this$getCenterInStageCoordinates.localToStageCoordinates(new Vector2($this$getCenterInStageCoordinates.getWidth() / (float)2, $this$getCenterInStageCoordinates.getHeight() / (float)2));
                Intrinsics.checkNotNullExpressionValue(vector2, "localToStageCoordinates(\u20262(width / 2, height / 2))");
                return vector2;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J@\u0010\b\u001a\u00020\t2.\u0010\n\u001a*\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bj\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r`\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "undefeatedCivs", "Lkotlin/sequences/Sequence;", "Lcom/unciv/logic/civilization/Civilization;", "freeSize", "", "(Lkotlin/sequences/Sequence;F)V", "onCivClicked", "", "civLines", "Ljava/util/HashMap;", "", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/HashMap;", "name", "core"})
    @SourceDebugExtension(value={"SMAP\nGlobalPoliticsOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,554:1\n1855#2,2:555\n1855#2,2:565\n1855#2,2:568\n515#3:557\n500#3,6:558\n215#4:564\n216#4:567\n*S KotlinDebug\n*F\n+ 1 GlobalPoliticsOverviewTable.kt\ncom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyGroup\n*L\n430#1:555,2\n438#1:565,2\n442#1:568,2\n437#1:557\n437#1:558,6\n438#1:564\n438#1:567\n*E\n"})
    private static final class DiplomacyGroup
    extends Group {
        public DiplomacyGroup(@NotNull Sequence<Civilization> undefeatedCivs, float freeSize) {
            Intrinsics.checkNotNullParameter(undefeatedCivs, "undefeatedCivs");
            this.setSize(freeSize, freeSize);
            ClickableCircle clickableArea = new ClickableCircle(freeSize / 1.25f - 25.0f);
            ActivationExtensionsKt.onActivation(clickableArea, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    Stage stage = this.getStage();
                    Intrinsics.checkNotNullExpressionValue(stage, "stage");
                    new DiagramLegendPopup(stage, (Actor)this);
                }
            });
            Scene2dExtensionsKt.center((Actor)clickableArea, this);
            this.addActor(clickableArea);
            HashMap civGroups = new HashMap();
            final HashMap<String, Set<Actor>> civLines = new HashMap<String, Set<Actor>>();
            int civCount = SequencesKt.count(undefeatedCivs);
            Iterator<Civilization> iterator2 = undefeatedCivs.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                final Civilization civ = iterator2.next();
                Portrait civGroup = ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 30.0f);
                Vector2 vector = HexMath.INSTANCE.getVectorForAngle((float)Math.PI * 2 * (float)i / (float)civCount);
                Scene2dExtensionsKt.center((Actor)civGroup, this);
                civGroup.moveBy(vector.x * freeSize / 2.25f, vector.y * freeSize / 2.25f);
                civGroup.setTouchable(Touchable.enabled);
                ActivationExtensionsKt.onClick(civGroup, new Function0<Unit>(){

                    @Override
                    public final void invoke() {
                        this.onCivClicked(civLines, civ.getCivName());
                    }
                });
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, civGroup, civ.getCivName(), 0.0f, false, 0, 12, false, null, 110, null);
                ((Map)civGroups).put(civ.getCivName(), civGroup);
                this.addActor(civGroup);
            }
            iterator2 = undefeatedCivs.iterator();
            while (iterator2.hasNext()) {
                Civilization civ = iterator2.next();
                if (civ.isDefeated()) continue;
                for (DiplomacyManager diplomacy : civ.getDiplomacy().values()) {
                    Civilization otherCiv = diplomacy.otherCiv();
                    if (!SequencesKt.contains(undefeatedCivs, otherCiv) || otherCiv.isDefeated()) continue;
                    Object v = civGroups.get(civ.getCivName());
                    Intrinsics.checkNotNull(v);
                    Actor civGroup = (Actor)v;
                    Object v2 = civGroups.get(diplomacy.getOtherCivName());
                    Intrinsics.checkNotNull(v2);
                    Actor otherCivGroup = (Actor)v2;
                    Image statusLine = ImageGetter.INSTANCE.getLine(civGroup.getX() + civGroup.getWidth() / (float)2, civGroup.getY() + civGroup.getHeight() / (float)2, otherCivGroup.getX() + otherCivGroup.getWidth() / (float)2, otherCivGroup.getY() + otherCivGroup.getHeight() / (float)2, 2.0f);
                    statusLine.setColor(diplomacy.getDiplomaticStatus() == DiplomaticStatus.War ? Color.RED : (diplomacy.getDiplomaticStatus() == DiplomaticStatus.DefensivePact || diplomacy.getCivInfo().isCityState() && Intrinsics.areEqual(diplomacy.getCivInfo().getAllyCiv(), diplomacy.getOtherCivName()) || otherCiv.isCityState() && Intrinsics.areEqual(otherCiv.getAllyCiv(), diplomacy.getCivInfo().getCivName()) ? Color.CYAN : diplomacy.relationshipLevel().getColor()));
                    if (!civLines.containsKey(civ.getCivName())) {
                        ((Map)civLines).put(civ.getCivName(), (Set)new LinkedHashSet());
                    }
                    Set<Actor> set2 = civLines.get(civ.getCivName());
                    Intrinsics.checkNotNull(set2);
                    set2.add(statusLine);
                    this.addActorAt(0, statusLine);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onCivClicked(HashMap<String, Set<Actor>> civLines, String name2) {
            Iterable $this$forEach$iv;
            Set<Actor> set2 = civLines.get(name2);
            if (set2 == null) {
                return;
            }
            Set<Actor> selectedLines = set2;
            boolean atLeastOneLineVisible = false;
            boolean allAreLinesInvisible = true;
            for (Set<Actor> lines2 : civLines.values()) {
                if (Intrinsics.areEqual(lines2, selectedLines) || lines2.isEmpty()) continue;
                Intrinsics.checkNotNullExpressionValue(lines2, "lines");
                boolean visibility = ((Actor)CollectionsKt.first((Iterable)lines2)).isVisible();
                atLeastOneLineVisible = atLeastOneLineVisible || visibility;
                boolean bl = allAreLinesInvisible = allAreLinesInvisible && visibility;
                if (!atLeastOneLineVisible || allAreLinesInvisible) continue;
                Iterable $this$forEach$iv2 = selectedLines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Actor it = (Actor)element$iv;
                    boolean bl2 = false;
                    it.setVisible(!it.isVisible());
                }
                return;
            }
            if (((Actor)CollectionsKt.first((Iterable)selectedLines)).isVisible()) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv = civLines;
                boolean $i$f$filter = false;
                Map visibility = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual(it.getKey(), name2))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filter$iv = destination$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator3.next();
                    boolean bl = false;
                    Iterable $this$forEach$iv3 = (Iterable)it.getValue();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv3) {
                        Actor line = (Actor)element$iv2;
                        boolean bl3 = false;
                        line.setVisible(!line.isVisible());
                    }
                }
            } else {
                $this$forEach$iv = selectedLines;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Actor it = (Actor)element$iv;
                    boolean bl = false;
                    it.setVisible(!it.isVisible());
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/overviewscreen/GlobalPoliticsOverviewTable$DiplomacyTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "showDiagram", "", "includeCityStates", "(ZZ)V", "getIncludeCityStates", "()Z", "setIncludeCityStates", "(Z)V", "getShowDiagram", "setShowDiagram", "isEmpty", "core"})
    public static final class DiplomacyTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        private boolean showDiagram;
        private boolean includeCityStates;

        public DiplomacyTabPersistableData(boolean showDiagram, boolean includeCityStates) {
            this.showDiagram = showDiagram;
            this.includeCityStates = includeCityStates;
        }

        public /* synthetic */ DiplomacyTabPersistableData(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getShowDiagram() {
            return this.showDiagram;
        }

        public final void setShowDiagram(boolean bl) {
            this.showDiagram = bl;
        }

        public final boolean getIncludeCityStates() {
            return this.includeCityStates;
        }

        public final void setIncludeCityStates(boolean bl) {
            this.includeCityStates = bl;
        }

        @Override
        public boolean isEmpty() {
            return !this.showDiagram && !this.includeCityStates;
        }

        public DiplomacyTabPersistableData() {
            this(false, false, 3, null);
        }
    }
}

