/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0017\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010#J\f\u0010$\u001a\u00020\u001a*\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "beliefsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civStatsTable", "headerTable", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "religionButtonLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "religionButtons", "statsTable", "createBeliefDescription", "belief", "Lcom/unciv/models/ruleset/Belief;", "getFixedContent", "loadReligion", "", "religion", "Lcom/unciv/models/Religion;", "religionName", "", "loadReligionButtons", "select", "", "selection", "(Ljava/lang/String;)Ljava/lang/Float;", "addCivSpecificStats", "ReligionTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nReligionOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReligionOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ReligionOverviewTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,204:1\n1603#2,9:205\n1855#2:214\n1856#2:216\n1612#2:217\n1#3:215\n179#4,2:218\n*S KotlinDebug\n*F\n+ 1 ReligionOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ReligionOverviewTab\n*L\n105#1:205,9\n105#1:214\n105#1:216\n105#1:217\n105#1:215\n161#1:218,2\n*E\n"})
public final class ReligionOverviewTab
extends EmpireOverviewTab {
    @NotNull
    private final ReligionTabPersistableData persistableData;
    @NotNull
    private final Table civStatsTable;
    @NotNull
    private final Table religionButtons;
    @NotNull
    private final Label religionButtonLabel;
    @NotNull
    private final Table statsTable;
    @NotNull
    private final Table beliefsTable;
    @NotNull
    private final Table headerTable;

    public ReligionOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        Table table2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        ReligionTabPersistableData religionTabPersistableData = persistedData instanceof ReligionTabPersistableData ? (ReligionTabPersistableData)persistedData : null;
        if (religionTabPersistableData == null) {
            religionTabPersistableData = new ReligionTabPersistableData(null, 1, null);
        }
        this.persistableData = religionTabPersistableData;
        this.civStatsTable = new Table();
        this.religionButtons = new Table();
        this.religionButtonLabel = Scene2dExtensionsKt.toLabel("Click an icon to see the stats of this religion");
        this.statsTable = new Table();
        this.beliefsTable = new Table();
        this.headerTable = new Table();
        this.civStatsTable.defaults().left().pad(5.0f);
        this.addCivSpecificStats(this.civStatsTable);
        Table $this$_init__u24lambda_u240 = table2 = this.headerTable;
        boolean bl = false;
        $this$_init__u24lambda_u240.defaults().pad(5.0f);
        $this$_init__u24lambda_u240.align(2);
        $this$_init__u24lambda_u240.add((Actor)this.civStatsTable).row();
        $this$_init__u24lambda_u240.add((Actor)this.religionButtons).row();
        $this$_init__u24lambda_u240.add((Actor)this.religionButtonLabel);
        Scene2dExtensionsKt.addSeparator$default($this$_init__u24lambda_u240, null, 0, 0.0f, 7, null);
        this.defaults().pad(5.0f);
        this.align(2);
        this.loadReligionButtons();
        this.statsTable.defaults().left().pad(5.0f);
        this.beliefsTable.defaults().padBottom(20.0f);
        this.loadReligion(this.getPersistableData().getSelectedReligion());
        this.add((Actor)this.statsTable).row();
        this.add((Actor)this.beliefsTable).pad(20.0f);
    }

    public /* synthetic */ ReligionOverviewTab(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public ReligionTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.headerTable;
    }

    private final void addCivSpecificStats(Table $this$addCivSpecificStats) {
        float minWidth = Math.max(this.religionButtonLabel.getPrefWidth(), this.getOverviewScreen().getStage().getWidth() / (float)3);
        ReligionManager manager = this.getViewingPlayer().getReligionManager();
        String headerText = this.getViewingPlayer().hideCivCount() ? "Religions to be founded: [?]" : "Religions to be founded: [" + manager.remainingFoundableReligions() + ']';
        ExpanderTab religionCountExpander2 = new ExpanderTab(headerText, 18, null, false, 0.0f, 5.0f, minWidth, null, null, new Function0<Unit>(this){
            final /* synthetic */ ReligionOverviewTab this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getOverviewScreen().resizePage(this.this$0);
            }
        }, new Function1<Table, Unit>(manager){
            final /* synthetic */ ReligionManager $manager;
            {
                this.$manager = $manager;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.defaults().padTop(10.0f);
                Iterator<Pair<String, Integer>> iterator2 = this.$manager.remainingFoundableReligionsBreakdown().iterator();
                while (iterator2.hasNext()) {
                    Pair<String, Integer> pair = iterator2.next();
                    String text2 = pair.component1();
                    int num = ((Number)pair.component2()).intValue();
                    it.add((Actor)Scene2dExtensionsKt.toLabel(text2));
                    it.add((Actor)Scene2dExtensionsKt.toLabel$default(String.valueOf(num), null, 0, 16, false, 11, null)).right().row();
                }
            }
        }, 388, null);
        $this$addCivSpecificStats.add((Actor)religionCountExpander2).colspan(2).growX().row();
        if (manager.canGenerateProphet(true)) {
            String[] stringArray = new String[1];
            BaseUnit baseUnit = manager.getGreatProphetEquivalent();
            Intrinsics.checkNotNull(baseUnit);
            stringArray[0] = baseUnit.getName();
            $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(TranslationsKt.fillPlaceholders("Minimal Faith required for\nthe next [great prophet equivalent]:", stringArray)));
            $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(manager.faithForNextGreatProphet() + 1)).right().row();
        }
        $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel("Religious status:")).left();
        $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(manager.getReligionState().toString())).right().row();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadReligionButtons() {
        void $this$mapNotNullTo$iv$iv;
        this.religionButtons.clear();
        Iterable $this$mapNotNull$iv = this.getGameInfo().getCivilizations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Religion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            if (it.getReligionManager().getReligion() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List existingReligions = (List)destination$iv$iv;
        for (Religion religion : existingReligions) {
            Portrait image2 = religion.isPantheon() ? (this.getViewingPlayer().knows(religion.getFoundingCivName()) || Intrinsics.areEqual(this.getViewingPlayer().getCivName(), religion.getFoundingCivName()) ? ImageGetter.INSTANCE.getNationPortrait(religion.getFounder().getNation(), 60.0f) : ImageGetter.INSTANCE.getRandomNationPortrait(60.0f)) : ImageGetter.INSTANCE.getReligionPortrait(religion.getIconName(), 60.0f);
            Button button = new Button((Actor)image2, BaseScreen.Companion.getSkin());
            ActivationExtensionsKt.onClick(button, new Function0<Unit>(this, religion){
                final /* synthetic */ ReligionOverviewTab this$0;
                final /* synthetic */ Religion $religion;
                {
                    this.this$0 = $receiver;
                    this.$religion = $religion;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getPersistableData().setSelectedReligion(this.$religion.getName());
                    ReligionOverviewTab.access$loadReligionButtons(this.this$0);
                    ReligionOverviewTab.access$loadReligion(this.this$0, this.$religion);
                }
            });
            if (Intrinsics.areEqual(this.getPersistableData().getSelectedReligion(), religion.getName())) {
                Scene2dExtensionsKt.disable(button);
            }
            this.religionButtons.add((Actor)button).pad(5.0f);
        }
    }

    @Override
    @Nullable
    public Float select(@NotNull String selection) {
        Intrinsics.checkNotNullParameter(selection, "selection");
        this.getPersistableData().setSelectedReligion(selection);
        this.loadReligionButtons();
        this.loadReligion(selection);
        return null;
    }

    private final void loadReligion(String religionName) {
        if (religionName == null) {
            return;
        }
        Religion religion = this.getGameInfo().getReligions().get(religionName);
        if (religion == null) {
            return;
        }
        Religion religion2 = religion;
        this.loadReligion(religion2);
    }

    private final void loadReligion(Religion religion) {
        block6: {
            Object object;
            this.statsTable.clear();
            this.beliefsTable.clear();
            this.religionButtonLabel.setText(TranslationsKt.tr$default(religion.getReligionDisplayName(), false, 1, null));
            Scene2dExtensionsKt.setFontSize(this.religionButtonLabel, 24);
            this.religionButtonLabel.setColor(Color.CORAL);
            Iterator<Belief> iterator2 = religion.getAllBeliefsOrdered().iterator();
            while (iterator2.hasNext()) {
                Belief belief2 = iterator2.next();
                this.beliefsTable.add((Actor)this.createBeliefDescription(belief2)).row();
            }
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(religion.isPantheon() ? "Pantheon Name:" : "Religion Name:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(religion.getReligionDisplayName())).right().row();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Founding Civ:"));
            String foundingCivName = this.getViewingPlayer().knows(religion.getFoundingCivName()) || Intrinsics.areEqual(this.getViewingPlayer().getCivName(), religion.getFoundingCivName()) ? religion.getFoundingCivName() : "???";
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(foundingCivName)).right().row();
            if (religion.isMajorReligion()) {
                City city2;
                block5: {
                    Sequence<City> $this$firstOrNull$iv = this.getGameInfo().getCities();
                    boolean $i$f$firstOrNull = false;
                    object = $this$firstOrNull$iv.iterator();
                    while (object.hasNext()) {
                        City element$iv;
                        City it = element$iv = object.next();
                        boolean bl = false;
                        if (!it.isHolyCityOf(religion.getName())) continue;
                        city2 = element$iv;
                        break block5;
                    }
                    city2 = null;
                }
                City holyCity = city2;
                if (holyCity != null) {
                    this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Holy City:"));
                    String cityName = this.getViewingPlayer().hasExplored(holyCity.getCenterTile()) ? holyCity.getName() : "???";
                    this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(cityName)).right().row();
                }
            }
            ReligionManager manager = religion.getFounder().getReligionManager();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Cities following this religion:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(manager.numberOfCitiesFollowingThisReligion())).right().row();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Followers of this religion:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(manager.numberOfFollowersFollowingThisReligion("in all cities"))).right().row();
            float minWidth = Math.max(this.statsTable.getMinWidth(), this.beliefsTable.getMinWidth()) + (float)5;
            this.statsTable.setWidth(minWidth);
            for (Cell cell2 : this.beliefsTable.getCells()) {
                cell2.minWidth(minWidth);
            }
            object = this.getParent();
            ScrollPane scrollPane = object instanceof ScrollPane ? (ScrollPane)object : null;
            if (scrollPane == null) break block6;
            Object $this$loadReligion_u24lambda_u243 = object = scrollPane;
            boolean bl = false;
            ((ScrollPane)$this$loadReligion_u24lambda_u243).layout();
            ((ScrollPane)$this$loadReligion_u24lambda_u243).setScrollX(((ScrollPane)$this$loadReligion_u24lambda_u243).getMaxX() / (float)2);
            ((ScrollPane)$this$loadReligion_u24lambda_u243).updateVisualScroll();
        }
    }

    private final Table createBeliefDescription(Belief belief2) {
        Table table2;
        Table $this$createBeliefDescription_u24lambda_u244 = table2 = MarkupRenderer.render$default(MarkupRenderer.INSTANCE, belief2.getCivilopediaTextLines(true), 0.0f, 0.0f, null, new Function1<String, Unit>(this){
            final /* synthetic */ ReligionOverviewTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.getOverviewScreen().openCivilopedia(it);
            }
        }, 14, null);
        boolean bl = false;
        $this$createBeliefDescription_u24lambda_u244.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/ReligionOverviewTab/BeliefDescription", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 2, null));
        return table2;
    }

    public static final /* synthetic */ void access$loadReligionButtons(ReligionOverviewTab $this) {
        $this.loadReligionButtons();
    }

    public static final /* synthetic */ void access$loadReligion(ReligionOverviewTab $this, Religion religion) {
        $this.loadReligion(religion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "selectedReligion", "", "(Ljava/lang/String;)V", "getSelectedReligion", "()Ljava/lang/String;", "setSelectedReligion", "core"})
    public static final class ReligionTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        @Nullable
        private String selectedReligion;

        public ReligionTabPersistableData(@Nullable String selectedReligion) {
            this.selectedReligion = selectedReligion;
        }

        public /* synthetic */ ReligionTabPersistableData(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getSelectedReligion() {
            return this.selectedReligion;
        }

        public final void setSelectedReligion(@Nullable String string) {
            this.selectedReligion = string;
        }

        public ReligionTabPersistableData() {
            this(null, 1, null);
        }
    }
}

