/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.logic.trade.TradeType;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import com.unciv.ui.screens.overviewscreen.ResourcesOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u0003234B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020(H\u0002J\f\u0010+\u001a\u00020&*\u00020,H\u0002J\u001e\u0010-\u001a\u0004\u0018\u00010.*\u00020\r2\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u0014H\u0002J\f\u0010-\u001a\u00020.*\u00020\u001bH\u0002J\u0014\u00101\u001a\u00020.*\u00020\r2\u0006\u0010/\u001a\u00020\u001bH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "drilldownSequence", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList$ResourceSupply;", "extraDrilldown", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "extraOrigins", "", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "fixedContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "origins", "", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "resourceDrilldown", "resources", "Lcom/unciv/models/ruleset/tile/TileResource;", "turnImageH", "Lcom/unciv/ui/images/IconCircleGroup;", "turnImageV", "getExtraDrilldown", "getFixedContent", "getResourceImage", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "name", "getTurnImage", "vertical", "", "update", "", "updateHorizontal", "updateVertical", "countAsUnimproved", "Lcom/unciv/logic/map/tile/Tile;", "getLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "resource", "origin", "getTotalLabel", "Companion", "ExtraInfoOrigin", "ResourcesTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nResourcesOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,293:1\n766#2:294\n857#2,2:295\n1477#2:298\n1502#2,3:299\n1505#2,3:309\n766#2:312\n857#2,2:313\n766#2:315\n857#2,2:316\n1#3:297\n361#4,7:302\n*S KotlinDebug\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab\n*L\n94#1:294\n94#1:295,2\n197#1:298\n197#1:299,3\n197#1:309,3\n273#1:312\n273#1:313,2\n274#1:315\n274#1:316,2\n197#1:302,7\n*E\n"})
public final class ResourcesOverviewTab
extends EmpireOverviewTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourcesTabPersistableData persistableData;
    @NotNull
    private final IconCircleGroup turnImageH;
    @NotNull
    private final IconCircleGroup turnImageV;
    @NotNull
    private final ResourceSupplyList resourceDrilldown;
    @NotNull
    private final ResourceSupplyList extraDrilldown;
    @NotNull
    private final Sequence<ResourceSupplyList.ResourceSupply> drilldownSequence;
    @NotNull
    private final List<TileResource> resources;
    @NotNull
    private final List<String> origins;
    @NotNull
    private final List<ExtraInfoOrigin> extraOrigins;
    @NotNull
    private final Table fixedContent;
    private static final float iconSize = 50.0f;
    private static final float defaultPad = 10.0f;
    private static final float tooltipSize = 24.0f;

    public ResourcesOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        ResourcesTabPersistableData resourcesTabPersistableData = persistedData instanceof ResourcesTabPersistableData ? (ResourcesTabPersistableData)persistedData : null;
        if (resourcesTabPersistableData == null) {
            resourcesTabPersistableData = new ResourcesTabPersistableData(false, 1, null);
        }
        this.persistableData = resourcesTabPersistableData;
        this.turnImageH = this.getTurnImage(false);
        this.turnImageV = this.getTurnImage(true);
        this.resourceDrilldown = viewingPlayer.getDetailedCivResources();
        this.extraDrilldown = this.getExtraDrilldown();
        this.drilldownSequence = SequencesKt.plus(CollectionsKt.asSequence(this.resourceDrilldown), CollectionsKt.asSequence(this.extraDrilldown));
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                TileResource it = (TileResource)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getResourceType());
                it = (TileResource)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getResourceType()));
            }
        };
        Comparator comparator2 = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        this.resources = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.distinct(SequencesKt.filter(SequencesKt.map(this.drilldownSequence, resources.1.INSTANCE), resources.2.INSTANCE)), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    TileResource tileResource = (TileResource)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    TileResource it = (TileResource)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }));
        this.origins = SequencesKt.toList(SequencesKt.distinct(SequencesKt.map(CollectionsKt.asSequence(this.resourceDrilldown), origins.1.INSTANCE)));
        this.extraOrigins = SequencesKt.toList(SequencesKt.distinct(SequencesKt.mapNotNull(CollectionsKt.asSequence(this.extraDrilldown), extraOrigins.1.INSTANCE)));
        this.fixedContent = new Table();
        this.defaults().pad(10.0f);
        this.top();
        this.fixedContent.defaults().pad(10.0f);
        ActivationExtensionsKt.onClick(this.turnImageH, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getPersistableData().setVertical(true);
                this.update();
            }
        });
        ActivationExtensionsKt.onClick(this.turnImageV, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getPersistableData().setVertical(false);
                this.update();
            }
        });
        this.update();
    }

    public /* synthetic */ ResourcesOverviewTab(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public ResourcesTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    private final IconCircleGroup getTurnImage(boolean vertical) {
        Image image2;
        Image $this$getTurnImage_u24lambda_u240 = image2 = ImageGetter.INSTANCE.getImage("OtherIcons/Turn right");
        boolean bl = false;
        $this$getTurnImage_u24lambda_u240.setColor(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor());
        if (vertical) {
            $this$getTurnImage_u24lambda_u240.rotateBy(90.0f);
        }
        Actor actor = image2;
        Color color = Color.LIGHT_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
        return Scene2dExtensionsKt.surroundWithCircle$default(actor, 50.0f, false, color, null, 10, null);
    }

    private final Label getLabel(ResourceSupplyList $this$getLabel, TileResource resource2, String origin2) {
        Label label2;
        ResourceSupplyList.ResourceSupply resourceSupply = $this$getLabel.get(resource2, origin2);
        if (resourceSupply == null) {
            return null;
        }
        int amount = resourceSupply.getAmount();
        Label label3 = label2 = resource2.isStockpiled() && amount > 0 ? Scene2dExtensionsKt.toLabel("" + '+' + amount) : Scene2dExtensionsKt.toLabel(amount);
        if (Intrinsics.areEqual(origin2, "Unimproved")) {
            ActivationExtensionsKt.onClick(label2, new Function0<Unit>(this, resource2){
                final /* synthetic */ ResourcesOverviewTab this$0;
                final /* synthetic */ TileResource $resource;
                {
                    this.this$0 = $receiver;
                    this.$resource = $resource;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getOverviewScreen().showOneTimeNotification$core(GameInfo.getExploredResourcesNotification$default(this.this$0.getGameInfo(), this.this$0.getViewingPlayer(), this.$resource.getName(), 0, new Function1<Tile, Boolean>(this.this$0){
                        final /* synthetic */ ResourcesOverviewTab this$0;
                        {
                            this.this$0 = $receiver;
                            super(1, Intrinsics.Kotlin.class, "isAlliedAndUnimproved", "getLabel$isAlliedAndUnimproved(Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull Tile p0) {
                            Intrinsics.checkNotNullParameter(p0, "p0");
                            return ResourcesOverviewTab.access$getLabel$isAlliedAndUnimproved(this.this$0, p0);
                        }
                    }, 4, null));
                }
            });
        }
        return label2;
    }

    /*
     * WARNING - void declaration
     */
    private final Label getTotalLabel(ResourceSupplyList $this$getTotalLabel, TileResource resource2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getTotalLabel;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getResource(), resource2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            ResourceSupplyList.ResourceSupply $i$f$filterTo2 = (ResourceSupplyList.ResourceSupply)e;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAmount();
            n = n2 + n3;
        }
        int total = n;
        return resource2.isStockpiled() && total > 0 ? Scene2dExtensionsKt.toLabel("" + '+' + total) : Scene2dExtensionsKt.toLabel(total);
    }

    private final Group getResourceImage(String name2) {
        Group group;
        Group $this$getResourceImage_u24lambda_u245 = group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, name2, 50.0f, 0, 4, null);
        boolean bl = false;
        ActivationExtensionsKt.onClick($this$getResourceImage_u24lambda_u245, new Function0<Unit>(this, name2){
            final /* synthetic */ ResourcesOverviewTab this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                this.this$0.getOverviewScreen().showOneTimeNotification$core(GameInfo.getExploredResourcesNotification$default(this.this$0.getGameInfo(), this.this$0.getViewingPlayer(), this.$name, 0, null, 12, null));
            }
        });
        return group;
    }

    private final Label getLabel(TileResource $this$getLabel) {
        Label label2;
        Label $this$getLabel_u24lambda_u246 = label2 = Scene2dExtensionsKt.toLabel$default($this$getLabel.getName(), null, 0, 0, true, 7, null);
        boolean bl = false;
        ActivationExtensionsKt.onClick($this$getLabel_u24lambda_u246, new Function0<Unit>(this, $this$getLabel){
            final /* synthetic */ ResourcesOverviewTab this$0;
            final /* synthetic */ TileResource $this_getLabel;
            {
                this.this$0 = $receiver;
                this.$this_getLabel = $receiver2;
                super(0);
            }

            public final void invoke() {
                this.this$0.getOverviewScreen().openCivilopedia(this.$this_getLabel.makeLink());
            }
        });
        return label2;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.fixedContent;
    }

    private final void update() {
        this.clear();
        this.fixedContent.clear();
        if (this.getPersistableData().getVertical()) {
            this.updateVertical();
        } else {
            this.updateHorizontal();
        }
    }

    private final void updateHorizontal() {
        boolean bl;
        ResourcesOverviewTab resourcesOverviewTab;
        Iterator<TileResource> iterator2;
        this.add((Actor)this.turnImageH);
        for (TileResource tileResource : this.resources) {
            iterator2 = this.getResourceImage(tileResource.getName());
            Group group = iterator2;
            resourcesOverviewTab = this;
            bl = false;
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, group, tileResource.getName(), 0.0f, false, 0, 10, true, null, 78, null);
            resourcesOverviewTab.add((Actor)((Object)iterator2));
        }
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        for (String string : this.origins) {
            this.add((Actor)Scene2dExtensionsKt.toLabel(StringsKt.removeSuffix(string, (CharSequence)"+"))).left();
            iterator2 = this.resources.iterator();
            while (iterator2.hasNext()) {
                TileResource tileResource = (TileResource)iterator2.next();
                this.add((Actor)this.getLabel(this.resourceDrilldown, tileResource, string));
            }
            this.row();
        }
        Table table2 = this;
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.pad(Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 0.0f, 6, null), 0.0f, 10.0f);
        this.add((Actor)Scene2dExtensionsKt.toLabel("Total")).left();
        for (TileResource tileResource : this.resources) {
            this.add((Actor)this.getTotalLabel(this.resourceDrilldown, tileResource));
        }
        Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
        for (ExtraInfoOrigin extraInfoOrigin : this.extraOrigins) {
            Iterator<TileResource> iterator3 = iterator2 = Scene2dExtensionsKt.toLabel(extraInfoOrigin.getHorizontalCaption());
            resourcesOverviewTab = this;
            bl = false;
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)((Object)iterator3), extraInfoOrigin.getTooltip(), 24.0f, false, 0, 8, false, null, 108, null);
            resourcesOverviewTab.add((Actor)((Object)iterator2)).left();
            iterator2 = this.resources.iterator();
            while (iterator2.hasNext()) {
                TileResource tileResource = iterator2.next();
                this.add((Actor)this.getLabel(this.extraDrilldown, tileResource, extraInfoOrigin.name()));
            }
            this.row();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateVertical() {
        Object object;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.origins;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Iterator<ExtraInfoOrigin> destination$iv$iv = new LinkedHashMap();
        boolean bl = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = StringsKt.removeSuffix(it, (CharSequence)"+");
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedOrigins = destination$iv$iv;
        Table[] tableArray = this.fixedContent;
        Table $this$updateVertical_u24lambda_u2411 = tableArray;
        boolean bl3 = false;
        $this$updateVertical_u24lambda_u2411.add((Actor)this.turnImageV).size(50.0f);
        $this$updateVertical_u24lambda_u2411.add();
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$updateVertical_u24lambda_u2411, color, 0.0f, 2, null).pad(0.0f);
        for (Map.Entry entry : groupedOrigins.entrySet()) {
            $this$updateVertical_u24lambda_u2411.add((Actor)Scene2dExtensionsKt.toLabel((String)entry.getKey()));
        }
        $this$updateVertical_u24lambda_u2411.add((Actor)Scene2dExtensionsKt.toLabel("Total"));
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$updateVertical_u24lambda_u2411, color2, 0.0f, 2, null).pad(0.0f);
        for (ExtraInfoOrigin extraInfoOrigin : this.extraOrigins) {
            void $this$updateVertical_u24lambda_u2411_u24lambda_u2410;
            Object element$iv$iv;
            object = Scene2dExtensionsKt.toLabel(extraInfoOrigin.getVerticalCaption());
            element$iv$iv = object;
            Table table2 = $this$updateVertical_u24lambda_u2411;
            boolean bl4 = false;
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)$this$updateVertical_u24lambda_u2411_u24lambda_u2410, extraInfoOrigin.getTooltip(), 24.0f, false, 4, 18, false, null, 100, null);
            table2.add((Actor)object);
        }
        Scene2dExtensionsKt.pad(Scene2dExtensionsKt.addSeparator$default($this$updateVertical_u24lambda_u2411, null, 0, 0.0f, 7, null), 0.0f, 10.0f);
        for (TileResource resource2 : this.resources) {
            this.add((Actor)this.getResourceImage(resource2.getName()));
            this.add((Actor)this.getLabel(resource2));
            Table table2 = this;
            Color color3 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table2, color3, 0.0f, 2, null).pad(0.0f);
            for (Map.Entry groupedOrigin : groupedOrigins.entrySet()) {
                if (((List)groupedOrigin.getValue()).size() == 1) {
                    this.add((Actor)this.getLabel(this.resourceDrilldown, resource2, (String)groupedOrigin.getKey()));
                    continue;
                }
                Table table4 = new Table();
                object = table4;
                ResourcesOverviewTab resourcesOverviewTab = this;
                boolean bl4 = false;
                for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)groupedOrigin.getValue())) {
                    void $this$updateVertical_u24lambda_u2412;
                    $this$updateVertical_u24lambda_u2412.add((Actor)this.getLabel(this.resourceDrilldown, resource2, (String)indexedValue.getValue())).padLeft(indexedValue.getIndex() == 0 ? 0.0f : 10.0f);
                }
                resourcesOverviewTab.add((Actor)table4);
            }
            this.add((Actor)this.getTotalLabel(this.resourceDrilldown, resource2));
            Table table3 = this;
            Color color4 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table3, color4, 0.0f, 2, null).pad(0.0f);
            for (ExtraInfoOrigin origin5 : this.extraOrigins) {
                this.add((Actor)this.getLabel(this.extraDrilldown, resource2, origin5.name()));
            }
            this.row();
        }
        tableArray = new Table[]{this.fixedContent, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
        this.getOverviewScreen().resizePage(this);
    }

    private final boolean countAsUnimproved(Tile $this$countAsUnimproved) {
        return $this$countAsUnimproved.getResource() != null && $this$countAsUnimproved.getTileResource().getResourceType() != ResourceType.Bonus && $this$countAsUnimproved.hasViewableResource(this.getViewingPlayer()) && !$this$countAsUnimproved.providesResources(this.getViewingPlayer());
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceSupplyList getExtraDrilldown() {
        ResourceSupplyList newResourceSupplyList = new ResourceSupplyList(true);
        for (City city2 : this.getViewingPlayer().getCities()) {
            if (((CharSequence)city2.getDemandedResource()).length() > 0) {
                TileResource wltkResource;
                Intrinsics.checkNotNull(this.getGameInfo().getRuleset().getTileResources().get(city2.getDemandedResource()));
                if (city2.isWeLoveTheKingDayActive()) {
                    ResourceSupplyList.add$default(newResourceSupplyList, wltkResource, "CelebratingWLKT", 0, 4, null);
                } else {
                    ResourceSupplyList.add$default(newResourceSupplyList, wltkResource, "DemandingWLTK", 0, 4, null);
                }
            }
            ResourcesOverviewTab.getExtraDrilldown$addUnimproved(city2, this, newResourceSupplyList);
        }
        Iterator<Object> iterator2 = this.getViewingPlayer().getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv;
            Civilization otherCiv = (Civilization)iterator2.next();
            Iterable $this$filter$iv = otherCiv.getTradeRequests();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeRequest it = (TradeRequest)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getRequestingCiv(), this.getViewingPlayer().getCivName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeRequest trade : (List)destination$iv$iv) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = trade.getTrade().getTheirOffers();
                boolean $i$f$filter2 = false;
                Iterable $i$f$filterTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    TradeOffer it = (TradeOffer)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getType() == TradeType.Strategic_Resource || it.getType() == TradeType.Luxury_Resource)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (TradeOffer offer : (List)destination$iv$iv2) {
                    TileResource tileResource = this.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                    Intrinsics.checkNotNull(tileResource);
                    newResourceSupplyList.add(tileResource, "TradeOffer", offer.getAmount());
                }
            }
            if (!otherCiv.isCityState() || !Intrinsics.areEqual(otherCiv.getAllyCiv(), this.getViewingPlayer().getCivName())) continue;
            for (City city3 : otherCiv.getCities()) {
                ResourcesOverviewTab.getExtraDrilldown$addUnimproved(city3, this, newResourceSupplyList);
            }
        }
        for (TileResource resource2 : this.getViewingPlayer().getGameInfo().getRuleset().getTileResources().values()) {
            if (resource2.getResourceType() != ResourceType.Strategic) continue;
            if (resource2.getRevealedBy() != null) {
                TechManager techManager = this.getViewingPlayer().getTech();
                String string = resource2.getRevealedBy();
                Intrinsics.checkNotNull(string);
                if (!techManager.isResearched(string)) continue;
            }
            Intrinsics.checkNotNullExpressionValue(resource2, "resource");
            newResourceSupplyList.add(resource2, "No source", 0);
        }
        return newResourceSupplyList;
    }

    private static final boolean getLabel$isAlliedAndUnimproved(ResourcesOverviewTab this$0, Tile tile) {
        Civilization civilization = tile.getOwner();
        if (civilization == null) {
            return false;
        }
        Civilization owner = civilization;
        if (!(Intrinsics.areEqual(owner, this$0.getViewingPlayer()) || owner.isCityState() && Intrinsics.areEqual(owner.getAllyCiv(), this$0.getViewingPlayer().getCivName()))) {
            return false;
        }
        return this$0.countAsUnimproved(tile);
    }

    private static final void getExtraDrilldown$addUnimproved(City $this$getExtraDrilldown_u24addUnimproved, ResourcesOverviewTab this$0, ResourceSupplyList newResourceSupplyList) {
        Iterator<Tile> iterator2 = $this$getExtraDrilldown_u24addUnimproved.getTiles().iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (!this$0.countAsUnimproved(tile)) continue;
            ResourceSupplyList.add$default(newResourceSupplyList, tile.getTileResource(), "Unimproved", 0, 4, null);
        }
    }

    public static final /* synthetic */ boolean access$getLabel$isAlliedAndUnimproved(ResourcesOverviewTab this$0, Tile tile) {
        return ResourcesOverviewTab.getLabel$isAlliedAndUnimproved(this$0, tile);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$Companion;", "", "()V", "defaultPad", "", "iconSize", "tooltipSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0082\u0001\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "", "horizontalCaption", "", "verticalCaption", "tooltip", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHorizontalCaption", "()Ljava/lang/String;", "getTooltip", "getVerticalCaption", "Unimproved", "CelebratingWLKT", "DemandingWLTK", "TradeOffer", "Companion", "core"})
    private static final class ExtraInfoOrigin
    extends Enum<ExtraInfoOrigin> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String horizontalCaption;
        @NotNull
        private final String verticalCaption;
        @NotNull
        private final String tooltip;
        public static final /* enum */ ExtraInfoOrigin Unimproved;
        public static final /* enum */ ExtraInfoOrigin CelebratingWLKT;
        public static final /* enum */ ExtraInfoOrigin DemandingWLTK;
        public static final /* enum */ ExtraInfoOrigin TradeOffer;
        private static final /* synthetic */ ExtraInfoOrigin[] $VALUES;

        private ExtraInfoOrigin(String horizontalCaption, String verticalCaption, String tooltip) {
            this.horizontalCaption = horizontalCaption;
            this.verticalCaption = verticalCaption;
            this.tooltip = tooltip;
        }

        @NotNull
        public final String getHorizontalCaption() {
            return this.horizontalCaption;
        }

        @NotNull
        public final String getVerticalCaption() {
            return this.verticalCaption;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        public static ExtraInfoOrigin[] values() {
            return (ExtraInfoOrigin[])$VALUES.clone();
        }

        public static ExtraInfoOrigin valueOf(String value) {
            return Enum.valueOf(ExtraInfoOrigin.class, value);
        }

        static {
            Unimproved = new ExtraInfoOrigin("Unimproved", "Unimproved", "Number of tiles with this resource\nin your territory, without an\nappropriate improvement to use it");
            CelebratingWLKT = new ExtraInfoOrigin("We Love The King Day", "WLTK+", "Number of your cities celebrating\n'We Love The King Day' thanks\nto access to this resource");
            DemandingWLTK = new ExtraInfoOrigin("WLTK demand", "WLTK-", "Number of your cities\ndemanding this resource for\n'We Love The King Day'");
            TradeOffer = new ExtraInfoOrigin("Trade offer", "Trade offer", "Resources we're offering in trades");
            $VALUES = extraInfoOriginArray = new ExtraInfoOrigin[]{ExtraInfoOrigin.Unimproved, ExtraInfoOrigin.CelebratingWLKT, ExtraInfoOrigin.DemandingWLTK, ExtraInfoOrigin.TradeOffer};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion;", "", "()V", "safeValueOf", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nResourcesOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,293:1\n1282#2,2:294\n*S KotlinDebug\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion\n*L\n125#1:294,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ExtraInfoOrigin safeValueOf(@NotNull String name2) {
                ExtraInfoOrigin extraInfoOrigin;
                block1: {
                    Intrinsics.checkNotNullParameter(name2, "name");
                    ExtraInfoOrigin[] $this$firstOrNull$iv = ExtraInfoOrigin.values();
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        ExtraInfoOrigin element$iv;
                        ExtraInfoOrigin it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name2)) continue;
                        extraInfoOrigin = element$iv;
                        break block1;
                    }
                    extraInfoOrigin = null;
                }
                return extraInfoOrigin;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "vertical", "", "(Z)V", "getVertical", "()Z", "setVertical", "isEmpty", "core"})
    public static final class ResourcesTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        private boolean vertical;

        public ResourcesTabPersistableData(boolean vertical) {
            this.vertical = vertical;
        }

        public /* synthetic */ ResourcesTabPersistableData(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getVertical() {
            return this.vertical;
        }

        public final void setVertical(boolean bl) {
            this.vertical = bl;
        }

        @Override
        public boolean isEmpty() {
            return !this.vertical;
        }

        public ResourcesTabPersistableData() {
            this(false, 1, null);
        }
    }
}

