/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.ui.screens.overviewscreen.WonderInfo;
import com.unciv.utils.DebugUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J'\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo;", "", "()V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleSet", "()Lcom/unciv/models/ruleset/Ruleset;", "collectInfo", "", "Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)[Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "knownFromQuest", "", "name", "", "shouldBeDisplayed", "wonder", "Lcom/unciv/models/ruleset/Building;", "wonderEra", "", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/models/ruleset/Building;Ljava/lang/Integer;)Z", "WonderInfo", "WonderStatus", "core"})
@SourceDebugExtension(value={"SMAP\nWonderOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WonderOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/WonderInfo\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n658#2:263\n739#2,4:264\n658#2:268\n739#2,4:269\n674#2:277\n704#2,4:278\n603#2:288\n125#3:273\n152#3,3:274\n1179#4,2:282\n1253#4,4:284\n*S KotlinDebug\n*F\n+ 1 WonderOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/WonderInfo\n*L\n169#1:263\n169#1:264,4\n178#1:268\n178#1:269,4\n188#1:277\n188#1:278,4\n251#1:288\n182#1:273\n182#1:274,3\n195#1:282,2\n195#1:284,4\n*E\n"})
public final class WonderInfo {
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Ruleset ruleSet;

    public WonderInfo() {
        GameInfo gameInfo2 = UncivGame.Companion.getCurrent().getGameInfo();
        Intrinsics.checkNotNull(gameInfo2);
        this.gameInfo = gameInfo2;
        this.ruleSet = this.gameInfo.getRuleset();
    }

    @NotNull
    public final GameInfo getGameInfo() {
        return this.gameInfo;
    }

    @NotNull
    public final Ruleset getRuleSet() {
        return this.ruleSet;
    }

    private final boolean shouldBeDisplayed(Civilization viewingPlayer, Building wonder, Integer wonderEra) {
        return !IHasUniques.DefaultImpls.isHiddenFromCivilopedia$default(wonder, viewingPlayer.getGameInfo(), null, 2, null) && (wonderEra == null || wonderEra <= viewingPlayer.getEraNumber());
    }

    private final boolean knownFromQuest(Civilization viewingPlayer, String name2) {
        for (Civilization civ : this.gameInfo.getCivilizations()) {
            Iterator<AssignedQuest> iterator2 = civ.getQuestManager().getAssignedQuestsFor(viewingPlayer.getCivName()).iterator();
            while (iterator2.hasNext()) {
                AssignedQuest quest2 = iterator2.next();
                if (!Intrinsics.areEqual(quest2.getQuestName(), QuestName.FindNaturalWonder.getValue()) || !Intrinsics.areEqual(quest2.getData1(), name2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WonderInfo[] collectInfo(@NotNull Civilization viewingPlayer) {
        WonderStatus status;
        Sequence<City> it;
        WonderInfo[] $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$associateTo$iv$iv2;
        void $this$associate$iv2;
        void $this$associateTo$iv$iv3;
        void $this$associate$iv3;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Collator collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        Collection<Building> collection = this.ruleSet.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "ruleSet.buildings.values");
        Sequence sequence = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), collectInfo.wonderEraMap.1.INSTANCE);
        boolean $i$f$associate232 = false;
        void var6_7 = $this$associate$iv3;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv3) {
            Map map2 = destination$iv$iv;
            Building building = (Building)element$iv$iv;
            boolean bl = false;
            Pair<String, Era> pair = TuplesKt.to(building.getName(), building.era(this.ruleSet));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map wonderEraMap2 = destination$iv$iv;
        Collection<Building> collection2 = this.ruleSet.getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "ruleSet.buildings.values");
        Object $i$f$associate232 = new Comparator(wonderEraMap2){
            final /* synthetic */ Map $wonderEraMap$inlined;
            {
                this.$wonderEraMap$inlined = map2;
            }

            public final int compare(T a, T b) {
                Building it = (Building)a;
                boolean bl = false;
                Era era2 = (Era)this.$wonderEraMap$inlined.get(it.getName());
                it = (Building)b;
                Comparable comparable = era2 != null ? (Comparable)Integer.valueOf(era2.getEraNumber()) : (Comparable)Integer.valueOf(100);
                bl = false;
                Era era3 = (Era)this.$wonderEraMap$inlined.get(it.getName());
                return ComparisonsKt.compareValues(comparable, era3 != null ? (Comparable)Integer.valueOf(era3.getEraNumber()) : (Comparable)Integer.valueOf(100));
            }
        };
        $i$f$associate232 = SequencesKt.withIndex(SequencesKt.sortedWith(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection2), collectInfo.allWonderMap.1.INSTANCE), new Comparator((Comparator)$i$f$associate232, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Building building = (Building)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Building it = (Building)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }));
        boolean $i$f$associate = false;
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateTo232 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map2 = destination$iv$iv2;
            Object it3 = (IndexedValue)element$iv$iv;
            boolean bl = false;
            it3 = TuplesKt.to(((IndexedValue)it3).getIndex(), ((Building)((IndexedValue)it3).getValue()).getName());
            map2.put(((Pair)it3).getFirst(), ((Pair)it3).getSecond());
        }
        Map allWonderMap2 = destination$iv$iv2;
        int wonderCount = allWonderMap2.size();
        Map $this$map$iv = allWonderMap2;
        boolean $i$f$map232 = false;
        Map $i$f$associateTo232 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator entry = $this$mapTo$iv$iv.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = entry.next();
            object = destination$iv$iv3;
            boolean bl2 = false;
            object.add(TuplesKt.to(entry2.getValue(), entry2.getKey()));
        }
        Map wonderIndexMap = MapsKt.toMap((List)destination$iv$iv3);
        Sequence $i$f$map232 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.gameInfo.getTileMap().getValues()), collectInfo.allNaturalsMap.1.INSTANCE);
        boolean $i$f$associateBy = false;
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv4 = new LinkedHashMap();
        boolean bl = false;
        for (Object t : $this$associateByTo$iv$iv) {
            void it5;
            Tile bl2 = (Tile)t;
            object = destination$iv$iv4;
            boolean bl3 = false;
            String string = it5.getNaturalWonder();
            Intrinsics.checkNotNull(string);
            object.put(string, t);
        }
        Map allNaturalsMap2 = destination$iv$iv4;
        int naturalsCount = allNaturalsMap2.size();
        $this$associateByTo$iv$iv = CollectionsKt.withIndex(CollectionsKt.sortedWith(allNaturalsMap2.keySet(), new Comparator(collator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                String string = (String)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                String it = (String)b;
                String string2 = TranslationsKt.tr$default(it, false, 1, null);
                bl = false;
                String string3 = TranslationsKt.tr$default(it, false, 1, null);
                return comparator.compare(string2, string3);
            }
        }));
        boolean $i$f$associate3 = false;
        int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterator item$iv$iv = $this$associate$iv;
        Map map3 = new LinkedHashMap(n);
        boolean $i$f$associateTo3 = false;
        Iterator bl3 = $this$associateTo$iv$iv.iterator();
        while (bl3.hasNext()) {
            Object element$iv$iv = bl3.next();
            Map map4 = map3;
            it = (IndexedValue)element$iv$iv;
            boolean bl32 = false;
            it = TuplesKt.to(((IndexedValue)((Object)it)).getIndex(), ((IndexedValue)((Object)it)).getValue());
            map4.put(((Pair)((Object)it)).getFirst(), ((Pair)((Object)it)).getSecond());
        }
        Map naturalsIndexMap = map3;
        int n2 = wonderCount + naturalsCount;
        $this$associateTo$iv$iv = new WonderInfo[n2];
        for (int i = 0; i < n2; ++i) {
            WonderInfo wonderInfo;
            int n3 = i;
            if (n3 < wonderCount) {
                Object object2;
                Building wonder;
                Era era2;
                LinkedHashMap<String, Building> linkedHashMap = this.ruleSet.getBuildings();
                Object v = allWonderMap2.get(n3);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNull(linkedHashMap.get(v));
                Era era3 = era2 = (Era)wonderEraMap2.get(wonder.getName());
                status = this.shouldBeDisplayed(viewingPlayer, wonder, era3 != null ? Integer.valueOf(era3.getEraNumber()) : null) ? WonderStatus.Unbuilt : WonderStatus.Hidden;
                Object v2 = allWonderMap2.get(n3);
                Intrinsics.checkNotNull(v2);
                String string = (String)v2;
                Object object3 = era2;
                if (object3 == null || (object3 = ((RulesetObject)object3).getName()) == null) {
                    object3 = "Other";
                }
                if ((object2 = era2) == null || (object2 = ((Era)object2).getColor()) == null) {
                    object2 = Color.WHITE;
                }
                Intrinsics.checkNotNullExpressionValue(object2, "era?.getColor() ?: Color.WHITE");
                wonderInfo = new WonderInfo(string, CivilopediaCategories.Wonder, (String)object3, (Color)object2, status, null, null, null);
            } else {
                Object v = naturalsIndexMap.get(n3 - wonderCount);
                Intrinsics.checkNotNull(v);
                String string = (String)v;
                Color color = Color.FOREST;
                Intrinsics.checkNotNullExpressionValue(color, "FOREST");
                wonderInfo = new WonderInfo(string, CivilopediaCategories.Terrain, "Natural Wonders", color, WonderStatus.Unknown, null, null, null);
            }
            $this$associateTo$iv$iv[n3] = wonderInfo;
        }
        WonderInfo[] wonders = $this$associateTo$iv$iv;
        Iterator<Object> iterator2 = this.gameInfo.getCities().iterator();
        while (iterator2.hasNext()) {
            City city2 = iterator2.next();
            for (String string : CollectionsKt.intersect(SequencesKt.toList(SequencesKt.map(city2.getCityConstructions().getBuiltBuildings(), collectInfo.1.INSTANCE)), wonderIndexMap.keySet())) {
                Object v = wonderIndexMap.get(string);
                Intrinsics.checkNotNull(v);
                int index = ((Number)v).intValue();
                WonderStatus status2 = Intrinsics.areEqual(viewingPlayer, city2.getCiv()) ? WonderStatus.Owned : (viewingPlayer.hasExplored(city2.getCenterTile()) ? WonderStatus.Known : WonderStatus.NotFound);
                wonders[index] = new WonderInfo(string, CivilopediaCategories.Wonder, wonders[index].getGroupName(), wonders[index].getGroupColor(), status2, city2.getCiv(), city2, city2.getCenterTile());
            }
        }
        for (Map.Entry entry3 : naturalsIndexMap.entrySet()) {
            City city3;
            int index = ((Number)entry3.getKey()).intValue();
            String string = (String)entry3.getValue();
            Object v = allNaturalsMap2.get(string);
            Intrinsics.checkNotNull(v);
            Tile tile = (Tile)v;
            Civilization civ = tile.getOwner();
            WonderStatus wonderStatus = Intrinsics.areEqual(civ, viewingPlayer) ? WonderStatus.Owned : (status = viewingPlayer.getNaturalWonders().contains(string) ? WonderStatus.Known : WonderStatus.NotFound);
            if (status == WonderStatus.NotFound && !this.knownFromQuest(viewingPlayer, string)) continue;
            if (status == WonderStatus.NotFound) {
                city3 = null;
            } else {
                void $this$sortedBy$iv;
                it = SequencesKt.filter(this.gameInfo.getCities(), (Function1)new Function1<City, Boolean>(tile, viewingPlayer){
                    final /* synthetic */ Tile $tile;
                    final /* synthetic */ Civilization $viewingPlayer;
                    {
                        this.$tile = $tile;
                        this.$viewingPlayer = $viewingPlayer;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.getCenterTile().aerialDistanceTo(this.$tile) <= 5 && this.$viewingPlayer.knows(it.getCiv()) && this.$viewingPlayer.hasExplored(it.getCenterTile());
                    }
                });
                boolean $i$f$sortedBy = false;
                city3 = (City)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(tile){
                    final /* synthetic */ Tile $tile$inlined;
                    {
                        this.$tile$inlined = tile;
                    }

                    public final int compare(T a, T b) {
                        City it = (City)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$tile$inlined));
                        it = (City)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$tile$inlined));
                    }
                }));
            }
            City city4 = city3;
            Color color = Color.FOREST;
            Intrinsics.checkNotNullExpressionValue(color, "FOREST");
            wonders[index + wonderCount] = new WonderInfo(string, CivilopediaCategories.Terrain, "Natural Wonders", color, status, civ, city4, tile);
        }
        return wonders;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010#\u001a\u0004\u0018\u00010$J\u0006\u0010%\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderInfo;", "", "name", "", "category", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "groupName", "groupColor", "Lcom/badlogic/gdx/graphics/Color;", "status", "Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "location", "Lcom/unciv/logic/map/tile/Tile;", "(Ljava/lang/String;Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;Ljava/lang/String;Lcom/badlogic/gdx/graphics/Color;Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/city/City;Lcom/unciv/logic/map/tile/Tile;)V", "getCategory", "()Lcom/unciv/ui/screens/civilopediascreen/CivilopediaCategories;", "getCity", "()Lcom/unciv/logic/city/City;", "getCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getGroupColor", "()Lcom/badlogic/gdx/graphics/Color;", "getGroupName", "()Ljava/lang/String;", "getLocation", "()Lcom/unciv/logic/map/tile/Tile;", "getName", "getStatus", "()Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "viewEntireMapForDebug", "", "getImage", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getLocationColumn", "getNameColumn", "getStatusColumn", "makeLink", "core"})
    public static final class WonderInfo {
        @NotNull
        private final String name;
        @NotNull
        private final CivilopediaCategories category;
        @NotNull
        private final String groupName;
        @NotNull
        private final Color groupColor;
        @NotNull
        private final WonderStatus status;
        @Nullable
        private final Civilization civ;
        @Nullable
        private final City city;
        @Nullable
        private final Tile location;
        private final boolean viewEntireMapForDebug;

        public WonderInfo(@NotNull String name2, @NotNull CivilopediaCategories category, @NotNull String groupName, @NotNull Color groupColor, @NotNull WonderStatus status, @Nullable Civilization civ, @Nullable City city2, @Nullable Tile location) {
            Intrinsics.checkNotNullParameter(name2, "name");
            Intrinsics.checkNotNullParameter((Object)category, "category");
            Intrinsics.checkNotNullParameter(groupName, "groupName");
            Intrinsics.checkNotNullParameter(groupColor, "groupColor");
            Intrinsics.checkNotNullParameter((Object)status, "status");
            this.name = name2;
            this.category = category;
            this.groupName = groupName;
            this.groupColor = groupColor;
            this.status = status;
            this.civ = civ;
            this.city = city2;
            this.location = location;
            this.viewEntireMapForDebug = DebugUtils.INSTANCE.getVISIBLE_MAP();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final CivilopediaCategories getCategory() {
            return this.category;
        }

        @NotNull
        public final String getGroupName() {
            return this.groupName;
        }

        @NotNull
        public final Color getGroupColor() {
            return this.groupColor;
        }

        @NotNull
        public final WonderStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final Civilization getCiv() {
            return this.civ;
        }

        @Nullable
        public final City getCity() {
            return this.city;
        }

        @Nullable
        public final Tile getLocation() {
            return this.location;
        }

        @Nullable
        public final Actor getImage() {
            Actor actor;
            if (this.status == WonderStatus.Unknown && !this.viewEntireMapForDebug) {
                actor = null;
            } else {
                Function2<String, Float, Actor> function2 = this.category.getGetImage();
                actor = function2 != null ? function2.invoke(this.name, Float.valueOf(this.category == CivilopediaCategories.Terrain ? 50.0f : 45.0f)) : null;
            }
            return actor;
        }

        @NotNull
        public final String getNameColumn() {
            return this.viewEntireMapForDebug ? this.name : (this.status == WonderStatus.Unknown ? this.status.getLabel() : this.name);
        }

        @NotNull
        public final String getStatusColumn() {
            return this.status != WonderStatus.Known ? this.status.getLabel() : (this.civ == null ? this.status.getLabel() : this.civ.getCivName());
        }

        @NotNull
        public final String getLocationColumn() {
            String string;
            if (this.status.compareTo((Enum)WonderStatus.NotFound) <= 0) {
                string = "";
            } else if (this.location == null) {
                string = "";
            } else if (this.location.isCityCenter()) {
                City city2 = this.location.getCity();
                Intrinsics.checkNotNull(city2);
                string = city2.getName();
            } else if (this.location.getCity() != null) {
                StringBuilder stringBuilder = new StringBuilder().append("Near [");
                City city3 = this.location.getCity();
                Intrinsics.checkNotNull(city3);
                string = stringBuilder.append(city3).append(']').toString();
            } else if (this.city != null) {
                string = "Somewhere around [" + this.city + ']';
            } else if (this.viewEntireMapForDebug) {
                String string2 = this.location.getPosition().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "location.position.toString()");
            } else {
                string = "Far away";
            }
            return string;
        }

        @NotNull
        public final String makeLink() {
            return this.category.name() + '/' + this.name;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/screens/overviewscreen/WonderInfo$WonderStatus;", "", "label", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "Hidden", "Unknown", "Unbuilt", "NotFound", "Known", "Owned", "core"})
    public static final class WonderStatus
    extends Enum<WonderStatus> {
        @NotNull
        private final String label;
        public static final /* enum */ WonderStatus Hidden = new WonderStatus("");
        public static final /* enum */ WonderStatus Unknown = new WonderStatus("Unknown");
        public static final /* enum */ WonderStatus Unbuilt = new WonderStatus("Not built");
        public static final /* enum */ WonderStatus NotFound = new WonderStatus("Not found");
        public static final /* enum */ WonderStatus Known = new WonderStatus("Known");
        public static final /* enum */ WonderStatus Owned = new WonderStatus("Owned");
        private static final /* synthetic */ WonderStatus[] $VALUES;

        private WonderStatus(String label2) {
            this.label = label2;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public static WonderStatus[] values() {
            return (WonderStatus[])$VALUES.clone();
        }

        public static WonderStatus valueOf(String value) {
            return Enum.valueOf(WonderStatus.class, value);
        }

        static {
            $VALUES = wonderStatusArray = new WonderStatus[]{WonderStatus.Hidden, WonderStatus.Unknown, WonderStatus.Unbuilt, WonderStatus.NotFound, WonderStatus.Known, WonderStatus.Owned};
        }
    }
}

