/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.unciv.GUI;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0007\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/pickerscreens/PickerPane;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "disableScroll", "", "(Z)V", "bottomTable", "getBottomTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "closeButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getCloseButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "descriptionLabel", "Lcom/unciv/ui/screens/pickerscreens/PickerPane$DescriptionLabel;", "getDescriptionLabel", "()Lcom/unciv/ui/screens/pickerscreens/PickerPane$DescriptionLabel;", "descriptionScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "getDescriptionScroll$core", "()Lcom/unciv/ui/components/widgets/AutoScrollPane;", "maxBottomTableHeight", "", "rightSideButton", "getRightSideButton", "rightSideGroup", "Lcom/badlogic/gdx/scenes/scene2d/ui/VerticalGroup;", "getRightSideGroup", "()Lcom/badlogic/gdx/scenes/scene2d/ui/VerticalGroup;", "screenSplit", "scrollPane", "getScrollPane", "splitPane", "Lcom/badlogic/gdx/scenes/scene2d/ui/SplitPane;", "getSplitPane", "()Lcom/badlogic/gdx/scenes/scene2d/ui/SplitPane;", "topTable", "getTopTable", "layout", "", "pick", "rightButtonText", "", "setRightSideButtonEnabled", "enabled", "Companion", "DescriptionLabel", "core"})
public final class PickerPane
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextButton closeButton;
    @NotNull
    private final DescriptionLabel descriptionLabel;
    @NotNull
    private final AutoScrollPane descriptionScroll;
    @NotNull
    private final VerticalGroup rightSideGroup;
    @NotNull
    private final TextButton rightSideButton;
    private final float screenSplit;
    private final float maxBottomTableHeight;
    @NotNull
    private final Table topTable;
    @NotNull
    private final Table bottomTable;
    @NotNull
    private final AutoScrollPane scrollPane;
    @NotNull
    private final SplitPane splitPane;
    public static final float pickerOptionIconSize = 30.0f;

    public PickerPane(boolean disableScroll) {
        this.closeButton = Scene2dExtensionsKt.toTextButton$default("Close", null, false, 3, null);
        this.descriptionLabel = new DescriptionLabel();
        this.rightSideGroup = new VerticalGroup();
        this.rightSideButton = Scene2dExtensionsKt.toTextButton$default("", null, false, 3, null);
        this.screenSplit = 0.85f;
        this.maxBottomTableHeight = 150.0f;
        this.topTable = new Table();
        this.bottomTable = new Table();
        this.scrollPane = new AutoScrollPane((Actor)this.topTable, null, 2, null);
        this.splitPane = new SplitPane((Actor)this.scrollPane, (Actor)this.bottomTable, true, BaseScreen.Companion.getSkin());
        this.bottomTable.add((Actor)this.closeButton).pad(10.0f);
        this.descriptionLabel.setWrap(true);
        Table descriptionWithPad = new Table();
        descriptionWithPad.add((Actor)this.descriptionLabel).pad(10.0f).grow();
        this.descriptionScroll = new AutoScrollPane((Actor)descriptionWithPad, BaseScreen.Companion.getSkin());
        this.bottomTable.add((Actor)this.descriptionScroll).grow();
        Scene2dExtensionsKt.disable(this.rightSideButton);
        this.rightSideGroup.addActor(this.rightSideButton);
        this.bottomTable.add((Actor)this.rightSideGroup).pad(10.0f).right();
        this.scrollPane.setScrollingDisabled(disableScroll, disableScroll);
        if (disableScroll) {
            this.scrollPane.clearListeners();
        }
        this.add((Actor)this.splitPane).expand().fill();
    }

    public /* synthetic */ PickerPane(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final TextButton getCloseButton() {
        return this.closeButton;
    }

    @NotNull
    public final DescriptionLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @NotNull
    public final AutoScrollPane getDescriptionScroll$core() {
        return this.descriptionScroll;
    }

    @NotNull
    public final VerticalGroup getRightSideGroup() {
        return this.rightSideGroup;
    }

    @NotNull
    public final TextButton getRightSideButton() {
        return this.rightSideButton;
    }

    @NotNull
    public final Table getTopTable() {
        return this.topTable;
    }

    @NotNull
    public final Table getBottomTable() {
        return this.bottomTable;
    }

    @NotNull
    public final AutoScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @NotNull
    public final SplitPane getSplitPane() {
        return this.splitPane;
    }

    @Override
    public void layout() {
        super.layout();
        this.bottomTable.setHeight(RangesKt.coerceAtMost(this.bottomTable.getHeight(), this.maxBottomTableHeight));
        this.splitPane.setSplitAmount(RangesKt.coerceAtLeast(this.scrollPane.getHeight() / (this.scrollPane.getHeight() + this.bottomTable.getHeight()), this.screenSplit));
    }

    public final void setRightSideButtonEnabled(boolean enabled) {
        Scene2dExtensionsKt.setEnabled(this.rightSideButton, enabled);
    }

    public final void pick(@NotNull String rightButtonText) {
        Intrinsics.checkNotNullParameter(rightButtonText, "rightButtonText");
        if (GUI.INSTANCE.isMyTurn()) {
            Scene2dExtensionsKt.enable(this.rightSideButton);
        }
        this.rightSideButton.setText(rightButtonText);
    }

    public PickerPane() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PickerPane$Companion;", "", "()V", "pickerOptionIconSize", "", "getPickerOptionButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "label", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Button getPickerOptionButton(@NotNull Actor icon, @NotNull String label2) {
            IconTextButton iconTextButton;
            Intrinsics.checkNotNullParameter(icon, "icon");
            Intrinsics.checkNotNullParameter(label2, "label");
            IconTextButton $this$getPickerOptionButton_u24lambda_u240 = iconTextButton = new IconTextButton(label2, icon, 0, null, 12, null);
            boolean bl = false;
            $this$getPickerOptionButton_u24lambda_u240.getIconCell().size(30.0f).pad(10.0f);
            $this$getPickerOptionButton_u24lambda_u240.getLabelCell().pad(10.0f);
            return iconTextButton;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PickerPane$DescriptionLabel;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "(Lcom/unciv/ui/screens/pickerscreens/PickerPane;)V", "setText", "", "newText", "", "core"})
    public final class DescriptionLabel
    extends Label {
        public DescriptionLabel() {
            super((CharSequence)"", BaseScreen.Companion.getSkin());
        }

        @Override
        public void setText(@Nullable CharSequence newText) {
            super.setText(newText);
            PickerPane.this.getDescriptionScroll$core().validate();
            PickerPane.this.getDescriptionScroll$core().setScrollY(RangesKt.coerceIn(this.getPrefHeight() + 10.0f - PickerPane.this.getDescriptionScroll$core().getHeight(), 0.0f, 8.0f));
            PickerPane.this.getDescriptionScroll$core().updateVisualScroll();
        }
    }
}

