/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Policy;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PolicyColors;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreenKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u0018\u001a\u00020\u00002\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\b\u0010\u001c\u001a\u00020\u001bH\u0002R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PolicyButton;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "canChangeState", "", "policy", "Lcom/unciv/models/ruleset/Policy;", "size", "", "(Lcom/unciv/logic/civilization/Civilization;ZLcom/unciv/models/ruleset/Policy;F)V", "icon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getIcon", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "isAdopted", "isPickable", "value", "isSelected", "()Z", "setSelected", "(Z)V", "getPolicy", "()Lcom/unciv/models/ruleset/Policy;", "onClick", "function", "Lkotlin/Function0;", "", "updateState", "core"})
final class PolicyButton
extends BorderedTable {
    @NotNull
    private final Policy policy;
    @NotNull
    private final Image icon;
    private final boolean isPickable;
    private final boolean isAdopted;
    private boolean isSelected;

    public PolicyButton(@NotNull Civilization viewingCiv, boolean canChangeState, @NotNull Policy policy2, float size2) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        Intrinsics.checkNotNullParameter(policy2, "policy");
        String string = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape();
        String string2 = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape();
        super("PolicyScreen/PolicyButton", string2, string);
        this.policy = policy2;
        this.icon = ImageGetter.INSTANCE.getImage("PolicyIcons/" + this.policy.getName());
        this.isPickable = PolicyPickerScreenKt.access$isPickable(this.policy, viewingCiv, canChangeState);
        this.isAdopted = viewingCiv.getPolicies().isAdopted(this.policy.getName());
        this.setBorderSize(2.0f);
        this.icon.setSize(size2 * 0.7f, size2 * 0.7f);
        this.addActor(this.icon);
        this.updateState();
        this.pack();
        this.setWidth(size2);
        this.setHeight(size2);
        this.icon.toFront();
        Scene2dExtensionsKt.center((Actor)this.icon, this);
    }

    public /* synthetic */ PolicyButton(Civilization civilization, boolean bl, Policy policy2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f = 30.0f;
        }
        this(civilization, bl, policy2, f);
    }

    @NotNull
    public final Policy getPolicy() {
        return this.policy;
    }

    @NotNull
    public final Image getIcon() {
        return this.icon;
    }

    public final boolean isSelected() {
        return this.isSelected;
    }

    public final void setSelected(boolean value) {
        this.isSelected = value;
        this.updateState();
    }

    @NotNull
    public final PolicyButton onClick(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, "function");
        Intrinsics.checkNotNull(this, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.Actor");
        ActivationExtensionsKt.onClick(this, new Function0<Unit>(function, this){
            final /* synthetic */ Function0<Unit> $function;
            final /* synthetic */ PolicyButton this$0;
            {
                this.$function = $function;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$function.invoke();
                PolicyButton.access$updateState(this.this$0);
            }
        });
        return this;
    }

    private final void updateState() {
        Pair<PolicyColors, PolicyColors> colors = this.isSelected && this.isPickable ? TuplesKt.to(PolicyColors.ButtonBGPickableSelected, PolicyColors.ButtonIconPickableSelected) : (this.isPickable ? TuplesKt.to(PolicyColors.ButtonBGPickable, PolicyColors.ButtonIconPickable) : (this.isSelected && this.isAdopted ? TuplesKt.to(PolicyColors.ButtonBGAdoptedSelected, PolicyColors.ButtonIconAdoptedSelected) : (this.isAdopted ? TuplesKt.to(PolicyColors.ButtonBGAdopted, PolicyColors.ButtonIconAdopted) : (this.isSelected ? TuplesKt.to(PolicyColors.ButtonBGNotPickableSelected, PolicyColors.ButtonIconNotPickableSelected) : TuplesKt.to(PolicyColors.ButtonBGNotPickable, PolicyColors.ButtonIconNotPickable)))));
        this.setBgColor(colors.getFirst().getColor());
        this.icon.setColor(colors.getSecond().getColor());
    }

    public static final /* synthetic */ void access$updateState(PolicyButton $this) {
        $this.updateState();
    }
}

