/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.unciv.GUI;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.pickerscreens.PromotionTree;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0015J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fJ\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\fJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!2\u0006\u0010\u0019\u001a\u00020\fJ\u0012\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0006\u0010#\u001a\u00020$R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionTree;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "nodes", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "Lkotlin/collections/LinkedHashMap;", "possiblePromotions", "Ljava/util/LinkedHashSet;", "Lcom/unciv/models/ruleset/unit/Promotion;", "Lkotlin/collections/LinkedHashSet;", "getPossiblePromotions", "()Ljava/util/LinkedHashSet;", "setPossiblePromotions", "(Ljava/util/LinkedHashSet;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "allNodes", "Lkotlin/sequences/Sequence;", "allRoots", "canBuyUpTo", "", "promotion", "detectLoop", "node", "getMaxColumns", "", "getMaxRows", "getNode", "getPathTo", "", "getReachableNode", "update", "", "PromotionNode", "core"})
@SourceDebugExtension(value={"SMAP\nPromotionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromotionTree.kt\ncom/unciv/ui/screens/pickerscreens/PromotionTree\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1229#2,2:200\n1#3:202\n*S KotlinDebug\n*F\n+ 1 PromotionTree.kt\ncom/unciv/ui/screens/pickerscreens/PromotionTree\n*L\n113#1:200,2\n*E\n"})
public final class PromotionTree {
    @NotNull
    private final MapUnit unit;
    public LinkedHashSet<Promotion> possiblePromotions;
    private LinkedHashMap<String, PromotionNode> nodes;

    public PromotionTree(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.update();
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final LinkedHashSet<Promotion> getPossiblePromotions() {
        LinkedHashSet<Promotion> linkedHashSet = this.possiblePromotions;
        if (linkedHashSet != null) {
            return linkedHashSet;
        }
        Intrinsics.throwUninitializedPropertyAccessException("possiblePromotions");
        return null;
    }

    public final void setPossiblePromotions(@NotNull LinkedHashSet<Promotion> linkedHashSet) {
        Intrinsics.checkNotNullParameter(linkedHashSet, "<set-?>");
        this.possiblePromotions = linkedHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        void var6_10;
        Collator collator = GUI.INSTANCE.getSettings().getCollatorFromLocale();
        Collection<Promotion> collection = this.unit.getCiv().getGameInfo().getRuleset().getUnitPromotions().values();
        Intrinsics.checkNotNullExpressionValue(collection, "unit.civ.gameInfo.ruleset.unitPromotions.values");
        Collection<Promotion> rulesetPromotions = collection;
        String unitType2 = this.unit.getBaseUnit().getUnitType();
        HashSet<String> adoptedPromotions = this.unit.getPromotions().getPromotions();
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Promotion it = (Promotion)a;
                boolean bl = false;
                Comparable comparable = it.getRow() < 0 ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (it.getRow() == 0 ? (Comparable)Integer.valueOf(Integer.MIN_VALUE + it.getColumn()) : (Comparable)Integer.valueOf(it.getColumn()));
                it = (Promotion)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getRow() < 0 ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (it.getRow() == 0 ? (Comparable)Integer.valueOf(Integer.MIN_VALUE + it.getColumn()) : (Comparable)Integer.valueOf(it.getColumn())));
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Promotion it = (Promotion)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRow());
                    it = (Promotion)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getRow());
                }
                return n;
            }
        };
        this.setPossiblePromotions((LinkedHashSet)SequencesKt.toCollection(SequencesKt.sortedWith(SequencesKt.filter(CollectionsKt.asSequence((Iterable)rulesetPromotions), (Function1)new Function1<Promotion, Boolean>(unitType2, adoptedPromotions){
            final /* synthetic */ String $unitType;
            final /* synthetic */ HashSet<String> $adoptedPromotions;
            {
                this.$unitType = $unitType;
                this.$adoptedPromotions = $adoptedPromotions;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Promotion it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getUnitTypes().contains(this.$unitType) || this.$adoptedPromotions.contains(it.getName());
            }
        }), new Comparator((Comparator)object, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Promotion promotion2 = (Promotion)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Promotion it = (Promotion)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), (Collection)new LinkedHashSet()));
        this.nodes = (LinkedHashMap)MapsKt.toMap(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getPossiblePromotions()), (Function1)new Function1<Promotion, Pair<? extends String, ? extends PromotionNode>>(adoptedPromotions){
            final /* synthetic */ HashSet<String> $adoptedPromotions;
            {
                this.$adoptedPromotions = $adoptedPromotions;
                super(1);
            }

            @NotNull
            public final Pair<String, PromotionNode> invoke(@NotNull Promotion it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return TuplesKt.to(it.getName(), new PromotionNode(it, this.$adoptedPromotions.contains(it.getName())));
            }
        }), (Map)new LinkedHashMap(this.getPossiblePromotions().size()));
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        for (PromotionNode promotionNode : linkedHashMap.values()) {
            Intrinsics.checkNotNullExpressionValue(promotionNode, "node");
            if (this.detectLoop(promotionNode)) continue;
            for (String string : promotionNode.getPromotion().getPrerequisites()) {
                PromotionNode parent;
                LinkedHashMap<String, PromotionNode> linkedHashMap2 = this.nodes;
                if (linkedHashMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("nodes");
                    linkedHashMap2 = null;
                }
                if (linkedHashMap2.get(string) == null) continue;
                ((Collection)promotionNode.getParents()).add(parent);
                ((Collection)parent.getChildren()).add(promotionNode);
                if (promotionNode.getLevel() <= 0 || !Intrinsics.areEqual(promotionNode.getBaseName(), parent.getBaseName())) continue;
                int n = parent.getLevels();
                parent.setLevels(n + 1);
            }
        }
        StateForConditionals state = new StateForConditionals(this.unit.getCiv(), null, this.unit, this.unit.getTile(), null, null, null, null, null, false, 1010, null);
        LinkedHashMap<String, PromotionNode> linkedHashMap3 = this.nodes;
        if (linkedHashMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap3 = null;
        }
        for (PromotionNode node3 : linkedHashMap3.values()) {
            boolean bl;
            block16: {
                if (!((Collection)node3.getPromotion().getPrerequisites()).isEmpty() && node3.getParents().isEmpty()) {
                    node3.setUnreachable(true);
                }
                Sequence<Unique> sequence = node3.getPromotion().getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
                boolean $i$f$any = false;
                Iterator<Unique> iterator2 = sequence.iterator();
                while (iterator2.hasNext()) {
                    Unique element$iv;
                    Unique it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(!it.conditionalsApply(state))) continue;
                    bl = true;
                    break block16;
                }
                bl = false;
            }
            if (!bl) continue;
            node3.setUnreachable(true);
        }
        Iterator<PromotionNode> iterator3 = this.allRoots().iterator();
        while (iterator3.hasNext()) {
            PromotionNode node = iterator3.next();
            node.setDepth(0);
            node.setDistanceToAdopted(node.isAdopted() ? 0 : (node.getUnreachable() ? Integer.MAX_VALUE : 1));
        }
        boolean bl = false;
        while (var6_10 < 100) {
            boolean complete = true;
            LinkedHashMap<String, PromotionNode> linkedHashMap4 = this.nodes;
            if (linkedHashMap4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("nodes");
                linkedHashMap4 = null;
            }
            for (PromotionNode node4 : linkedHashMap4.values()) {
                if (node4.getDepth() == Integer.MIN_VALUE) {
                    complete = false;
                    continue;
                }
                if (node4.getDepth() != var6_10) continue;
                for (PromotionNode child : node4.getChildren()) {
                    PromotionNode promotionNode;
                    int distance = child.isAdopted() ? 0 : (node4.getDistanceToAdopted() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (child.getUnreachable() ? Integer.MAX_VALUE : node4.getDistanceToAdopted() + 1));
                    if (child.getDepth() != Integer.MIN_VALUE) {
                        if (child.getDistanceToAdopted() < distance) continue;
                        if (child.getDistanceToAdopted() == distance) {
                            child.setPathIsAmbiguous(true);
                            child.setPreferredParent(null);
                            continue;
                        }
                    }
                    child.setDepth((int)(var6_10 + true));
                    child.setDistanceToAdopted(distance);
                    child.setPathIsAmbiguous(node4.getPathIsAmbiguous());
                    PromotionNode promotionNode2 = promotionNode = node4;
                    PromotionNode promotionNode3 = child;
                    boolean bl2 = false;
                    boolean bl3 = node4.getPathIsAmbiguous();
                    promotionNode3.setPreferredParent(!bl3 ? promotionNode : null);
                }
            }
            if (complete) break;
            ++var6_10;
        }
    }

    @NotNull
    public final Sequence<PromotionNode> allNodes() {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        Collection<PromotionNode> collection = linkedHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "nodes.values");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    @NotNull
    public final Sequence<PromotionNode> allRoots() {
        return SequencesKt.filter(this.allNodes(), allRoots.1.INSTANCE);
    }

    private final boolean detectLoop(PromotionNode node) {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        HashSet<PromotionNode> loopCheck = new HashSet<PromotionNode>(linkedHashMap.size());
        return PromotionTree.detectLoop$detectRecursive(node, 0, loopCheck);
    }

    @Nullable
    public final PromotionNode getNode(@NotNull Promotion promotion2) {
        Intrinsics.checkNotNullParameter(promotion2, "promotion");
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        return linkedHashMap.get(promotion2.getName());
    }

    private final PromotionNode getReachableNode(Promotion promotion2) {
        PromotionNode promotionNode;
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        PromotionNode promotionNode2 = linkedHashMap.get(promotion2.getName());
        if (promotionNode2 != null) {
            PromotionNode promotionNode3;
            PromotionNode it = promotionNode3 = promotionNode2;
            boolean bl = false;
            promotionNode = !(it.getDistanceToAdopted() == Integer.MAX_VALUE) ? promotionNode3 : null;
        } else {
            promotionNode = null;
        }
        return promotionNode;
    }

    public final boolean canBuyUpTo(@NotNull Promotion promotion2) {
        Intrinsics.checkNotNullParameter(promotion2, "promotion");
        UnitPromotions $this$canBuyUpTo_u24lambda_u246 = this.unit.getPromotions();
        boolean bl = false;
        PromotionNode promotionNode = this.getReachableNode(promotion2);
        if (promotionNode == null) {
            return false;
        }
        PromotionNode node = promotionNode;
        if (node.isAdopted()) {
            return false;
        }
        return $this$canBuyUpTo_u24lambda_u246.getXP() >= $this$canBuyUpTo_u24lambda_u246.xpForNextNPromotions(node.getDistanceToAdopted());
    }

    @NotNull
    public final List<Promotion> getPathTo(@NotNull Promotion promotion2) {
        Intrinsics.checkNotNullParameter(promotion2, "promotion");
        PromotionNode promotionNode = this.getReachableNode(promotion2);
        if (promotionNode == null) {
            return CollectionsKt.emptyList();
        }
        PromotionNode node = promotionNode;
        Promotion[] promotionArray = new Promotion[]{node.getPromotion()};
        List<Promotion> result2 = CollectionsKt.mutableListOf(promotionArray);
        while (node.getPreferredParent() != null && !node.isAdopted()) {
            result2.add(node.getPromotion());
        }
        return CollectionsKt.asReversedMutable(result2);
    }

    public final int getMaxRows() {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        return linkedHashMap.size();
    }

    public final int getMaxColumns() {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        Collection<PromotionNode> collection = linkedHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "nodes.values");
        Iterator iterator2 = ((Iterable)collection).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        PromotionNode it = (PromotionNode)iterator2.next();
        boolean bl = false;
        int n = RangesKt.coerceAtLeast(it.getPromotion().getRow(), it.getDepth() + 1);
        while (iterator2.hasNext()) {
            PromotionNode it2 = (PromotionNode)iterator2.next();
            $i$a$-maxOf-PromotionTree$getMaxColumns$1 = false;
            int n2 = RangesKt.coerceAtLeast(it2.getPromotion().getRow(), it2.getDepth() + 1);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private static final boolean detectLoop$detectRecursive(PromotionNode node, int level, HashSet<PromotionNode> loopCheck) {
        if (level > 99) {
            return true;
        }
        if (loopCheck.contains(node)) {
            return true;
        }
        loopCheck.add(node);
        for (PromotionNode parent : node.getParents()) {
            if (!PromotionTree.detectLoop$detectRecursive(parent, level + 1, loopCheck)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u00102\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00000\fj\b\u0012\u0004\u0012\u00020\u0000`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0019\"\u0004\b1\u0010'\u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "isAdopted", "", "(Lcom/unciv/models/ruleset/unit/Promotion;Z)V", "baseName", "", "getBaseName", "()Ljava/lang/String;", "children", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getChildren", "()Ljava/util/LinkedHashSet;", "depth", "", "getDepth", "()I", "setDepth", "(I)V", "distanceToAdopted", "getDistanceToAdopted", "setDistanceToAdopted", "()Z", "isRoot", "level", "getLevel", "levels", "getLevels", "setLevels", "parents", "", "getParents", "()Ljava/util/Set;", "pathIsAmbiguous", "getPathIsAmbiguous", "setPathIsAmbiguous", "(Z)V", "preferredParent", "getPreferredParent", "()Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "setPreferredParent", "(Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;)V", "getPromotion", "()Lcom/unciv/models/ruleset/unit/Promotion;", "unreachable", "getUnreachable", "setUnreachable", "toString", "core"})
    public static final class PromotionNode {
        @NotNull
        private final Promotion promotion;
        private final boolean isAdopted;
        private int depth;
        private int distanceToAdopted;
        @NotNull
        private final Set<PromotionNode> parents;
        @Nullable
        private PromotionNode preferredParent;
        @NotNull
        private final LinkedHashSet<PromotionNode> children;
        private boolean pathIsAmbiguous;
        private boolean unreachable;
        @NotNull
        private final String baseName;
        private final int level;
        private int levels;

        public PromotionNode(@NotNull Promotion promotion2, boolean isAdopted) {
            Intrinsics.checkNotNullParameter(promotion2, "promotion");
            this.promotion = promotion2;
            this.isAdopted = isAdopted;
            this.depth = Integer.MIN_VALUE;
            this.distanceToAdopted = Integer.MAX_VALUE;
            this.parents = new LinkedHashSet();
            this.children = new LinkedHashSet();
            this.levels = 1;
            Promotion.Companion.PromotionBaseNameAndLevel splitName = Promotion.Companion.getBaseNameAndLevel(this.promotion.getName());
            this.level = splitName.getLevel();
            this.baseName = splitName.getBasePromotionName();
        }

        @NotNull
        public final Promotion getPromotion() {
            return this.promotion;
        }

        public final boolean isAdopted() {
            return this.isAdopted;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getDistanceToAdopted() {
            return this.distanceToAdopted;
        }

        public final void setDistanceToAdopted(int n) {
            this.distanceToAdopted = n;
        }

        @NotNull
        public final Set<PromotionNode> getParents() {
            return this.parents;
        }

        @Nullable
        public final PromotionNode getPreferredParent() {
            return this.preferredParent;
        }

        public final void setPreferredParent(@Nullable PromotionNode promotionNode) {
            this.preferredParent = promotionNode;
        }

        @NotNull
        public final LinkedHashSet<PromotionNode> getChildren() {
            return this.children;
        }

        public final boolean getPathIsAmbiguous() {
            return this.pathIsAmbiguous;
        }

        public final void setPathIsAmbiguous(boolean bl) {
            this.pathIsAmbiguous = bl;
        }

        public final boolean getUnreachable() {
            return this.unreachable;
        }

        public final void setUnreachable(boolean bl) {
            this.unreachable = bl;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public final int getLevel() {
            return this.level;
        }

        public final int getLevels() {
            return this.levels;
        }

        public final void setLevels(int n) {
            this.levels = n;
        }

        public final boolean isRoot() {
            return this.parents.isEmpty();
        }

        @NotNull
        public String toString() {
            return this.promotion.getName();
        }
    }
}

