/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StringBuilder;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.MissingModsException;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.LoadingPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.io.FileNotFoundException;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\u001e\u0010\u0010\u001a\u00020\f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\b\b\u0002\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\fH\u0016J\f\u0010\u001b\u001a\u00020\f*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\f*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadGameScreen;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "()V", "copySavedGameToClipboardButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "errorLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "loadMissingModsButton", "missingModsToLoad", "", "", "doubleClickAction", "", "getCopyExistingSaveToClipboardButton", "getLoadFromClipboardButton", "getLoadMissingModsButton", "handleLoadGameException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "primaryText", "loadMissingMods", "onExistingSaveSelected", "saveGameFile", "Lcom/badlogic/gdx/files/FileHandle;", "onLoadGame", "resetWindowState", "addLoadFromCustomLocationButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "initRightSideTable", "Companion", "core"})
public final class LoadGameScreen
extends LoadOrSaveScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextButton copySavedGameToClipboardButton = this.getCopyExistingSaveToClipboardButton();
    @NotNull
    private final Label errorLabel;
    @NotNull
    private final TextButton loadMissingModsButton;
    @NotNull
    private Iterable<String> missingModsToLoad;
    @NotNull
    private static final String loadGame = "Load game";
    @NotNull
    private static final String loadFromCustomLocation = "Load from custom location";
    @NotNull
    private static final String loadFromClipboard = "Load copied data";
    @NotNull
    private static final String copyExistingSaveToClipboard = "Copy saved game to clipboard";
    @NotNull
    private static final String downloadMissingMods = "Download missing mods";

    public LoadGameScreen() {
        super(null, 1, null);
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        this.errorLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        this.loadMissingModsButton = this.getLoadMissingModsButton();
        this.missingModsToLoad = CollectionsKt.emptyList();
        this.errorLabel.setVisible(false);
        this.errorLabel.setWrap(true);
        this.setDefaultCloseAction();
        this.initRightSideTable(this.getRightSideTable());
        ActivationExtensionsKt.onActivation(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onLoadGame();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getRETURN());
        this.getRightSideButton().setVisible(false);
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "LoadGameScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getTopTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "LoadGameScreen/TopTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
    }

    @Override
    public void resetWindowState() {
        super.resetWindowState();
        Scene2dExtensionsKt.disable(this.copySavedGameToClipboardButton);
        this.getRightSideButton().setText(TranslationsKt.tr$default(loadGame, false, 1, null));
        Scene2dExtensionsKt.disable(this.getRightSideButton());
    }

    @Override
    public void onExistingSaveSelected(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        Scene2dExtensionsKt.enable(this.copySavedGameToClipboardButton);
        this.getRightSideButton().setVisible(true);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Load [" + saveGameFile.name() + ']', false, 1, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
    }

    @Override
    public void doubleClickAction() {
        this.onLoadGame();
    }

    private final void initRightSideTable(Table $this$initRightSideTable) {
        $this$initRightSideTable.add((Actor)this.getLoadFromClipboardButton()).row();
        this.addLoadFromCustomLocationButton($this$initRightSideTable);
        $this$initRightSideTable.add((Actor)this.errorLabel).width($this$initRightSideTable.getStage().getWidth() / (float)2).row();
        $this$initRightSideTable.add((Actor)this.loadMissingModsButton).row();
        $this$initRightSideTable.add((Actor)this.getDeleteSaveButton()).row();
        $this$initRightSideTable.add((Actor)this.copySavedGameToClipboardButton).row();
        $this$initRightSideTable.add((Actor)this.getShowAutosavesCheckbox()).row();
    }

    private final void onLoadGame() {
        if (this.getSelectedSave() == null) {
            return;
        }
        LoadingPopup loadingPopup = new LoadingPopup(this);
        Concurrency.run$default(Concurrency.INSTANCE, loadGame, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, loadingPopup, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LoadGameScreen this$0;
            final /* synthetic */ LoadingPopup $loadingPopup;
            {
                this.this$0 = $receiver;
                this.$loadingPopup = $loadingPopup;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                        FileHandle fileHandle = this.this$0.getSelectedSave();
                        Intrinsics.checkNotNull(fileHandle);
                        GameInfo loadedGame = uncivFiles.loadGameFromFile(fileHandle);
                        this.L$0 = $this$run;
                        this.label = 1;
                        Object object3 = UncivGame.loadGame$default(this.this$0.getGame(), loadedGame, null, true, this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (UncivShowableException notAPlayer) {
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(notAPlayer, this.$loadingPopup, this.this$0, null){
                                int label;
                                final /* synthetic */ UncivShowableException $notAPlayer;
                                final /* synthetic */ LoadingPopup $loadingPopup;
                                final /* synthetic */ LoadGameScreen this$0;
                                {
                                    this.$notAPlayer = $notAPlayer;
                                    this.$loadingPopup = $loadingPopup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String message2 = (String)com.unciv.ui.screens.savescreens.LoadGameScreen$Companion.getLoadExceptionMessage$default(LoadGameScreen.Companion, this.$notAPlayer, null, 2, null).component1();
                                            this.$loadingPopup.reuseWith(message2, true);
                                            LoadGameScreen.handleLoadGameException$default(this.this$0, this.$notAPlayer, null, 2, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingPopup, this.this$0, ex, null){
                                int label;
                                final /* synthetic */ LoadingPopup $loadingPopup;
                                final /* synthetic */ LoadGameScreen this$0;
                                final /* synthetic */ Exception $ex;
                                {
                                    this.$loadingPopup = $loadingPopup;
                                    this.this$0 = $receiver;
                                    this.$ex = $ex;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$loadingPopup.close();
                                            LoadGameScreen.handleLoadGameException$default(this.this$0, this.$ex, null, 2, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final TextButton getLoadFromClipboardButton() {
        TextButton pasteButton = Scene2dExtensionsKt.toTextButton$default(loadFromClipboard, null, false, 3, null);
        ActivationExtensionsKt.onActivation(pasteButton, new Function0<Unit>(pasteButton, this){
            final /* synthetic */ TextButton $pasteButton;
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.$pasteButton = $pasteButton;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!Gdx.app.getClipboard().hasContents()) {
                    return;
                }
                this.$pasteButton.setText(TranslationsKt.tr$default("Working...", false, 1, null));
                Scene2dExtensionsKt.disable(this.$pasteButton);
                Concurrency.run$default(Concurrency.INSTANCE, "Load copied data", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$pasteButton, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ LoadGameScreen this$0;
                    final /* synthetic */ TextButton $pasteButton;
                    {
                        this.this$0 = $receiver;
                        this.$pasteButton = $pasteButton;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                $this$run = (CoroutineScope)this.L$0;
                                v0 = Gdx.app.getClipboard().getContents();
                                Intrinsics.checkNotNullExpressionValue(v0, "app.clipboard.contents");
                                clipboardContentsString = StringsKt.trim((CharSequence)v0).toString();
                                loadedGame = UncivFiles.Companion.gameInfoFromString(clipboardContentsString);
                                this.L$0 = $this$run;
                                this.label = 1;
                                v1 = UncivGame.loadGame$default(this.this$0.getGame(), loadedGame, null, true, this, 2, null);
                                ** if (v1 != var5_2) goto lbl17
lbl16:
                                // 1 sources

                                return var5_2;
lbl17:
                                // 1 sources

                                ** GOTO lbl24
                            }
                            case 1: {
                                $this$run = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
                                }
                                catch (Exception ex) {
                                    try {
                                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, ex, null){
                                            int label;
                                            final /* synthetic */ LoadGameScreen this$0;
                                            final /* synthetic */ Exception $ex;
                                            {
                                                this.this$0 = $receiver;
                                                this.$ex = $ex;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        LoadGameScreen.access$handleLoadGameException(this.this$0, this.$ex, "Could not load game from clipboard!");
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                    }
                                    catch (Throwable var3_6) {
                                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$pasteButton, null){
                                            int label;
                                            final /* synthetic */ TextButton $pasteButton;
                                            {
                                                this.$pasteButton = $pasteButton;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        this.$pasteButton.setText(TranslationsKt.tr$default("Load copied data", false, 1, null));
                                                        Scene2dExtensionsKt.enable(this.$pasteButton);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                        throw var3_6;
                                    }
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                                }
lbl24:
                                // 2 sources

                                ConcurrencyKt.launchOnGLThread$default($this$run, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        KeyCharAndCode ctrlV = KeyCharAndCode.Companion.ctrl('v');
        ActivationExtensionsKt.getKeyShortcuts(pasteButton).add(ctrlV);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)pasteButton, ctrlV, 0.0f, 2, null);
        return pasteButton;
    }

    private final void addLoadFromCustomLocationButton(Table $this$addLoadFromCustomLocationButton) {
        TextButton loadFromCustomLocationButton = Scene2dExtensionsKt.toTextButton$default(loadFromCustomLocation, null, false, 3, null);
        ActivationExtensionsKt.onClick(loadFromCustomLocationButton, new Function0<Unit>(this, loadFromCustomLocationButton){
            final /* synthetic */ LoadGameScreen this$0;
            final /* synthetic */ TextButton $loadFromCustomLocationButton;
            {
                this.this$0 = $receiver;
                this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                super(0);
            }

            public final void invoke() {
                LoadGameScreen.access$getErrorLabel$p(this.this$0).setVisible(false);
                this.$loadFromCustomLocationButton.setText(TranslationsKt.tr$default("Loading...", false, 1, null));
                Scene2dExtensionsKt.disable(this.$loadFromCustomLocationButton);
                Concurrency.run$default(Concurrency.INSTANCE, "Load from custom location", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$loadFromCustomLocationButton, null){
                    int label;
                    final /* synthetic */ LoadGameScreen this$0;
                    final /* synthetic */ TextButton $loadFromCustomLocationButton;
                    {
                        this.this$0 = $receiver;
                        this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.this$0.getGame().getFiles().loadGameFromCustomLocation((Function1<? super GameInfo, Unit>)new Function1<GameInfo, Unit>(this.this$0){
                                    final /* synthetic */ LoadGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull GameInfo it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                            int label;
                                            final /* synthetic */ LoadGameScreen this$0;
                                            final /* synthetic */ GameInfo $it;
                                            {
                                                this.this$0 = $receiver;
                                                this.$it = $it;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        this.label = 1;
                                                        Object object3 = UncivGame.loadGame$default(this.this$0.getGame(), this.$it, null, true, this, 2, null);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure($result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 3, null);
                                    }
                                }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(this.this$0, this.$loadFromCustomLocationButton){
                                    final /* synthetic */ LoadGameScreen this$0;
                                    final /* synthetic */ TextButton $loadFromCustomLocationButton;
                                    {
                                        this.this$0 = $receiver;
                                        this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Exception it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        if (!(it instanceof PlatformSaverLoader.Cancelled)) {
                                            LoadGameScreen.access$handleLoadGameException(this.this$0, it, "Could not load game from custom location!");
                                        }
                                        this.$loadFromCustomLocationButton.setText(TranslationsKt.tr$default("Load from custom location", false, 1, null));
                                        Scene2dExtensionsKt.enable(this.$loadFromCustomLocationButton);
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        $this$addLoadFromCustomLocationButton.add((Actor)loadFromCustomLocationButton).row();
    }

    private final TextButton getCopyExistingSaveToClipboardButton() {
        TextButton copyButton2 = Scene2dExtensionsKt.toTextButton$default(copyExistingSaveToClipboard, null, false, 3, null);
        ActivationExtensionsKt.onActivation(copyButton2, new Function0<Unit>(this){
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileHandle fileHandle = this.this$0.getSelectedSave();
                if (fileHandle == null) {
                    return;
                }
                FileHandle file = fileHandle;
                Concurrency.run$default(Concurrency.INSTANCE, "Copy saved game to clipboard", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, this.this$0, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ FileHandle $file;
                    final /* synthetic */ LoadGameScreen this$0;
                    {
                        this.$file = $file;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                CoroutineScope $this$run = (CoroutineScope)this.L$0;
                                try {
                                    String string;
                                    String gameText = this.$file.readString();
                                    Clipboard clipboard = Gdx.app.getClipboard();
                                    if (gameText.charAt(0) == '{') {
                                        Intrinsics.checkNotNullExpressionValue(gameText, "gameText");
                                        string = Gzip.INSTANCE.zip(gameText);
                                    } else {
                                        string = gameText;
                                    }
                                    clipboard.setContents(string);
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$file, this.this$0, null){
                                        int label;
                                        final /* synthetic */ FileHandle $file;
                                        final /* synthetic */ LoadGameScreen this$0;
                                        {
                                            this.$file = $file;
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    new ToastPopup("'[" + this.$file.name() + "]' copied to clipboard!", this.this$0, 0L, 4, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                                catch (Throwable ex) {
                                    ex.printStackTrace();
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ LoadGameScreen this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    new ToastPopup("Could not save game to clipboard!", this.this$0, 0L, 4, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        Scene2dExtensionsKt.disable(copyButton2);
        KeyCharAndCode ctrlC = KeyCharAndCode.Companion.ctrl('c');
        ActivationExtensionsKt.getKeyShortcuts(copyButton2).add(ctrlC);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)copyButton2, ctrlC, 0.0f, 2, null);
        return copyButton2;
    }

    private final TextButton getLoadMissingModsButton() {
        TextButton button = Scene2dExtensionsKt.toTextButton$default(downloadMissingMods, null, false, 3, null);
        ActivationExtensionsKt.onClick(button, new Function0<Unit>(this){
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LoadGameScreen.access$loadMissingMods(this.this$0);
            }
        });
        button.setVisible(false);
        return button;
    }

    private final void handleLoadGameException(Exception ex, String primaryText) {
        Log.INSTANCE.error("Error while loading game", ex);
        Pair<String, Boolean> pair = Companion.getLoadExceptionMessage(ex, primaryText);
        String errorText = pair.component1();
        boolean isUserFixable = pair.component2();
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isUserFixable, this, errorText, ex, null){
            int label;
            final /* synthetic */ boolean $isUserFixable;
            final /* synthetic */ LoadGameScreen this$0;
            final /* synthetic */ String $errorText;
            final /* synthetic */ Exception $ex;
            {
                this.$isUserFixable = $isUserFixable;
                this.this$0 = $receiver;
                this.$errorText = $errorText;
                this.$ex = $ex;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        if (!this.$isUserFixable) {
                            Popup cantLoadGamePopup = new Popup(this.this$0, null, 0.0f, 6, null);
                            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "It looks like your saved game can't be loaded!", 0, false, 6, null).row();
                            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "If you could copy your game data (\"Copy saved game to clipboard\" - ", 0, false, 6, null).row();
                            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "  paste into an email to yairm210@hotmail.com)", 0, false, 6, null).row();
                            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "I could maybe help you figure out what went wrong, since this isn't supposed to happen!", 0, false, 6, null).row();
                            Popup.addCloseButton$default(cantLoadGamePopup, null, null, null, null, 15, null);
                            Popup.open$default(cantLoadGamePopup, false, 1, null);
                        }
                        LoadGameScreen.access$getErrorLabel$p(this.this$0).setText(this.$errorText);
                        LoadGameScreen.access$getErrorLabel$p(this.this$0).setVisible(true);
                        if (this.$ex instanceof MissingModsException) {
                            LoadGameScreen.access$getLoadMissingModsButton$p(this.this$0).setVisible(true);
                            LoadGameScreen.access$setMissingModsToLoad$p(this.this$0, ((MissingModsException)this.$ex).getMissingMods());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    static /* synthetic */ void handleLoadGameException$default(LoadGameScreen loadGameScreen, Exception exception2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Could not load game!";
        }
        loadGameScreen.handleLoadGameException(exception2, string);
    }

    private final void loadMissingMods() {
        Scene2dExtensionsKt.setEnabled(this.loadMissingModsButton, false);
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Loading...", false, 1, null));
        Concurrency.INSTANCE.runOnNonDaemonThreadPool(downloadMissingMods, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        try {
                            for (String rawName : LoadGameScreen.access$getMissingModsToLoad$p(this.this$0)) {
                                Intrinsics.checkNotNullExpressionValue(Github.INSTANCE.folderNameToRepoName(rawName).toLowerCase(Locale.ROOT), "this as java.lang.String).toLowerCase(Locale.ROOT)");
                                if (Github.INSTANCE.tryGetGithubReposWithTopic(10, 1, modName) == null) {
                                    throw new UncivShowableException("Could not download mod list.", null, 2, null);
                                }
                                $this$firstOrNull$iv = repos.getItems();
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it = (GithubAPI.Repo)element$iv;
                                    $i$a$-firstOrNull-LoadGameScreen$loadMissingMods$1$repo$1 = false;
                                    v0 = it.getName().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue(v0, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    if (!Intrinsics.areEqual(v0, modName)) continue;
                                    v1 = element$iv;
                                    ** GOTO lbl24
                                }
                                v1 = null;
lbl24:
                                // 2 sources

                                if ((GithubAPI.Repo)v1 == null) {
                                    throw new UncivShowableException("Could not find a mod named \"[" + modName + "]\".", null, 2, null);
                                }
                                v2 = Gdx.files.local("mods");
                                Intrinsics.checkNotNullExpressionValue(v2, "files.local(\"mods\")");
                                if (Github.INSTANCE.downloadAndExtract(repo, v2) == null) {
                                    throw new Exception("Unexpected 404 error");
                                }
                                Github.INSTANCE.rewriteModOptions(repo, modFolder);
                                labelText = this.this$0.getDescriptionLabel().getText();
                                Intrinsics.checkNotNullExpressionValue(labelText, "labelText");
                                Intrinsics.checkNotNullExpressionValue(((Appendable)labelText).append('\n'), "append('\\n')");
                                labelText.append(TranslationsKt.tr$default('[' + repo.getName() + "] Downloaded!", false, 1, null));
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, labelText, null){
                                    int label;
                                    final /* synthetic */ LoadGameScreen this$0;
                                    final /* synthetic */ StringBuilder $labelText;
                                    {
                                        this.this$0 = $receiver;
                                        this.$labelText = $labelText;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                this.this$0.getDescriptionLabel().setText(this.$labelText);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ LoadGameScreen this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            RulesetCache.loadRulesets$default(RulesetCache.INSTANCE, false, false, 3, null);
                                            LoadGameScreen.access$setMissingModsToLoad$p(this.this$0, CollectionsKt.emptyList());
                                            LoadGameScreen.access$getLoadMissingModsButton$p(this.this$0).setVisible(false);
                                            LoadGameScreen.access$getErrorLabel$p(this.this$0).setVisible(false);
                                            this.this$0.getRightSideTable().pack();
                                            new ToastPopup("Missing mods are downloaded successfully.", this.this$0, 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Exception ex) {
                            try {
                                LoadGameScreen.access$handleLoadGameException(this.this$0, ex, "Could not load the missing mods!");
                            }
                            catch (Throwable var3_5) {
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ LoadGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                Scene2dExtensionsKt.setEnabled(LoadGameScreen.access$getLoadMissingModsButton$p(this.this$0), true);
                                                this.this$0.getDescriptionLabel().setText("");
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                                throw var3_5;
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                        }
                        ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ void access$handleLoadGameException(LoadGameScreen $this, Exception ex, String primaryText) {
        $this.handleLoadGameException(ex, primaryText);
    }

    public static final /* synthetic */ Label access$getErrorLabel$p(LoadGameScreen $this) {
        return $this.errorLabel;
    }

    public static final /* synthetic */ void access$loadMissingMods(LoadGameScreen $this) {
        $this.loadMissingMods();
    }

    public static final /* synthetic */ TextButton access$getLoadMissingModsButton$p(LoadGameScreen $this) {
        return $this.loadMissingModsButton;
    }

    public static final /* synthetic */ void access$setMissingModsToLoad$p(LoadGameScreen $this, Iterable iterable) {
        $this.missingModsToLoad = iterable;
    }

    public static final /* synthetic */ Iterable access$getMissingModsToLoad$p(LoadGameScreen $this) {
        return $this.missingModsToLoad;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadGameScreen$Companion;", "", "()V", "copyExistingSaveToClipboard", "", "downloadMissingMods", "loadFromClipboard", "loadFromCustomLocation", "loadGame", "getLoadExceptionMessage", "Lkotlin/Pair;", "", "ex", "", "primaryText", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable ex, @NotNull String primaryText) {
            Intrinsics.checkNotNullParameter(ex, "ex");
            Intrinsics.checkNotNullParameter(primaryText, "primaryText");
            java.lang.StringBuilder errorText = new java.lang.StringBuilder(TranslationsKt.tr$default(primaryText, false, 1, null));
            boolean isUserFixable = false;
            Intrinsics.checkNotNullExpressionValue(errorText.append('\n'), "append('\\n')");
            Throwable throwable = ex;
            if (throwable instanceof UncivShowableException) {
                errorText.append(((UncivShowableException)ex).getLocalizedMessage());
                isUserFixable = true;
            } else if (throwable instanceof SerializationException) {
                errorText.append(TranslationsKt.tr$default("The file data seems to be corrupted.", false, 1, null));
                isUserFixable = false;
            } else if (throwable instanceof FileNotFoundException) {
                boolean bl;
                Object object = ex.getCause();
                boolean bl2 = object != null && (object = ((Throwable)object).getMessage()) != null ? StringsKt.contains$default((CharSequence)object, "Permission denied", false, 2, null) : false;
                if (bl2) {
                    errorText.append(TranslationsKt.tr$default("You do not have sufficient permissions to access the file.", false, 1, null));
                    bl = true;
                } else {
                    bl = false;
                }
                isUserFixable = bl;
            } else {
                errorText.append(TranslationsKt.tr$default("Unhandled problem, [" + Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + ' ' + ExceptionsKt.stackTraceToString(ex) + ']', false, 1, null));
                isUserFixable = false;
            }
            String string = errorText.toString();
            Intrinsics.checkNotNullExpressionValue(string, "errorText.toString()");
            return new Pair<String, Boolean>(string, isUserFixable);
        }

        public static /* synthetic */ Pair getLoadExceptionMessage$default(Companion companion, Throwable throwable, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "Could not load game!";
            }
            return companion.getLoadExceptionMessage(throwable, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

