/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.ui.screens.savescreens.VerticalFileListScrollPane;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0010H&J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "fileListHeaderText", "", "(Ljava/lang/String;)V", "deleteSaveButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getDeleteSaveButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "rightSideTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getRightSideTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "savesScrollPane", "Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane;", "<set-?>", "Lcom/badlogic/gdx/files/FileHandle;", "selectedSave", "getSelectedSave", "()Lcom/badlogic/gdx/files/FileHandle;", "showAutosavesCheckbox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "getShowAutosavesCheckbox", "()Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "doubleClickAction", "", "onDeleteClicked", "onExistingSaveSelected", "saveGameFile", "resetWindowState", "selectExistingSave", "showSaveInfo", "updateShownSaves", "showAutosaves", "", "core"})
public abstract class LoadOrSaveScreen
extends PickerScreen {
    @Nullable
    private FileHandle selectedSave;
    @NotNull
    private final VerticalFileListScrollPane savesScrollPane;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final TextButton deleteSaveButton;
    @NotNull
    private final CheckBox showAutosavesCheckbox;

    public LoadOrSaveScreen(@Nullable String fileListHeaderText) {
        super(true);
        this.savesScrollPane = new VerticalFileListScrollPane(null, 1, null);
        this.rightSideTable = new Table();
        this.deleteSaveButton = Scene2dExtensionsKt.toTextButton$default("Delete save", BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class), false, 2, null);
        this.showAutosavesCheckbox = new CheckBox(TranslationsKt.tr$default("Show autosaves", false, 1, null), BaseScreen.Companion.getSkin());
        this.savesScrollPane.onChange((Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((LoadOrSaveScreen)this.receiver).selectExistingSave(p0);
            }
        });
        ActivationExtensionsKt.onDoubleClick$default(this.savesScrollPane, null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.doubleClickAction();
            }
        }, 1, null);
        Cell cell2 = this.rightSideTable.defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "rightSideTable.defaults()");
        Scene2dExtensionsKt.pad(cell2, 5.0f, 10.0f);
        this.showAutosavesCheckbox.setChecked(UncivGame.Companion.getCurrent().getSettings().getShowAutosaves());
        ActivationExtensionsKt.onChange(this.showAutosavesCheckbox, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.updateShownSaves(this.getShowAutosavesCheckbox().isChecked());
                UncivGame.Companion.getCurrent().getSettings().setShowAutosaves(this.getShowAutosavesCheckbox().isChecked());
            }
        });
        KeyCharAndCode ctrlA = KeyCharAndCode.Companion.ctrl('a');
        ActivationExtensionsKt.getKeyShortcuts(this.showAutosavesCheckbox).add(ctrlA, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getShowAutosavesCheckbox().toggle();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.showAutosavesCheckbox, ctrlA, 0.0f, 2, null);
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        ActivationExtensionsKt.onActivation(this.deleteSaveButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onDeleteClicked();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.deleteSaveButton).add(KeyCharAndCode.Companion.getDEL());
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.deleteSaveButton, KeyCharAndCode.Companion.getDEL(), 0.0f, 2, null);
        if (fileListHeaderText != null) {
            this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel(fileListHeaderText)).pad(10.0f).row();
        }
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        this.getTopTable().add((Actor)this.savesScrollPane);
        this.getTopTable().add((Actor)this.rightSideTable);
        this.getTopTable().pack();
    }

    public /* synthetic */ LoadOrSaveScreen(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public abstract void onExistingSaveSelected(@NotNull FileHandle var1);

    public abstract void doubleClickAction();

    @Nullable
    protected final FileHandle getSelectedSave() {
        return this.selectedSave;
    }

    @NotNull
    protected final Table getRightSideTable() {
        return this.rightSideTable;
    }

    @NotNull
    protected final TextButton getDeleteSaveButton() {
        return this.deleteSaveButton;
    }

    @NotNull
    protected final CheckBox getShowAutosavesCheckbox() {
        return this.showAutosavesCheckbox;
    }

    public void resetWindowState() {
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        this.getDescriptionLabel().setText("");
    }

    private final void onDeleteClicked() {
        if (this.selectedSave == null) {
            return;
        }
        FileHandle fileHandle = this.selectedSave;
        Intrinsics.checkNotNull(fileHandle);
        String name2 = fileHandle.name();
        Popup.open$default(new ConfirmPopup(this, "Are you sure you want to delete this save?", "Delete save", false, null, (Function0)new Function0<Unit>(this, name2){
            final /* synthetic */ LoadOrSaveScreen this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                String string;
                try {
                    String string2;
                    UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                    FileHandle fileHandle = this.this$0.getSelectedSave();
                    Intrinsics.checkNotNull(fileHandle);
                    if (uncivFiles.deleteSave(fileHandle)) {
                        this.this$0.resetWindowState();
                        string2 = '[' + this.$name + "] deleted successfully.";
                    } else {
                        string2 = "Failed to delete [" + this.$name + "].";
                    }
                    string = string2;
                }
                catch (SecurityException _) {
                    string = "Insufficient permissions to delete [" + this.$name + "].";
                }
                catch (Throwable _) {
                    string = "Failed to delete [" + this.$name + "].";
                }
                String result2 = string;
                this.this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(result2, false, 1, null));
            }
        }, 24, null), false, 1, null);
    }

    private final void updateShownSaves(boolean showAutosaves) {
        this.savesScrollPane.updateSaveGames(this.getGame().getFiles(), showAutosaves);
    }

    private final void selectExistingSave(FileHandle saveGameFile) {
        Scene2dExtensionsKt.enable(this.deleteSaveButton);
        this.selectedSave = saveGameFile;
        this.showSaveInfo(saveGameFile);
        this.getRightSideButton().setVisible(true);
        this.onExistingSaveSelected(saveGameFile);
    }

    private final void showSaveInfo(FileHandle saveGameFile) {
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Loading...", false, 1, null));
        Concurrency.run$default(Concurrency.INSTANCE, "LoadMetaData", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(saveGameFile, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileHandle $saveGameFile;
            final /* synthetic */ LoadOrSaveScreen this$0;
            {
                this.$saveGameFile = $saveGameFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $this$filterTo$iv$iv;
                            Date savedAt = new Date(this.$saveGameFile.lastModified());
                            GameInfoPreview game = this.this$0.getGame().getFiles().loadGamePreviewFromFile(this.$saveGameFile);
                            Iterable $this$filter$iv = game.getCivilizations();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                CivilizationInfoPreview it = (CivilizationInfoPreview)element$iv$iv;
                                boolean bl = false;
                                if (!it.isPlayerCivilization()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            String playerCivNames2 = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, showSaveInfo.textToSet.playerCivNames.2.INSTANCE, 31, null);
                            String mods = game.getGameParameters().getMods().isEmpty() ? "" : "\n{Mods:} " + CollectionsKt.joinToString$default(game.getGameParameters().getMods(), null, null, null, 0, null, null, 63, null);
                            string = this.$saveGameFile.name() + "\n{Saved at}: " + UncivDateFormat.INSTANCE.formatDate(savedAt) + '\n' + playerCivNames2 + ", " + TranslationsKt.tr$default(game.getDifficulty(), false, 1, null) + ", \u23f3" + game.getTurns() + "\n{Base ruleset:} " + game.getGameParameters().getBaseRuleset() + mods;
                        }
                        catch (Exception exception2) {
                            string = "\n{Could not load game}!";
                        }
                        String textToSet2 = string;
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, textToSet2, null){
                            int label;
                            final /* synthetic */ LoadOrSaveScreen this$0;
                            final /* synthetic */ String $textToSet;
                            {
                                this.this$0 = $receiver;
                                this.$textToSet = $textToSet;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(this.$textToSet, false, 1, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public LoadOrSaveScreen() {
        this(null, 1, null);
    }
}

