/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.VictoryData;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.newgamescreen.NewGameScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.victoryscreen.RankingType;
import com.unciv.ui.screens.victoryscreen.VictoryScreen;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCharts;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivRankings;
import com.unciv.ui.screens.victoryscreen.VictoryScreenDemographics;
import com.unciv.ui.screens.victoryscreen.VictoryScreenGlobalVictory;
import com.unciv.ui.screens.victoryscreen.VictoryScreenIllustrations;
import com.unciv.ui.screens.victoryscreen.VictoryScreenOurVictory;
import com.unciv.ui.screens.victoryscreen.VictoryScreenReplay;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001f B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J!\u0010\u0016\u001a\u00020\u00132\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "pageNumber", "", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;I)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "music", "Lcom/unciv/ui/audio/MusicController;", "getMusic", "()Lcom/unciv/ui/audio/MusicController;", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "tabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "displayWinner", "", "victoryData", "Lcom/unciv/logic/VictoryData;", "displayWonOrLost", "descriptions", "", "", "([Ljava/lang/String;)V", "dispose", "recreate", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "show", "CivWithStat", "VictoryTabs", "core"})
public final class VictoryScreen
extends PickerScreen
implements RecreateOnResize {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final Civilization playerCiv;
    @NotNull
    private final TabbedPager tabs;

    public VictoryScreen(@NotNull WorldScreen worldScreen, int pageNumber) {
        VerticalGroup verticalGroup;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        super(false, 1, null);
        this.worldScreen = worldScreen;
        this.gameInfo = this.worldScreen.getGameInfo();
        this.playerCiv = this.worldScreen.getViewingCiv();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        this.tabs = new TabbedPager(0.0f, 0.0f, 0.0f, 0.0f, 0, null, null, null, 0.0f, color, this, 0, 2559, null);
        this.worldScreen.getAutoPlay().stopAutoPlay();
        this.getSplitPane().setFirstWidget(this.tabs);
        float iconSize = 24.0f;
        for (VictoryTabs tab : VictoryTabs.values()) {
            boolean tabHidden = tab.isHidden(this.playerCiv);
            if (tabHidden) {
                if (!tab.getAllowAsSecret()) continue;
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                if (!Scene2dExtensionsKt.areSecretKeysPressed(input2)) continue;
            }
            Image icon = ImageGetter.INSTANCE.getImage("VictoryScreenIcons/" + tab.name());
            TabbedPager tabbedPager = this.tabs;
            String string = tab.getCaption();
            if (string == null) {
                string = tab.name();
            }
            String string2 = string;
            Table table2 = tab.getContent(this);
            KeyCharAndCode keyCharAndCode = new KeyCharAndCode(tab.getKey());
            boolean bl = tabHidden && tab.getAllowAsSecret();
            TabbedPager.addPage$default(tabbedPager, string2, table2, icon, iconSize, 0, bl, false, keyCharAndCode, 10, false, 592, null);
        }
        TabbedPager.selectPage$default(this.tabs, pageNumber, false, 2, null);
        if (this.gameInfo.getVictoryData() != null) {
            VictoryData victoryData = this.gameInfo.getVictoryData();
            Intrinsics.checkNotNull(victoryData);
            this.displayWinner(victoryData);
        } else if (this.playerCiv.isDefeated()) {
            String[] stringArray = new String[]{new Victory().getDefeatString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = this.playerCiv.getCivName();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(MusicTrackChooserFlags.SuffixMustMatch)");
            musicController.chooseTrack(string, "Defeat", enumSet);
        } else {
            this.getRightSideButton().setVisible(false);
            this.setDefaultCloseAction();
        }
        this.tabs.pack();
        VerticalGroup $this$_init__u24lambda_u240 = verticalGroup = new VerticalGroup();
        boolean bl = false;
        $this$_init__u24lambda_u240.space(5.0f);
        $this$_init__u24lambda_u240.align(16);
        $this$_init__u24lambda_u240.addActor(Scene2dExtensionsKt.toLabel("{Game Speed}: {" + this.gameInfo.getGameParameters().getSpeed() + '}'));
        if (this.gameInfo.getGameParameters().getVictoryTypes().contains("Time")) {
            $this$_init__u24lambda_u240.addActor(Scene2dExtensionsKt.toLabel("{Max Turns}: " + this.gameInfo.getGameParameters().getMaxTurns()));
        }
        $this$_init__u24lambda_u240.pack();
        VerticalGroup verticalGroup2 = verticalGroup;
        Label difficultyLabel = Scene2dExtensionsKt.toLabel("{Difficulty}: {" + this.gameInfo.getDifficulty() + '}');
        float neededSpace = RangesKt.coerceAtLeast(verticalGroup2.getWidth(), difficultyLabel.getWidth()) * (float)2 + this.tabs.getHeaderPrefWidth();
        if (neededSpace > this.getStage().getWidth()) {
            this.tabs.decorateHeader(difficultyLabel, true, false);
            this.tabs.decorateHeader(verticalGroup2, false, false);
            this.tabs.getHeaderScroll().setFadeScrollBars(false);
        } else {
            float panelY = this.getStage().getHeight() - this.tabs.getRowHeight(0) * 0.5f;
            this.getStage().addActor(verticalGroup2);
            verticalGroup2.setPosition(this.getStage().getWidth() - 10.0f, panelY, 16);
            this.getStage().addActor(difficultyLabel);
            difficultyLabel.setPosition(10.0f, panelY, 8);
        }
    }

    public /* synthetic */ VictoryScreen(WorldScreen worldScreen, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(worldScreen, n);
    }

    private final MusicController getMusic() {
        return UncivGame.Companion.getCurrent().getMusicController();
    }

    private final void displayWinner(VictoryData victoryData) {
        Victory victory;
        String winningCiv = victoryData.component1();
        String victoryType = victoryData.component2();
        Victory victory2 = this.gameInfo.getRuleset().getVictories().get(victoryType);
        if (victory2 == null) {
            victory2 = victory = new Victory();
        }
        if (Intrinsics.areEqual(winningCiv, this.playerCiv.getCivName())) {
            String[] stringArray = new String[]{"You have won a [" + victoryType + "] Victory!", victory.getVictoryString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = this.playerCiv.getCivName();
            stringArray = new String[]{"Victory", "Theme"};
            List<String> list2 = CollectionsKt.listOf(stringArray);
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(MusicTrackChooserFlags.SuffixMustMatch)");
            musicController.chooseTrack(string, list2, enumSet);
        } else {
            String[] stringArray = new String[]{'[' + winningCiv + "] has won a [" + victoryType + "] Victory!", victory.getDefeatString()};
            this.displayWonOrLost(stringArray);
            MusicController musicController = this.getMusic();
            String string = this.playerCiv.getCivName();
            EnumSet<Enum> enumSet = EnumSet.of((Enum)MusicTrackChooserFlags.SuffixMustMatch);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(MusicTrackChooserFlags.SuffixMustMatch)");
            musicController.chooseTrack(string, "Defeat", enumSet);
        }
        this.worldScreen.getAutoPlay().stopAutoPlay();
    }

    private final void displayWonOrLost(String ... descriptions) {
        this.getDescriptionLabel().setText(ArraysKt.joinToString$default(descriptions, (CharSequence)"\n", null, null, 0, null, (Function1)displayWonOrLost.1.INSTANCE, 30, null));
        this.getRightSideButton().setText(TranslationsKt.tr$default("Start new game", false, 1, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        ActivationExtensionsKt.onClick(this.getRightSideButton(), new Function0<Unit>(this){
            final /* synthetic */ VictoryScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GameSetupInfo newGameSetupInfo = new GameSetupInfo(VictoryScreen.access$getGameInfo$p(this.this$0));
                newGameSetupInfo.getMapParameters().reseed();
                this.this$0.getGame().pushScreen(new NewGameScreen(newGameSetupInfo));
            }
        });
        this.getCloseButton().setText(TranslationsKt.tr$default("One more turn...!", false, 1, null));
        ActivationExtensionsKt.onClick(this.getCloseButton(), new Function0<Unit>(this){
            final /* synthetic */ VictoryScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                VictoryScreen.access$getGameInfo$p(this.this$0).setOneMoreTurnMode(true);
                this.this$0.getGame().popScreen();
            }
        });
    }

    @Override
    public void show() {
        super.show();
        this.tabs.askForPassword(2747985);
    }

    @Override
    public void dispose() {
        TabbedPager.selectPage$default(this.tabs, -1, false, 2, null);
        super.dispose();
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new VictoryScreen(this.worldScreen, this.tabs.getActivePage());
    }

    public static final /* synthetic */ GameInfo access$getGameInfo$p(VictoryScreen $this) {
        return $this.gameInfo;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$CivWithStat;", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "category", "Lcom/unciv/ui/screens/victoryscreen/RankingType;", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/victoryscreen/RankingType;)V", "value", "", "(Lcom/unciv/logic/civilization/Civilization;I)V", "getCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getValue", "()I", "core"})
    public static final class CivWithStat {
        @NotNull
        private final Civilization civ;
        private final int value;

        public CivWithStat(@NotNull Civilization civ, int value) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            this.civ = civ;
            this.value = value;
        }

        @NotNull
        public final Civilization getCiv() {
            return this.civ;
        }

        public final int getValue() {
            return this.value;
        }

        public CivWithStat(@NotNull Civilization civ, @NotNull RankingType category) {
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter((Object)category, "category");
            this(civ, civ.getStatForRanking(category));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "", "key", "", "caption", "", "allowAsSecret", "", "(Ljava/lang/String;ICLjava/lang/String;Z)V", "getAllowAsSecret", "()Z", "getCaption", "()Ljava/lang/String;", "getKey", "()C", "getContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "OurStatus", "Global", "Illustration", "Demographics", "Rankings", "Charts", "Replay", "core"})
    private static final abstract class VictoryTabs
    extends Enum<VictoryTabs> {
        private final char key;
        @Nullable
        private final String caption;
        private final boolean allowAsSecret;
        public static final /* enum */ VictoryTabs OurStatus = new OurStatus("OurStatus", 0);
        public static final /* enum */ VictoryTabs Global = new Global("Global", 1);
        public static final /* enum */ VictoryTabs Illustration = new Illustration("Illustration", 2);
        public static final /* enum */ VictoryTabs Demographics = new Demographics("Demographics", 3);
        public static final /* enum */ VictoryTabs Rankings = new Rankings("Rankings", 4);
        public static final /* enum */ VictoryTabs Charts = new Charts("Charts", 5);
        public static final /* enum */ VictoryTabs Replay = new Replay("Replay", 6);
        private static final /* synthetic */ VictoryTabs[] $VALUES;

        private VictoryTabs(char key, String caption, boolean allowAsSecret) {
            this.key = key;
            this.caption = caption;
            this.allowAsSecret = allowAsSecret;
        }

        /* synthetic */ VictoryTabs(String string, int n, char c, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string2 = null;
            }
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(c, string2, bl);
        }

        public final char getKey() {
            return this.key;
        }

        @Nullable
        public final String getCaption() {
            return this.caption;
        }

        public final boolean getAllowAsSecret() {
            return this.allowAsSecret;
        }

        @NotNull
        public abstract Table getContent(@NotNull VictoryScreen var1);

        public boolean isHidden(@NotNull Civilization playerCiv) {
            Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
            return false;
        }

        public static VictoryTabs[] values() {
            return (VictoryTabs[])$VALUES.clone();
        }

        public static VictoryTabs valueOf(String value) {
            return Enum.valueOf(VictoryTabs.class, value);
        }

        static {
            $VALUES = victoryTabsArray = new VictoryTabs[]{VictoryTabs.OurStatus, VictoryTabs.Global, VictoryTabs.Illustration, VictoryTabs.Demographics, VictoryTabs.Rankings, VictoryTabs.Charts, VictoryTabs.Replay};
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Charts;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCharts;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Charts
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Charts() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenCharts getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenCharts(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !playerCiv.isSpectator() && playerCiv.getStatsHistory().size() < 2;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Demographics;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenDemographics;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Demographics
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Demographics() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenDemographics getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenDemographics(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !UncivGame.Companion.getCurrent().getSettings().getUseDemographics();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Global;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenGlobalVictory;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "core"})
        static final class Global
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Global() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenGlobalVictory getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenGlobalVictory(parent.worldScreen);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Illustration;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenIllustrations;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Illustration
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Illustration() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenIllustrations getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenIllustrations(parent, parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !VictoryScreenIllustrations.Companion.enablePage$core(playerCiv.getGameInfo());
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$OurStatus;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenOurVictory;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class OurStatus
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            OurStatus() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenOurVictory getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenOurVictory(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return playerCiv.isSpectator();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Rankings;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenCivRankings;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Rankings
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Rankings() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenCivRankings getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenCivRankings(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return UncivGame.Companion.getCurrent().getSettings().getUseDemographics();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs$Replay;", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen$VictoryTabs;", "getContent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreenReplay;", "parent", "Lcom/unciv/ui/screens/victoryscreen/VictoryScreen;", "isHidden", "", "playerCiv", "Lcom/unciv/logic/civilization/Civilization;", "core"})
        static final class Replay
        extends VictoryTabs {
            /*
             * WARNING - void declaration
             */
            Replay() {
                void var1_1;
            }

            @Override
            @NotNull
            public VictoryScreenReplay getContent(@NotNull VictoryScreen parent) {
                Intrinsics.checkNotNullParameter(parent, "parent");
                return new VictoryScreenReplay(parent.worldScreen);
            }

            @Override
            public boolean isHidden(@NotNull Civilization playerCiv) {
                Intrinsics.checkNotNullParameter(playerCiv, "playerCiv");
                return !playerCiv.isSpectator() && playerCiv.getGameInfo().getVictoryData() == null && playerCiv.isAlive() && playerCiv.getGameInfo().getTurns() < 5;
            }
        }
    }
}

